/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.DoesNotAffect;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.sha.earthquake.faultSysSolution.RupSetDeformationModel;
import org.opensha.sha.earthquake.faultSysSolution.RupSetFaultModel;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_CrustalFaultModels;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_CrustalRandomlySampledDeformationModels;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.GeoJSONFaultSection;

@Affects.Affected(value={@Affects(value="fault_sections.geojson"), @Affects(value="properties.csv"), @Affects(value="rates.csv")})
@DoesNotAffect.NotAffected(value={@DoesNotAffect(value="indices.csv"), @DoesNotAffect(value="grid_region.geojson"), @DoesNotAffect(value="grid_source_locations.csv"), @DoesNotAffect(value="grid_sources.csv")})
public enum PRVI25_CrustalDeformationModels implements RupSetDeformationModel
{
    GEOLOGIC("Geologic Preferred", "Preferred", 0.9){

        @Override
        protected void applySlipRates(List<? extends FaultSection> subSects, List<? extends FaultSection> fullSects) throws IOException {
            1.applyGeologicSlipRates(subSects, fullSects, RateType.PREF);
        }
    }
    ,
    GEOLOGIC_HIGH("Geologic High", "High", 0.05){

        @Override
        protected void applySlipRates(List<? extends FaultSection> subSects, List<? extends FaultSection> fullSects) throws IOException {
            2.applyGeologicSlipRates(subSects, fullSects, RateType.HIGH);
        }
    }
    ,
    GEOLOGIC_LOW("Geologic Low", "Low", 0.05){

        @Override
        protected void applySlipRates(List<? extends FaultSection> subSects, List<? extends FaultSection> fullSects) throws IOException {
            3.applyGeologicSlipRates(subSects, fullSects, RateType.LOW);
        }
    }
    ,
    GEOLOGIC_DIST_AVG("Geologic Distribution Average", "GeologicDistAvg", 0.0){

        @Override
        protected void applySlipRates(List<? extends FaultSection> subSects, List<? extends FaultSection> fullSects) {
            try {
                PRVI25_CrustalRandomlySampledDeformationModels.applyDistAvgSlipRates(subSects, fullSects);
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException((Throwable)e);
            }
        }
    };

    private static final double DEFAULT_FRACT_SLIP_STD_DEV = 0.1;
    public static final double STD_DEV_FLOOR = 1.0E-4;
    public static double HARDCODED_FRACTIONAL_STD_DEV;
    public static double HARDCODED_FRACTIONAL_STD_DEV_UPPER_BOUND;
    public static double ASEIS_CEILING;
    public static double CREEP_FRACT_DEFAULT;
    private static Table<String, RateType, Double> csvRateTable;
    public static boolean USE_DM_CSV_FILE;
    private static final String CSV_FILE_PATH = "/data/erf/prvi25/def_models/crustal/BinRanges_RakeDipProjected_Out_PrefRate.csv";
    private String name;
    private String shortName;
    private double weight;
    private static final DecimalFormat pDF;

    private static synchronized Table<String, RateType, Double> checkLoadCSVRates() throws IOException {
        if (csvRateTable == null) {
            InputStream is = PRVI25_CrustalDeformationModels.class.getResourceAsStream(CSV_FILE_PATH);
            Preconditions.checkNotNull((Object)is, (String)"Couldn't locate CSV: %s", (Object)CSV_FILE_PATH);
            CSVFile<String> csv = CSVFile.readStream(is, true);
            HashBasedTable table = HashBasedTable.create();
            for (int row = 1; row < csv.getNumRows(); ++row) {
                String name = csv.get(row, 0);
                for (RateType type : RateType.values()) {
                    double val = csv.getDouble(row, type.csvColumn);
                    Preconditions.checkState((Double.isFinite(val) && val >= 0.0 ? 1 : 0) != 0);
                    table.put((Object)name, (Object)type, (Object)val);
                }
            }
            csvRateTable = table;
        }
        return csvRateTable;
    }

    private PRVI25_CrustalDeformationModels(String name, String shortName, double weight) {
        this.name = name;
        this.shortName = shortName;
        this.weight = weight;
    }

    @Override
    public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
        return this.weight;
    }

    @Override
    public String getFilePrefix() {
        return this.name();
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isApplicableTo(RupSetFaultModel faultModel) {
        return faultModel instanceof PRVI25_CrustalFaultModels;
    }

    @Override
    public List<? extends FaultSection> apply(RupSetFaultModel faultModel, LogicTreeBranch<? extends LogicTreeNode> branch, List<? extends FaultSection> fullSects, List<? extends FaultSection> subSects) throws IOException {
        return this.buildDefModel(subSects, fullSects);
    }

    private List<? extends FaultSection> buildDefModel(List<? extends FaultSection> subSects, List<? extends FaultSection> fullSects) throws IOException {
        this.applySlipRates(subSects, fullSects);
        PRVI25_CrustalDeformationModels.applyStdDevDefaults(subSects);
        PRVI25_CrustalDeformationModels.applyCreepDefaults(subSects);
        return subSects;
    }

    protected abstract void applySlipRates(List<? extends FaultSection> var1, List<? extends FaultSection> var2) throws IOException;

    protected static void applyGeologicSlipRates(List<? extends FaultSection> subSects, List<? extends FaultSection> fullSects, RateType type) throws IOException {
        HashMap<Integer, FaultSection> idMapped = new HashMap<Integer, FaultSection>();
        for (FaultSection faultSection : fullSects) {
            idMapped.put(faultSection.getSectionId(), faultSection);
        }
        for (FaultSection faultSection : subSects) {
            FaultSection origSect = (FaultSection)idMapped.get(faultSection.getParentSectionId());
            Preconditions.checkNotNull((Object)origSect);
            Preconditions.checkState((boolean)origSect.getSectionName().equals(faultSection.getParentSectionName()));
            double slip = PRVI25_CrustalDeformationModels.getSlipRate(origSect, type);
            faultSection.setAveSlipRate(slip);
        }
    }

    protected static double getSlipRate(FaultSection origSect, RateType type) throws IOException {
        double slip;
        if (USE_DM_CSV_FILE) {
            PRVI25_CrustalDeformationModels.checkLoadCSVRates();
            slip = (Double)csvRateTable.get((Object)origSect.getSectionName(), (Object)type);
        } else {
            Preconditions.checkState((boolean)(origSect instanceof GeoJSONFaultSection));
            slip = ((GeoJSONFaultSection)origSect).getProperties().getDouble(type.propName, Double.NaN);
        }
        Preconditions.checkState((boolean)Double.isFinite(slip));
        return slip;
    }

    public static boolean isHardcodedFractionalStdDev() {
        return HARDCODED_FRACTIONAL_STD_DEV > 0.0;
    }

    public static void applyStdDevDefaults(List<? extends FaultSection> subSects) {
        if (PRVI25_CrustalDeformationModels.isHardcodedFractionalStdDev()) {
            System.out.println("Overriding deformation model slip rates std devs and using hardcoded fractional value: " + HARDCODED_FRACTIONAL_STD_DEV);
            Preconditions.checkState((!(HARDCODED_FRACTIONAL_STD_DEV_UPPER_BOUND > 0.0) ? 1 : 0) != 0, (Object)"Can't supply both hardcoded fractional std dev, and a fractional upper bound");
        }
        int numZeroSlips = 0;
        int numFractDefault = 0;
        int numFloor = 0;
        for (FaultSection faultSection : subSects) {
            double stdDev;
            double origStdDev;
            double slipRate = faultSection.getOrigAveSlipRate();
            Preconditions.checkState((Double.isFinite(slipRate) && slipRate >= 0.0 ? 1 : 0) != 0, (String)"Bad slip rate for %s. %s: %s", (Object)faultSection.getSectionId(), (Object)faultSection.getSectionName(), (Object)slipRate);
            if ((float)slipRate == 0.0f) {
                ++numZeroSlips;
            }
            if (faultSection instanceof GeoJSONFaultSection && slipRate > 0.0 && Double.isFinite(origStdDev = faultSection.getOrigSlipRateStdDev())) {
                ((GeoJSONFaultSection)faultSection).setProperty("OrigFractStdDev", origStdDev / slipRate);
            }
            if (PRVI25_CrustalDeformationModels.isHardcodedFractionalStdDev()) {
                stdDev = HARDCODED_FRACTIONAL_STD_DEV * slipRate;
            } else {
                stdDev = faultSection.getOrigSlipRateStdDev();
                if (!Double.isFinite(stdDev)) {
                    stdDev = 0.0;
                }
                if (HARDCODED_FRACTIONAL_STD_DEV_UPPER_BOUND > 0.0) {
                    double floorSD = HARDCODED_FRACTIONAL_STD_DEV_UPPER_BOUND * slipRate;
                    if ((float)stdDev <= 0.0f || floorSD < stdDev) {
                        stdDev = floorSD;
                    }
                }
                if ((float)stdDev <= 0.0f && (float)stdDev <= 0.0f) {
                    stdDev = slipRate * 0.1;
                    ++numFractDefault;
                }
            }
            if ((float)stdDev < 1.0E-4f) {
                stdDev = 1.0E-4;
                ++numFloor;
            }
            faultSection.setSlipRateStdDev(stdDev);
        }
        if (numZeroSlips > 0) {
            System.err.println("WARNING: " + numZeroSlips + "/" + subSects.size() + " (" + pDF.format((double)numZeroSlips / (double)subSects.size()) + ") subsection slip rates are 0");
        }
        if (numFractDefault > 0) {
            System.err.println("WARNING: Set " + numFractDefault + "/" + subSects.size() + " (" + pDF.format((double)numFractDefault / (double)subSects.size()) + ") subsection slip rate standard deviations to the default: 0.1 x slipRate");
        }
        if (numFloor > 0) {
            System.err.println("WARNING: Set " + numFloor + "/" + subSects.size() + " (" + pDF.format((double)numFloor / (double)subSects.size()) + ") subsection slip rate standard deviations to the floor value of 1.0E-4 (mm/yr)");
        }
    }

    static void applyCreepDefaults(List<? extends FaultSection> subSects) {
        double coupling;
        double aseis;
        double creepFract = CREEP_FRACT_DEFAULT;
        if (creepFract < ASEIS_CEILING) {
            aseis = creepFract;
            coupling = 1.0;
        } else {
            aseis = ASEIS_CEILING;
            coupling = 1.0 - 1.0 / (1.0 - ASEIS_CEILING) * (creepFract - ASEIS_CEILING);
        }
        for (FaultSection faultSection : subSects) {
            faultSection.setAseismicSlipFactor(aseis);
            faultSection.setCouplingCoeff(coupling);
        }
    }

    public static void main(String[] args) throws IOException {
        PRVI25_CrustalFaultModels fm = PRVI25_CrustalFaultModels.PRVI_CRUSTAL_FM_V1p1;
        for (FaultSection faultSection : fm.getFaultSections()) {
            System.out.println(faultSection.getSectionName());
            System.out.println("\tPref:\t" + (float)PRVI25_CrustalDeformationModels.getSlipRate(faultSection, RateType.PREF));
            System.out.println("\tBounds:\t[" + (float)PRVI25_CrustalDeformationModels.getSlipRate(faultSection, RateType.LOW) + ", " + (float)PRVI25_CrustalDeformationModels.getSlipRate(faultSection, RateType.HIGH) + "]");
        }
    }

    static {
        HARDCODED_FRACTIONAL_STD_DEV = 0.0;
        HARDCODED_FRACTIONAL_STD_DEV_UPPER_BOUND = 0.1;
        ASEIS_CEILING = 0.4;
        CREEP_FRACT_DEFAULT = 0.1;
        csvRateTable = null;
        USE_DM_CSV_FILE = true;
        pDF = new DecimalFormat("0.00%");
    }

    private static enum RateType {
        PREF("SlipRate", 1),
        LOW("LowRate", 2),
        HIGH("HighRate", 3);

        private String propName;
        private int csvColumn;

        private RateType(String propName, int csvColumn) {
            this.propName = propName;
            this.csvColumn = csvColumn;
        }
    }
}

