/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree;

import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.DoesNotAffect;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeNode;

@DoesNotAffect.NotAffected(value={@DoesNotAffect(value="fault_sections.geojson"), @DoesNotAffect(value="indices.csv"), @DoesNotAffect(value="properties.csv"), @DoesNotAffect(value="rates.csv"), @DoesNotAffect(value="grid_region.geojson"), @DoesNotAffect(value="grid_mech_weights.csv"), @DoesNotAffect(value="grid_source_locations.csv")})
@Affects.Affected(value={@Affects(value="grid_sub_seis_mfds.csv"), @Affects(value="grid_unassociated_mfds.csv"), @Affects(value="grid_sources.csv")})
public enum PRVI25_SubductionSlabMMax implements LogicTreeNode
{
    MAG_7p5(7.5, 0.5),
    MAG_8p0(8.0, 0.5);

    public static PRVI25_SubductionSlabMMax DEFAULT;
    private double mMax;
    private double weight;

    private PRVI25_SubductionSlabMMax(double mMax, double weight) {
        this.mMax = mMax;
        this.weight = weight;
    }

    @Override
    public String getShortName() {
        return "" + (float)this.mMax;
    }

    @Override
    public String getName() {
        return "Mmax=" + (float)this.mMax;
    }

    @Override
    public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
        return this.weight;
    }

    @Override
    public String getFilePrefix() {
        return "SlabMmax" + this.getShortName().replace('.', 'p');
    }

    public double getMmax() {
        return this.mMax;
    }

    public double getIncrementalMmax() {
        return this.mMax - 0.05;
    }

    static {
        DEFAULT = MAG_8p0;
    }
}

