/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.prvi25.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.scec.getfile.GetFile;

public class NSHM25_Downloader
extends GetFile {
    private static final List<URI> ENDPOINTS = List.of(URI.create("https://g-3a9041.a78b8.36fe.data.globus.org/getfile/nshm25/nshm25.json"), URI.create("https://data.opensha.org/getfile/nshm25/nshm25.json"), URI.create("https://opensha.scec.org/getfile/nshm25/nshm25.json"));

    public NSHM25_Downloader(File storeDir, boolean showProgress) {
        super("NSHM 2025", new File(storeDir, "nshm25_client.json"), ENDPOINTS, showProgress);
    }

    public NSHM25_Downloader(boolean showProgress) {
        this(NSHM25_Downloader.getStoreDir(), showProgress);
    }

    public NSHM25_Downloader(File storeDir) {
        this(storeDir, true);
    }

    public NSHM25_Downloader() {
        this(true);
    }

    public static File getStoreDir() {
        Path storeDir = Paths.get(System.getProperty("user.home"), ".opensha", "nshm25");
        try {
            Files.createDirectories(storeDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            System.err.println("NSHM25_Downloader failed to create storeDir at " + String.valueOf(storeDir));
            e.printStackTrace();
        }
        return storeDir.toFile();
    }
}

