/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.step;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.earthquake.PointSource;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class STEP_EqkRupForecast
extends AbstractERF
implements ParameterChangeListener {
    private static String C = new String("STEP_EqkRupForecast");
    private boolean D = false;
    public static String NAME = new String("STEP ERF");
    private static final String DELTA_RATES_FILE_NAME = "http://www.relm.org/models/step/AllCalDeltaRates.txt";
    private static final String BACKGROUND_RATES_FILE_NAME = "/data/erf/step/AllCal96ModelDaily.txt";
    private ArrayList deltaRateFileLines;
    private ArrayList backgroundRateFileLines;
    private static final double RAKE = 0.0;
    private static final double DIP = 90.0;
    private static final double MAG_LOWER = 4.0;
    private static final double MAG_UPPER = 8.0;
    private static final int NUM_MAG = 41;
    private static final double DEPTH = 0.0;
    private double oldMinMag = 4.0;
    private ArrayList deltaRateSources;
    private ArrayList backgroundRateSources;
    private ArrayList allSources;
    private boolean deltaSourcesAlreadyMade = false;
    private boolean backgroundSourcesAlreadyMade = false;
    private boolean backgroundRatesFileAlreadyRead = false;
    public static final String SEIS_TYPE_NAME = new String("Seismicity Type");
    public static final String SEIS_TYPE_ADD_ON = new String("STEP Add-On Rates");
    public static final String SEIS_TYPE_BACKGROUND = new String("Background Rates");
    public static final String SEIS_TYPE_BOTH = new String("Both");
    public static final String SEIS_TYPE_INFO = new String("Seismicity-type to use in the forecast");
    private StringParameter seisTypeParam;
    private static final String MIN_MAG_PARAM_NAME = "Minimum Magnitude";
    private Double MIN_MAG_PARAM_DEFAULT = 4.0;
    private static final String MIN_MAG_PARAM_UNITS = null;
    private static final String MIN_MAG_PARAM_INFO = "The minimum magnitude to be considered (those below are ignored)";
    private static final double MIN_MAG_PARAM_MIN = 4.0;
    private static final double MIN_MAG_PARAM_MAX = 8.0;
    DoubleParameter minMagParam;

    public STEP_EqkRupForecast() {
        try {
            this.deltaRateFileLines = FileUtils.loadFile(new URL(DELTA_RATES_FILE_NAME));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        StringTokenizer st = new StringTokenizer(this.deltaRateFileLines.get(0).toString());
        int year = Integer.valueOf(st.nextToken());
        int month = Integer.valueOf(st.nextToken());
        int day = Integer.valueOf(st.nextToken());
        int hour = Integer.valueOf(st.nextToken());
        int minute = Integer.valueOf(st.nextToken());
        int second = Integer.valueOf(st.nextToken());
        if (this.D) {
            System.out.println("year=" + year + "; month=" + month + "; day=" + day + "; hour=" + hour + "; minute=" + minute + "; second=" + second);
        }
        st = new StringTokenizer(this.deltaRateFileLines.get(1).toString());
        double duration = Double.valueOf(st.nextToken());
        if (this.D) {
            System.out.println("duration=" + duration);
        }
        this.timeSpan = new TimeSpan("Seconds", "Days");
        this.timeSpan.setStartTime(year, month, day, hour, minute, second);
        this.timeSpan.setDuration(duration);
        this.timeSpan.setStartTimeConstraint("Start Year", year, year);
        this.timeSpan.setStartTimeConstraint("Start Month", month, month);
        this.timeSpan.setStartTimeConstraint("Start Day", day, day);
        this.timeSpan.setStartTimeConstraint("Start Hour", hour, hour);
        this.timeSpan.setStartTimeConstraint("Start Minute", minute, minute);
        this.timeSpan.setStartTimeConstraint("Start Second", second, second);
        this.timeSpan.setDuractionConstraint(duration, duration);
        if (this.D) {
            System.out.println("Start-Time Calendar toString: \n" + this.timeSpan.getStartTimeCalendar().toString());
        }
        if (this.D) {
            System.out.println("Number of lines in delta rate file = " + this.deltaRateFileLines.size());
        }
        if (this.D) {
            System.out.println("Number of lines in background rate file = " + this.backgroundRateFileLines.size());
        }
        this.intiAdjParams();
    }

    private void intiAdjParams() {
        ArrayList<String> seisOptionsStrings = new ArrayList<String>();
        seisOptionsStrings.add(SEIS_TYPE_ADD_ON);
        seisOptionsStrings.add(SEIS_TYPE_BACKGROUND);
        seisOptionsStrings.add(SEIS_TYPE_BOTH);
        StringConstraint constraint = new StringConstraint(seisOptionsStrings);
        this.seisTypeParam = new StringParameter(SEIS_TYPE_NAME, constraint, SEIS_TYPE_BOTH);
        this.seisTypeParam.setInfo(SEIS_TYPE_INFO);
        this.minMagParam = new DoubleParameter(MIN_MAG_PARAM_NAME, 4.0, 8.0, this.MIN_MAG_PARAM_DEFAULT);
        this.minMagParam.setInfo(MIN_MAG_PARAM_INFO);
        this.adjustableParams.addParameter(this.seisTypeParam);
        this.adjustableParams.addParameter(this.minMagParam);
        this.seisTypeParam.addParameterChangeListener(this);
        this.minMagParam.addParameterChangeListener(this);
    }

    private void makeDeltaRateSources() {
        String S = C + ": makeDeltaRateSources(): ";
        if (this.D) {
            System.out.println(S + "Starting");
        }
        this.deltaRateSources = new ArrayList();
        double duration = this.timeSpan.getDuration();
        double minMag = (Double)this.minMagParam.getValue();
        ListIterator it = this.deltaRateFileLines.listIterator();
        StringTokenizer st = new StringTokenizer(it.next().toString());
        st = new StringTokenizer(it.next().toString());
        while (it.hasNext()) {
            st = new StringTokenizer(it.next().toString());
            double lon = Double.parseDouble(st.nextToken());
            double lat = Double.parseDouble(st.nextToken());
            IncrementalMagFreqDist magFreqDist = new IncrementalMagFreqDist(4.0, 8.0, 41);
            for (int i = 0; i < 41; ++i) {
                double rate = Double.parseDouble(st.nextToken());
                magFreqDist.set(i, rate);
            }
            PointSource.PoissonPointSource ptSource = ((PointSource.PoissonBuilder)PointSource.poissonBuilder(new Location(lat, lon, 0.0)).truePointSources()).forMFDAndFocalMech(magFreqDist.getAboveMagnitude(minMag), new FocalMechanism(Double.NaN, 90.0, 0.0)).duration(duration).build();
            if (ptSource.getNumRuptures() <= 0) continue;
            this.deltaRateSources.add(ptSource);
            if (!this.D) continue;
            System.out.println(C + "makeDeltaRateSources(): numRups=" + ptSource.getNumRuptures() + " for source " + this.deltaRateSources.size());
        }
        this.deltaSourcesAlreadyMade = true;
    }

    private void makeBackgroundRateSources() {
        String S = C + ": makeBackgroundRateSources(): ";
        if (this.D) {
            System.out.println(S + "Starting");
        }
        if (!this.backgroundRatesFileAlreadyRead) {
            try {
                this.backgroundRateFileLines = FileUtils.loadJarFile(BACKGROUND_RATES_FILE_NAME);
            }
            catch (Exception e) {
                throw new RuntimeException("Background file could not be loaded");
            }
            this.backgroundRatesFileAlreadyRead = true;
        }
        this.backgroundRateSources = new ArrayList();
        double duration = this.timeSpan.getDuration();
        double minMag = (Double)this.minMagParam.getValue();
        ListIterator it = this.backgroundRateFileLines.listIterator();
        while (it.hasNext()) {
            StringTokenizer st = new StringTokenizer(it.next().toString());
            st.nextToken();
            double lon = Double.parseDouble(st.nextToken());
            double lat = Double.parseDouble(st.nextToken());
            IncrementalMagFreqDist magFreqDist = new IncrementalMagFreqDist(4.0, 8.0, 41);
            for (int j = 0; j < 20; ++j) {
                st.nextToken();
            }
            for (int i = 0; i < 41; ++i) {
                double rate = Double.parseDouble(st.nextToken());
                magFreqDist.set(i, rate);
            }
            PointSource.PoissonPointSource ptSource = ((PointSource.PoissonBuilder)PointSource.poissonBuilder(new Location(lat, lon, 0.0)).truePointSources()).forMFDAndFocalMech(magFreqDist.getAboveMagnitude(minMag), new FocalMechanism(Double.NaN, 90.0, 0.0)).duration(duration).build();
            if (ptSource.getNumRuptures() <= 0) continue;
            this.backgroundRateSources.add(ptSource);
            if (!this.D) continue;
            System.out.println(C + "makeBackgroundRateSources(): numRups=" + ptSource.getNumRuptures() + " for source " + this.backgroundRateSources.size());
        }
        this.backgroundSourcesAlreadyMade = true;
    }

    @Override
    public ProbEqkSource getSource(int iSource) {
        return (ProbEqkSource)this.allSources.get(iSource);
    }

    @Override
    public int getNumSources() {
        return this.allSources.size();
    }

    public Iterator getSourcesIterator() {
        Iterator i = this.getSourceList().iterator();
        return i;
    }

    public ArrayList getSourceList() {
        return this.allSources;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void updateForecast() {
        if (this.parameterChangeFlag) {
            this.allSources = new ArrayList();
            String seisType = (String)this.seisTypeParam.getValue();
            double minMag = (Double)this.minMagParam.getValue();
            if (seisType.equals(SEIS_TYPE_ADD_ON) || seisType.equals(SEIS_TYPE_BOTH)) {
                if (!this.deltaSourcesAlreadyMade || minMag != this.oldMinMag) {
                    this.makeDeltaRateSources();
                }
                this.allSources.addAll(this.deltaRateSources);
            }
            if (seisType.equals(SEIS_TYPE_BACKGROUND) || seisType.equals(SEIS_TYPE_BOTH)) {
                if (!this.backgroundSourcesAlreadyMade || minMag != this.oldMinMag) {
                    this.makeBackgroundRateSources();
                }
                this.allSources.addAll(this.backgroundRateSources);
            }
            this.parameterChangeFlag = false;
            this.oldMinMag = minMag;
        }
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        this.parameterChangeFlag = true;
    }

    public static void main(String[] args) throws Exception {
        double rate;
        Location loc;
        ProbEqkRupture rup;
        int i;
        STEP_EqkRupForecast forecast = new STEP_EqkRupForecast();
        forecast.getAdjustableParameterList().getParameter(SEIS_TYPE_NAME).setValue(SEIS_TYPE_ADD_ON);
        forecast.updateForecast();
        System.out.println("startTimeFromCal:\n " + forecast.getTimeSpan().getStartTimeCalendar().toString());
        System.out.println("Duration: " + forecast.getTimeSpan().getDuration() + "  " + forecast.getTimeSpan().getDurationUnits());
        System.out.println("getNumSources(): " + forecast.getNumSources());
        int index = 0;
        PointSource.PoissonPointSource qkSrc = (PointSource.PoissonPointSource)forecast.getSource(index);
        System.out.println("getNumRuptures(): " + qkSrc.getNumRuptures());
        double duration = qkSrc.getDuration();
        for (i = 0; i < qkSrc.getNumRuptures(); ++i) {
            rup = qkSrc.getRupture(i);
            loc = rup.getRuptureSurface().getFirstLocOnUpperEdge();
            if (i == 0) {
                System.out.println("First Source:\n" + loc.getLongitude() + "  " + loc.getLatitude());
            }
            rate = -Math.log(1.0 - rup.getProbability()) / duration;
            System.out.println((float)rup.getMag() + "  " + rate);
        }
        index = forecast.getNumSources() - 1;
        qkSrc = (PointSource.PoissonPointSource)forecast.getSource(index);
        System.out.println("getNumRuptures(): " + qkSrc.getNumRuptures());
        duration = qkSrc.getDuration();
        for (i = 0; i < qkSrc.getNumRuptures(); ++i) {
            rup = qkSrc.getRupture(i);
            loc = rup.getRuptureSurface().getFirstLocOnUpperEdge();
            if (i == 0) {
                System.out.println("Last Source:\n" + loc.getLongitude() + "  " + loc.getLatitude());
            }
            rate = -Math.log(1.0 - rup.getProbability()) / duration;
            System.out.println((float)rup.getMag() + "  " + rate);
        }
    }
}

