/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.util;

import com.google.common.base.Preconditions;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.earthquake.PointSource;
import org.opensha.sha.earthquake.util.GridCellSupersamplingSettings;
import org.opensha.sha.earthquake.util.SiteDistanceDependentPoissonPointSourceData;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.PointSurface;
import org.opensha.sha.faultSurface.RuptureSurface;

public class GridCellSuperSamplingPoissonPointSourceData
extends SiteDistanceDependentPoissonPointSourceData {
    public GridCellSuperSamplingPoissonPointSourceData(PointSource.PoissonPointSourceData data, Location centerLoc, Region gridCell, GridCellSupersamplingSettings supersampleSettings) {
        this(data, centerLoc, gridCell, supersampleSettings.targetSpacingKM, supersampleSettings.fullDist, supersampleSettings.borderDist, supersampleSettings.cornerDist, supersampleSettings.applyToFinite);
    }

    public GridCellSuperSamplingPoissonPointSourceData(PointSource.PoissonPointSourceData data, Location centerLoc, Region gridCell, double targetSpacingKM, double fullDist, double borderDist, double cornerDist, boolean applyToFinite) {
        int maxSamples;
        if (!applyToFinite) {
            boolean allFinite = true;
            for (int r = 0; allFinite && r < data.getNumRuptures(); ++r) {
                allFinite = data.isFinite(r);
            }
            if (allFinite) {
                this.init(centerLoc, List.of(data), List.of(Double.valueOf(Double.POSITIVE_INFINITY)), data);
                return;
            }
        }
        Preconditions.checkState((boolean)gridCell.contains(centerLoc), (String)"CenterLoc=%s not contined in cell region", (Object)centerLoc);
        double cellWidth = LocationUtils.horzDistanceFast(new Location(centerLoc.getLatitude(), gridCell.getMinLon()), new Location(centerLoc.getLatitude(), gridCell.getMaxLon()));
        double cellHeight = LocationUtils.horzDistanceFast(new Location(gridCell.getMinLat(), centerLoc.getLongitude()), new Location(gridCell.getMaxLat(), centerLoc.getLongitude()));
        double samplesPerWidth = cellWidth / targetSpacingKM;
        double samplesPerHeight = cellHeight / targetSpacingKM;
        int latSamples = (int)Math.round(samplesPerHeight);
        int lonSamples = (int)Math.round(samplesPerWidth);
        if (latSamples % 2 == 1) {
            ++latSamples;
        }
        if (lonSamples % 2 == 1) {
            ++lonSamples;
        }
        Preconditions.checkState(((maxSamples = Integer.max(latSamples, lonSamples)) > 1 ? 1 : 0) != 0, (String)"maxSamples must be >1; was calculated as %s=max(%s,%s) for %s km sample spacing and cell dimensions of %s x %s km", (Object[])new Object[]{maxSamples, latSamples, lonSamples, targetSpacingKM, cellWidth, cellHeight});
        GriddedRegion sampled = GridCellSuperSamplingPoissonPointSourceData.buildSampled(gridCell, latSamples, lonSamples);
        int count = 0;
        if (fullDist > 0.0) {
            ++count;
        }
        if (borderDist > 0.0) {
            if (fullDist > 0.0) {
                Preconditions.checkState((borderDist > fullDist ? 1 : 0) != 0, (String)"Border distance (%s) must be greater than full distance (%s)", (Object)borderDist, (Object)fullDist);
            }
            ++count;
        }
        if (cornerDist > 0.0) {
            if (borderDist > 0.0) {
                Preconditions.checkState((cornerDist > borderDist ? 1 : 0) != 0, (String)"Corner distance (%s) must be greater than border distance (%s)", (Object)cornerDist, (Object)borderDist);
            } else if (fullDist > 0.0) {
                Preconditions.checkState((cornerDist > fullDist ? 1 : 0) != 0, (String)"Corner distance (%s) must be greater than full distance (%s)", (Object)cornerDist, (Object)fullDist);
            }
            ++count;
        }
        ArrayList<PointSource.PoissonPointSourceData> datas = new ArrayList<PointSource.PoissonPointSourceData>(count);
        ArrayList<Double> cutoffDists = new ArrayList<Double>(count);
        if (fullDist > 0.0) {
            datas.add(new LocSamplingWrapper(data, centerLoc, sampled.getNodeList(), applyToFinite));
            cutoffDists.add(fullDist);
        }
        if (borderDist > 0.0) {
            datas.add(new LocSamplingWrapper(data, centerLoc, GridCellSuperSamplingPoissonPointSourceData.getExteriorNodes(sampled), applyToFinite));
            cutoffDists.add(borderDist);
        }
        if (cornerDist > 0.0) {
            LocationList locs = gridCell.isRectangular() ? GridCellSuperSamplingPoissonPointSourceData.getCorners(sampled) : GridCellSuperSamplingPoissonPointSourceData.getResampledExterior(gridCell, 8);
            datas.add(new LocSamplingWrapper(data, centerLoc, locs, applyToFinite));
            cutoffDists.add(cornerDist);
        }
        super.init(centerLoc, datas, cutoffDists, data);
    }

    private static GriddedRegion buildSampled(Region gridCell, int latSamples, int lonSamples) {
        double latSpan = gridCell.getMaxLat() - gridCell.getMinLat();
        double latSpacing = latSpan / (double)latSamples;
        double lonSpan = gridCell.getMaxLon() - gridCell.getMinLon();
        double lonSpacing = lonSpan / (double)lonSamples;
        return new GriddedRegion(gridCell, latSpacing, lonSpacing, new Location(0.5 * latSpacing, 0.5 * lonSpacing));
    }

    private static LocationList getExteriorNodes(GriddedRegion sampled) {
        int numLats = sampled.getNumLatNodes();
        int[] minLonIndexes = new int[numLats];
        int[] maxLonIndexes = new int[numLats];
        for (int i = 0; i < numLats; ++i) {
            minLonIndexes[i] = Integer.MAX_VALUE;
        }
        int minLatIndex = Integer.MAX_VALUE;
        int maxLatIndex = -1;
        LocationList nodes = sampled.getNodeList();
        for (Location loc : nodes) {
            int latIndex = sampled.getLatIndex(loc);
            int lonIndex = sampled.getLonIndex(loc);
            Preconditions.checkState((latIndex >= 0 && lonIndex >= 0 ? 1 : 0) != 0);
            minLatIndex = Integer.min(latIndex, minLatIndex);
            maxLatIndex = Integer.max(latIndex, maxLatIndex);
            minLonIndexes[latIndex] = Integer.min(minLonIndexes[latIndex], lonIndex);
            maxLonIndexes[latIndex] = Integer.max(maxLonIndexes[latIndex], lonIndex);
        }
        LocationList locs = new LocationList();
        for (Location loc : nodes) {
            int latIndex = sampled.getLatIndex(loc);
            int lonIndex = sampled.getLonIndex(loc);
            if (latIndex != minLatIndex && latIndex != maxLatIndex && lonIndex != minLonIndexes[latIndex] && lonIndex != maxLonIndexes[latIndex]) continue;
            locs.add(loc);
        }
        return locs;
    }

    private static LocationList getCorners(GriddedRegion sampled) {
        Preconditions.checkState((boolean)sampled.isRectangular());
        LocationList locs = new LocationList(4);
        locs.add(new Location(sampled.getMinGridLat(), sampled.getMinGridLon()));
        locs.add(new Location(sampled.getMinGridLat(), sampled.getMaxGridLon()));
        locs.add(new Location(sampled.getMaxGridLat(), sampled.getMinGridLon()));
        locs.add(new Location(sampled.getMaxGridLat(), sampled.getMaxGridLon()));
        return locs;
    }

    private static LocationList getResampledExterior(Region cell, int samples) {
        LocationList border = cell.getBorder();
        if (LocationUtils.areSimilar(border.first(), border.last())) {
            border = new LocationList(border);
            border.remove(border.size() - 1);
        }
        FaultTrace borderAsTrace = new FaultTrace(null);
        borderAsTrace.addAll(border);
        borderAsTrace.add(border.first());
        FaultTrace locs = FaultUtils.resampleTrace(borderAsTrace, samples);
        locs.remove(locs.size() - 1);
        return locs;
    }

    public static void main(String[] args) {
        Location centerLoc = new Location(37.0, -110.0);
        double gridSpacing = 0.1;
        Region gridCell = new Region(new Location(centerLoc.getLatitude() - 0.5 * gridSpacing, centerLoc.getLongitude() - 0.5 * gridSpacing), new Location(centerLoc.getLatitude() + 0.5 * gridSpacing, centerLoc.getLongitude() + 0.5 * gridSpacing));
        double spacing = 1.0;
        double fullDist = 30.0;
        double borderDist = 80.0;
        double cornerDist = 160.0;
        PointSource.PoissonPointSourceData fakeData = new PointSource.PoissonPointSourceData(){

            @Override
            public boolean isFinite(int rupIndex) {
                return false;
            }

            @Override
            public RuptureSurface getSurface(int rupIndex) {
                return null;
            }

            @Override
            public double getRate(int rupIndex) {
                return 1.0;
            }

            @Override
            public int getNumRuptures() {
                return 1;
            }

            @Override
            public double getMagnitude(int rupIndex) {
                return 6.0;
            }

            @Override
            public Location getHypocenter(Location sourceLoc, RuptureSurface rupSurface, int rupIndex) {
                return null;
            }

            @Override
            public double getAveRake(int rupIndex) {
                return 0.0;
            }
        };
        GridCellSuperSamplingPoissonPointSourceData sampler = new GridCellSuperSamplingPoissonPointSourceData(fakeData, centerLoc, gridCell, spacing, fullDist, borderDist, cornerDist, false);
        DecimalFormat distDF = new DecimalFormat("0.0");
        double prevDist = 0.0;
        for (int i = 0; i < sampler.datas.size(); ++i) {
            double dist = (Double)sampler.cutoffDistances.get(i);
            System.out.println("[" + distDF.format(prevDist) + ", " + distDF.format(dist) + "] km");
            LocSamplingWrapper data = (LocSamplingWrapper)sampler.datas.get(i);
            System.out.println("\t" + data.numNodes + " nodes");
            prevDist = dist;
        }
    }

    private static class LocSamplingWrapper
    implements PointSource.PoissonPointSourceData {
        private PointSource.PoissonPointSourceData data;
        private Location centerLoc;
        private LocationList samples;
        private int numNodes;
        private double nodeRateScalar;
        private short[] rupDataIndexes;
        private short[] rupNodeIndexes;

        public LocSamplingWrapper(PointSource.PoissonPointSourceData data, Location centerLoc, LocationList samples, boolean applyToFinite) {
            this.data = data;
            this.centerLoc = centerLoc;
            this.samples = samples;
            this.numNodes = samples.size();
            Preconditions.checkState((this.numNodes < Short.MAX_VALUE ? 1 : 0) != 0);
            Preconditions.checkState((data.getNumRuptures() < Short.MAX_VALUE ? 1 : 0) != 0);
            this.nodeRateScalar = 1.0 / (double)this.numNodes;
            if (applyToFinite) {
                int numRuptures = data.getNumRuptures() * this.numNodes;
                this.rupDataIndexes = new short[numRuptures];
                this.rupNodeIndexes = new short[numRuptures];
                for (int r = 0; r < numRuptures; ++r) {
                    this.rupDataIndexes[r] = (short)(r / this.numNodes);
                    this.rupNodeIndexes[r] = (short)(r % this.numNodes);
                }
            } else {
                int sampledNumRuptures = 0;
                int dataNumRuptures = data.getNumRuptures();
                for (int r = 0; r < dataNumRuptures; ++r) {
                    if (data.isFinite(r)) {
                        ++sampledNumRuptures;
                        continue;
                    }
                    sampledNumRuptures += this.numNodes;
                }
                this.rupDataIndexes = new short[sampledNumRuptures];
                this.rupNodeIndexes = new short[sampledNumRuptures];
                int rupIndex = 0;
                for (int dataIndex = 0; dataIndex < dataNumRuptures; ++dataIndex) {
                    if (data.isFinite(dataIndex)) {
                        this.rupDataIndexes[rupIndex] = (short)dataIndex;
                        this.rupNodeIndexes[rupIndex] = -1;
                        ++rupIndex;
                        continue;
                    }
                    for (int n = 0; n < this.numNodes; ++n) {
                        this.rupDataIndexes[rupIndex] = (short)dataIndex;
                        this.rupNodeIndexes[rupIndex] = (short)n;
                        ++rupIndex;
                    }
                }
                Preconditions.checkState((rupIndex == sampledNumRuptures ? 1 : 0) != 0);
            }
        }

        @Override
        public int getNumRuptures() {
            return this.rupDataIndexes.length;
        }

        @Override
        public double getMagnitude(int rupIndex) {
            return this.data.getMagnitude(this.rupDataIndexes[rupIndex]);
        }

        @Override
        public double getAveRake(int rupIndex) {
            return this.data.getAveRake(this.rupDataIndexes[rupIndex]);
        }

        @Override
        public double getRate(int rupIndex) {
            if (this.rupNodeIndexes[rupIndex] < 0) {
                return this.data.getRate(this.rupDataIndexes[rupIndex]);
            }
            return this.data.getRate(this.rupDataIndexes[rupIndex]) * this.nodeRateScalar;
        }

        @Override
        public RuptureSurface getSurface(int rupIndex) {
            RuptureSurface surf = this.data.getSurface(this.rupDataIndexes[rupIndex]);
            if (this.rupNodeIndexes[rupIndex] < 0) {
                return surf;
            }
            Location destLoc = (Location)this.samples.get(this.rupNodeIndexes[rupIndex]);
            if (surf instanceof PointSurface) {
                PointSurface moved = ((PointSurface)surf).copyShallow();
                moved.setLocation(new Location(destLoc.lat, destLoc.lon, moved.getLocation().depth));
                return moved;
            }
            LocationVector vector = LocationUtils.vector(this.centerLoc, destLoc);
            vector.setVertDistance(0.0);
            return surf.getMoved(vector);
        }

        @Override
        public boolean isFinite(int rupIndex) {
            return this.data.isFinite(this.rupDataIndexes[rupIndex]);
        }

        @Override
        public Location getHypocenter(Location sourceLoc, RuptureSurface rupSurface, int rupIndex) {
            Location hypo = this.data.getHypocenter(sourceLoc, rupSurface, this.rupDataIndexes[rupIndex]);
            if (hypo == null || this.rupNodeIndexes[rupIndex] < 0) {
                return hypo;
            }
            Location nodeLoc = (Location)this.samples.get(this.rupNodeIndexes[rupIndex]);
            if (hypo.depth != nodeLoc.depth) {
                nodeLoc = new Location(nodeLoc.lat, nodeLoc.lon, hypo.depth);
            }
            return nodeLoc;
        }
    }
}

