/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface;

import org.opensha.commons.data.Container2D;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.RuptureSurface;

public interface EvenlyGriddedSurface
extends Container2D<Location>,
RuptureSurface {
    public double getGridSpacingAlongStrike();

    public double getGridSpacingDownDip();

    public Boolean isGridSpacingSame();

    public Location getLocation(int var1, int var2);

    public FaultTrace getRowAsTrace(int var1);

    @Override
    default public double getAreaInsideRegion(Region region) {
        double gridSpacingDown = this.getGridSpacingDownDip();
        double gridSpacingAlong = this.getGridSpacingAlongStrike();
        double areaInside = 0.0;
        for (int row = 0; row < this.getNumRows(); ++row) {
            double myWidth = row == 0 || row == this.getNumRows() - 1 ? 0.5 * gridSpacingDown : gridSpacingDown;
            for (int col = 0; col < this.getNumCols(); ++col) {
                double myLen;
                double d = myLen = col == 0 || col == this.getNumCols() - 1 ? 0.5 * gridSpacingAlong : gridSpacingAlong;
                if (!region.contains((Location)this.get(row, col))) continue;
                areaInside += myWidth * myLen;
            }
        }
        return areaInside;
    }
}

