/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface;

import java.util.ListIterator;
import org.opensha.commons.data.ContainerSubset2D;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.geo.Region;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurface;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurfaceWithSubsets;
import org.opensha.sha.faultSurface.EvenlyGriddedSurfFromSimpleFaultData;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.cache.CacheEnabledSurface;
import org.opensha.sha.faultSurface.cache.SurfaceCachingPolicy;
import org.opensha.sha.faultSurface.cache.SurfaceDistanceCache;
import org.opensha.sha.faultSurface.cache.SurfaceDistances;
import org.opensha.sha.faultSurface.utils.GriddedSurfaceUtils;

public class GriddedSubsetSurface
extends ContainerSubset2D<Location>
implements EvenlyGriddedSurface,
CacheEnabledSurface {
    private static final long serialVersionUID = 1L;
    private SurfaceDistanceCache cache = SurfaceCachingPolicy.build(this);
    EvenlyGriddedSurface parentSurface;
    static final char TAB = '\t';

    public GriddedSubsetSurface(int numRows, int numCols, int startRow, int startCol, EvenlyGriddedSurface data) throws ArrayIndexOutOfBoundsException {
        super(numRows, numCols, startRow, startCol, data);
        this.parentSurface = data;
    }

    public void setLocation(int row, int col, Location location) {
        throw new UnsupportedOperationException("This function is not implemented in this subclass");
    }

    public int getMainNumRows() {
        return this.data.getNumRows();
    }

    public int getMainNumCols() {
        return this.data.getNumCols();
    }

    @Override
    public double getAveStrike() {
        return this.getEvenlyDiscritizedUpperEdge().getAveStrike();
    }

    @Override
    public LocationList getEvenlyDiscritizedListOfLocsOnSurface() {
        LocationList locList = new LocationList();
        ListIterator it = this.listIterator();
        while (it.hasNext()) {
            locList.add((Location)it.next());
        }
        return locList;
    }

    @Override
    public double getAveDip() {
        return ((AbstractEvenlyGriddedSurfaceWithSubsets)this.data).getAveDip();
    }

    @Override
    public double getAveLength() {
        return this.getGridSpacingAlongStrike() * (double)(this.getNumCols() - 1);
    }

    @Override
    public double getAveWidth() {
        return this.getGridSpacingDownDip() * (double)(this.getNumRows() - 1);
    }

    @Override
    public LocationList getEvenlyDiscritizedPerimeter() {
        return GriddedSurfaceUtils.getEvenlyDiscritizedPerimeter(this);
    }

    @Override
    public double getGridSpacingAlongStrike() {
        return ((AbstractEvenlyGriddedSurface)this.data).getGridSpacingAlongStrike();
    }

    @Override
    public double getGridSpacingDownDip() {
        return ((AbstractEvenlyGriddedSurface)this.data).getGridSpacingDownDip();
    }

    @Override
    public Boolean isGridSpacingSame() {
        return ((AbstractEvenlyGriddedSurface)this.data).isGridSpacingSame();
    }

    @Override
    public double getArea() {
        return this.getAveWidth() * this.getAveLength();
    }

    @Override
    public Location getLocation(int row, int column) {
        return (Location)this.get(row, column);
    }

    @Override
    public ListIterator<Location> getLocationsIterator() {
        return this.listIterator();
    }

    @Override
    public FaultTrace getRowAsTrace(int row) {
        FaultTrace trace = new FaultTrace(null);
        for (int col = 0; col < this.getNumCols(); ++col) {
            trace.add((Location)this.get(row, col));
        }
        return trace;
    }

    @Override
    public double getAveDipDirection() {
        return ((AbstractEvenlyGriddedSurface)this.data).getAveDipDirection();
    }

    @Override
    public double getAveGridSpacing() {
        return ((AbstractEvenlyGriddedSurface)this.data).getAveGridSpacing();
    }

    @Override
    public FaultTrace getEvenlyDiscritizedUpperEdge() {
        return this.getRowAsTrace(0);
    }

    @Override
    public FaultTrace getEvenlyDiscritizedLowerEdge() {
        return this.getRowAsTrace(this.getNumRows() - 1);
    }

    @Override
    public Location getFirstLocOnUpperEdge() {
        return (Location)this.get(0, 0);
    }

    @Override
    public Location getLastLocOnUpperEdge() {
        return (Location)this.get(0, this.getNumCols() - 1);
    }

    @Override
    public LocationList getPerimeter() {
        FaultTrace topTr = this.getRowAsTrace(0);
        FaultTrace botTr = this.getRowAsTrace(this.getNumRows() - 1);
        botTr.reverse();
        LocationList list = new LocationList();
        list.addAll(topTr);
        list.addAll(botTr);
        list.add((Location)topTr.get(0));
        return list;
    }

    @Override
    public FaultTrace getUpperEdge() {
        return this.getEvenlyDiscritizedUpperEdge();
    }

    @Override
    public SurfaceDistances calcDistances(Location loc) {
        double[] dCalc = GriddedSurfaceUtils.getPropagationDistances(this, loc);
        return new SurfaceDistances(dCalc[0], dCalc[1], dCalc[2]);
    }

    @Override
    public double getQuickDistance(Location siteLoc) {
        return this.cache.getQuickDistance(siteLoc);
    }

    @Override
    public double calcQuickDistance(Location siteLoc) {
        return GriddedSurfaceUtils.getCornerMidpointDistance(this, siteLoc);
    }

    @Override
    public double calcDistanceX(Location loc) {
        return GriddedSurfaceUtils.getDistanceX(this.getEvenlyDiscritizedUpperEdge(), loc);
    }

    @Override
    public double getDistanceRup(Location siteLoc) {
        return this.cache.getSurfaceDistances(siteLoc).getDistanceRup();
    }

    @Override
    public double getDistanceJB(Location siteLoc) {
        return this.cache.getSurfaceDistances(siteLoc).getDistanceJB();
    }

    @Override
    public double getDistanceSeis(Location siteLoc) {
        return this.cache.getSurfaceDistances(siteLoc).getDistanceSeis();
    }

    @Override
    public double getDistanceX(Location siteLoc) {
        return this.cache.getDistanceX(siteLoc);
    }

    @Override
    public double getAveRupTopDepth() {
        if (this.data instanceof EvenlyGriddedSurfFromSimpleFaultData) {
            return this.getLocation(0, 0).getDepth();
        }
        double depth = 0.0;
        FaultTrace topTrace = this.getRowAsTrace(0);
        for (Location loc : topTrace) {
            depth += loc.getDepth();
        }
        return depth / (double)topTrace.size();
    }

    @Override
    public double getFractionOfSurfaceInRegion(Region region) {
        double numInside = 0.0;
        for (Location loc : this) {
            if (!region.contains(loc)) continue;
            numInside += 1.0;
        }
        return numInside / (double)this.size();
    }

    @Override
    public String getInfo() {
        return GriddedSurfaceUtils.getSurfaceInfo(this);
    }

    @Override
    public boolean isPointSurface() {
        return this.size() == 1L;
    }

    public EvenlyGriddedSurface getParentSurface() {
        return this.parentSurface;
    }

    @Override
    public double getMinDistance(RuptureSurface surface) {
        return GriddedSurfaceUtils.getMinDistanceBetweenSurfaces(surface, this);
    }

    @Override
    public RuptureSurface getMoved(LocationVector v) {
        return new GriddedSubsetSurface(this.window.getNumRows(), this.window.getNumCols(), this.window.getStartRow(), this.window.getStartCol(), (EvenlyGriddedSurface)this.parentSurface.getMoved(v));
    }

    @Override
    public GriddedSubsetSurface copyShallow() {
        return new GriddedSubsetSurface(this.window.getNumRows(), this.window.getNumCols(), this.window.getStartRow(), this.window.getStartCol(), this.parentSurface);
    }

    @Override
    public void clearCache() {
        this.cache.clearCache();
    }
}

