/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.sha.faultSurface.SimpleFaultData;

public class SimpleFaultDataList {
    protected static final String C = "SimpleFaultDataList";
    protected static final boolean D = false;
    protected ArrayList<SimpleFaultData> list = new ArrayList();
    protected HashMap<String, SimpleFaultData> map = new HashMap();
    private static final String TAB = "  ";

    public SimpleFaultData getSimpleFaultDataAt(int index) throws InvalidRangeException {
        this.checkIndex(index);
        return this.list.get(index);
    }

    public SimpleFaultData getSimpleFaultData(String name) {
        return this.map.get(name);
    }

    private void checkIndex(int index) throws InvalidRangeException {
        if (this.size() < index + 1) {
            throw new InvalidRangeException("SimpleFaultDataList: getSimpleFaultDataAt(): Specified index larger than array size.");
        }
    }

    public void replaceSimpleFaultDataAt(SimpleFaultData simpleFaultData, int index) throws InvalidRangeException {
        this.checkIndex(index);
        SimpleFaultData f1 = this.getSimpleFaultDataAt(index);
        this.map.remove(f1.getFaultTrace().getName());
        this.list.add(index, simpleFaultData);
        this.map.put(simpleFaultData.getFaultTrace().getName(), simpleFaultData);
    }

    public void addSimpleFaultData(SimpleFaultData simpleFaultData) {
        this.map.put(simpleFaultData.getFaultTrace().getName(), simpleFaultData);
        this.list.add(simpleFaultData);
    }

    public ListIterator<SimpleFaultData> listIterator() {
        return this.list.listIterator();
    }

    public void clear() {
        this.list.clear();
        this.map.clear();
    }

    public int size() {
        return this.list.size();
    }

    public String toString() {
        StringBuffer b = new StringBuffer(C);
        b.append('\n');
        b.append("  Size = " + this.size());
        ListIterator<SimpleFaultData> it = this.listIterator();
        while (it.hasNext()) {
            SimpleFaultData trace = it.next();
            b.append("\n  " + trace.toString());
        }
        return b.toString();
    }
}

