/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.opensha.commons.exceptions.FaultException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurface;
import org.opensha.sha.faultSurface.EvenlyGriddedSurfFromSimpleFaultData;
import org.opensha.sha.faultSurface.FaultTrace;

public class SimpleListricGriddedSurface
extends EvenlyGriddedSurfFromSimpleFaultData {
    private static final long serialVersionUID = 1L;
    protected static final String C = "SimpleListricGriddedSurface";
    protected static final boolean D = false;
    protected static final double PI_RADIANS = Math.PI / 180;
    protected ArrayList<Double> dips;
    protected ArrayList<Double> depths;

    public SimpleListricGriddedSurface(FaultTrace faultTrace, ArrayList<Double> dips, ArrayList<Double> depths, double gridSpacing) throws FaultException {
        this.faultTrace = faultTrace;
        this.dips = dips;
        this.depths = depths;
        this.gridSpacingAlong = gridSpacing;
        this.gridSpacingDown = gridSpacing;
        this.sameGridSpacing = true;
        this.upperSeismogenicDepth = depths.get(0);
        this.lowerSeismogenicDepth = depths.get(depths.size() - 1);
        this.createEvenlyGriddedSurface();
    }

    private void createEvenlyGriddedSurface() throws FaultException {
        double dip;
        Location firstLoc;
        String S = "SimpleListricGriddedSurface: createEvenlyGriddedSurface():";
        this.assertValidData();
        int numSegments = this.faultTrace.getNumLocations() - 1;
        double[] segmentLenth = new double[numSegments];
        double[] segmentAzimuth = new double[numSegments];
        double[] segmentCumLenth = new double[numSegments];
        double cumDistance = 0.0;
        int i = 0;
        double aveDipDirection = this.getAveDipDirection();
        Iterator it = this.faultTrace.iterator();
        Location lastLoc = firstLoc = (Location)it.next();
        Location loc = null;
        LocationVector dir = null;
        while (it.hasNext()) {
            loc = (Location)it.next();
            dir = LocationUtils.vector(lastLoc, loc);
            double azimuth = dir.getAzimuth();
            double distance = dir.getHorzDistance();
            segmentLenth[i] = distance;
            segmentAzimuth[i] = azimuth;
            segmentCumLenth[i] = cumDistance += distance;
            ++i;
            lastLoc = loc;
        }
        double downDipWidth = 0.0;
        double totVert = 0.0;
        double totHorz = 0.0;
        double depthLast = this.depths.get(0);
        for (i = 1; i < this.depths.size(); ++i) {
            double depth = this.depths.get(i);
            dip = this.dips.get(i - 1);
            downDipWidth += Math.abs(depth - depthLast) / Math.sin(dip * (Math.PI / 180));
            totVert += depth - depthLast;
            totHorz += Math.abs(depth - depthLast) / Math.tan(dip * (Math.PI / 180));
            depthLast = depth;
        }
        this.aveDip = Math.atan(totVert / totHorz) / (Math.PI / 180);
        FaultUtils.assertValidDip(this.aveDip);
        int rows = 1 + Math.round((float)(downDipWidth / this.gridSpacingDown));
        int cols = 1 + Math.round((float)(segmentCumLenth[numSegments - 1] / this.gridSpacingAlong));
        this.setNumRowsAndNumCols(rows, cols);
        for (int ith_col = 0; ith_col < cols; ++ith_col) {
            int segmentNumber;
            double distanceAlong = (double)ith_col * this.gridSpacingAlong;
            for (segmentNumber = 1; segmentNumber <= numSegments && distanceAlong > segmentCumLenth[segmentNumber - 1]; ++segmentNumber) {
            }
            if (segmentNumber == numSegments + 1) {
                --segmentNumber;
            }
            double distance = segmentNumber > 1 ? distanceAlong - segmentCumLenth[segmentNumber - 2] : distanceAlong;
            Location location1 = (Location)this.faultTrace.get(segmentNumber - 1);
            dir = new LocationVector(segmentAzimuth[segmentNumber - 1], distance, 0.0);
            Location topLocation = LocationUtils.location(location1, dir);
            this.set(0, ith_col, topLocation.clone());
            dip = this.dips.get(0);
            double hDistance = this.gridSpacingDown * Math.cos(dip * (Math.PI / 180));
            double vDistance = this.gridSpacingDown * Math.sin(dip * (Math.PI / 180));
            dir = new LocationVector(aveDipDirection, hDistance, vDistance);
            int depthNum = 1;
            Location lastLocation = topLocation;
            for (int ith_row = 1; ith_row < rows; ++ith_row) {
                Location nextLocation = LocationUtils.location(lastLocation, dir);
                this.set(ith_row, ith_col, nextLocation.clone());
                if (nextLocation.getDepth() > this.depths.get(depthNum) && ith_row != rows - 1) {
                    dip = this.dips.get(depthNum);
                    hDistance = this.gridSpacingDown * Math.cos(dip * (Math.PI / 180));
                    vDistance = this.gridSpacingDown * Math.sin(dip * (Math.PI / 180));
                    dir = new LocationVector(aveDipDirection, hDistance, vDistance);
                    ++depthNum;
                }
                lastLocation = nextLocation;
            }
        }
    }

    @Override
    protected void assertValidData() throws FaultException {
        for (Double dip : this.dips) {
            FaultUtils.assertValidDip(dip);
        }
        ListIterator<Double> it2 = this.depths.listIterator();
        double depth = it2.next();
        FaultUtils.assertValidDepth(depth);
        double lastDepth = depth;
        while (it2.hasNext()) {
            double nextDepth = it2.next();
            FaultUtils.assertValidDepth(nextDepth);
            if (nextDepth < lastDepth) {
                throw new FaultException("SimpleListricGriddedSurfaceFault depths must be monotonically increasing");
            }
            lastDepth = nextDepth;
        }
        if (this.depths.size() != this.dips.size() + 1) {
            throw new FaultException("SimpleListricGriddedSurfaceNumber of Depths must equal Number of Dips + 1");
        }
        if (this.faultTrace == null) {
            throw new FaultException("SimpleListricGriddedSurfaceFault Trace is null");
        }
        Iterator it = this.faultTrace.iterator();
        while (it.hasNext()) {
            if (((Location)it.next()).getDepth() == depth) continue;
            throw new FaultException("SimpleListricGriddedSurfaceAll depths of faultTrace locations must be same as the first depth in the depths ArrayList");
        }
        if (!(this.gridSpacingAlong > 0.0)) {
            throw new FaultException("SimpleListricGriddedSurfaceinvalid gridSpacing");
        }
    }

    public static void main(String[] args) {
        FaultTrace faultTrace = new FaultTrace("test");
        faultTrace.add(new Location(20.0, -120.0, 0.0));
        faultTrace.add(new Location(20.2, -120.0, 0.0));
        ArrayList<Double> dips = new ArrayList<Double>();
        dips.add(60.0);
        dips.add(45.0);
        ArrayList<Double> depths = new ArrayList<Double>();
        depths.add(0.0);
        depths.add(5.0);
        depths.add(10.0);
        SimpleListricGriddedSurface test = new SimpleListricGriddedSurface(faultTrace, dips, depths, 5.0);
        ListIterator<Location> it = test.getLocationsIterator();
        while (it.hasNext()) {
            Location loc = (Location)it.next();
            System.out.println(loc.getLatitude() + "  " + loc.getLongitude() + "  " + loc.getDepth());
        }
    }

    @Override
    public double getAveDipDirection() {
        return this.faultTrace.getDipDirection();
    }

    @Override
    public LocationList getPerimeter() {
        return this.getEvenlyDiscritizedPerimeter();
    }

    @Override
    public FaultTrace getUpperEdge() {
        return this.faultTrace;
    }

    @Override
    protected AbstractEvenlyGriddedSurface getNewInstance() {
        return new SimpleListricGriddedSurface(this.faultTrace, this.dips, this.depths, this.gridSpacingAlong);
    }
}

