/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface.cache;

import org.opensha.commons.geo.Location;
import org.opensha.sha.faultSurface.WrappedRuptureSurface;
import org.opensha.sha.faultSurface.cache.CacheEnabledSurface;
import org.opensha.sha.faultSurface.cache.SurfaceCachingPolicy;
import org.opensha.sha.faultSurface.cache.SurfaceDistanceCache;
import org.opensha.sha.faultSurface.cache.SurfaceDistances;

public class CustomCacheWrappedSurface
extends WrappedRuptureSurface
implements CacheEnabledSurface {
    private CacheEnabledSurface surf;
    private SurfaceDistanceCache cache;

    public CustomCacheWrappedSurface(CacheEnabledSurface surf) {
        super(surf);
        this.surf = surf;
        this.cache = SurfaceCachingPolicy.build(this, SurfaceCachingPolicy.CacheTypes.SINGLE);
    }

    @Override
    public SurfaceDistances calcDistances(Location loc) {
        return this.surf.calcDistances(loc);
    }

    @Override
    public double calcQuickDistance(Location loc) {
        return this.surf.calcQuickDistance(loc);
    }

    @Override
    public double calcDistanceX(Location loc) {
        return this.surf.calcDistanceX(loc);
    }

    @Override
    public void clearCache() {
        this.cache.clearCache();
    }

    @Override
    public double getQuickDistance(Location siteLoc) {
        return this.cache.getQuickDistance(siteLoc);
    }

    @Override
    public double getDistanceRup(Location siteLoc) {
        return this.cache.getSurfaceDistances(siteLoc).getDistanceRup();
    }

    @Override
    public double getDistanceJB(Location siteLoc) {
        return this.cache.getSurfaceDistances(siteLoc).getDistanceJB();
    }

    @Override
    public double getDistanceSeis(Location siteLoc) {
        return this.cache.getSurfaceDistances(siteLoc).getDistanceSeis();
    }

    @Override
    public double getDistanceX(Location siteLoc) {
        return this.cache.getDistanceX(siteLoc);
    }
}

