/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface.cache;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.opensha.sha.faultSurface.CompoundSurface;
import org.opensha.sha.faultSurface.cache.CacheEnabledSurface;
import org.opensha.sha.faultSurface.cache.DisabledDistanceCache;
import org.opensha.sha.faultSurface.cache.HybridDistanceCache;
import org.opensha.sha.faultSurface.cache.MultiDistanceCache;
import org.opensha.sha.faultSurface.cache.SingleLocDistanceCache;
import org.opensha.sha.faultSurface.cache.SurfaceDistanceCache;
import org.opensha.sha.faultSurface.cache.ThreadLocalSingleLocDistanceCache;

public final class SurfaceCachingPolicy {
    public static final String FORCE_TYPE = "dist.cache.force";
    private static CacheTypes force = null;
    public static final String SIZE_PROP = "dist.cache.size";
    private static int size = Runtime.getRuntime().availableProcessors() + 5;
    public static final String EXP_TIME_PROP = "dist.cache.exp.time";
    private static long expirationTime = 0L;
    public static final String EXP_UNIT_PROP = "dist.cache.exp.unit";
    private static TimeUnit expirationUnit = TimeUnit.HOURS;

    public static void loadConfigFromProps() {
        Properties props = System.getProperties();
        if (props.containsKey(FORCE_TYPE)) {
            force = CacheTypes.valueOf(props.getProperty(FORCE_TYPE));
        }
        if (props.containsKey(SIZE_PROP)) {
            size = Integer.parseInt(props.getProperty(SIZE_PROP));
        }
        if (props.containsKey(EXP_TIME_PROP)) {
            expirationTime = Integer.parseInt(props.getProperty(EXP_TIME_PROP));
        }
        if (props.containsKey(EXP_UNIT_PROP)) {
            String val = props.getProperty(EXP_UNIT_PROP);
            expirationUnit = val.equals("null") ? null : TimeUnit.valueOf(val);
        }
    }

    public static void force(CacheTypes type) {
        force = type;
    }

    public static SurfaceDistanceCache build(CacheEnabledSurface surf) {
        boolean multi;
        if (force != null) {
            return SurfaceCachingPolicy.build(surf, force);
        }
        boolean bl = multi = size > 1 && !(surf instanceof CompoundSurface);
        if (multi) {
            return SurfaceCachingPolicy.build(surf, CacheTypes.HYBRID);
        }
        if (size == 0) {
            return SurfaceCachingPolicy.build(surf, CacheTypes.DISABLED);
        }
        return SurfaceCachingPolicy.build(surf, CacheTypes.SINGLE);
    }

    public static SurfaceDistanceCache build(CacheEnabledSurface surf, CacheTypes type) {
        switch (type.ordinal()) {
            case 0: {
                return new SingleLocDistanceCache(surf);
            }
            case 1: {
                return new MultiDistanceCache(surf, size, expirationTime, expirationUnit);
            }
            case 2: {
                return new HybridDistanceCache(surf, size, expirationTime, expirationUnit);
            }
            case 3: {
                return new ThreadLocalSingleLocDistanceCache(surf, size);
            }
            case 4: {
                return new DisabledDistanceCache(surf);
            }
        }
        throw new IllegalStateException("Unkown cache type: " + String.valueOf((Object)force));
    }

    public static String getPolicyStr() {
        String expUnitStr = expirationUnit == null ? "null" : expirationUnit.name();
        String forceStr = force == null ? "null" : force.name();
        return "force=" + forceStr + ", size=" + size + ", expTime=" + expirationTime + ", expUnit=" + expUnitStr;
    }

    static {
        SurfaceCachingPolicy.loadConfigFromProps();
    }

    public static enum CacheTypes {
        SINGLE,
        MULTI,
        HYBRID,
        THREAD_LOCAL,
        DISABLED;

    }
}

