/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.opensha.commons.calc.magScalingRelations.MagAreaRelationship;
import org.opensha.commons.calc.magScalingRelations.MagLengthRelationship;
import org.opensha.commons.calc.magScalingRelations.MagScalingRelationship;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.WC1994_MagLengthRelationship;
import org.opensha.commons.data.WeightedList;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.earthquake.param.BackgroundRupType;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.FiniteApproxPointSurface;
import org.opensha.sha.faultSurface.FrankelGriddedSurface;
import org.opensha.sha.faultSurface.PointSurface;
import org.opensha.sha.faultSurface.QuadSurface;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.cache.SurfaceCachingPolicy;
import org.opensha.sha.faultSurface.utils.PointSourceDistanceCorrection;
import org.opensha.sha.faultSurface.utils.PointSourceDistanceCorrections;

public class PointSurfaceBuilder {
    private Location loc;
    private double zTop;
    private double zBot;
    private Region sampleFromCell = null;
    private Random rand;
    private double mag = Double.NaN;
    private double strike = Double.NaN;
    private Range<Double> strikeRange = null;
    private double dip = 90.0;
    private double length = Double.NaN;
    private Boolean footwall = null;
    private double rake = Double.NaN;
    private double zHyp = Double.NaN;
    private double zHypFract = 0.5;
    private boolean zHypSample = false;
    private EvenlyDiscretizedFunc zHypCDF = null;
    private EvenlyDiscretizedFunc zHypFractCDF = null;
    private double das = Double.NaN;
    private double dasFract = 0.5;
    private boolean dasSample = false;
    private EvenlyDiscretizedFunc dasCDF = null;
    private EvenlyDiscretizedFunc dasFractCDF = null;
    private MagScalingRelationship scale = WC94;
    private double gridSpacing = 1.0;
    private double width = Double.NaN;
    private static final WC1994_MagLengthRelationship WC94 = new WC1994_MagLengthRelationship();

    public PointSurfaceBuilder(Location loc) {
        this.loc = loc;
        this.zTop = loc.getDepth();
        this.zBot = loc.getDepth();
    }

    public PointSurfaceBuilder sampleFromCell(Region cell) {
        this.sampleFromCell = cell;
        return this;
    }

    public PointSurfaceBuilder random(Random rand) {
        this.rand = rand;
        return this;
    }

    public PointSurfaceBuilder random(long seed) {
        this.rand = new Random(seed);
        return this;
    }

    public PointSurfaceBuilder randomGlobalSeed(long globalSeed) {
        List<Long> seeds = this.getRandSeedElements();
        seeds.add(globalSeed);
        return this.random(new Random(PointSurfaceBuilder.uniqueSeedCombination(seeds)));
    }

    private List<Long> getRandSeedElements() {
        ArrayList<Long> seeds = new ArrayList<Long>();
        seeds.add(Double.doubleToLongBits(this.loc.lat));
        seeds.add(Double.doubleToLongBits(this.loc.lon));
        seeds.add(Double.doubleToLongBits(this.loc.depth));
        seeds.add(Double.doubleToLongBits(this.zTop));
        seeds.add(Double.doubleToLongBits(this.zBot));
        if (this.sampleFromCell != null) {
            seeds.add(Long.valueOf(this.sampleFromCell.hashCode()));
        }
        if (Double.isFinite(this.mag)) {
            seeds.add(Double.doubleToLongBits(this.mag));
        }
        if (Double.isFinite(this.strike)) {
            seeds.add(Double.doubleToLongBits(this.strike));
        }
        if (this.strikeRange != null) {
            seeds.add(Double.doubleToLongBits((Double)this.strikeRange.lowerEndpoint()));
            seeds.add(Double.doubleToLongBits((Double)this.strikeRange.upperEndpoint()));
        }
        seeds.add(Double.doubleToLongBits(this.dip));
        if (Double.isFinite(this.length)) {
            seeds.add(Double.doubleToLongBits(this.length));
        }
        if (this.footwall != null) {
            if (this.footwall.booleanValue()) {
                seeds.add(1L);
            } else {
                seeds.add(2L);
            }
        }
        if (Double.isFinite(this.zHyp)) {
            seeds.add(Double.doubleToLongBits(this.zHyp));
        }
        if (Double.isFinite(this.zHypFract)) {
            seeds.add(Double.doubleToLongBits(this.zHypFract));
        }
        if (this.scale != WC94 && this.scale != null && this.scale.getName() != null) {
            seeds.add(Long.valueOf(this.scale.getName().hashCode()));
        }
        if (Double.isFinite(this.gridSpacing)) {
            seeds.add(Double.doubleToLongBits(this.gridSpacing));
        }
        return seeds;
    }

    private Random getRand() {
        if (this.rand == null) {
            List<Long> seeds = this.getRandSeedElements();
            this.rand = new Random(PointSurfaceBuilder.uniqueSeedCombination(seeds));
        }
        return this.rand;
    }

    private static long uniqueSeedCombination(List<Long> seeds) {
        Preconditions.checkState((!seeds.isEmpty() ? 1 : 0) != 0);
        long result = 1L;
        for (long element : seeds) {
            result = 31L * result + element;
        }
        return result;
    }

    private Location getLoc() {
        if (this.sampleFromCell != null) {
            double minLat = this.sampleFromCell.getMinLat();
            double maxLat = this.sampleFromCell.getMaxLat();
            double latSpan = maxLat - minLat;
            Preconditions.checkState((latSpan > 0.0 ? 1 : 0) != 0);
            double minLon = this.sampleFromCell.getMinLon();
            double maxLon = this.sampleFromCell.getMaxLon();
            double lonSpan = maxLon - minLon;
            Preconditions.checkState((lonSpan > 0.0 ? 1 : 0) != 0);
            Random rand = this.getRand();
            boolean rectangular = this.sampleFromCell.isRectangular();
            int maxNumTries = 100;
            int tries = 0;
            while (true) {
                double lat = minLat + rand.nextDouble() * latSpan;
                double lon = minLon + rand.nextDouble() * latSpan;
                Location randLoc = new Location(lat, lon, this.loc.depth);
                if (rectangular || this.sampleFromCell.contains(randLoc)) {
                    return randLoc;
                }
                Preconditions.checkState((++tries <= maxNumTries ? 1 : 0) != 0, (String)"Couldn't randomly sample a location in the grid cell after %s tries", (int)tries);
            }
        }
        return this.loc;
    }

    public PointSurfaceBuilder dip(double dip) {
        FaultUtils.assertValidDip(dip);
        this.dip = dip;
        this.width = Double.NaN;
        return this;
    }

    public PointSurfaceBuilder singleDepth(double depth) {
        FaultUtils.assertValidDepth(depth);
        this.zTop = depth;
        this.zBot = depth;
        this.width = Double.NaN;
        return this;
    }

    public PointSurfaceBuilder upperDepth(double zTop) {
        FaultUtils.assertValidDepth(zTop);
        this.zTop = zTop;
        this.width = Double.NaN;
        return this;
    }

    public PointSurfaceBuilder lowerDepth(double zBot) {
        FaultUtils.assertValidDepth(zBot);
        this.zBot = zBot;
        this.width = Double.NaN;
        return this;
    }

    public PointSurfaceBuilder upperDepthWidthAndDip(double zTop, double width, double dip) {
        FaultUtils.assertValidDepth(zTop);
        FaultUtils.assertValidDip(dip);
        Preconditions.checkState((width > 0.0 ? 1 : 0) != 0);
        double zBot = dip == 90.0 ? zTop + width : zTop + width * Math.sin(Math.toRadians(dip));
        FaultUtils.assertValidDepth(zBot);
        this.zTop = zTop;
        this.zBot = zBot;
        this.width = width;
        this.dip = dip;
        return this;
    }

    public PointSurfaceBuilder fractionalHypocentralDepth(double zHypFract) {
        Preconditions.checkArgument((zHypFract >= 0.0 && zHypFract <= 1.0 ? 1 : 0) != 0, (String)"zHypFract=%s is not within the range [0,1]", (Object)zHypFract);
        this.zHypFract = zHypFract;
        this.zHyp = Double.NaN;
        this.zHypSample = false;
        this.zHypCDF = null;
        this.zHypFractCDF = null;
        return this;
    }

    public PointSurfaceBuilder hypocentralDepth(double zHyp) {
        FaultUtils.assertValidDepth(zHyp);
        this.zHyp = zHyp;
        this.zHypFract = Double.NaN;
        this.zHypSample = false;
        this.zHypCDF = null;
        this.zHypFractCDF = null;
        return this;
    }

    public PointSurfaceBuilder sampleHypocentralDepths() {
        this.zHypFract = Double.NaN;
        this.zHyp = Double.NaN;
        this.zHypSample = true;
        this.zHypCDF = null;
        this.zHypFractCDF = null;
        return this;
    }

    public PointSurfaceBuilder sampleFractionalHypocentralDepths(EvenlyDiscretizedFunc zHypFractDistribution) {
        Preconditions.checkNotNull((Object)zHypFractDistribution, (Object)"Cannot set the distribution to null. Clear it by setting zHyp another way.");
        Preconditions.checkState(((float)zHypFractDistribution.getMinX() >= 0.0f && (float)zHypFractDistribution.getMaxX() <= 1.0f ? 1 : 0) != 0, (String)"Distribution sum of x values must be in the range [0,1]: [%s,%s]", (Object)Float.valueOf((float)zHypFractDistribution.getMinX()), (Object)Float.valueOf((float)zHypFractDistribution.getMaxX()));
        this.zHypFract = Double.NaN;
        this.zHyp = Double.NaN;
        this.zHypSample = true;
        this.zHypCDF = null;
        this.zHypFractCDF = PointSurfaceBuilder.toCDF(zHypFractDistribution);
        return this;
    }

    public PointSurfaceBuilder sampleHypocentralDepths(EvenlyDiscretizedFunc zHypDistribution) {
        Preconditions.checkNotNull((Object)zHypDistribution, (Object)"Cannot set the distribution to null. Clear it by setting zHyp another way.");
        this.zHypFract = Double.NaN;
        this.zHyp = Double.NaN;
        this.zHypSample = true;
        this.zHypCDF = PointSurfaceBuilder.toCDF(zHypDistribution);
        this.zHypFractCDF = null;
        return this;
    }

    public PointSurfaceBuilder fractionalDAS(double dasFract) {
        Preconditions.checkArgument((dasFract >= 0.0 && dasFract <= 1.0 ? 1 : 0) != 0, (String)"dasFract=%s is not within the range [0,1]", (Object)dasFract);
        this.das = Double.NaN;
        this.dasFract = dasFract;
        this.dasSample = false;
        this.dasCDF = null;
        this.dasFractCDF = null;
        return this;
    }

    public PointSurfaceBuilder das(double das) {
        Preconditions.checkState((das >= 0.0 ? 1 : 0) != 0);
        this.das = das;
        this.dasFract = Double.NaN;
        this.dasSample = false;
        this.dasCDF = null;
        this.dasFractCDF = null;
        return this;
    }

    public PointSurfaceBuilder sampleDASs() {
        this.dasFract = Double.NaN;
        this.das = Double.NaN;
        this.dasSample = true;
        this.dasCDF = null;
        this.dasFractCDF = null;
        return this;
    }

    public PointSurfaceBuilder sampleFractionalDASs(EvenlyDiscretizedFunc dasFractDistribution) {
        Preconditions.checkNotNull((Object)dasFractDistribution, (Object)"Cannot set the distribution to null. Clear it by setting DAS another way.");
        Preconditions.checkState(((float)dasFractDistribution.getMinX() >= 0.0f && (float)dasFractDistribution.getMaxX() <= 1.0f ? 1 : 0) != 0, (String)"Distribution sum of x values must be in the range [0,1]: [%s,%s]", (Object)Float.valueOf((float)dasFractDistribution.getMinX()), (Object)Float.valueOf((float)dasFractDistribution.getMaxX()));
        this.zHypFract = Double.NaN;
        this.zHyp = Double.NaN;
        this.zHypSample = true;
        this.zHypCDF = null;
        this.zHypFractCDF = PointSurfaceBuilder.toCDF(dasFractDistribution);
        return this;
    }

    public PointSurfaceBuilder sampleDASs(EvenlyDiscretizedFunc dasDistribution) {
        Preconditions.checkNotNull((Object)dasDistribution, (Object)"Cannot set the distribution to null. Clear it by setting DAS another way.");
        this.dasFract = Double.NaN;
        this.das = Double.NaN;
        this.dasSample = true;
        this.dasCDF = PointSurfaceBuilder.toCDF(dasDistribution);
        this.dasFractCDF = null;
        return this;
    }

    private static EvenlyDiscretizedFunc toCDF(EvenlyDiscretizedFunc dist) {
        Preconditions.checkState(((float)dist.calcSumOfY_Vals() == 1.0f ? 1 : 0) != 0, (String)"Distribution sum of y values must sum to 1: %s", (Object)Float.valueOf((float)dist.calcSumOfY_Vals()));
        EvenlyDiscretizedFunc cdf = new EvenlyDiscretizedFunc(dist.getMinX(), dist.getMaxX(), dist.size());
        double sumY = 0.0;
        for (int i = 0; i < dist.size(); ++i) {
            cdf.set(i, sumY += dist.getY(i));
        }
        return cdf;
    }

    private static double sampleFromCDF(EvenlyDiscretizedFunc cdf, double randDouble) {
        for (int i = 0; i < cdf.size(); ++i) {
            double cmlProb = cdf.getY(i);
            if (!((float)randDouble <= (float)cmlProb)) continue;
            return cdf.getX(i);
        }
        throw new IllegalStateException("Couldn't sample from CDF with randDouble=" + (float)randDouble + "\nCDF:\n" + String.valueOf(cdf));
    }

    private double getAbsolutelValue(double lowerBound, double upperBound, double fractValue, double absValue, boolean sample, EvenlyDiscretizedFunc fractDist, EvenlyDiscretizedFunc absDist) {
        fractValue = this.getFractionalValue(lowerBound, upperBound, fractValue, absValue, sample, fractDist, absDist);
        return lowerBound + fractValue * (upperBound - lowerBound);
    }

    private double getFractionalValue(double lowerBound, double upperBound, double fractValue, double absValue, boolean sample, EvenlyDiscretizedFunc fractDist, EvenlyDiscretizedFunc absDist) {
        Preconditions.checkState((Double.isFinite(fractValue) || Double.isFinite(absValue) || sample ? 1 : 0) != 0, (Object)"Must specify exactly 1 of absolute, fractional, or sampled values");
        Preconditions.checkState((sample || absDist == null && fractDist == null ? 1 : 0) != 0, (Object)"Samplign is disabled, but a distribution was provided");
        if (Double.isFinite(fractValue)) {
            Preconditions.checkState((!Double.isFinite(absValue) && !sample ? 1 : 0) != 0, (Object)"Must specify exactly 1 of absolute, fractional, or sampled values");
            return fractValue;
        }
        if (Double.isFinite(absValue)) {
            Preconditions.checkState((!Double.isFinite(fractValue) && !sample ? 1 : 0) != 0, (Object)"Must specify exactly 1 of absolute, fractional, or sampled values");
            Preconditions.checkState(((float)absValue >= (float)lowerBound && (float)absValue <= (float)upperBound ? 1 : 0) != 0, (String)"Supplied absolute value %s is not in the allowed range: [%s, %s]", (Object)Float.valueOf((float)absValue), (Object)Float.valueOf((float)lowerBound), (Object)Float.valueOf((float)upperBound));
            return (absValue - lowerBound) / (upperBound - lowerBound);
        }
        Preconditions.checkState((boolean)sample);
        double randDouble = this.getRand().nextDouble();
        if (fractDist != null) {
            return PointSurfaceBuilder.sampleFromCDF(fractDist, randDouble);
        }
        if (absDist != null) {
            absValue = PointSurfaceBuilder.sampleFromCDF(absDist, randDouble);
            Preconditions.checkState(((float)absValue >= (float)lowerBound && (float)absValue <= (float)upperBound ? 1 : 0) != 0, (String)"Supplied absolute value %s is not in the allowed range: [%s, %s]", (Object)Float.valueOf((float)absValue), (Object)Float.valueOf((float)lowerBound), (Object)Float.valueOf((float)upperBound));
            return (absValue - lowerBound) / (upperBound - lowerBound);
        }
        return randDouble;
    }

    public PointSurfaceBuilder magnitude(double mag) {
        this.mag = mag;
        return this;
    }

    public PointSurfaceBuilder scaling(MagScalingRelationship scale) {
        Preconditions.checkNotNull((Object)scale);
        this.scale = scale;
        return this;
    }

    public PointSurfaceBuilder length(double length) {
        this.length = length;
        return this;
    }

    public PointSurfaceBuilder mechanism(FocalMechanism mech) {
        this.strike(mech.getStrike());
        this.dip(mech.getDip());
        return this;
    }

    public PointSurfaceBuilder randomStrike() {
        this.strike(this.getRandStrikes(1, this.strikeRange)[0]);
        return this;
    }

    public PointSurfaceBuilder strike(double strike) {
        this.strike = strike;
        this.strikeRange = null;
        return this;
    }

    public PointSurfaceBuilder strikeRange(double minStrike, double maxStrike) {
        Preconditions.checkState((maxStrike > minStrike ? 1 : 0) != 0, (String)"maxStrike=%s must be greater than minStrike=%s", (Object)maxStrike, (Object)minStrike);
        return this.strikeRange((Range<Double>)Range.closed((Comparable)Double.valueOf(minStrike), (Comparable)Double.valueOf(maxStrike)));
    }

    public PointSurfaceBuilder strikeRange(Range<Double> strikeRange) {
        this.strikeRange = strikeRange;
        this.strike = Double.NaN;
        return this;
    }

    public PointSurfaceBuilder footwall(boolean footwall) {
        this.footwall = footwall;
        return this;
    }

    public PointSurfaceBuilder gridSpacing(double gridSpacing) {
        this.gridSpacing = gridSpacing;
        return this;
    }

    private double getCalcLength() {
        if (Double.isFinite(this.length)) {
            return this.length;
        }
        if (Double.isFinite(this.mag)) {
            if (Double.isFinite(this.rake)) {
                if (this.scale == WC94) {
                    this.scale = new WC1994_MagLengthRelationship();
                }
                this.scale.setRake(this.rake);
            } else if (this.scale != WC94) {
                this.scale.setRake(this.rake);
            }
            if (this.scale instanceof MagLengthRelationship) {
                return ((MagLengthRelationship)this.scale).getMedianLength(this.mag);
            }
            Preconditions.checkState((boolean)(this.scale instanceof MagAreaRelationship));
            double area = ((MagAreaRelationship)this.scale).getMedianArea(this.mag);
            double width = this.getCalcWidth();
            if (width > 0.0) {
                return area / width;
            }
            return 0.0;
        }
        return 0.0;
    }

    private double getCalcWidth() {
        Preconditions.checkState((this.zBot >= this.zTop ? 1 : 0) != 0, (Object)"zBOT must be >= zTOR");
        if (Double.isNaN(this.width)) {
            this.width = this.dip == 90.0 ? this.zBot - this.zTop : (this.zBot - this.zTop) / Math.sin(Math.toRadians(this.dip));
        }
        return this.width;
    }

    public PointSurface buildTruePointSurface() {
        return this.buildTruePointSurface(null);
    }

    public PointSurface buildTruePointSurface(PointSourceDistanceCorrection corr) {
        PointSurface surf = this.loc.depth == this.zTop ? new PointSurface(this.loc) : new PointSurface(this.loc.lat, this.loc.lon, this.zTop);
        surf.setAveDip(this.dip);
        surf.setDistanceCorrection(corr, this.mag);
        return surf;
    }

    public WeightedList<PointSurface> buildTruePointSurfaces(PointSourceDistanceCorrections distCorrType) {
        Object distCorrs = distCorrType == null || distCorrType == PointSourceDistanceCorrections.NONE ? null : distCorrType.get();
        return this.buildTruePointSurfaces((WeightedList<PointSourceDistanceCorrection>)distCorrs);
    }

    public WeightedList<PointSurface> buildTruePointSurfaces(WeightedList<PointSourceDistanceCorrection> distCorrs) {
        if (distCorrs == null) {
            return WeightedList.evenlyWeighted(this.buildTruePointSurface(null));
        }
        if (distCorrs.size() == 1) {
            return WeightedList.evenlyWeighted(this.buildTruePointSurface(distCorrs.getValue(0)));
        }
        WeightedList<PointSurface> ret = new WeightedList<PointSurface>(distCorrs.size());
        for (int i = 0; i < distCorrs.size(); ++i) {
            PointSurface surf = this.buildTruePointSurface(distCorrs.getValue(i));
            ret.add(surf, distCorrs.getWeight(i));
        }
        return ret;
    }

    public FiniteApproxPointSurface buildFiniteApproxPointSurface() {
        return this.buildFiniteApproxPointSurface(null);
    }

    public FiniteApproxPointSurface buildFiniteApproxPointSurface(PointSourceDistanceCorrection corr) {
        Preconditions.checkState((this.footwall != null || this.dip == 90.0 ? 1 : 0) != 0, (Object)"Footwall boolean must be specified if dip != 90");
        boolean footwall = this.footwall == null ? true : this.footwall;
        return this.buildFiniteApproxPointSurface(corr, footwall);
    }

    public FiniteApproxPointSurface buildFiniteApproxPointSurface(PointSourceDistanceCorrection corr, boolean footwall) {
        Preconditions.checkState((this.zBot >= this.zTop ? 1 : 0) != 0, (Object)"zBOT must be >= zTOR");
        double length = this.getCalcLength();
        FiniteApproxPointSurface surf = new FiniteApproxPointSurface(this.getLoc(), this.dip, this.zTop, this.zBot, footwall, length);
        surf.setDistanceCorrection(corr, this.mag);
        return surf;
    }

    public WeightedList<FiniteApproxPointSurface> buildFiniteApproxPointSurfaces(PointSourceDistanceCorrections distCorrType) {
        Object distCorrs = distCorrType == null || distCorrType == PointSourceDistanceCorrections.NONE ? null : distCorrType.get();
        return this.buildFiniteApproxPointSurfaces((WeightedList<PointSourceDistanceCorrection>)distCorrs);
    }

    public WeightedList<FiniteApproxPointSurface> buildFiniteApproxPointSurfaces(WeightedList<PointSourceDistanceCorrection> distCorrs) {
        PointSourceDistanceCorrection singleCorr;
        PointSourceDistanceCorrection pointSourceDistanceCorrection = singleCorr = distCorrs != null && distCorrs.size() == 1 ? distCorrs.getValue(0) : null;
        FiniteApproxPointSurface[] surfs = this.dip == 90.0 || this.footwall != null ? new FiniteApproxPointSurface[]{this.buildFiniteApproxPointSurface(singleCorr, this.footwall == null ? true : this.footwall)} : new FiniteApproxPointSurface[]{this.buildFiniteApproxPointSurface(singleCorr, true), this.buildFiniteApproxPointSurface(singleCorr, false)};
        if (distCorrs != null && distCorrs.size() > 1) {
            double weightEach = 1.0 / (double)surfs.length;
            WeightedList<FiniteApproxPointSurface> ret = new WeightedList<FiniteApproxPointSurface>(distCorrs.size() * surfs.length);
            for (FiniteApproxPointSurface surf : surfs) {
                for (int i = 0; i < distCorrs.size(); ++i) {
                    FiniteApproxPointSurface surfCopy = surf.copyShallow();
                    surfCopy.setDistanceCorrection(singleCorr, this.mag);
                    ret.add(surfCopy, distCorrs.getWeight(i) * weightEach);
                }
            }
            return ret;
        }
        return WeightedList.evenlyWeighted(surfs);
    }

    private FaultTrace buildTrace(double strike) {
        Preconditions.checkState((boolean)Double.isFinite(strike), (String)"Can't build finite surface because strike=%s", (Object)strike);
        double length = this.getCalcLength();
        Preconditions.checkState((length > 0.0 ? 1 : 0) != 0, (String)"Can't build finite surface because length=%s; set magnitude to infer length from scaling relationship", (Object)length);
        double dasFract = this.getFractionalValue(0.0, length, this.dasFract, this.das, this.dasSample, this.dasFractCDF, this.dasCDF);
        double strikeRad = Math.toRadians(strike);
        Location loc = this.getLoc();
        Location l0 = LocationUtils.location(loc, strikeRad - Math.PI, length * dasFract);
        Location l1 = LocationUtils.location(loc, strikeRad, length * (1.0 - dasFract));
        if (this.zBot > this.zTop && this.dip < 90.0) {
            double horzFract = this.getFractionalValue(this.zTop, this.zBot, this.zHypFract, this.zHyp, this.zHypSample, this.zHypFractCDF, this.zHypCDF);
            double horzWidth = (this.zBot - this.zTop) / Math.tan(Math.toRadians(this.dip));
            double transAz = strikeRad - 1.5707963267948966;
            l0 = LocationUtils.location(l0, transAz, horzFract * horzWidth);
            l1 = LocationUtils.location(l1, transAz, horzFract * horzWidth);
        }
        l0 = new Location(l0.lat, l0.lon, this.zTop);
        l1 = new Location(l1.lat, l1.lon, this.zTop);
        FaultTrace trace = new FaultTrace(null);
        trace.add(l0);
        trace.add(l1);
        return trace;
    }

    private double[] getRandStrikes(int num, Range<Double> strikeRange) {
        double[] strikes = new double[num];
        if (strikeRange == null) {
            double origStrike = Double.isFinite(this.strike) ? this.strike : this.getRand().nextDouble() * 360.0;
            double delta = 360.0 / (double)num;
            for (int i = 0; i < num; ++i) {
                strikes[i] = origStrike + (double)i * delta;
            }
        } else {
            double lower = (Double)strikeRange.lowerEndpoint();
            double upper = (Double)strikeRange.upperEndpoint();
            double span = upper - lower;
            Preconditions.checkState((span > 0.0 ? 1 : 0) != 0);
            Random rand = this.getRand();
            for (int i = 0; i < num; ++i) {
                strikes[i] = lower + rand.nextDouble() * span;
            }
        }
        return strikes;
    }

    public QuadSurface buildQuadSurface() {
        return this.buildQuadSurface(this.strike);
    }

    public QuadSurface buildQuadSurface(double strike) {
        FaultTrace trace = this.buildTrace(strike);
        return new QuadSurface(trace, this.dip, this.getCalcWidth(), SurfaceCachingPolicy.CacheTypes.DISABLED);
    }

    public QuadSurface[] buildRandQuadSurfaces(int num) {
        return this.buildRandQuadSurfaces(num, this.strikeRange);
    }

    public QuadSurface[] buildRandQuadSurfaces(int num, Range<Double> strikeRange) {
        QuadSurface[] ret = new QuadSurface[num];
        double[] strikes = this.getRandStrikes(num, strikeRange);
        for (int i = 0; i < num; ++i) {
            ret[i] = this.buildQuadSurface(strikes[i]);
        }
        return ret;
    }

    public EvenlyGriddedSurface buildLineSurface() {
        return this.buildLineSurface(this.strike);
    }

    public EvenlyGriddedSurface buildLineSurface(double strike) {
        FaultTrace trace = this.buildTrace(strike);
        return new FrankelGriddedSurface(trace, this.dip, this.zTop, this.zTop, this.gridSpacing);
    }

    public EvenlyGriddedSurface[] buildRandLineSurfaces(int num) {
        return this.buildRandLineSurfaces(num, null);
    }

    public EvenlyGriddedSurface[] buildRandLineSurfaces(int num, Range<Double> strikeRange) {
        EvenlyGriddedSurface[] ret = new EvenlyGriddedSurface[num];
        double[] strikes = this.getRandStrikes(num, strikeRange);
        for (int i = 0; i < num; ++i) {
            ret[i] = this.buildLineSurface(strikes[i]);
        }
        return ret;
    }

    public EvenlyGriddedSurface buildGriddedSurface() {
        return this.buildGriddedSurface(this.strike);
    }

    public EvenlyGriddedSurface buildGriddedSurface(double strike) {
        Preconditions.checkState((this.zBot >= this.zTop ? 1 : 0) != 0, (Object)"zBOT must be >= zTOR");
        FaultTrace trace = this.buildTrace(strike);
        return new FrankelGriddedSurface(trace, this.dip, this.zTop, this.zBot, this.gridSpacing);
    }

    public EvenlyGriddedSurface[] buildRandGriddedSurfaces(int num) {
        return this.buildRandGriddedSurfaces(num, null);
    }

    public EvenlyGriddedSurface[] buildRandGriddedSurfaces(int num, Range<Double> strikeRange) {
        EvenlyGriddedSurface[] ret = new EvenlyGriddedSurface[num];
        double[] strikes = this.getRandStrikes(num, strikeRange);
        for (int i = 0; i < num; ++i) {
            ret[i] = this.buildGriddedSurface(strikes[i]);
        }
        return ret;
    }

    public WeightedList<? extends RuptureSurface> build(BackgroundRupType bgRupType, PointSourceDistanceCorrections distCorrType) {
        if ((float)this.length == 0.0f) {
            distCorrType = PointSourceDistanceCorrections.NONE;
            return this.buildFiniteApproxPointSurfaces(distCorrType);
        }
        if (Double.isFinite(this.strike) && (float)this.length > 0.0f) {
            return WeightedList.evenlyWeighted(this.buildQuadSurface());
        }
        switch (bgRupType) {
            case POINT: {
                return this.buildFiniteApproxPointSurfaces(distCorrType);
            }
            case FINITE: {
                return WeightedList.evenlyWeighted(this.buildRandQuadSurfaces(1));
            }
            case CROSSHAIR: {
                return WeightedList.evenlyWeighted(this.buildRandQuadSurfaces(2));
            }
        }
        throw new IllegalStateException("Unsupported BackgroundRupType: " + String.valueOf((Object)bgRupType));
    }

    public static void main(String[] args) {
        Location center = new Location(0.0, 0.0);
        PointSurfaceBuilder builder = new PointSurfaceBuilder(center);
        builder.magnitude(7.05);
        builder.upperDepth(1.0);
        builder.lowerDepth(14.0);
        builder.dip(90.0);
        builder.strike(0.0);
        QuadSurface surf = builder.buildQuadSurface();
        System.out.println("Quad rJB at colocated point: " + surf.getDistanceJB(center));
        System.out.println("Trace:\t" + String.valueOf(surf.getUpperEdge()));
    }
}

