/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gcim.imCorrRel.imCorrRelImpl;

import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.sha.gcim.imCorrRel.ImCorrelationRelationship;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.IA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodInterpolatedParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_InterpolatedParam;
import org.opensha.sha.imr.param.OtherParams.TectonicRegionTypeParam;
import org.opensha.sha.util.TectonicRegionType;

public class Baker07_ImCorrRel
extends ImCorrelationRelationship {
    static final String C = "Baker07_ImCorrRel";
    public static final String NAME = "Baker (2007)";
    public static final String SHORT_NAME = "Baker2007";
    private static final long serialVersionUID = 1234567890987654353L;
    public static final String TRT_ACTIVE_SHALLOW = TectonicRegionType.ACTIVE_SHALLOW.toString();
    private double t_min = 0.05;
    private double t_max = 5.0;

    public Baker07_ImCorrRel() {
        this.initOtherParams();
        this.initSupportedIntensityMeasureParams();
        this.ti = Double.NaN;
    }

    @Override
    public double getImCorrelation() {
        if (this.imi.getName() == "SA Interpolated" && this.imj.getName() == "PGA" || this.imi.getName() == "PGA" && this.imj.getName() == "SA Interpolated") {
            if (this.imi.getName() == "SA Interpolated") {
                this.ti = (Double)((SA_InterpolatedParam)this.imi).getPeriodInterpolatedParam().getValue();
            } else if (this.imj.getName() == "SA Interpolated") {
                this.ti = (Double)((SA_InterpolatedParam)this.imj).getPeriodInterpolatedParam().getValue();
            }
            if (this.ti < 0.05) {
                this.ti = 0.05;
            } else if (this.ti > 5.0) {
                this.ti = 5.0;
            }
            if (this.ti < 0.11) {
                return 0.5 - 0.127 * Math.log(this.ti);
            }
            if (this.ti < 0.25) {
                return 0.968 + 0.085 * Math.log(this.ti);
            }
            return 0.568 - 0.204 * Math.log(this.ti);
        }
        if (this.imi.getName() == "SA Interpolated" && this.imj.getName() == "IA" || this.imi.getName() == "IA" && this.imj.getName() == "SA Interpolated") {
            if (this.imi.getName() == "SA Interpolated") {
                this.ti = (Double)((SA_InterpolatedParam)this.imi).getPeriodInterpolatedParam().getValue();
            } else if (this.imj.getName() == "SA Interpolated") {
                this.ti = (Double)((SA_InterpolatedParam)this.imj).getPeriodInterpolatedParam().getValue();
            }
            if (this.ti < 0.05) {
                this.ti = 0.05;
            } else if (this.ti > 5.0) {
                this.ti = 5.0;
            }
            if (this.ti < 0.11) {
                return 0.344 - 0.152 * Math.log(this.ti);
            }
            if (this.ti < 0.4) {
                return 0.971 + 0.131 * Math.log(this.ti);
            }
            return 0.697 - 0.166 * Math.log(this.ti);
        }
        return Double.NaN;
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        StringConstraint trtConstraint = new StringConstraint();
        trtConstraint.addString(TRT_ACTIVE_SHALLOW);
        this.tectonicRegionTypeParam = new TectonicRegionTypeParam(trtConstraint, TRT_ACTIVE_SHALLOW);
        this.tectonicRegionTypeParam.setValueAsDefault();
        this.otherParams.replaceParameter("Tectonic Region", this.tectonicRegionTypeParam);
    }

    protected void initSupportedIntensityMeasureParams() {
        this.InterpPeriodiParam = new PeriodInterpolatedParam(this.t_min, this.t_max, 1.0, false);
        this.saiDampingParam = new DampingParam();
        this.saiInterpParam = new SA_InterpolatedParam(this.InterpPeriodiParam, this.saiDampingParam);
        this.saiInterpParam.setNonEditable();
        this.pgaParam = new PGA_Param();
        this.pgaParam.setNonEditable();
        this.iaParam = new IA_Param();
        this.iaParam.setNonEditable();
        this.supportedIMiParams.clear();
        this.supportedIMjParams.clear();
        this.supportedIMiParams.add(this.saiInterpParam);
        this.supportedIMjParams.add(this.pgaParam);
        this.supportedIMiParams.add(this.pgaParam);
        this.supportedIMjParams.add(this.saiInterpParam);
        this.supportedIMiParams.add(this.saiInterpParam);
        this.supportedIMjParams.add(this.iaParam);
        this.supportedIMiParams.add(this.iaParam);
        this.supportedIMjParams.add(this.saiInterpParam);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }
}

