/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui;

import com.google.common.collect.Lists;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.jfree.data.Range;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.WeightedFuncListforPlotting;
import org.opensha.commons.data.function.XY_DataSetList;
import org.opensha.commons.exceptions.WarningException;
import org.opensha.commons.gui.ControlPanel;
import org.opensha.commons.gui.DisclaimerDialog;
import org.opensha.commons.gui.HelpMenuBuilder;
import org.opensha.commons.gui.plot.GraphWidget;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotElement;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.util.ApplicationVersion;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.ListUtils;
import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.commons.util.bugReports.BugReport;
import org.opensha.commons.util.bugReports.BugReportDialog;
import org.opensha.commons.util.bugReports.DefaultExceptionHandler;
import org.opensha.sha.calc.HazardCurveCalculator;
import org.opensha.sha.calc.HazardCurveCalculatorAPI;
import org.opensha.sha.calc.disaggregation.DisaggregationCalculator;
import org.opensha.sha.calc.disaggregation.DisaggregationCalculatorAPI;
import org.opensha.sha.calc.disaggregation.chart3d.PureJavaDisaggPlotter;
import org.opensha.sha.earthquake.BaseERF;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.ERF_Ref;
import org.opensha.sha.earthquake.EpistemicListERF;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.gcim.calc.GcimCalculator;
import org.opensha.sha.gcim.imCorrRel.ImCorrelationRelationship;
import org.opensha.sha.gcim.ui.GcimControlPanel;
import org.opensha.sha.gcim.ui.infoTools.GcimPlotViewerWindow;
import org.opensha.sha.gui.beans.ERF_GuiBean;
import org.opensha.sha.gui.beans.EqkRupSelectorGuiBean;
import org.opensha.sha.gui.beans.IMR_MultiGuiBean;
import org.opensha.sha.gui.beans.IMT_NewGuiBean;
import org.opensha.sha.gui.beans.Site_GuiBean;
import org.opensha.sha.gui.beans.event.IMTChangeEvent;
import org.opensha.sha.gui.beans.event.IMTChangeListener;
import org.opensha.sha.gui.controls.CalculationSettingsControlPanel;
import org.opensha.sha.gui.controls.CalculationSettingsControlPanelAPI;
import org.opensha.sha.gui.controls.CurveDisplayAppAPI;
import org.opensha.sha.gui.controls.DisaggregationControlPanel;
import org.opensha.sha.gui.controls.ERF_EpistemicListControlPanel;
import org.opensha.sha.gui.controls.PEER_TestCaseSelectorControlPanel;
import org.opensha.sha.gui.controls.PlottingOptionControl;
import org.opensha.sha.gui.controls.RunAll_PEER_TestCasesControlPanel;
import org.opensha.sha.gui.controls.SiteDataControlPanel;
import org.opensha.sha.gui.controls.SitesOfInterestControlPanel;
import org.opensha.sha.gui.controls.XY_ValuesControlPanel;
import org.opensha.sha.gui.controls.X_ValuesInCurveControlPanel;
import org.opensha.sha.gui.infoTools.CalcProgressBar;
import org.opensha.sha.gui.infoTools.DisaggregationPlotViewerWindow;
import org.opensha.sha.gui.infoTools.IMT_Info;
import org.opensha.sha.gui.util.IconFetcher;
import org.opensha.sha.imr.AttenRelRef;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.event.ScalarIMRChangeEvent;
import org.opensha.sha.imr.event.ScalarIMRChangeListener;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_InterpolatedParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.util.TRTUtils;
import org.opensha.sha.util.TectonicRegionType;

public class HazardCurveApplication
extends JFrame
implements ParameterChangeListener,
CurveDisplayAppAPI,
CalculationSettingsControlPanelAPI,
ActionListener,
ScalarIMRChangeListener,
IMTChangeListener {
    private static final long serialVersionUID = 1L;
    private static ApplicationVersion version;
    public static final String APP_NAME = "Hazard Curve Application";
    public static final String APP_SHORT_NAME = "HazardCurveLocal";
    protected String appShortName;
    private static final String C = "HazardCurveServerModeApplication";
    protected static final boolean D = false;
    public static final String PROBABILISTIC = "Probabilistic";
    public static final String DETERMINISTIC = "Deterministic";
    public static final String STOCHASTIC = "Stochastic Event Sets";
    protected static final String CONTROL_PANELS = "Select";
    private PEER_TestCaseSelectorControlPanel peerTestsControlPanel;
    private DisaggregationControlPanel disaggregationControlPanel;
    protected ERF_EpistemicListControlPanel epistemicControlPanel;
    private SiteDataControlPanel cvmControlPanel;
    private RunAll_PEER_TestCasesControlPanel runAllPeerTestsCP;
    protected PlottingOptionControl plotOptionControl;
    private CalculationSettingsControlPanel calcParamsControl;
    private GcimControlPanel gcimControlPanel;
    private ArrayList<ControlPanel> controlPanels;
    private boolean gcimFlag = false;
    protected ArrayList<PlotElement> functionList = new ArrayList();
    protected ArbitrarilyDiscretizedFunc function;
    protected IMT_Info imtInfo = new IMT_Info();
    protected boolean isEqkList = false;
    protected boolean isAllCurves = true;
    protected String fractileOption;
    protected boolean avgSelected = false;
    protected int numERFsInEpistemicList = 0;
    protected int currentERFInEpistemicListForHazardCurve = 0;
    boolean useCustomX_Values = false;
    protected boolean disaggregationFlag = false;
    private String disaggregationString;
    protected boolean isProbabilisticCurve = true;
    protected boolean isDeterministicCurve = false;
    private boolean isStochasticCurve = false;
    private static final String DEFAULT_TITLE;
    private JMenuItem saveMenuItem;
    private JMenuItem printMenuItem;
    private JMenuItem closeMenuItem;
    private JButton computeButton;
    private JButton cancelButton;
    private JButton clearButton;
    private JButton peelButton;
    protected JCheckBox progressCheckBox;
    protected JComboBox<String> controlComboBox;
    protected JComboBox<String> probDeterComboBox;
    private JPanel plotPanel;
    private JSplitPane imrImtSplitPane;
    private JTabbedPane paramsTabbedPane;
    protected GraphWidget graphWidget;
    protected IMR_MultiGuiBean imrGuiBean;
    private IMT_NewGuiBean imtGuiBean;
    protected Site_GuiBean siteGuiBean;
    protected ERF_GuiBean erfGuiBean;
    protected EqkRupSelectorGuiBean erfRupSelectorGuiBean;
    protected HazardCurveCalculatorAPI calc;
    protected DisaggregationCalculatorAPI disaggCalc;
    private GcimCalculator gcimCalc;
    protected CalcProgressBar progressClass;
    private CalcProgressBar disaggProgressClass;
    private CalcProgressBar gcimProgressClass;
    protected CalcProgressBar startAppProgressClass;
    protected Timer timer;
    private Timer disaggTimer;
    private Timer gcimTimer;
    protected boolean isHazardCalcDone = false;
    private CompletableFuture<Void> calcFuture = null;
    private volatile boolean cancelled = false;
    protected String prevSelectedERF_List = null;
    protected WeightedFuncListforPlotting weightedFuncList;
    protected boolean addData = true;
    private static String errorInInitializationMessage;

    public HazardCurveApplication(String appShortName) {
        this.appShortName = appShortName;
    }

    public void init() {
        try {
            this.startAppProgressClass = new CalcProgressBar(null, "Initializing application\u2026");
            this.initIMR_GuiBean();
            this.initIMT_GuiBean();
            this.initSiteGuiBean();
            this.initERF_GuiBean();
            this.imrGuiBean.setTectonicRegions(this.getIncludedTectonicRegionTypes());
            this.jbInit();
            this.computeButton.requestFocusInWindow();
        }
        catch (Exception e) {
            e.printStackTrace();
            BugReport bug = new BugReport(e, errorInInitializationMessage, this.appShortName, HazardCurveApplication.getAppVersion(), this);
            BugReportDialog bugDialog = new BugReportDialog((Component)this, bug, true);
            bugDialog.setVisible(true);
        }
        this.startAppProgressClass.dispose();
    }

    protected String getGuideURL() {
        return null;
    }

    protected String getTutorialURL() {
        return "http://www.opensha.org/tutorial-HazardCurveCalculator";
    }

    private JMenu buildHelpMenu() {
        HelpMenuBuilder builder = new HelpMenuBuilder(APP_NAME, this.appShortName, HazardCurveApplication.getAppVersion(), this);
        builder.setTutorialURL(this.getTutorialURL());
        builder.setGuideURL(this.getGuideURL());
        return builder.buildMenu();
    }

    public static Color getBottomBarColor() {
        Color defaultBackground = UIManager.getColor("Panel.background");
        double avgColor = (double)(defaultBackground.getRed() + defaultBackground.getGreen() + defaultBackground.getBlue()) / 3.0;
        if (avgColor > 127.0) {
            return new Color(220, 220, 220);
        }
        return new Color(35, 35, 35);
    }

    protected void jbInit() throws Exception {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        this.saveMenuItem = new JMenuItem("Save");
        this.saveMenuItem.addActionListener(this);
        fileMenu.add(this.saveMenuItem);
        this.printMenuItem = new JMenuItem("Print");
        this.printMenuItem.addActionListener(this);
        fileMenu.add(this.printMenuItem);
        this.closeMenuItem = new JMenuItem("Exit");
        this.closeMenuItem.addActionListener(this);
        fileMenu.add(this.closeMenuItem);
        menuBar.add(fileMenu);
        menuBar.add(this.buildHelpMenu());
        this.enableMenuButtons();
        Color bg = HazardCurveApplication.getBottomBarColor();
        JPanel buttonPanel = new JPanel(new GridBagLayout()){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(Color.gray);
                g.drawLine(0, 0, this.getWidth(), 0);
            }
        };
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(12, 24, 12, 40));
        buttonPanel.setBackground(bg);
        JLabel shaLogo = new JLabel(new ImageIcon(FileUtils.loadImage("logos/opensha_64.png")));
        JLabel calcTypeLabel = new JLabel("Calculation type:");
        JLabel cpLabel = new JLabel("Control panel:");
        this.controlComboBox = new JComboBox();
        this.initControlList();
        this.controlComboBox.addActionListener(this);
        this.controlComboBox.setMaximumRowCount(32);
        Dimension cbSize = new Dimension(200, 26);
        this.controlComboBox.setPreferredSize(cbSize);
        this.progressCheckBox = new JCheckBox("Show Progress Bar");
        this.progressCheckBox.setSelected(true);
        this.probDeterComboBox = new JComboBox();
        this.initProbOrDeterList();
        this.probDeterComboBox.addActionListener(this);
        this.probDeterComboBox.setPreferredSize(cbSize);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setEnabled(false);
        this.computeButton = new JButton("Compute");
        this.computeButton.addActionListener(this);
        this.computeButton.setDefaultCapable(true);
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0);
        gbc.gridheight = 2;
        gbc.weightx = 0.0;
        buttonPanel.add((Component)shaLogo, gbc);
        ++gbc.gridx;
        gbc.anchor = 10;
        gbc.weightx = 1.0;
        buttonPanel.add((Component)this.progressCheckBox, gbc);
        ++gbc.gridx;
        gbc.gridheight = 1;
        gbc.anchor = 22;
        gbc.weightx = 0.0;
        buttonPanel.add((Component)calcTypeLabel, gbc);
        ++gbc.gridx;
        gbc.anchor = 21;
        buttonPanel.add(this.probDeterComboBox, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.gridheight = 2;
        gbc.anchor = 22;
        buttonPanel.add((Component)this.cancelButton, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        buttonPanel.add((Component)this.computeButton, gbc);
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridheight = 1;
        gbc.anchor = 22;
        buttonPanel.add((Component)cpLabel, gbc);
        ++gbc.gridx;
        gbc.anchor = 21;
        buttonPanel.add(this.controlComboBox, gbc);
        this.clearButton = new JButton("Clear Plot");
        this.clearButton.addActionListener(this);
        this.clearButton.setEnabled(false);
        this.clearButton.putClientProperty("JButton.buttonType", "segmentedTextured");
        this.clearButton.putClientProperty("JButton.segmentPosition", "first");
        this.clearButton.putClientProperty("JComponent.sizeVariant", "small");
        this.peelButton = new JButton("Peel Off");
        this.peelButton.addActionListener(this);
        this.peelButton.setEnabled(false);
        this.peelButton.putClientProperty("JButton.buttonType", "segmentedTextured");
        this.peelButton.putClientProperty("JButton.segmentPosition", "last");
        this.peelButton.putClientProperty("JComponent.sizeVariant", "small");
        this.plotPanel = new JPanel(new BorderLayout());
        this.plotPanel.setBorder(BorderFactory.createEmptyBorder(11, 10, 11, 4));
        this.buildGraphWidget();
        this.imrImtSplitPane = new JSplitPane(0, true, this.imtGuiBean, this.imrGuiBean);
        this.imrImtSplitPane.setResizeWeight(0.18);
        this.imrImtSplitPane.setBorder(null);
        this.imrImtSplitPane.setOpaque(false);
        this.imrImtSplitPane.setMinimumSize(new Dimension(200, 100));
        this.imrImtSplitPane.setPreferredSize(new Dimension(280, 100));
        JSplitPane imrImtSiteSplitPane = new JSplitPane(1, true, this.imrImtSplitPane, this.siteGuiBean);
        imrImtSiteSplitPane.setResizeWeight(0.7);
        imrImtSiteSplitPane.setBorder(BorderFactory.createEmptyBorder(2, 8, 8, 8));
        imrImtSiteSplitPane.setOpaque(false);
        this.paramsTabbedPane = new JTabbedPane();
        this.paramsTabbedPane.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 4));
        this.paramsTabbedPane.add((Component)imrImtSiteSplitPane, "IMR, IMT & Site");
        this.erfGuiBean.setBorder(BorderFactory.createEmptyBorder(2, 8, 8, 4));
        this.paramsTabbedPane.add((Component)this.erfGuiBean, "ERF & Time Span");
        this.paramsTabbedPane.setMinimumSize(new Dimension(320, 100));
        this.paramsTabbedPane.setPreferredSize(new Dimension(480, 100));
        JSplitPane contentSplitPane = new JSplitPane(1, true, this.plotPanel, this.paramsTabbedPane);
        contentSplitPane.setResizeWeight(1.0);
        contentSplitPane.setBorder(null);
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        content.add((Component)contentSplitPane, "Center");
        content.add((Component)buttonPanel, "South");
        this.setDefaultCloseOperation(3);
        this.setTitle("Hazard Curve Application (" + String.valueOf(HazardCurveApplication.getAppVersion()) + ")");
        this.setSize(1000, 720);
        contentSplitPane.setDividerLocation(500);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int xPos = (dim.width - this.getWidth()) / 2;
        this.setLocation(xPos, 0);
        this.setJMenuBar(menuBar);
        this.getRootPane().setDefaultButton(this.computeButton);
        this.imrGuiBean.setSelectedSingleIMR("Campbell & Bozorgnia (2008)");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src.equals(this.closeMenuItem)) {
            this.close();
        } else if (src.equals(this.saveMenuItem)) {
            this.save();
        } else if (src.equals(this.printMenuItem)) {
            this.print();
        } else if (src.equals(this.clearButton)) {
            this.clearPlot();
        } else if (src.equals(this.computeButton)) {
            this.addButton_actionPerformed();
        } else if (src.equals(this.controlComboBox)) {
            this.selectControlPanel();
        } else if (src.equals(this.probDeterComboBox)) {
            this.probDeterSelectionChange();
        } else if (src.equals(this.peelButton)) {
            this.peelOffCurves();
        } else if (src.equals(this.cancelButton)) {
            this.cancelCalculation();
        }
    }

    protected void setImtPanel(ParameterListEditor panel, double resizeWeight) {
        this.imrImtSplitPane.setTopComponent(panel);
        this.imrImtSplitPane.setResizeWeight(resizeWeight);
    }

    public String getAppletInfo() {
        return "Hazard Curves Applet";
    }

    public static ApplicationVersion getAppVersion() {
        if (version == null) {
            try {
                version = ApplicationVersion.loadBuildVersion();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return version;
    }

    public static void main(String[] args) throws IOException {
        new DisclaimerDialog(APP_NAME, APP_SHORT_NAME, HazardCurveApplication.getAppVersion());
        DefaultExceptionHandler exp = new DefaultExceptionHandler(APP_SHORT_NAME, HazardCurveApplication.getAppVersion(), null, null);
        Thread.setDefaultUncaughtExceptionHandler(exp);
        HazardCurveApplication.launch(exp);
    }

    public static HazardCurveApplication launch(DefaultExceptionHandler handler) {
        HazardCurveApplication applet = new HazardCurveApplication(APP_SHORT_NAME);
        if (handler != null) {
            handler.setApp(applet);
            handler.setParent(applet);
        }
        applet.init();
        applet.setIconImages(IconFetcher.fetchIcons(APP_SHORT_NAME));
        applet.setVisible(true);
        applet.computeButton.requestFocusInWindow();
        return applet;
    }

    private void addGraphPanel() {
        PlotSpec spec = this.graphWidget.getPlotSpec();
        spec.setPlotElems(this.functionList);
        this.graphWidget.drawGraph();
    }

    void addButton_actionPerformed() {
        if (this.runAllPeerTestsCP != null) {
            if (this.runAllPeerTestsCP.runAllPEER_TestCases()) {
                try {
                    this.progressCheckBox.setSelected(false);
                    String peerDirName = "PEER_TESTS/";
                    File peerDir = new File(peerDirName);
                    if (!peerDir.isDirectory()) {
                        new File(peerDirName).mkdir();
                    }
                    ArrayList<String> testCases = this.peerTestsControlPanel.getPEER_SetOneTestCasesNames();
                    int size = testCases.size();
                    this.setAverageSelected(true);
                    for (int i = 0; i < size; ++i) {
                        System.out.println("Working on # " + (i + 1) + " of " + size);
                        this.peerTestsControlPanel.setTestCaseAndSite(testCases.get(i));
                        this.calculate();
                        FileWriter peerFile = new FileWriter(peerDirName + testCases.get(i) + "-PGA_OpenSHA.txt");
                        DiscretizedFunc func = (DiscretizedFunc)this.functionList.get(0);
                        for (int j = 0; j < func.size(); ++j) {
                            peerFile.write(func.get(j).getX() + "\t" + func.get(j).getY() + "\n");
                        }
                        peerFile.close();
                        this.clearPlot();
                    }
                    System.exit(101);
                }
                catch (Exception ee) {
                    BugReport bug = new BugReport(ee, this.getParametersInfoAsString(), this.appShortName, HazardCurveApplication.getAppVersion(), this);
                    BugReportDialog bugDialog = new BugReportDialog((Component)this, bug, false);
                    bugDialog.setVisible(true);
                }
            }
        } else {
            this.cancelButton.setEnabled(true);
            this.calculate();
        }
    }

    protected void createCalcInstance() {
        try {
            if (this.calc == null) {
                this.calc = new HazardCurveCalculator();
                this.calc.setTrackProgress(true);
                if (this.calcParamsControl != null) {
                    this.calc.setAdjustableParams(this.calcParamsControl.getAdjustableCalcParams());
                }
            }
            if (this.disaggregationFlag && this.disaggCalc == null) {
                this.disaggCalc = new DisaggregationCalculator();
            }
            if (this.gcimFlag && this.gcimCalc == null) {
                this.gcimCalc = new GcimCalculator();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BugReport bug = new BugReport(e, this.getParametersInfoAsString(), this.appShortName, HazardCurveApplication.getAppVersion(), this);
            BugReportDialog bugDialog = new BugReportDialog((Component)this, bug, true);
            bugDialog.setVisible(true);
        }
    }

    protected void initTimers() {
        this.startPrimaryTimer();
        this.startDisaggTimer();
        this.startGcimTimer();
    }

    protected void startPrimaryTimer() {
        this.timer = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (!HazardCurveApplication.this.isEqkList) {
                        int totRupture = HazardCurveApplication.this.calc.getTotRuptures();
                        int currRupture = HazardCurveApplication.this.calc.getCurrRuptures();
                        boolean totCurCalculated = true;
                        if (currRupture == -1) {
                            HazardCurveApplication.this.progressClass.setProgressMessage("Calculating total ruptures\u2026");
                            totCurCalculated = false;
                        }
                        if (!HazardCurveApplication.this.isHazardCalcDone && totCurCalculated) {
                            HazardCurveApplication.this.progressClass.updateProgress(currRupture, totRupture);
                        }
                    } else if (HazardCurveApplication.this.numERFsInEpistemicList != 0) {
                        HazardCurveApplication.this.progressClass.updateProgress(HazardCurveApplication.this.currentERFInEpistemicListForHazardCurve, HazardCurveApplication.this.numERFsInEpistemicList);
                    }
                    if (HazardCurveApplication.this.isHazardCalcDone) {
                        HazardCurveApplication.this.timer.stop();
                        HazardCurveApplication.this.progressClass.dispose();
                        HazardCurveApplication.this.drawGraph();
                    }
                }
                catch (Exception e) {
                    HazardCurveApplication.this.timer.stop();
                    HazardCurveApplication.this.setButtonsEnable(true);
                    e.printStackTrace();
                    BugReport bug = new BugReport(e, HazardCurveApplication.this.getParametersInfoAsString(), HazardCurveApplication.APP_NAME, HazardCurveApplication.getAppVersion(), HazardCurveApplication.this.getApplicationComponent());
                    BugReportDialog bugDialog = new BugReportDialog(HazardCurveApplication.this.getApplicationComponent(), bug, false);
                    bugDialog.setVisible(true);
                }
            }
        });
    }

    protected void startDisaggTimer() {
        this.disaggTimer = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    int totalRupture = HazardCurveApplication.this.disaggCalc.getTotRuptures();
                    int currRupture = HazardCurveApplication.this.disaggCalc.getCurrRuptures();
                    boolean calcDone = HazardCurveApplication.this.disaggCalc.done();
                    if (!calcDone) {
                        HazardCurveApplication.this.disaggProgressClass.updateProgress(currRupture, totalRupture);
                    }
                    if (calcDone) {
                        HazardCurveApplication.this.disaggTimer.stop();
                        HazardCurveApplication.this.disaggProgressClass.dispose();
                    }
                }
                catch (Exception e) {
                    HazardCurveApplication.this.disaggTimer.stop();
                    HazardCurveApplication.this.setButtonsEnable(true);
                    e.printStackTrace();
                    BugReport bug = new BugReport(e, HazardCurveApplication.this.getParametersInfoAsString(), HazardCurveApplication.APP_NAME, HazardCurveApplication.getAppVersion(), HazardCurveApplication.this.getApplicationComponent());
                    BugReportDialog bugDialog = new BugReportDialog(HazardCurveApplication.this.getApplicationComponent(), bug, false);
                    bugDialog.setVisible(true);
                }
            }
        });
    }

    private void startGcimTimer() {
        this.gcimTimer = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    int totalIMi = HazardCurveApplication.this.gcimCalc.getTotIMi();
                    int currIMi = HazardCurveApplication.this.gcimCalc.getCurrIMi();
                    boolean calcDone = HazardCurveApplication.this.gcimCalc.done();
                    if (!calcDone) {
                        HazardCurveApplication.this.gcimProgressClass.updateProgress(currIMi, totalIMi);
                    }
                    if (calcDone) {
                        HazardCurveApplication.this.gcimTimer.stop();
                        HazardCurveApplication.this.gcimProgressClass.dispose();
                    }
                }
                catch (Exception e) {
                    HazardCurveApplication.this.gcimTimer.stop();
                    HazardCurveApplication.this.setButtonsEnable(true);
                    e.printStackTrace();
                    BugReport bug = new BugReport(e, HazardCurveApplication.this.getParametersInfoAsString(), HazardCurveApplication.APP_NAME, HazardCurveApplication.getAppVersion(), HazardCurveApplication.this.getApplicationComponent());
                    BugReportDialog bugDialog = new BugReportDialog(HazardCurveApplication.this.getApplicationComponent(), bug, false);
                    bugDialog.setVisible(true);
                }
            }
        });
    }

    protected void calculate() {
        this.signalReset();
        this.setButtonsEnable(false);
        if (this.plotOptionControl != null) {
            this.addData = this.plotOptionControl.getSelectedOption().equals("Plot on top of existing dataset");
        }
        try {
            this.createCalcInstance();
        }
        catch (Exception e) {
            this.setButtonsEnable(true);
            e.printStackTrace();
            BugReport bug = new BugReport(e, this.getParametersInfoAsString(), this.appShortName, HazardCurveApplication.getAppVersion(), this);
            BugReportDialog bugDialog = new BugReportDialog((Component)this, bug, false);
            bugDialog.setVisible(true);
        }
        if (this.progressCheckBox.isSelected()) {
            this.calcFuture = CompletableFuture.runAsync(() -> {
                try {
                    this.computeHazardCurve();
                    this.cancelButton.setEnabled(false);
                    this.erfGuiBean.closeProgressBar();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    BugReport bug = new BugReport(t, this.getParametersInfoAsString(), this.appShortName, HazardCurveApplication.getAppVersion(), this);
                    BugReportDialog bugDialog = new BugReportDialog((Component)this, bug, false);
                    bugDialog.setVisible(true);
                    this.setButtonsEnable(true);
                }
            });
            this.initTimers();
        } else {
            this.computeHazardCurve();
            this.drawGraph();
        }
    }

    protected Component getApplicationComponent() {
        return this;
    }

    protected void drawGraph() {
        HazardCurveApplication.runInEDT(new Runnable(){

            @Override
            public void run() {
                HazardCurveApplication.this.addGraphPanel();
                if (!HazardCurveApplication.this.disaggregationFlag) {
                    HazardCurveApplication.this.setButtonsEnable(true);
                }
            }
        });
    }

    public void plotGraphUsingPlotPreferences() {
        this.drawGraph();
    }

    private void clearPlot() {
        this.graphWidget.setAutoRange();
        this.graphWidget.removeChartAndMetadata();
        this.functionList = Lists.newArrayList();
        this.graphWidget.getButtonControlPanel().setEnabled(false);
        this.enableMenuButtons();
        this.validate();
        this.repaint();
    }

    public void setDisaggregationSelected(boolean isSelected) {
        this.disaggregationFlag = isSelected;
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        String S = "HazardCurveServerModeApplication: parameterChange(): ";
        String name1 = event.getParameterName();
        if (name1.equalsIgnoreCase("IMR")) {
            this.updateSiteParams();
        }
        if (name1.equalsIgnoreCase("Eqk Rup Forecast")) {
            String plottingOption = null;
            if (this.plotOptionControl != null) {
                plottingOption = this.plotOptionControl.getSelectedOption();
            }
            if (this.erfGuiBean.isEpistemicList()) {
                this.showControlPanel("Epistemic List Control");
            } else if (plottingOption != null && plottingOption.equalsIgnoreCase("Add to existing dataset")) {
                JOptionPane.showMessageDialog(this, "Cannot add to existing without selecting ERF Epistemic list", "Input Error", 1);
                this.plotOptionControl.setSelectedOption("Plot on top of existing dataset");
                this.setButtonsEnable(true);
            }
            this.imrGuiBean.setTectonicRegions(this.getIncludedTectonicRegionTypes());
        }
    }

    protected void setButtonsEnable(boolean b) {
        this.computeButton.setEnabled(b);
        this.graphWidget.getButtonControlPanel().setEnabled(b);
        this.progressCheckBox.setEnabled(b);
        this.enableMenuButtons();
    }

    private void enableMenuButtons() {
        boolean enableSavePrint = this.functionList != null && this.functionList.size() > 0;
        this.saveMenuItem.setEnabled(enableSavePrint);
        this.printMenuItem.setEnabled(enableSavePrint);
    }

    protected void computeHazardCurve() {
        BugReportDialog bugDialog;
        BugReport bug;
        double probVal;
        double imlVal;
        int num;
        this.isHazardCalcDone = false;
        BaseERF forecast = null;
        if (this.isCancelled()) {
            return;
        }
        try {
            if (!this.isDeterministicCurve) {
                this.erfGuiBean.showProgressBar(this.progressCheckBox.isSelected());
                forecast = this.erfGuiBean.getSelectedERF();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = e.getMessage() != null ? e.getMessage() : e.toString();
            JOptionPane.showMessageDialog(this, message, "Incorrect Values", 0);
            this.setButtonsEnable(true);
            return;
        }
        if (this.progressCheckBox.isSelected()) {
            this.progressClass = new CalcProgressBar((Component)this, "Calculation Status", "Starting\u2026");
            this.timer.start();
        }
        if (this.isCancelled()) {
            return;
        }
        Map<TectonicRegionType, ScalarIMR> imrMap = this.imrGuiBean.getIMRMap();
        ScalarIMR firstIMRFromMap = TRTUtils.getFirstIMR(imrMap);
        Site site = this.siteGuiBean.getSite();
        try {
            this.imtGuiBean.setIMTinIMRs(imrMap);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            BugReport bug2 = new BugReport(ex, this.getParametersInfoAsString(), this.appShortName, HazardCurveApplication.getAppVersion(), this);
            BugReportDialog bugDialog2 = new BugReportDialog((Component)this, bug2, false);
            bugDialog2.setVisible(true);
        }
        if (forecast instanceof EpistemicListERF && !this.isDeterministicCurve) {
            if (this.addData) {
                this.prevSelectedERF_List = forecast.getName();
            } else if (this.prevSelectedERF_List == null || !this.prevSelectedERF_List.equals(forecast.getName())) {
                JOptionPane.showMessageDialog(this, "Cannot add to existing without selecting same ERF Epistemic list", "Input Error", 1);
                return;
            }
            this.isEqkList = true;
            this.handleForecastList(site, imrMap, forecast);
            this.currentERFInEpistemicListForHazardCurve = 0;
            this.numERFsInEpistemicList = 0;
            this.isHazardCalcDone = true;
            return;
        }
        this.prevSelectedERF_List = null;
        this.isEqkList = false;
        ArbitrarilyDiscretizedFunc hazFunction = new ArbitrarilyDiscretizedFunc();
        this.initX_Values(hazFunction);
        try {
            try {
                if (this.isProbabilisticCurve) {
                    hazFunction = (ArbitrarilyDiscretizedFunc)this.calc.getHazardCurve((DiscretizedFunc)hazFunction, site, imrMap, (ERF)forecast);
                } else if (this.isStochasticCurve) {
                    hazFunction = (ArbitrarilyDiscretizedFunc)this.calc.getAverageEventSetHazardCurve(hazFunction, site, this.imrGuiBean.getSelectedIMR(), (ERF)forecast);
                } else {
                    HazardCurveApplication.runInEDT(new Runnable(){

                        @Override
                        public void run() {
                            HazardCurveApplication.this.progressCheckBox.setSelected(false);
                            HazardCurveApplication.this.progressCheckBox.setEnabled(false);
                        }
                    });
                    ScalarIMR imr = this.imrGuiBean.getSelectedIMR();
                    EqkRupture rupture = this.erfRupSelectorGuiBean.getRupture();
                    hazFunction = (ArbitrarilyDiscretizedFunc)this.calc.getHazardCurve((DiscretizedFunc)hazFunction, site, imr, rupture);
                    HazardCurveApplication.runInEDT(new Runnable(){

                        @Override
                        public void run() {
                            HazardCurveApplication.this.progressCheckBox.setSelected(true);
                            HazardCurveApplication.this.progressCheckBox.setEnabled(true);
                        }
                    });
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.setButtonsEnable(true);
                BugReport bug3 = new BugReport(e, this.getParametersInfoAsString(), this.appShortName, HazardCurveApplication.getAppVersion(), this);
                BugReportDialog bugDialog3 = new BugReportDialog((Component)this, bug3, false);
                bugDialog3.setVisible(true);
            }
            hazFunction = this.toggleHazFuncLogValues(hazFunction);
            hazFunction.setInfo(this.getParametersInfoAsString());
        }
        catch (RuntimeException e) {
            if (!this.isCancelled()) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Parameters Invalid", 1);
            }
            e.printStackTrace();
            this.setButtonsEnable(true);
            return;
        }
        this.functionList.add(hazFunction);
        String imt = this.imtGuiBean.getSelectedIMT();
        final String xAxisName = imt + " (" + firstIMRFromMap.getParameter(imt).getUnits() + ")";
        String yAxisName = "Probability of Exceedance";
        HazardCurveApplication.runInEDT(new Runnable(){
            final /* synthetic */ HazardCurveApplication this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.graphWidget.setXAxisLabel(xAxisName);
                this.this$0.graphWidget.setYAxisLabel("Probability of Exceedance");
            }
        });
        this.isHazardCalcDone = true;
        this.disaggregationString = null;
        if (this.disaggregationFlag && this.isStochasticCurve) {
            final HazardCurveApplication parent = this;
            HazardCurveApplication.runInEDT(new Runnable(){
                final /* synthetic */ HazardCurveApplication this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(parent, "Disaggregation not yet supported with stochastic event-set calculations", "Input Error", 1);
                    this.this$0.setButtonsEnable(true);
                }
            });
            return;
        }
        if (this.disaggregationFlag && this.isProbabilisticCurve) {
            if (this.progressCheckBox.isSelected()) {
                this.disaggProgressClass = new CalcProgressBar((Component)this, "Disaggregation Status", "Beginning disaggregation\u2026");
                this.disaggTimer.start();
            }
            num = hazFunction.size();
            boolean disaggSuccessFlag = false;
            boolean disaggrAtIML = false;
            double disaggregationVal = this.disaggregationControlPanel.getDisaggregationVal();
            String disaggregationParamVal = this.disaggregationControlPanel.getDisaggregationParamValue();
            double minMag = this.disaggregationControlPanel.getMinMag();
            double deltaMag = this.disaggregationControlPanel.getdeltaMag();
            int numMag = this.disaggregationControlPanel.getNumMag();
            double minDist = this.disaggregationControlPanel.getMinDist();
            double deltaDist = this.disaggregationControlPanel.getdeltaDist();
            int numDist = this.disaggregationControlPanel.getNumDist();
            int numSourcesForDisag = this.disaggregationControlPanel.getNumSourcesForDisagg();
            boolean showSourceDistances = this.disaggregationControlPanel.isShowSourceDistances();
            double maxZAxis = this.disaggregationControlPanel.getZAxisMax();
            imlVal = 0.0;
            probVal = 0.0;
            try {
                if (this.disaggregationControlPanel.isCustomDistBinning()) {
                    double[] distBins = this.disaggregationControlPanel.getCustomBinEdges();
                    this.disaggCalc.setDistanceRange(distBins);
                } else {
                    this.disaggCalc.setDistanceRange(minDist, numDist, deltaDist);
                }
                this.disaggCalc.setMagRange(minMag, numMag, deltaMag);
                this.disaggCalc.setNumSourcesToShow(numSourcesForDisag);
                this.disaggCalc.setShowDistances(showSourceDistances);
            }
            catch (Exception e) {
                this.setButtonsEnable(true);
                e.printStackTrace();
                bug = new BugReport(e, this.getParametersInfoAsString(), this.appShortName, HazardCurveApplication.getAppVersion(), this);
                bugDialog = new BugReportDialog((Component)this, bug, false);
                bugDialog.setVisible(true);
            }
            try {
                if (disaggregationParamVal.equals("Probability")) {
                    disaggrAtIML = false;
                    if (disaggregationVal > hazFunction.getY(0) || disaggregationVal < hazFunction.getY(num - 1)) {
                        JOptionPane.showMessageDialog(this, new String("Chosen Probability is not within the range of the min and max prob. in the Hazard Curve"), "Disaggregation error message", 0);
                    } else {
                        imlVal = hazFunction.getFirstInterpolatedX_inLogXLogYDomain(disaggregationVal);
                        probVal = disaggregationVal;
                    }
                } else if (disaggregationParamVal.equals("IML")) {
                    disaggrAtIML = true;
                    if (disaggregationVal < hazFunction.getX(0) || disaggregationVal > hazFunction.getX(num - 1)) {
                        JOptionPane.showMessageDialog(this, new String("Chosen IML is not within the range of the min and max IML values in the Hazard Curve"), "Disaggregation error message", 0);
                    } else {
                        imlVal = disaggregationVal;
                        probVal = hazFunction.getInterpolatedY_inLogXLogYDomain(disaggregationVal);
                    }
                }
                disaggSuccessFlag = this.disaggCalc.disaggregate(Math.log(imlVal), site, imrMap, (ERF)forecast, this.calc.getSourceFilters(), this.calc.getAdjustableParams());
                this.disaggCalc.setMaxZAxisForPlot(maxZAxis);
                this.disaggregationString = this.disaggCalc.getMeanAndModeInfo();
            }
            catch (WarningException warningException) {
                this.setButtonsEnable(true);
                JOptionPane.showMessageDialog(this, warningException.getMessage());
            }
            catch (Exception e) {
                this.setButtonsEnable(true);
                e.printStackTrace();
                bug = new BugReport(e, this.getParametersInfoAsString(), this.appShortName, HazardCurveApplication.getAppVersion(), this);
                bugDialog = new BugReportDialog((Component)this, bug, false);
                bugDialog.setVisible(true);
            }
            if (disaggSuccessFlag) {
                this.showDisaggregationResults(numSourcesForDisag, disaggrAtIML, imlVal, probVal);
            } else if (!this.isCancelled()) {
                JOptionPane.showMessageDialog(this, "Disaggregation failed because there is no exceedance above \n the given IML (or that interpolated from the chosen probability).", "Disaggregation Message", 0);
            }
        }
        this.disaggregationString = null;
        if (this.gcimFlag && this.isProbabilisticCurve) {
            this.gcimCalc = new GcimCalculator();
            if (this.progressCheckBox.isSelected()) {
                this.gcimProgressClass = new CalcProgressBar("GCIM Calc Status", "Beginning GCIM calculations ");
                this.gcimTimer.start();
            }
            num = hazFunction.size();
            boolean gcimSuccessFlag = false;
            boolean gcimRealizationSuccessFlag = false;
            boolean gcimAtIML = false;
            Site gcimSite = this.gcimControlPanel.getGcimSite();
            double gcimVal = this.gcimControlPanel.getGcimVal();
            String gcimParamVal = this.gcimControlPanel.getGcimParamValue();
            int gcimNumIMi = this.gcimControlPanel.getNumIMi();
            double minApproxZVal = this.gcimControlPanel.getMinApproxZ();
            double maxApproxZVal = this.gcimControlPanel.getMaxApproxZ();
            double deltaApproxZVal = this.gcimControlPanel.getDeltaApproxZ();
            int numGcimRealizations = this.gcimControlPanel.getNumGcimRealizations();
            ArrayList<String> imiTypes = this.gcimControlPanel.getImiTypes();
            ArrayList<? extends Map<TectonicRegionType, ScalarIMR>> imiMapAttenRels = this.gcimControlPanel.getImris();
            ArrayList<? extends Map<TectonicRegionType, ImCorrelationRelationship>> imijCorrRels = this.gcimControlPanel.getImCorrRels();
            ArrayList<? extends Map<TectonicRegionType, ImCorrelationRelationship>> imikCorrRels = this.gcimControlPanel.getImikCorrRels();
            this.gcimCalc.setApproxCDFvalues(minApproxZVal, maxApproxZVal, deltaApproxZVal);
            imlVal = 0.0;
            probVal = 0.0;
            try {
                if (gcimParamVal.equals("Probability")) {
                    gcimAtIML = false;
                    if (gcimVal > hazFunction.getY(0) || gcimVal < hazFunction.getY(num - 1)) {
                        JOptionPane.showMessageDialog(this, new String("Chosen Probability is not within the range of the min and max prob. in the Hazard Curve"), "GCIM error message", 0);
                    } else {
                        imlVal = hazFunction.getFirstInterpolatedX_inLogXLogYDomain(gcimVal);
                        probVal = gcimVal;
                    }
                } else if (gcimParamVal.equals("IML")) {
                    gcimAtIML = true;
                    if (gcimVal < hazFunction.getX(0) || gcimVal > hazFunction.getX(num - 1)) {
                        JOptionPane.showMessageDialog(this, new String("Chosen IML is not within the range of the min and max IML values in the Hazard Curve"), "GCIM error message", 0);
                    } else {
                        imlVal = gcimVal;
                        probVal = hazFunction.getInterpolatedY_inLogXLogYDomain(gcimVal);
                    }
                }
                this.gcimCalc.getRuptureContributions(Math.log(imlVal), gcimSite, imrMap, (ERF)forecast, this.calc.getSourceFilters(), this.calc.getAdjustableParams());
                gcimSuccessFlag = this.gcimCalc.getMultipleGcims(gcimNumIMi, imiMapAttenRels, imiTypes, imijCorrRels, this.calc.getMaxSourceDistance(), this.calc.getMagDistCutoffFunc());
                gcimRealizationSuccessFlag = numGcimRealizations > 0 ? this.gcimCalc.getGcimRealizations(numGcimRealizations, gcimNumIMi, imiMapAttenRels, imiTypes, imijCorrRels, imikCorrRels, this.calc.getMaxSourceDistance(), this.calc.getMagDistCutoffFunc()) : true;
            }
            catch (WarningException warningException) {
                this.setButtonsEnable(true);
                JOptionPane.showMessageDialog(this, warningException.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.setButtonsEnable(true);
                bug = new BugReport(e, this.getParametersInfoAsString(), this.appShortName, HazardCurveApplication.getAppVersion(), this);
                bugDialog = new BugReportDialog((Component)this, bug, false);
                bugDialog.setVisible(true);
            }
            if (gcimSuccessFlag & gcimRealizationSuccessFlag) {
                Object imjName = firstIMRFromMap.getIntensityMeasure().getName() == "SA" ? "SA (" + String.valueOf(((SA_Param)firstIMRFromMap.getIntensityMeasure()).getPeriodParam().getValue()) + "s)" : (firstIMRFromMap.getIntensityMeasure().getName() == "SA Interpolated" ? "SA (" + String.valueOf(((SA_InterpolatedParam)firstIMRFromMap.getIntensityMeasure()).getPeriodInterpolatedParam().getValue()) + "s)" : firstIMRFromMap.getIntensityMeasure().getName());
                this.showGcimResults((String)imjName, gcimAtIML, imlVal, probVal);
            } else {
                JOptionPane.showMessageDialog(this, "GCIM calculations failed because there is no exceedance above \n the given IML (or that interpolated from the chosen probability).", "GCIM Message", 0);
            }
        }
        HazardCurveApplication.runInEDT(new Runnable(){

            @Override
            public void run() {
                HazardCurveApplication.this.setButtonsEnable(true);
            }
        });
    }

    protected static void runInEDT(Runnable run) {
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InterruptedException | InvocationTargetException e) {
                ExceptionUtils.throwAsRuntimeException(e);
            }
        }
    }

    protected void showDisaggregationResults(int numSourceToShow, boolean imlBasedDisaggr, double imlVal, double probVal) {
        boolean binDataToShow = this.disaggregationControlPanel.isShowDisaggrBinDataSelected();
        String disaggregationPlotWebAddr = null;
        Object metadata = this.getMapParametersInfoAsHTML();
        Object modeString = "";
        modeString = imlBasedDisaggr ? "Disaggregation Results for IML = " + imlVal + " (for Prob = " + (float)probVal + ")" : "Disaggregation Results for Prob = " + probVal + " (for IML = " + (float)imlVal + ")";
        modeString = (String)modeString + "\n" + this.disaggregationString;
        if (this.disaggregationControlPanel.isUseGMT()) {
            try {
                disaggregationPlotWebAddr = this.getDisaggregationPlot();
                metadata = (String)metadata + "<br><br>Click  <a href=\"" + disaggregationPlotWebAddr + "\">here</a> to download files. They will be deleted at midnight";
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, e.getMessage(), "Server Problem", 1);
                return;
            }
            new DisaggregationPlotViewerWindow(disaggregationPlotWebAddr + "DisaggregationPlot.pdf", this.disaggCalc, (String)modeString, (String)metadata, binDataToShow);
        } else {
            new DisaggregationPlotViewerWindow(PureJavaDisaggPlotter.buildChartPanel(this.disaggCalc.getDisaggPlotData()), this.disaggCalc, (String)modeString, (String)metadata, binDataToShow);
        }
    }

    protected void handleForecastList(Site site, Map<TectonicRegionType, ScalarIMR> imrMap, BaseERF eqkRupForecast) {
        EpistemicListERF erfList = (EpistemicListERF)eqkRupForecast;
        this.numERFsInEpistemicList = erfList.getNumERFs();
        if (this.addData) {
            this.weightedFuncList = new WeightedFuncListforPlotting();
        } else if (!this.addData && this.weightedFuncList == null) {
            JOptionPane.showMessageDialog(this, "No ERF List Exists", "Wrong selection", 0);
            return;
        }
        XY_DataSetList hazardFuncList = new XY_DataSetList();
        for (int i = 0; i < this.numERFsInEpistemicList; ++i) {
            if (this.isCancelled()) {
                return;
            }
            this.currentERFInEpistemicListForHazardCurve = i;
            ArbitrarilyDiscretizedFunc hazFunction = new ArbitrarilyDiscretizedFunc();
            this.initX_Values(hazFunction);
            try {
                block21: {
                    try {
                        if (this.isProbabilisticCurve) {
                            hazFunction = (ArbitrarilyDiscretizedFunc)this.calc.getHazardCurve((DiscretizedFunc)hazFunction, site, imrMap, erfList.getERF(i));
                            break block21;
                        }
                        if (this.isStochasticCurve) {
                            hazFunction = (ArbitrarilyDiscretizedFunc)this.calc.getAverageEventSetHazardCurve(hazFunction, site, this.imrGuiBean.getSelectedIMR(), erfList.getERF(i));
                            break block21;
                        }
                        throw new RuntimeException("Can't disaggregate with deterministic calculations");
                    }
                    catch (Exception e) {
                        this.setButtonsEnable(true);
                        e.printStackTrace();
                        BugReport bug = new BugReport(e, this.getParametersInfoAsString(), this.appShortName, HazardCurveApplication.getAppVersion(), this);
                        BugReportDialog bugDialog = new BugReportDialog((Component)this, bug, false);
                        bugDialog.setVisible(true);
                    }
                }
                hazFunction = this.toggleHazFuncLogValues(hazFunction);
            }
            catch (RuntimeException e) {
                if (!this.isCancelled()) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Parameters Invalid", 1);
                }
                this.setButtonsEnable(true);
                e.printStackTrace();
                return;
            }
            hazardFuncList.add(hazFunction);
        }
        this.weightedFuncList.addList(erfList.getRelativeWeightsList(), hazardFuncList);
        if (this.addData) {
            this.weightedFuncList.setInfo(this.getParametersInfoAsString());
        } else {
            this.weightedFuncList.setInfo(this.getParametersInfoAsString() + "\nPrevious List Info:\n--------------------\n" + this.weightedFuncList.getInfo());
        }
        if (!this.isAllCurves) {
            this.weightedFuncList.setIndividualCurvesToPlot(false);
        } else {
            this.weightedFuncList.setIndividualCurvesToPlot(true);
        }
        if (this.fractileOption.equalsIgnoreCase("Plot Fractiles")) {
            this.weightedFuncList.setFractilesToPlot(true);
            this.weightedFuncList.addFractiles(this.epistemicControlPanel.getSelectedFractileValues());
        } else {
            this.weightedFuncList.setFractilesToPlot(false);
        }
        if (this.avgSelected) {
            this.weightedFuncList.setMeanToPlot(true);
            this.weightedFuncList.addMean();
        } else {
            this.weightedFuncList.setMeanToPlot(false);
        }
        if (this.addData) {
            this.functionList.add(this.weightedFuncList);
        }
        String xAxisName = this.imtGuiBean.getSelectedIMT();
        String yAxisName = "Probability of Exceedance";
        this.graphWidget.setXAxisLabel(xAxisName);
        this.graphWidget.setYAxisLabel(yAxisName);
    }

    protected void probDeterSelectionChange() {
        String prevTypeCalc = this.isProbabilisticCurve ? PROBABILISTIC : (this.isDeterministicCurve ? DETERMINISTIC : STOCHASTIC);
        String selectedControl = this.probDeterComboBox.getSelectedItem().toString();
        if (selectedControl.equalsIgnoreCase(PROBABILISTIC)) {
            this.isProbabilisticCurve = true;
            this.isStochasticCurve = false;
            this.isDeterministicCurve = false;
        } else if (selectedControl.equalsIgnoreCase(STOCHASTIC)) {
            this.isProbabilisticCurve = false;
            this.isStochasticCurve = true;
            this.isDeterministicCurve = false;
        } else if (selectedControl.equalsIgnoreCase(DETERMINISTIC)) {
            this.isProbabilisticCurve = false;
            this.isStochasticCurve = false;
            this.isDeterministicCurve = true;
        }
        this.imrGuiBean.setMultipleIMRsEnabled(selectedControl.equalsIgnoreCase(PROBABILISTIC));
        if (prevTypeCalc.equalsIgnoreCase(DETERMINISTIC)) {
            try {
                this.paramsTabbedPane.remove(1);
                this.erfGuiBean.refreshGUI();
                this.paramsTabbedPane.add((Component)this.erfGuiBean, "ERF & Time Span");
            }
            catch (RuntimeException ee) {
                ee.printStackTrace();
                JOptionPane.showMessageDialog(this, "Connection to ERF failed", "Internet Connection Problem", 0);
                System.exit(0);
            }
        } else if (selectedControl.equalsIgnoreCase(DETERMINISTIC)) {
            try {
                this.initERFSelector_GuiBean();
                this.paramsTabbedPane.remove(1);
                this.paramsTabbedPane.add((Component)this.erfRupSelectorGuiBean, "ERF & Time Span");
            }
            catch (RuntimeException ee) {
                ee.printStackTrace();
                JOptionPane.showMessageDialog(this, "Connection to ERF failed", "Internet Connection Problem", 0);
                System.exit(0);
            }
        }
        this.calc = null;
        this.createCalcInstance();
    }

    protected void initIMR_GuiBean() {
        List<AttenuationRelationship> imrs = AttenRelRef.instanceList(null, true, ServerPrefUtils.SERVER_PREFS);
        for (ScalarIMR scalarIMR : imrs) {
            scalarIMR.setParamDefaults();
        }
        this.imrGuiBean = new IMR_MultiGuiBean(imrs);
        this.imrGuiBean.addIMRChangeListener(this);
        this.imrGuiBean.setMaxChooserChars(30);
        this.imrGuiBean.rebuildGUI();
    }

    protected void initIMT_GuiBean() {
        this.imtGuiBean = new IMT_NewGuiBean(this.imrGuiBean);
        this.imtGuiBean.setSelectedIMT("SA");
        this.imtGuiBean.setMinimumSize(new Dimension(200, 90));
        this.imtGuiBean.setPreferredSize(new Dimension(290, 220));
        this.imtGuiBean.addIMTChangeListener(this);
    }

    protected void initSiteGuiBean() {
        this.siteGuiBean = new Site_GuiBean();
        this.siteGuiBean.addSiteParams(this.imrGuiBean.getMultiIMRSiteParamIterator());
    }

    protected void initERF_GuiBean() {
        if (this.erfGuiBean == null) {
            try {
                this.erfGuiBean = new ERF_GuiBean(ERF_Ref.get(true, ServerPrefUtils.SERVER_PREFS));
                this.erfGuiBean.getParameter("Eqk Rup Forecast").addParameterChangeListener(this);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                BugReport bug = new BugReport(e, errorInInitializationMessage, this.appShortName, HazardCurveApplication.getAppVersion(), this);
                BugReportDialog bugDialog = new BugReportDialog((Component)this, bug, true);
                bugDialog.setVisible(true);
            }
        } else {
            boolean isCustomRupture = this.erfRupSelectorGuiBean.isCustomRuptureSelected();
            if (!isCustomRupture) {
                ERF eqkRupForecast = this.erfRupSelectorGuiBean.getSelectedEqkRupForecastModel();
                this.erfGuiBean.setERF(eqkRupForecast);
            }
        }
    }

    protected void initERFSelector_GuiBean() {
        BaseERF erf = null;
        try {
            erf = this.erfGuiBean.getSelectedERF();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        if (this.erfRupSelectorGuiBean == null) {
            try {
                this.erfRupSelectorGuiBean = new EqkRupSelectorGuiBean(erf, ERF_Ref.get(false, ServerPrefUtils.SERVER_PREFS));
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Connection to ERF's failed");
            }
        } else {
            this.erfRupSelectorGuiBean.setEqkRupForecastModel(erf);
        }
    }

    protected void initCommonControlList() {
        this.controlPanels = new ArrayList();
        this.controlComboBox.addItem(CONTROL_PANELS);
        this.controlComboBox.addItem("Calculation Settings");
        this.controlPanels.add(new CalculationSettingsControlPanel(this, this));
        this.controlComboBox.addItem("Sites of Interest");
        this.controlPanels.add(new SitesOfInterestControlPanel(this, this.siteGuiBean));
        this.controlComboBox.addItem("Set Site Params from Web Services");
        this.cvmControlPanel = new SiteDataControlPanel(this, this.imrGuiBean, this.siteGuiBean);
        this.controlPanels.add(this.cvmControlPanel);
        this.controlComboBox.addItem("Set X values for Hazard Curve Calc.");
        this.controlPanels.add(new X_ValuesInCurveControlPanel(this, this));
        this.controlComboBox.addItem("Set new dataset plotting option");
        this.controlPanels.add(new PlottingOptionControl(this));
        this.controlComboBox.addItem("Set external XY dataset");
        this.controlPanels.add(new XY_ValuesControlPanel(this, this));
        this.controlComboBox.addItem("Epistemic List Control");
        this.epistemicControlPanel = new ERF_EpistemicListControlPanel(this, this);
        System.out.println("init: " + this.epistemicControlPanel.getName());
        this.controlPanels.add(this.epistemicControlPanel);
    }

    protected void initControlList() {
        this.initCommonControlList();
        this.controlComboBox.addItem("PEER Test Case Selector");
        this.controlPanels.add(new PEER_TestCaseSelectorControlPanel(this, this, this.imrGuiBean, this.siteGuiBean, this.imtGuiBean, this.erfGuiBean, this.erfGuiBean.getSelectedERFTimespanGuiBean(), this));
        this.controlComboBox.addItem("Disaggregation");
        this.disaggregationControlPanel = new DisaggregationControlPanel(this, this);
        this.controlPanels.add(this.disaggregationControlPanel);
        this.controlComboBox.addItem("Run all PEER Test Cases");
        this.controlPanels.add(new RunAll_PEER_TestCasesControlPanel(this));
        this.controlComboBox.addItem("GCIM distributions");
        this.gcimControlPanel = new GcimControlPanel(this, this);
        this.controlPanels.add(this.gcimControlPanel);
    }

    protected void selectControlPanel() {
        if (this.controlComboBox.getItemCount() <= 0) {
            return;
        }
        String selectedControl = this.controlComboBox.getSelectedItem().toString();
        if (selectedControl == "GCIM distributions") {
            this.gcimControlPanel.updateWithParentDetails();
        }
        this.showControlPanel(selectedControl);
        this.controlComboBox.setSelectedItem(CONTROL_PANELS);
    }

    @Override
    public ParameterList getCalcAdjustableParams() {
        if (this.calc == null) {
            this.createCalcInstance();
        }
        return this.calc.getAdjustableParams();
    }

    @Override
    public String getCalcParamMetadataString() {
        ParameterList params = this.getCalcAdjustableParams();
        if (params == null) {
            return "";
        }
        return params.getParameterListMetadataString();
    }

    @Override
    public String getSelectedIMT() {
        return this.imtGuiBean.getSelectedIMT();
    }

    public SiteDataControlPanel getCVMControl() {
        if (this.cvmControlPanel == null) {
            this.cvmControlPanel = new SiteDataControlPanel(this, this.imrGuiBean, this.siteGuiBean);
        }
        if (!this.cvmControlPanel.isInitialized()) {
            this.cvmControlPanel.init();
        }
        return this.cvmControlPanel;
    }

    protected void showControlPanel(String controlName) {
        ControlPanel control = (ControlPanel)ListUtils.getObjectByName(this.controlPanels, controlName);
        System.out.println("controlName: " + controlName);
        System.out.println("control:" + String.valueOf(control));
        if (control == null) {
            throw new NullPointerException("Control Panel '" + controlName + "' not found!");
        }
        this.showControlPanel(control);
    }

    protected void showControlPanel(ControlPanel control) {
        control.showControlPanel();
    }

    protected void initProbOrDeterList() {
        this.probDeterComboBox.addItem(PROBABILISTIC);
        this.probDeterComboBox.addItem(DETERMINISTIC);
        this.probDeterComboBox.addItem(STOCHASTIC);
    }

    public Range getX_AxisRange() {
        return this.graphWidget.getX_AxisRange();
    }

    public Range getY_AxisRange() {
        return this.graphWidget.getY_AxisRange();
    }

    @Override
    public void setCurveXValues() {
        this.useCustomX_Values = false;
    }

    @Override
    public void setCurveXValues(ArbitrarilyDiscretizedFunc func) {
        this.useCustomX_Values = true;
        this.function = func;
    }

    @Override
    public void addCurve(ArbitrarilyDiscretizedFunc function) {
        this.functionList.add(function);
        this.enableMenuButtons();
        List<PlotCurveCharacterstics> plotFeaturesList = this.getPlottingFeatures();
        plotFeaturesList.add(new PlotCurveCharacterstics(null, 1.0f, PlotSymbol.CROSS, 4.0f, Color.BLACK));
        this.addGraphPanel();
    }

    protected void initX_Values(DiscretizedFunc arb) {
        if (!this.useCustomX_Values) {
            this.function = this.imtInfo.getDefaultHazardCurve(this.imtGuiBean.getSelectedIMT());
        }
        if (IMT_Info.isIMT_LogNormalDist(this.imtGuiBean.getSelectedIMT())) {
            for (int i = 0; i < this.function.size(); ++i) {
                arb.set(Math.log(this.function.getX(i)), 1.0);
            }
        } else {
            throw new RuntimeException("Unsupported IMT");
        }
    }

    protected ArbitrarilyDiscretizedFunc toggleHazFuncLogValues(ArbitrarilyDiscretizedFunc hazFunc) {
        int numPoints = hazFunc.size();
        ArbitrarilyDiscretizedFunc tempFunc = hazFunc.deepClone();
        hazFunc = new ArbitrarilyDiscretizedFunc();
        if (IMT_Info.isIMT_LogNormalDist(this.imtGuiBean.getSelectedIMT())) {
            for (int i = 0; i < numPoints; ++i) {
                hazFunc.set(this.function.getX(i), tempFunc.getY(i));
            }
            return hazFunc;
        }
        throw new RuntimeException("Unsupported IMT");
    }

    public void setPlotAllCurves(boolean drawAllCurves) {
        this.isAllCurves = drawAllCurves;
    }

    public void setFractileOption(String fractileOption) {
        this.fractileOption = fractileOption;
    }

    public void setAverageSelected(boolean isAvgSelected) {
        this.avgSelected = isAvgSelected;
    }

    public String getParametersInfoAsString() {
        return this.getMapParametersInfoAsHTML().replaceAll("<br>", System.lineSeparator());
    }

    public String getERFParametersInfoAsHTML() {
        String calcType = this.probDeterComboBox.getSelectedItem().toString();
        StringBuilder str = new StringBuilder();
        if (calcType.equalsIgnoreCase(DETERMINISTIC)) {
            this.erfRupSelectorGuiBean.getParameterListMetadataString();
            str.append("Deterministic Earthquake Rupture Param List: ").append("<br>").append("--------------------").append("<br>").append(this.erfRupSelectorGuiBean.getParameterListMetadataString()).append("<br><br>");
        } else {
            str.append("Forecast Param List: ").append("<br>").append("--------------------").append("<br>").append(this.erfGuiBean.getERFParameterList().getParameterListMetadataString()).append("<br><br>").append("TimeSpan Param List: ").append("<br>").append("--------------------").append("<br>").append(this.erfGuiBean.getSelectedERFTimespanGuiBean().getParameterListMetadataString()).append("<br><br>");
        }
        return str.toString();
    }

    public String getMapParametersInfoAsHTML() {
        String imrMetadata = !this.isDeterministicCurve ? this.imrGuiBean.getIMRMetadataHTML() : this.imrGuiBean.getSelectedIMR().getAllParamMetadata();
        String calcType = this.probDeterComboBox.getSelectedItem().toString();
        StringBuilder str = new StringBuilder();
        str.append("<br>Calculation Type = ").append(calcType).append("<br><br>IMR Param List:<br>---------------<br>").append(imrMetadata).append("<br><br>").append("Site Param List: ").append("<br>").append("----------------").append("<br>").append(this.siteGuiBean.getParameterListEditor().getVisibleParametersCloned().getParameterListMetadataString()).append("<br><br>").append("IMT Param List: ").append("<br>").append("---------------").append("<br>").append(this.imtGuiBean.getVisibleParametersCloned().getParameterListMetadataString()).append("<br><br>").append(this.getERFParametersInfoAsHTML()).append("Calculation Settings: ").append("<br>").append("--------------------").append("<br>").append(this.getCalcParamMetadataString());
        return str.toString();
    }

    public List<PlotElement> getCurveFunctionList() {
        return this.functionList;
    }

    private void buildGraphWidget() {
        this.graphWidget = new GraphWidget();
        this.graphWidget.setPlotLabel(DEFAULT_TITLE);
        JPanel buttonRow = this.graphWidget.getButtonControlPanel().getButtonRow();
        buttonRow.remove(4);
        buttonRow.add(Box.createHorizontalStrut(10));
        buttonRow.add(this.clearButton);
        buttonRow.add(this.peelButton);
        buttonRow.add(Box.createHorizontalGlue());
        this.plotPanel.add((Component)this.graphWidget, "Center");
    }

    protected void peelOffCurves() {
        JPanel buttonRow = this.graphWidget.getButtonControlPanel().getButtonRow();
        buttonRow.remove(this.clearButton);
        buttonRow.remove(this.peelButton);
        this.plotPanel.remove(this.graphWidget);
        GraphWindow graphWindow = new GraphWindow(this.graphWidget);
        this.buildGraphWidget();
        this.clearPlot();
        graphWindow.setVisible(true);
        this.clearButton.setEnabled(false);
        this.peelButton.setEnabled(false);
    }

    public List<PlotCurveCharacterstics> getPlottingFeatures() {
        return this.graphWidget.getPlottingFeatures();
    }

    private void close() {
        int option = JOptionPane.showConfirmDialog(this, "Do you really want to exit the application?\nYou will loose all unsaved data.", "Exit App", 2);
        if (option == 0) {
            System.exit(0);
        }
    }

    private void save() {
        try {
            this.graphWidget.save();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Save File Error", 0);
            return;
        }
    }

    public void print() {
        this.graphWidget.print();
    }

    public GraphWidget getGraphWidget() {
        return this.graphWidget;
    }

    protected final boolean isCancelled() {
        return this.cancelled;
    }

    protected final void signalCancel() {
        this.cancelled = true;
    }

    protected final void signalReset() {
        this.cancelled = false;
    }

    protected void cancelCalculation() {
        if (this.calcFuture == null) {
            return;
        }
        this.signalCancel();
        try {
            if (this.calc != null) {
                this.calc.stopCalc();
            }
            if (this.disaggCalc != null) {
                this.disaggCalc.stopCalc();
            }
            if (this.gcimCalc != null) {
                this.gcimCalc.stopCalc();
            }
        }
        catch (RuntimeException ee) {
            ee.printStackTrace();
            BugReport bug = new BugReport(ee, this.getParametersInfoAsString(), this.appShortName, HazardCurveApplication.getAppVersion(), this);
            BugReportDialog bugDialog = new BugReportDialog((Component)this, bug, false);
            bugDialog.setVisible(true);
        }
        this.calcFuture.thenRun(() -> {
            this.setButtonsEnable(true);
            this.erfGuiBean.closeProgressBar();
            if (this.timer != null && this.progressClass != null) {
                this.timer.stop();
                this.timer = null;
                this.progressClass.dispose();
            }
            if (this.disaggTimer != null && this.disaggProgressClass != null) {
                this.disaggTimer.stop();
                this.disaggTimer = null;
                this.disaggProgressClass.dispose();
            }
            if (this.gcimTimer != null && this.gcimProgressClass != null) {
                this.gcimTimer.stop();
                this.gcimTimer = null;
                this.gcimProgressClass.dispose();
            }
            this.isHazardCalcDone = false;
            this.setButtonsEnable(true);
            this.cancelButton.setEnabled(false);
        });
    }

    public String getDisaggregationPlot() {
        try {
            return this.disaggCalc.getDisaggregationPlotUsingServlet(this.getParametersInfoAsString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.setButtonsEnable(true);
            BugReport bug = new BugReport(ex, this.getParametersInfoAsString(), this.appShortName, HazardCurveApplication.getAppVersion(), this);
            BugReportDialog bugDialog = new BugReportDialog((Component)this, bug, false);
            bugDialog.setVisible(true);
            return null;
        }
    }

    public String getSourceDisaggregationInfo() {
        try {
            return this.disaggCalc.getDisaggregationSourceInfo();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.setButtonsEnable(true);
            BugReport bug = new BugReport(ex, this.getParametersInfoAsString(), this.appShortName, HazardCurveApplication.getAppVersion(), this);
            BugReportDialog bugDialog = new BugReportDialog((Component)this, bug, false);
            bugDialog.setVisible(true);
            return null;
        }
    }

    public String getConsolidatedSourceDisaggregationInfo() {
        try {
            return this.disaggCalc.getConsolidatedDisaggregationSourceInfo();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.setButtonsEnable(true);
            BugReport bug = new BugReport(ex, this.getParametersInfoAsString(), this.appShortName, HazardCurveApplication.getAppVersion(), this);
            BugReportDialog bugDialog = new BugReportDialog((Component)this, bug, false);
            bugDialog.setVisible(true);
            return null;
        }
    }

    public void addCybershakeCurveData(DiscretizedFunc function) {
        this.functionList.add(function);
        List<PlotCurveCharacterstics> plotFeaturesList = this.getPlottingFeatures();
        plotFeaturesList.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, PlotSymbol.FILLED_CIRCLE, 4.0f, Color.BLACK));
        this.addGraphPanel();
    }

    public void setCurveType(String calcType) {
        if (calcType.equals(PROBABILISTIC)) {
            this.probDeterComboBox.setSelectedItem(PROBABILISTIC);
        } else if (calcType.equals(DETERMINISTIC)) {
            this.probDeterComboBox.setSelectedItem(DETERMINISTIC);
        } else if (calcType.equals(STOCHASTIC)) {
            this.probDeterComboBox.setSelectedItem(STOCHASTIC);
        } else {
            throw new RuntimeException("Calculation Type Not Supported");
        }
    }

    public ArrayList<Double> getIML_Values() {
        ArrayList<Double> imlList = new ArrayList<Double>();
        ArbitrarilyDiscretizedFunc func = null;
        func = this.function != null ? this.function : this.imtInfo.getDefaultHazardCurve(this.imtGuiBean.getSelectedIMT());
        int size = func.size();
        for (int i = 0; i < size; ++i) {
            imlList.add(func.getX(i));
        }
        return imlList;
    }

    public ERF_GuiBean getEqkRupForecastGuiBeanInstance() {
        return this.erfGuiBean;
    }

    public EqkRupSelectorGuiBean getEqkSrcRupSelectorGuiBeanInstance() {
        return this.erfRupSelectorGuiBean;
    }

    public Site_GuiBean getSiteGuiBeanInstance() {
        return this.siteGuiBean;
    }

    public IMT_NewGuiBean getIMTGuiBeanInstance() {
        return this.imtGuiBean;
    }

    public IMR_MultiGuiBean getIMRGuiBeanInstance() {
        return this.imrGuiBean;
    }

    public void updateSiteParams() {
        this.siteGuiBean.replaceSiteParams(this.imrGuiBean.getMultiIMRSiteParamIterator());
        this.siteGuiBean.validate();
        this.siteGuiBean.repaint();
    }

    @Override
    public void imrChange(ScalarIMRChangeEvent event) {
        this.updateSiteParams();
    }

    @Override
    public void imtChange(IMTChangeEvent e) {
        this.controlPanels.remove(this.gcimControlPanel);
        this.gcimControlPanel = new GcimControlPanel(this, this);
        this.controlPanels.add(this.gcimControlPanel);
    }

    public void setGcimSelected(boolean isSelected) {
        this.gcimFlag = isSelected;
    }

    private void showGcimResults(String imjName, boolean imlBasedGcim, double imlVal, double probVal) {
        Object headerString = "";
        headerString = imlBasedGcim ? "GCIM Results: \nConditioning IM: " + imjName + "\nIML  = " + imlVal + "\n(Prob= " + (float)probVal + ")" : "GCIM Results: \nConditioning IM: " + imjName + "\nProb = " + probVal + "\n(IML = " + (float)imlVal + ")";
        Object gcimResultsString = this.gcimCalc.getGcimResultsString();
        gcimResultsString = (String)headerString + "\n\n" + (String)gcimResultsString;
        new GcimPlotViewerWindow((String)gcimResultsString);
    }

    public String getGcimResults() {
        try {
            return this.gcimCalc.getGcimResultsString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.setButtonsEnable(true);
            BugReport bug = new BugReport(ex, this.getParametersInfoAsString(), this.appShortName, HazardCurveApplication.getAppVersion(), this);
            BugReportDialog bugDialog = new BugReportDialog((Component)this, bug, false);
            bugDialog.setVisible(true);
            return null;
        }
    }

    public ArrayList<TectonicRegionType> getIncludedTectonicRegionTypes() {
        try {
            ArrayList<TectonicRegionType> includedTectonicRegionTypes = this.erfGuiBean.getSelectedERF_Instance().getIncludedTectonicRegionTypes();
            return includedTectonicRegionTypes;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            this.imrGuiBean.setTectonicRegions(null);
            return null;
        }
    }

    static {
        DEFAULT_TITLE = new String("Hazard Curves");
        errorInInitializationMessage = "Problem occured during initialization the ERF's. All parameters are set to default.";
        try {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        catch (Exception e1) {
            System.err.println("WARNING: could not set property 'apple.laf.useScreenMenuBar'");
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

