/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.WeightedFuncListforPlotting;
import org.opensha.commons.data.function.XY_DataSetList;
import org.opensha.commons.gui.DisclaimerDialog;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.impl.DoubleDiscreteParameter;
import org.opensha.commons.util.bugReports.BugReport;
import org.opensha.commons.util.bugReports.BugReportDialog;
import org.opensha.commons.util.bugReports.DefaultExceptionHandler;
import org.opensha.sha.calc.SpectrumCalculator;
import org.opensha.sha.calc.SpectrumCalculatorAPI;
import org.opensha.sha.earthquake.BaseERF;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.EpistemicListERF;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.gui.HazardCurveApplication;
import org.opensha.sha.gui.beans.IMLorProbSelectorGuiBean;
import org.opensha.sha.gui.beans.IMT_NewGuiBean;
import org.opensha.sha.gui.infoTools.CalcProgressBar;
import org.opensha.sha.gui.util.IconFetcher;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.event.ScalarIMRChangeEvent;

public class HazardSpectrumApplication
extends HazardCurveApplication {
    private static final long serialVersionUID = 1L;
    public static final String APP_NAME = "Hazard Spectrum Application";
    public static final String APP_SHORT_NAME = "HazardSpectrumLocal";
    protected static String SA_NAME = "SA";
    private static String SA_PERIOD = "SA Period";
    private static final String IML = "SA (g)";
    private static final String PROB_AT_EXCEED = "Probability of Exceedance";
    private static final String X_AXIS_LABEL = "Period (sec)";
    private IMLorProbSelectorGuiBean imlProbGuiBean;
    private List saPeriodVector;
    protected static final String DEFAULT_TITLE = new String("Response Spectra Curves");
    protected SpectrumCalculatorAPI calc;
    boolean probAtIML;

    public HazardSpectrumApplication(String appShortName) {
        super(appShortName);
    }

    @Override
    public ParameterList getCalcAdjustableParams() {
        if (this.calc == null) {
            this.createCalcInstance();
        }
        return this.calc.getAdjustableParams();
    }

    @Override
    protected void initIMR_GuiBean() {
        super.initIMR_GuiBean();
        this.imrGuiBean.setMultipleIMRsEnabled(false);
        this.imrGuiBean.getSelectedIMR().setIntensityMeasure("SA");
    }

    @Override
    protected String getGuideURL() {
        return null;
    }

    @Override
    protected String getTutorialURL() {
        return null;
    }

    @Override
    public void init() {
        try {
            this.startAppProgressClass = new CalcProgressBar("Starting Application", "Initializing Application .. Please Wait");
            this.initIMR_GuiBean();
            this.initImlProb_GuiBean();
            this.initSiteGuiBean();
            try {
                this.initERF_GuiBean();
            }
            catch (RuntimeException e) {
                JOptionPane.showMessageDialog(this, "Connection to ERF's failed", "Internet Connection Problem", 0);
                e.printStackTrace();
                System.exit(0);
            }
            this.jbInit();
            this.setImtPanel(this.imlProbGuiBean, 0.28);
        }
        catch (Exception e) {
            e.printStackTrace();
            BugReport bug = new BugReport(e, this.getParametersInfoAsString(), this.appShortName, HazardSpectrumApplication.getAppVersion(), this);
            BugReportDialog bugDialog = new BugReportDialog((Component)this, bug, true);
            bugDialog.setVisible(true);
        }
        this.setTitle("Hazard Spectrum Application (" + String.valueOf(HazardSpectrumApplication.getAppVersion()) + ")");
        this.startAppProgressClass.dispose();
        ((JPanel)this.getContentPane()).updateUI();
        this.graphWidget.setPlotLabel(DEFAULT_TITLE);
    }

    @Override
    protected void createCalcInstance() {
        try {
            if (this.calc == null) {
                this.calc = new SpectrumCalculator();
            }
        }
        catch (Exception e) {
            BugReport bug = new BugReport(e, this.getParametersInfoAsString(), this.appShortName, HazardSpectrumApplication.getAppVersion(), this);
            BugReportDialog bugDialog = new BugReportDialog((Component)this, bug, true);
            bugDialog.setVisible(true);
        }
    }

    @Override
    protected void computeHazardCurve() {
        String yAxisName;
        this.isHazardCalcDone = false;
        this.numERFsInEpistemicList = 0;
        BaseERF forecast = null;
        EqkRupture rupture = null;
        if (this.isCancelled()) {
            return;
        }
        if (!this.isProbabilisticCurve) {
            rupture = this.erfRupSelectorGuiBean.getRupture();
        }
        try {
            if (this.isProbabilisticCurve) {
                this.erfGuiBean.showProgressBar(this.progressCheckBox.isSelected());
                forecast = this.erfGuiBean.getSelectedERF();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = e.getMessage() != null ? e.getMessage() : e.toString();
            JOptionPane.showMessageDialog(this, message, "Incorrect Values", 0);
            this.setButtonsEnable(true);
            return;
        }
        if (this.progressCheckBox.isSelected()) {
            this.progressClass = new CalcProgressBar("Response-Spectrum Calc Status", "Beginning Calculation ");
            this.timer.start();
        }
        if (this.isCancelled()) {
            return;
        }
        ScalarIMR imr = this.imrGuiBean.getSelectedIMR();
        this.getSA_PeriodForIMR(imr);
        Site site = this.siteGuiBean.getSite();
        DiscretizedFunc hazFunction = null;
        String imlOrProb = this.imlProbGuiBean.getSelectedOption();
        double imlProbValue = this.imlProbGuiBean.getIML_Prob();
        if (imlOrProb.equalsIgnoreCase("Prob@IML")) {
            yAxisName = PROB_AT_EXCEED;
            this.probAtIML = true;
        } else {
            yAxisName = IML;
            this.probAtIML = false;
        }
        final String xAxisName = X_AXIS_LABEL;
        HazardSpectrumApplication.runInEDT(new Runnable(){
            final /* synthetic */ HazardSpectrumApplication this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.graphWidget.setXAxisLabel(xAxisName);
                this.this$0.graphWidget.setYAxisLabel(yAxisName);
            }
        });
        if (forecast instanceof EpistemicListERF && this.isProbabilisticCurve) {
            if (this.addData) {
                this.prevSelectedERF_List = forecast.getName();
            }
            if (!this.prevSelectedERF_List.equals(forecast.getName()) && !this.addData) {
                JOptionPane.showMessageDialog(this, "Cannot add to existing without selecting same ERF Epistemic list", "Input Error", 1);
                return;
            }
            this.isEqkList = true;
            this.handleForecastList(site, imr, forecast, imlProbValue);
            this.currentERFInEpistemicListForHazardCurve = 0;
            this.numERFsInEpistemicList = 0;
            this.isHazardCalcDone = true;
            return;
        }
        this.prevSelectedERF_List = null;
        this.isEqkList = false;
        try {
            block22: {
                try {
                    if (this.isProbabilisticCurve) {
                        if (this.probAtIML) {
                            hazFunction = this.calc.getSpectrumCurve(site, imr, (ERF)forecast, imlProbValue, this.saPeriodVector);
                            break block22;
                        }
                        hazFunction = new ArbitrarilyDiscretizedFunc();
                        this.initX_Values(hazFunction);
                        try {
                            hazFunction = this.calc.getIML_SpectrumCurve(hazFunction, site, imr, (ERF)forecast, imlProbValue, this.saPeriodVector);
                            break block22;
                        }
                        catch (RuntimeException e) {
                            e.printStackTrace();
                            if (!this.isCancelled()) {
                                JOptionPane.showMessageDialog(this, e.getMessage(), "Parameters Invalid", 1);
                            }
                            return;
                        }
                    }
                    HazardSpectrumApplication.runInEDT(new Runnable(){

                        @Override
                        public void run() {
                            HazardSpectrumApplication.this.progressCheckBox.setSelected(false);
                            HazardSpectrumApplication.this.progressCheckBox.setEnabled(false);
                        }
                    });
                    hazFunction = this.probAtIML ? this.calc.getDeterministicSpectrumCurve(site, imr, rupture, this.probAtIML, imlProbValue) : this.calc.getDeterministicSpectrumCurve(site, imr, rupture, this.probAtIML, imlProbValue);
                    HazardSpectrumApplication.runInEDT(new Runnable(){

                        @Override
                        public void run() {
                            HazardSpectrumApplication.this.progressCheckBox.setSelected(true);
                            HazardSpectrumApplication.this.progressCheckBox.setEnabled(true);
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.setButtonsEnable(true);
                    BugReport bug = new BugReport(e, this.getParametersInfoAsString(), this.appShortName, HazardSpectrumApplication.getAppVersion(), this);
                    BugReportDialog bugDialog = new BugReportDialog((Component)this, bug, false);
                    bugDialog.setVisible(true);
                }
            }
            hazFunction.setInfo(this.getParametersInfoAsString());
        }
        catch (RuntimeException e) {
            if (!this.isCancelled()) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Parameters Invalid", 1);
            }
            e.printStackTrace();
            this.setButtonsEnable(true);
            return;
        }
        this.isHazardCalcDone = true;
        this.functionList.add(hazFunction);
    }

    private void initImlProb_GuiBean() {
        this.imlProbGuiBean = new IMLorProbSelectorGuiBean();
    }

    @Override
    protected void initControlList() {
        this.initCommonControlList();
    }

    @Override
    public IMT_NewGuiBean getIMTGuiBeanInstance() {
        return null;
    }

    public void updateIM() {
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        String S = ": parameterChange(): ";
        String name1 = event.getParameterName();
        if (name1.equalsIgnoreCase("Eqk Rup Forecast")) {
            String plottingOption = null;
            if (this.plotOptionControl != null) {
                plottingOption = this.plotOptionControl.getSelectedOption();
            }
            if (this.erfGuiBean.isEpistemicList()) {
                this.showControlPanel("Epistemic List Control");
            } else if (plottingOption != null && plottingOption.equalsIgnoreCase("Add to existing dataset")) {
                JOptionPane.showMessageDialog(this, "Cannot add to existing without selecting ERF Epistemic list", "Input Error", 1);
                this.plotOptionControl.setSelectedOption("Plot on top of existing dataset");
                this.setButtonsEnable(true);
            }
        }
    }

    @Override
    protected void startPrimaryTimer() {
        this.timer = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (!HazardSpectrumApplication.this.isEqkList) {
                        int totRupture = HazardSpectrumApplication.this.calc.getTotRuptures();
                        int currRupture = HazardSpectrumApplication.this.calc.getCurrRuptures();
                        boolean totCurCalculated = true;
                        if (currRupture == -1) {
                            HazardSpectrumApplication.this.progressClass.setProgressMessage("Calculating total ruptures\u2026");
                            totCurCalculated = false;
                        }
                        if (!HazardSpectrumApplication.this.isHazardCalcDone && totCurCalculated) {
                            HazardSpectrumApplication.this.progressClass.updateProgress(currRupture, totRupture);
                        }
                    } else if (HazardSpectrumApplication.this.numERFsInEpistemicList != 0) {
                        HazardSpectrumApplication.this.progressClass.updateProgress(HazardSpectrumApplication.this.currentERFInEpistemicListForHazardCurve, HazardSpectrumApplication.this.numERFsInEpistemicList);
                    }
                    if (HazardSpectrumApplication.this.isHazardCalcDone) {
                        HazardSpectrumApplication.this.timer.stop();
                        HazardSpectrumApplication.this.progressClass.dispose();
                        HazardSpectrumApplication.this.drawGraph();
                    }
                }
                catch (Exception e) {
                    HazardSpectrumApplication.this.timer.stop();
                    HazardSpectrumApplication.this.setButtonsEnable(true);
                    e.printStackTrace();
                    BugReport bug = new BugReport(e, HazardSpectrumApplication.this.getParametersInfoAsString(), HazardSpectrumApplication.APP_NAME, HazardCurveApplication.getAppVersion(), HazardSpectrumApplication.this.getApplicationComponent());
                    BugReportDialog bugDialog = new BugReportDialog(HazardSpectrumApplication.this.getApplicationComponent(), bug, false);
                    bugDialog.setVisible(true);
                }
            }
        });
    }

    private void getSA_PeriodForIMR(ScalarIMR imr) {
        for (Parameter<?> tempParam : imr.getSupportedIntensityMeasures()) {
            if (!tempParam.getName().equalsIgnoreCase(SA_NAME)) continue;
            for (Parameter<?> independentParam : tempParam.getIndependentParameterList()) {
                if (!independentParam.getName().equalsIgnoreCase(SA_PERIOD)) continue;
                this.saPeriodVector = ((DoubleDiscreteParameter)independentParam).getAllowedDoubles();
                return;
            }
        }
    }

    @Override
    protected void cancelCalculation() {
        super.cancelCalculation();
        try {
            if (this.calc != null) {
                this.calc.stopCalc();
            }
        }
        catch (RuntimeException ee) {
            ee.printStackTrace();
            BugReport bug = new BugReport(ee, this.getParametersInfoAsString(), this.appShortName, HazardSpectrumApplication.getAppVersion(), this);
            BugReportDialog bugDialog = new BugReportDialog((Component)this, bug, false);
            bugDialog.setVisible(true);
        }
    }

    protected void handleForecastList(Site site, ScalarIMR imr, BaseERF forecast, double imlProbValue) {
        EpistemicListERF erfList = (EpistemicListERF)forecast;
        this.numERFsInEpistemicList = erfList.getNumERFs();
        if (this.addData) {
            this.weightedFuncList = new WeightedFuncListforPlotting();
        } else if (!this.addData && this.weightedFuncList == null) {
            JOptionPane.showMessageDialog(this, "No ERF List Exists", "Wrong selection", 0);
            return;
        }
        XY_DataSetList hazardFuncList = new XY_DataSetList();
        for (int i = 0; i < this.numERFsInEpistemicList; ++i) {
            if (this.isCancelled()) {
                return;
            }
            this.currentERFInEpistemicListForHazardCurve = i;
            DiscretizedFunc hazFunction = null;
            try {
                if (this.probAtIML) {
                    hazFunction = this.calc.getSpectrumCurve(site, imr, erfList.getERF(i), imlProbValue, this.saPeriodVector);
                } else {
                    hazFunction = new ArbitrarilyDiscretizedFunc();
                    this.initX_Values(hazFunction);
                    hazFunction = this.calc.getIML_SpectrumCurve(hazFunction, site, imr, erfList.getERF(i), imlProbValue, this.saPeriodVector);
                }
            }
            catch (RuntimeException e) {
                this.setButtonsEnable(true);
                if (!this.isCancelled()) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Parameters Invalid", 1);
                }
                return;
            }
            hazardFuncList.add(hazFunction);
        }
        this.weightedFuncList.addList(erfList.getRelativeWeightsList(), hazardFuncList);
        if (this.addData) {
            this.weightedFuncList.setInfo(this.getParametersInfoAsString());
        } else {
            this.weightedFuncList.setInfo(this.getParametersInfoAsString() + "\nPrevious List Info:\n--------------------\n" + this.weightedFuncList.getInfo());
        }
        if (!this.isAllCurves) {
            this.weightedFuncList.setIndividualCurvesToPlot(false);
        } else {
            this.weightedFuncList.setIndividualCurvesToPlot(true);
        }
        if (this.fractileOption.equalsIgnoreCase("Plot Fractiles")) {
            this.weightedFuncList.setFractilesToPlot(true);
            this.weightedFuncList.addFractiles(this.epistemicControlPanel.getSelectedFractileValues());
        } else {
            this.weightedFuncList.setFractilesToPlot(false);
        }
        if (this.avgSelected) {
            this.weightedFuncList.setMeanToPlot(true);
            this.weightedFuncList.addMean();
        } else {
            this.weightedFuncList.setMeanToPlot(false);
        }
        if (this.addData) {
            this.functionList.add(this.weightedFuncList);
        }
    }

    @Override
    protected void initX_Values(DiscretizedFunc arb) {
        if (!this.useCustomX_Values) {
            this.function = this.imtInfo.getDefaultHazardCurve("SA");
        }
        for (int i = 0; i < this.function.size(); ++i) {
            arb.set(this.function.getX(i), 1.0);
        }
    }

    @Override
    public String getMapParametersInfoAsHTML() {
        String imrMetadata = !this.isDeterministicCurve ? this.imrGuiBean.getIMRMetadataHTML() : this.imrGuiBean.getSelectedIMR().getAllParamMetadata();
        StringBuilder str = new StringBuilder();
        str.append("<br>IMR Param List:<br>").append("---------------<br>").append(imrMetadata).append("<br><br>").append("Site Param List: <br>").append("----------------<br>").append(this.siteGuiBean.getParameterListEditor().getVisibleParametersCloned().getParameterListMetadataString()).append("<br><br>").append("IML/Prob Param List: <br>").append("---------------<br>").append(this.imlProbGuiBean.getVisibleParametersCloned().getParameterListMetadataString()).append("<br><br>").append(this.getERFParametersInfoAsHTML()).append("TimeSpan Param List: <br>").append("--------------------<br>").append(this.erfGuiBean.getSelectedERFTimespanGuiBean().getParameterListMetadataString()).append("<br><br>").append(this.getCalcParamMetadataString());
        return str.toString();
    }

    public static void main(String[] args) throws IOException {
        new DisclaimerDialog(APP_NAME, APP_SHORT_NAME, HazardSpectrumApplication.getAppVersion());
        DefaultExceptionHandler exp = new DefaultExceptionHandler(APP_SHORT_NAME, HazardSpectrumApplication.getAppVersion(), null, null);
        Thread.setDefaultUncaughtExceptionHandler(exp);
        HazardSpectrumApplication.launch(exp);
    }

    public static HazardSpectrumApplication launch(DefaultExceptionHandler handler) {
        HazardSpectrumApplication applet = new HazardSpectrumApplication(APP_SHORT_NAME);
        if (handler != null) {
            handler.setApp(applet);
            handler.setParent(applet);
        }
        applet.init();
        applet.setIconImages(IconFetcher.fetchIcons(APP_SHORT_NAME));
        applet.setVisible(true);
        return applet;
    }

    @Override
    protected void initProbOrDeterList() {
        this.probDeterComboBox.addItem("Probabilistic");
        this.probDeterComboBox.addItem("Deterministic");
    }

    @Override
    public void imrChange(ScalarIMRChangeEvent event) {
        super.imrChange(event);
        this.imrGuiBean.getSelectedIMR().setIntensityMeasure("SA");
    }

    @Override
    public String getSelectedIMT() {
        return "SA";
    }
}

