/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.beans;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.impl.IntegerConstraint;
import org.opensha.commons.param.editor.ParameterEditor;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.commons.param.impl.LocationParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.earthquake.BaseERF;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.ERF_Ref;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.gui.beans.ERF_GuiBean;
import org.opensha.sha.gui.beans.EqkRupSelectorGuiBeanAPI;
import org.opensha.sha.gui.infoTools.CalcProgressBar;

public class EqkRuptureFromERFSelectorPanel
extends JPanel
implements ParameterChangeListener,
EqkRupSelectorGuiBeanAPI {
    protected static final String C = "EqkRupSelectorGuiBean";
    protected static final boolean D = false;
    private DecimalFormat decimalFormat = new DecimalFormat("0.000##");
    private static final String TITLE = "";
    public static final String ERF_PARAM_NAME = "Eqk Rup Forecast";
    public static final String SOURCE_PARAM_NAME = "Source Index";
    public static final String RUPTURE_PARAM_NAME = "Rupture Index";
    public static final String RUPTURE_HYPOLOCATIONS_PARAM_NAME = "Hypocenter Location (Lat,Lon,Depth)";
    ProbEqkRupture probEqkRupture;
    ERF_GuiBean erfGuiBean;
    private JButton erfAdjParamButton = new JButton();
    private JTextArea sourceRupInfoText = new JTextArea();
    private ParameterListEditor listEditor;
    private ParameterList parameterList;
    private IntegerParameter ruptureParam;
    private StringParameter sourceParam;
    private LocationParameter hypoCenterLocationParam;
    private int sourceValue = 0;
    private int ruptureValue = 0;
    private boolean showAllAdjustableParamForERF = true;
    JDialog frame;
    private JCheckBox hypoCentreCheck = new JCheckBox();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private ArrayList alreadySeenERFs = new ArrayList();
    private ERF erf = null;
    private Timer timer;
    private CalcProgressBar progress;
    private int step;
    private List<ERF_Ref> erfRefs;
    private boolean firstTime = true;
    StringParameter myChooseERF_Param = null;
    StringParameter erfGuiChooseERF_Param = null;

    public EqkRuptureFromERFSelectorPanel(BaseERF baseERF, List<ERF_Ref> erfRefs) {
        this.erfRefs = erfRefs;
        this.parameterList = new ParameterList();
        try {
            for (ERF_Ref erfRef : erfRefs) {
                Preconditions.checkArgument((!erfRef.isERFList() ? 1 : 0) != 0, (Object)"Rupture From ERF Panel can't be used with Epistemic List ERFs");
            }
            this.erf = baseERF instanceof ERF ? (ERF)baseERF : null;
            String erfName = this.erf.getClass().getName();
            this.progress = new CalcProgressBar("Updating Ruptures", "Please wait while ruptures are being updated ...");
            this.step = 1;
            this.startProgressBarTimer();
            this.erfGuiBean = new ERF_GuiBean(erfRefs);
            this.setEqkRupForecast(this.erf);
            this.erfGuiBean.showProgressBar(false);
            this.setSelectedERF();
            this.setSourceFromSelectedERF(0);
            this.setRuptureForSelectedSource(0);
            this.getHypocenterLocationsForSelectedRupture();
            this.listEditor = new ParameterListEditor(this.parameterList);
            this.listEditor.setTitle(TITLE);
            this.setHypocenterLocationInRupture(false);
            this.stopProgressBarTimer();
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.firstTime = false;
    }

    public EqkRuptureFromERFSelectorPanel(List<ERF_Ref> erfRefs) throws InvocationTargetException {
        this.erfGuiBean = new ERF_GuiBean(erfRefs);
        this.erfGuiBean.showProgressBar(false);
        this.parameterList = new ParameterList();
        this.progress = new CalcProgressBar("Updating Ruptures", "Please wait while ruptures are being updated ...");
        this.step = 1;
        this.startProgressBarTimer();
        this.setSelectedERF();
        this.setSourceFromSelectedERF(0);
        this.setRuptureForSelectedSource(0);
        this.getHypocenterLocationsForSelectedRupture();
        this.listEditor = new ParameterListEditor(this.parameterList);
        this.listEditor.setTitle(TITLE);
        this.setHypocenterLocationInRupture(false);
        this.stopProgressBarTimer();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.firstTime = false;
    }

    public void setSelectedERF() {
        this.step = 2;
        this.startProgressBarTimer();
        if (this.firstTime) {
            this.erfGuiChooseERF_Param = (StringParameter)this.erfGuiBean.getERFParameterList().getParameter(ERF_PARAM_NAME);
            ArrayList<String> allowedStrings = this.erfGuiChooseERF_Param.getAllowedStrings();
            this.myChooseERF_Param = new StringParameter(ERF_PARAM_NAME, allowedStrings, this.erfGuiBean.getSelectedERF_Name());
            this.myChooseERF_Param.addParameterChangeListener(this);
            this.parameterList.addParameter(this.myChooseERF_Param);
            if (this.erf == null) {
                try {
                    this.erf = (ERF)this.erfGuiBean.getSelectedERF();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.stopProgressBarTimer();
    }

    public void setEqkRupForecast(BaseERF erf) {
        if (erf != null) {
            this.showAllAdjustableParamForERF = false;
            this.erf = (ERF)erf;
            this.erfGuiBean.setERF(erf);
            this.showAllAdjustableParamForERF = true;
        }
    }

    public void setSourceFromSelectedERF(int sourceIndex) {
        this.step = 3;
        this.startProgressBarTimer();
        int numSources = this.erf.getNumSources();
        ArrayList<CallSite> sourcesVector = new ArrayList<CallSite>();
        for (int i = 0; i < numSources; ++i) {
            sourcesVector.add((CallSite)((Object)(i + " ( " + this.erf.getSource(i).getName() + " )")));
        }
        this.sourceParam = new StringParameter(SOURCE_PARAM_NAME, sourcesVector, (String)sourcesVector.get(sourceIndex));
        this.sourceParam.addParameterChangeListener(this);
        if (this.parameterList.containsParameter(this.sourceParam)) {
            this.listEditor.replaceParameterForEditor(SOURCE_PARAM_NAME, this.sourceParam);
        } else {
            this.parameterList.addParameter(this.sourceParam);
        }
        this.sourceValue = Integer.parseInt(((String)this.sourceParam.getValue()).substring(0, ((String)this.sourceParam.getValue()).indexOf("(")).trim());
        this.setSelectedSourceRupturesInfo();
        this.stopProgressBarTimer();
    }

    private void setSelectedSourceRupturesInfo() {
        int numRuptures = this.erf.getNumRuptures(this.sourceValue);
        Object rupturesInfo = "Rupture info for \"";
        rupturesInfo = (String)rupturesInfo + this.sourceValue;
        rupturesInfo = (String)rupturesInfo + "\":\n";
        for (int i = 0; i < numRuptures; ++i) {
            rupturesInfo = (String)rupturesInfo + "\n  rupture #" + i + ": \n\n" + this.erf.getSource(this.sourceValue).getRupture(i).getInfo();
        }
        this.sourceRupInfoText.setText((String)rupturesInfo);
        this.sourceRupInfoText.setCaretPosition(0);
    }

    public void setRuptureForSelectedSource(int ruptureIndex) {
        this.step = 4;
        this.startProgressBarTimer();
        int numRuptures = this.erf.getNumRuptures(this.sourceValue);
        if (this.ruptureParam == null) {
            this.ruptureParam = new IntegerParameter(RUPTURE_PARAM_NAME, 0, numRuptures - 1, (Integer)ruptureIndex);
            this.ruptureParam.addParameterChangeListener(this);
            this.parameterList.addParameter(this.ruptureParam);
        } else {
            IntegerConstraint iconst = (IntegerConstraint)this.ruptureParam.getConstraint();
            iconst.setMinMax(0, numRuptures - 1);
            this.ruptureParam.setValue(ruptureIndex);
            this.ruptureParam.getEditor().refreshParamEditor();
        }
        this.ruptureValue = (Integer)this.ruptureParam.getValue();
        this.stopProgressBarTimer();
    }

    public void getHypocenterLocationsForSelectedRupture() {
        this.probEqkRupture = this.erf.getRupture(this.sourceValue, this.ruptureValue);
        ArrayList<Location> locations = new ArrayList<Location>();
        ListIterator hypoLocationsIt = this.probEqkRupture.getRuptureSurface().getEvenlyDiscritizedUpperEdge().listIterator();
        while (hypoLocationsIt.hasNext()) {
            locations.add((Location)hypoLocationsIt.next());
        }
        this.hypoCenterLocationParam = new LocationParameter(RUPTURE_HYPOLOCATIONS_PARAM_NAME, locations, (Location)locations.get(0));
        this.hypoCenterLocationParam.addParameterChangeListener(this);
        if (this.parameterList.containsParameter(this.hypoCenterLocationParam)) {
            this.listEditor.replaceParameterForEditor(RUPTURE_HYPOLOCATIONS_PARAM_NAME, this.hypoCenterLocationParam);
        } else {
            this.parameterList.addParameter(this.hypoCenterLocationParam);
        }
    }

    private void startProgressBarTimer() {
        this.timer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (EqkRuptureFromERFSelectorPanel.this.step == 1) {
                    EqkRuptureFromERFSelectorPanel.this.progress.setProgressMessage("Please wait while ruptures are being updated ...");
                } else if (EqkRuptureFromERFSelectorPanel.this.step == 2) {
                    EqkRuptureFromERFSelectorPanel.this.progress.setProgressMessage("Please wait while ERF is being updated ...");
                } else if (EqkRuptureFromERFSelectorPanel.this.step == 3) {
                    EqkRuptureFromERFSelectorPanel.this.progress.setProgressMessage("Please wait while sources are being updated ...");
                } else if (EqkRuptureFromERFSelectorPanel.this.step == 4) {
                    EqkRuptureFromERFSelectorPanel.this.progress.setProgressMessage("Please wait while ruptures are being updated ...");
                }
                EqkRuptureFromERFSelectorPanel.this.progress.validate();
                EqkRuptureFromERFSelectorPanel.this.progress.repaint();
            }
        });
        this.timer.start();
        this.progress.showProgress(true);
    }

    private void stopProgressBarTimer() {
        this.timer.stop();
        this.progress.dispose();
    }

    private void setHypocenterLocationInRupture(boolean visible) {
        if (!visible) {
            this.listEditor.getParameterEditor(RUPTURE_HYPOLOCATIONS_PARAM_NAME).setVisible(false);
        } else {
            this.listEditor.getParameterEditor(RUPTURE_HYPOLOCATIONS_PARAM_NAME).setVisible(true);
        }
        this.probEqkRupture.setHypocenterLocation(this.getHypocenterLocation());
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        String S = "EqkRupSelectorGuiBean: parameterChange(): ";
        String name1 = event.getParameterName();
        if (name1.equals(ERF_PARAM_NAME)) {
            this.erfGuiChooseERF_Param.setValue((String)this.myChooseERF_Param.getValue());
            if (this.showAllAdjustableParamForERF && !this.alreadySeenERFs.contains(event.getNewValue())) {
                this.getAllERFAdjustableParams();
                this.alreadySeenERFs.add(event.getNewValue());
            }
            this.hypoCentreCheck.setSelected(false);
            this.listEditor.refreshParamEditor();
        } else if (name1.equals(SOURCE_PARAM_NAME)) {
            this.sourceValue = Integer.parseInt(((String)this.sourceParam.getValue()).substring(0, ((String)this.sourceParam.getValue()).indexOf("(")).trim());
            this.setSelectedSourceRupturesInfo();
            this.hypoCentreCheck.setSelected(false);
            this.setRuptureForSelectedSource(0);
            this.getHypocenterLocationsForSelectedRupture();
            this.listEditor.refreshParamEditor();
        } else if (name1.equals(RUPTURE_PARAM_NAME)) {
            this.ruptureValue = (Integer)this.ruptureParam.getValue();
            this.hypoCentreCheck.setSelected(false);
            this.getHypocenterLocationsForSelectedRupture();
            this.listEditor.refreshParamEditor();
        } else if (name1.equals(RUPTURE_HYPOLOCATIONS_PARAM_NAME)) {
            this.probEqkRupture.setHypocenterLocation(this.getHypocenterLocation());
        }
    }

    private void jbInit() throws Exception {
        this.erfAdjParamButton.setText("Set Eqk Rup Forecast Params");
        this.erfAdjParamButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EqkRuptureFromERFSelectorPanel.this.erfAdjParamButton_actionPerformed(e);
            }
        });
        this.erfAdjParamButton.setBackground(SystemColor.control);
        this.setLayout(this.gridBagLayout1);
        this.sourceRupInfoText.setLineWrap(true);
        this.sourceRupInfoText.setForeground(Color.blue);
        this.sourceRupInfoText.setSelectedTextColor(new Color(80, 80, 133));
        this.sourceRupInfoText.setSelectionColor(Color.blue);
        this.sourceRupInfoText.setEditable(false);
        this.hypoCentreCheck.setText("Set Hypocenter Location");
        this.hypoCentreCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                EqkRuptureFromERFSelectorPanel.this.hypoCentreCheck_itemStateChanged(e);
            }
        });
        this.add((Component)this.sourceRupInfoText, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.erfAdjParamButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.hypoCentreCheck, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        ParameterEditor paramEdit = this.listEditor.getParameterEditor(ERF_PARAM_NAME);
        TitledBorder titledBorder1 = new TitledBorder(BorderFactory.createLineBorder(new Color(80, 80, 140), 3), TITLE);
        titledBorder1.setTitleColor(new Color(80, 80, 140));
        Font DEFAULT_LABEL_FONT = new Font("SansSerif", 1, 13);
        titledBorder1.setTitleFont(DEFAULT_LABEL_FONT);
        titledBorder1.setTitle(ERF_PARAM_NAME);
        CompoundBorder border1 = BorderFactory.createCompoundBorder(titledBorder1, BorderFactory.createEmptyBorder(0, 0, 3, 0));
        paramEdit.setEditorBorder(border1);
        this.add((Component)this.listEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
    }

    void erfAdjParamButton_actionPerformed(ActionEvent e) {
        this.getAllERFAdjustableParams();
    }

    public void showAllParamsForForecast(boolean flag) {
        this.showAllAdjustableParamForERF = flag;
    }

    public ERF_GuiBean getERF_ParamEditor() {
        return this.erfGuiBean;
    }

    @Override
    public String getParameterListMetadataString() {
        this.probEqkRupture = this.erf.getRupture(this.sourceValue, this.ruptureValue);
        this.erfGuiBean.getERFParameterListEditor().getParameterEditor(ERF_PARAM_NAME).setVisible(false);
        String metadata = "<br><br>Forecast Param List: <br>\n-------------------------<br>\n" + this.getParameterListEditor().getVisibleParameters().getParameterListMetadataString() + ";" + this.erfGuiBean.getERFParameterListEditor().getVisibleParameters().getParameterListMetadataString() + "<br><br>\nRupture Info: " + this.probEqkRupture.getInfo();
        return metadata;
    }

    public void addERFs_ToList(ArrayList erfList) throws InvocationTargetException {
        this.erfGuiBean.addERFs_ToList(erfList);
    }

    public void removeERFs_FromList(ArrayList erfList) throws InvocationTargetException {
        this.erfGuiBean.removeERFs_FromList(erfList);
    }

    private void getAllERFAdjustableParams() {
        Container parent;
        this.erfGuiBean.getERFParameterListEditor().getParameterEditor(ERF_PARAM_NAME).setVisible(false);
        for (parent = this; !(parent instanceof JFrame) && parent != null; parent = parent.getParent()) {
        }
        this.frame = new JDialog((JFrame)parent);
        this.frame.setModal(true);
        this.frame.setSize(300, 600);
        this.frame.setTitle("ERF Adjustable Params");
        this.frame.getContentPane().setLayout(new GridBagLayout());
        this.frame.getContentPane().add((Component)this.erfGuiBean, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        JButton button = new JButton();
        button.setText("Update Forecast");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EqkRuptureFromERFSelectorPanel.this.button_actionPerformed(e);
            }
        });
        this.frame.getContentPane().add((Component)button, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.frame.setVisible(true);
        this.frame.pack();
    }

    void button_actionPerformed(ActionEvent e) {
        this.frame.dispose();
        this.updateERFAndSourceRupList();
    }

    private void updateERFAndSourceRupList() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    EqkRuptureFromERFSelectorPanel.this.erf = (ERF)EqkRuptureFromERFSelectorPanel.this.erfGuiBean.getSelectedERF();
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
                EqkRuptureFromERFSelectorPanel.this.setSourceFromSelectedERF(0);
                EqkRuptureFromERFSelectorPanel.this.setRuptureForSelectedSource(0);
                EqkRuptureFromERFSelectorPanel.this.getHypocenterLocationsForSelectedRupture();
            }
        });
        t.start();
    }

    @Override
    public Parameter getParameter(String param) {
        return this.listEditor.getParameterList().getParameter(param);
    }

    @Override
    public ParameterEditor getParameterEditor(String paramName) {
        return this.listEditor.getParameterEditor(paramName);
    }

    public ERF getSelectedERF_Instance() {
        ERF erfAPI = null;
        try {
            erfAPI = (ERF)this.erfGuiBean.getSelectedERF_Instance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return erfAPI;
    }

    @Override
    public EqkRupture getRupture() {
        this.probEqkRupture = this.erf.getRupture(this.sourceValue, this.ruptureValue);
        return this.probEqkRupture;
    }

    public ProbEqkSource getSource() {
        return this.erf.getSource(this.sourceValue);
    }

    void hypoCentreCheck_itemStateChanged(ItemEvent e) {
        if (this.hypoCentreCheck.isSelected()) {
            this.setHypocenterLocationInRupture(true);
        } else {
            this.setHypocenterLocationInRupture(false);
        }
        this.updateUI();
    }

    @Override
    public ParameterListEditor getParameterListEditor() {
        return this.listEditor;
    }

    @Override
    public ParameterList getVisibleParameterList() {
        return this.listEditor.getVisibleParameters();
    }

    public int getSourceIndex() {
        String sourceValue = (String)this.listEditor.getParameterList().getParameter(SOURCE_PARAM_NAME).getValue();
        int sourceIndex = Integer.parseInt(sourceValue.substring(0, sourceValue.indexOf("(")).trim());
        return sourceIndex;
    }

    public int getRuptureIndex() {
        int ruptureIndex = (Integer)this.listEditor.getParameterList().getParameter(RUPTURE_PARAM_NAME).getValue();
        return ruptureIndex;
    }

    @Override
    public Location getHypocenterLocation() {
        if (this.hypoCentreCheck.isSelected()) {
            return (Location)this.hypoCenterLocationParam.getValue();
        }
        return null;
    }

    @Override
    public EqkRupSelectorGuiBeanAPI getEqkRuptureSelectorPanel() {
        return this;
    }

    @Override
    public String getTimespanMetadataString() {
        return this.erfGuiBean.getSelectedERFTimespanGuiBean().getParameterListMetadataString();
    }
}

