/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.beans;

import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.opensha.commons.data.region.SitesInGriddedRegion;
import org.opensha.commons.hpc.grid.GridResourcesList;
import org.opensha.commons.hpc.grid.ResourceProvider;
import org.opensha.commons.hpc.grid.ResourceProviderEditor;
import org.opensha.commons.hpc.grid.StorageHost;
import org.opensha.commons.hpc.grid.SubmitHost;
import org.opensha.commons.hpc.grid.SubmitHostEditor;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.editor.ParameterEditor;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeFailEvent;
import org.opensha.commons.param.event.ParameterChangeFailListener;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.util.SiteTranslator;

public class GridParametersGuiBean
extends ParameterListEditor
implements ParameterChangeFailListener,
ParameterChangeListener,
Serializable {
    protected static final String C = "GridParametersGuiBean";
    public static final String GRIDDED_SITE_PARAMS = "Set Gridded Region Params";
    public static final String CUSTOM_PARAM_NAME = "Custom";
    ResourceProvider currentRP = null;
    ResourceProviderEditor currentRPEditor = null;
    SubmitHost currentSubmit = null;
    SubmitHostEditor currentSubmitEditor = null;
    ArrayList<ResourceProvider> rpList = new ArrayList();
    ArrayList<SubmitHost> submitList = new ArrayList();
    private StringParameter rpPresets;
    private StringParameter submitPresets;
    private IntegerParameter sitesPerJob = new IntegerParameter("Site Per Job", 0, Integer.MAX_VALUE);
    private IntegerParameter maxWallTime = new IntegerParameter("Maximum Time Per Job", 0, 999);
    private BooleanParameter saveERF = new BooleanParameter("Save ERF to File?", true);
    public static final String SUBMIT_HOST_PARAM_NAME = "Submit Host Presets";
    SiteTranslator siteTrans = new SiteTranslator();
    private SitesInGriddedRegion gridRectRegion;

    public GridParametersGuiBean(GridResourcesList resources) {
        this.init(resources);
    }

    public GridParametersGuiBean() {
        ArrayList<ResourceProvider> rpList = new ArrayList<ResourceProvider>();
        rpList.add(ResourceProvider.HPC());
        rpList.add(ResourceProvider.ABE_GLIDE_INS());
        rpList.add(ResourceProvider.ABE_NO_GLIDE_INS());
        rpList.add(ResourceProvider.DYNAMIC());
        rpList.add(ResourceProvider.ORNL());
        ArrayList<SubmitHost> submitList = new ArrayList<SubmitHost>();
        submitList.add(SubmitHost.AFTERSHOCK);
        ArrayList<StorageHost> storageList = new ArrayList<StorageHost>();
        storageList.add(StorageHost.HPC);
        this.init(new GridResourcesList(rpList, submitList, storageList));
    }

    private void init(GridResourcesList resources) {
        this.rpList = resources.getResourceProviders();
        this.currentRP = this.rpList.get(0);
        ArrayList<String> rpPresetsStr = new ArrayList<String>();
        for (ResourceProvider resourceProvider : this.rpList) {
            rpPresetsStr.add(resourceProvider.getName());
        }
        rpPresetsStr.add(CUSTOM_PARAM_NAME);
        this.submitList = resources.getSubmitHosts();
        this.currentSubmit = this.submitList.get(0);
        ArrayList<String> submitPresetsStr = new ArrayList<String>();
        for (SubmitHost preset : this.submitList) {
            submitPresetsStr.add(preset.getName());
        }
        submitPresetsStr.add(CUSTOM_PARAM_NAME);
        this.sitesPerJob.setValue(100);
        this.maxWallTime.setValue(240);
        this.rpPresets = new StringParameter("Resource Provider Presets", rpPresetsStr);
        this.rpPresets.setValue(this.currentRP.getName());
        this.rpPresets.addParameterChangeListener(this);
        this.submitPresets = new StringParameter(SUBMIT_HOST_PARAM_NAME, submitPresetsStr);
        this.submitPresets.setValue(this.currentSubmit.getName());
        this.submitPresets.addParameterChangeListener(this);
        this.parameterList = new ParameterList();
        this.parameterList.addParameter(this.rpPresets);
        this.parameterList.addParameter(this.submitPresets);
        this.parameterList.addParameter(this.sitesPerJob);
        this.parameterList.addParameter(this.maxWallTime);
        this.parameterList.addParameter(this.saveERF);
        this.editorPanel.removeAll();
        this.addParameters();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setSubmitHostsVisible(boolean visible) {
        ParameterEditor editor = this.getParameterEditor(SUBMIT_HOST_PARAM_NAME);
        editor.setVisible(visible);
    }

    @Override
    public void parameterChangeFailed(ParameterChangeFailEvent e) {
        String S = "GridParametersGuiBean : parameterChangeFailed(): ";
        StringBuffer b = new StringBuffer();
        Parameter param = (Parameter)e.getSource();
        ParameterConstraint constraint = param.getConstraint();
        String oldValueStr = e.getOldValue().toString();
        String badValueStr = e.getBadValue().toString();
        String name = param.getName();
        b.append("The value ");
        b.append(badValueStr);
        b.append(" is not permitted for '");
        b.append(name);
        b.append("'.\n");
        b.append("Resetting to ");
        b.append(oldValueStr);
        b.append(". The constraints are: \n");
        b.append(constraint.toString());
        JOptionPane.showMessageDialog(this, b.toString(), "Cannot Change Value", 1);
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        String name;
        Parameter param = (Parameter)e.getSource();
        if (param == this.rpPresets) {
            name = (String)this.rpPresets.getValue();
            if (name.equals(CUSTOM_PARAM_NAME)) {
                if (this.currentRPEditor == null) {
                    this.currentRPEditor = new ResourceProviderEditor(this.currentRP);
                    this.currentRPEditor.setLocationRelativeTo(this);
                }
                this.currentRPEditor.setVisible(true);
            } else {
                for (ResourceProvider resourceProvider : this.rpList) {
                    if (!name.equals(resourceProvider.getName())) continue;
                    this.currentRP = resourceProvider;
                    if (this.currentRPEditor == null) break;
                    this.currentRPEditor.setVisible(false);
                    this.currentRPEditor = null;
                    break;
                }
            }
        }
        if (param == this.submitPresets) {
            name = (String)this.submitPresets.getValue();
            if (name.equals(CUSTOM_PARAM_NAME)) {
                if (this.currentSubmitEditor == null) {
                    this.currentSubmitEditor = new SubmitHostEditor(this.currentSubmit);
                    this.currentSubmitEditor.setLocationRelativeTo(this);
                }
                this.currentSubmitEditor.setVisible(true);
            } else {
                for (SubmitHost submitHost : this.submitList) {
                    if (!name.equals(submitHost.getName())) continue;
                    this.currentSubmit = submitHost;
                    if (this.currentSubmitEditor == null) break;
                    this.currentSubmitEditor.setVisible(false);
                    this.currentSubmitEditor = null;
                    break;
                }
            }
        }
    }

    public int get_sitesPerJob() {
        return (Integer)this.sitesPerJob.getValue();
    }

    public int get_maxWallTime() {
        return (Integer)this.maxWallTime.getValue();
    }

    public boolean get_saveERF() {
        return (Boolean)this.saveERF.getValue();
    }

    public ResourceProvider get_resourceProvider() {
        return this.currentRP;
    }

    public SubmitHost get_submitHost() {
        return this.currentSubmit;
    }
}

