/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.beans;

import java.util.ArrayList;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.gui.infoTools.IMT_Info;
import org.opensha.sha.imr.AbstractIMR;

public class IMLorProbSelectorGuiBean
extends ParameterListEditor
implements ParameterChangeListener {
    public static final String IML_AT_PROB = "IML@Prob";
    public static final String PROB_AT_IML = "Prob@IML";
    public static final String PROBABILITY = "Probability";
    public static final String MAP_TYPE = "Map Type";
    private static final String IML = "IML";
    private static final String MAP_INFO = "Set What To Plot";
    private static final Double MIN_PROB = AbstractIMR.EXCEED_PROB_MIN;
    private static final Double MAX_PROB = AbstractIMR.EXCEED_PROB_MAX;
    private static final Double DEFAULT_PROB = 0.5;
    private static final Double DEFAULT_IML = 0.1;
    private StringParameter imlProbParam;
    private DoubleParameter probParam = new DoubleParameter("Probability", MIN_PROB, MAX_PROB, DEFAULT_PROB);
    private DoubleParameter imlParam = new DoubleParameter("IML", Double.MIN_VALUE, Double.MAX_VALUE, DEFAULT_IML);

    public IMLorProbSelectorGuiBean() {
        ArrayList<String> imlProbVector = new ArrayList<String>();
        imlProbVector.add(IML_AT_PROB);
        imlProbVector.add(PROB_AT_IML);
        this.imlProbParam = new StringParameter(MAP_TYPE, imlProbVector, imlProbVector.get(0).toString());
        this.imlProbParam.addParameterChangeListener(this);
        this.parameterList = new ParameterList();
        this.parameterList.addParameter(this.imlProbParam);
        this.parameterList.addParameter(this.probParam);
        this.parameterList.addParameter(this.imlParam);
        this.addParameters();
        this.setTitle(MAP_INFO);
        this.setParams(((String)this.imlProbParam.getValue()).toString());
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        String name = e.getParameterName();
        if (name.equalsIgnoreCase(MAP_TYPE)) {
            this.setParams(this.parameterList.getParameter(MAP_TYPE).getValue().toString());
        }
    }

    private void setParams(String mapType) {
        if (mapType.equalsIgnoreCase(IML_AT_PROB)) {
            this.setParameterVisible(IML, false);
            this.setParameterVisible(PROBABILITY, true);
        } else {
            this.setParameterVisible(PROBABILITY, false);
            this.setParameterVisible(IML, true);
        }
    }

    public void setIMLConstraintBasedOnSelectedIMT(String imt) {
        double minVal = IMT_Info.getMinIMT_Val(imt);
        double maxVal = IMT_Info.getMaxIMT_Val(imt);
        double defaultVal = IMT_Info.getDefaultIMT_VAL(imt);
        DoubleConstraint constraint = new DoubleConstraint(minVal, maxVal);
        this.imlParam.setConstraint(constraint);
        this.imlParam.setValue(Double.valueOf(defaultVal));
        this.refreshParamEditor();
    }

    public double getIML_Prob() {
        if (this.parameterList.getParameter(MAP_TYPE).getValue().toString().equalsIgnoreCase(IML_AT_PROB)) {
            return (Double)this.probParam.getValue();
        }
        return (Double)this.imlParam.getValue();
    }

    public boolean isProbAt_IML() {
        return ((String)this.imlProbParam.getValue()).equals(PROB_AT_IML);
    }

    public String getSelectedOption() {
        return ((String)this.imlProbParam.getValue()).toString();
    }
}

