/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.beans;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.sha.gui.beans.IMR_MultiGuiBean;
import org.opensha.sha.gui.beans.event.IMTChangeEvent;
import org.opensha.sha.gui.beans.event.IMTChangeListener;
import org.opensha.sha.imr.AttenRelRef;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.event.ScalarIMRChangeEvent;
import org.opensha.sha.imr.event.ScalarIMRChangeListener;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.util.TectonicRegionType;

public class IMT_NewGuiBean
extends ParameterListEditor
implements ParameterChangeListener,
ScalarIMRChangeListener {
    private static final long serialVersionUID = 1L;
    private static double default_period = 1.0;
    public static final String IMT_PARAM_NAME = "IMT";
    public static final String TITLE = "Set IMT";
    private boolean commonParamsOnly = false;
    private boolean imtsAvailable;
    private ParameterList imtParams;
    private StringParameter imtParameter;
    private List<? extends ScalarIMR> imrs;
    private ArrayList<IMTChangeListener> listeners = new ArrayList();
    private List<Double> allPeriods;
    private List<Double> currentSupportedPeriods;

    public IMT_NewGuiBean(ScalarIMR imr, boolean commonParamsOnly) {
        this(IMT_NewGuiBean.wrapInList(imr), commonParamsOnly);
    }

    public IMT_NewGuiBean(ScalarIMR imr) {
        this(IMT_NewGuiBean.wrapInList(imr));
    }

    public IMT_NewGuiBean(IMR_MultiGuiBean imrGuiBean) {
        this(imrGuiBean, false);
    }

    public IMT_NewGuiBean(IMR_MultiGuiBean imrGuiBean, boolean commonParamsOnly) {
        this(imrGuiBean.getIMRs(), commonParamsOnly);
        this.addIMTChangeListener(imrGuiBean);
        imrGuiBean.addIMRChangeListener(this);
        this.fireIMTChangeEvent();
    }

    public IMT_NewGuiBean(List<? extends ScalarIMR> imrs) {
        this(imrs, false);
    }

    public IMT_NewGuiBean(List<? extends ScalarIMR> imrs, boolean commonParamsOnly) {
        this.commonParamsOnly = commonParamsOnly;
        this.setTitle(TITLE);
        this.setIMRs(imrs);
    }

    private static ArrayList<ScalarIMR> wrapInList(ScalarIMR imr) {
        ArrayList<ScalarIMR> imrs = new ArrayList<ScalarIMR>();
        imrs.add(imr);
        return imrs;
    }

    public boolean areIMTsAvailable() {
        return this.imtsAvailable;
    }

    public void setIMR(ScalarIMR imr) {
        this.setIMRs(IMT_NewGuiBean.wrapInList(imr));
    }

    public void setIMRs(List<? extends ScalarIMR> imrs) {
        ArrayList<Double> saPeriods;
        ParameterList paramList;
        this.imrs = imrs;
        Preconditions.checkNotNull(imrs, (Object)"IMR list cannot be null!");
        Preconditions.checkArgument((!imrs.isEmpty() ? 1 : 0) != 0, (Object)"IMR list cannot be empty!");
        ParameterList[] supportedParamsPerIMR = new ParameterList[imrs.size()];
        for (int i = 0; i < supportedParamsPerIMR.length; ++i) {
            supportedParamsPerIMR[i] = imrs.get(i).getSupportedIntensityMeasures();
        }
        if (this.commonParamsOnly) {
            paramList = ParameterList.intersection(supportedParamsPerIMR);
            saPeriods = IMT_NewGuiBean.getCommonPeriods(imrs);
        } else {
            paramList = ParameterList.union(supportedParamsPerIMR);
            saPeriods = IMT_NewGuiBean.getAllSupportedPeriods(imrs);
        }
        SA_Param oldSAParam = null;
        if (paramList.containsParameter("SA")) {
            oldSAParam = (SA_Param)paramList.getParameter("SA");
        }
        if (oldSAParam != null && paramList.containsParameter(oldSAParam.getName())) {
            Collections.sort(saPeriods);
            this.allPeriods = saPeriods;
            DoubleDiscreteConstraint pConst = new DoubleDiscreteConstraint(saPeriods);
            double defaultPeriod = default_period;
            if (!pConst.isAllowed(defaultPeriod)) {
                defaultPeriod = saPeriods.get(0);
            }
            PeriodParam periodParam = new PeriodParam(pConst, defaultPeriod, true);
            periodParam.addParameterChangeListener(this);
            SA_Param replaceSA = new SA_Param(periodParam, oldSAParam.getDampingParam());
            replaceSA.setValue(defaultPeriod);
            paramList.replaceParameter(replaceSA.getName(), replaceSA);
        }
        this.imtParams = paramList;
        boolean bl = this.imtsAvailable = !paramList.isEmpty();
        if (!this.imtsAvailable) {
            paramList.addParameter(new StringParameter("No IMTs available for selected IMRs"));
        }
        ArrayList<String> imtNames = new ArrayList<String>();
        for (Parameter<?> param : paramList) {
            imtNames.add(param.getName());
        }
        ParameterList finalParamList = new ParameterList();
        this.imtParameter = new StringParameter(IMT_PARAM_NAME, imtNames, (String)imtNames.get(0));
        this.imtParameter.addParameterChangeListener(this);
        finalParamList.addParameter(this.imtParameter);
        finalParamList.addParameterList(paramList);
        this.updateGUI();
        this.fireIMTChangeEvent();
    }

    private void updateGUI() {
        ParameterList params = new ParameterList();
        params.addParameter(this.imtParameter);
        String imtName = (String)this.imtParameter.getValue();
        Parameter imtParam = this.imtParams.getParameter(imtName);
        for (Parameter<?> param : imtParam.getIndependentParameterList()) {
            if (param.getName().equals("SA Period")) {
                PeriodParam periodParam = (PeriodParam)param;
                List<Double> periods = this.currentSupportedPeriods;
                if (periods == null) {
                    periods = this.allPeriods;
                }
                DoubleDiscreteConstraint pConst = new DoubleDiscreteConstraint(periods);
                periodParam.setConstraint(pConst);
                if (periodParam.getValue() == null) {
                    if (periodParam.isAllowed(default_period)) {
                        periodParam.setValue(default_period);
                    } else {
                        periodParam.setValue(periods.get(0));
                    }
                }
                periodParam.getEditor().setParameter(periodParam);
            }
            params.addParameter(param);
        }
        this.setParameterList(params);
        this.refreshParamEditor();
        this.revalidate();
        this.repaint();
    }

    public String getSelectedIMT() {
        return (String)this.imtParameter.getValue();
    }

    public void setSelectedIMT(String imtName) {
        if (!imtName.equals(this.getSelectedIMT())) {
            this.imtParameter.setValue(imtName);
        }
    }

    public ArrayList<String> getSupportedIMTs() {
        return this.imtParameter.getAllowedStrings();
    }

    public Parameter<Double> getSelectedIM() {
        return this.imtParams.getParameter(this.getSelectedIMT());
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        String paramName = event.getParameterName();
        if (paramName.equals(IMT_PARAM_NAME)) {
            this.fireIMTChangeEvent();
            this.updateGUI();
        } else if (paramName.equals("SA Period") && this.getSelectedIMT().equals("SA")) {
            this.fireIMTChangeEvent();
        }
    }

    public void addIMTChangeListener(IMTChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeIMTChangeListener(IMTChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void clearIMTChangeListeners(IMTChangeListener listener) {
        this.listeners.clear();
    }

    private void fireIMTChangeEvent() {
        IMTChangeEvent event = new IMTChangeEvent(this, this.getSelectedIM());
        for (IMTChangeListener listener : this.listeners) {
            listener.imtChange(event);
        }
    }

    public void setIMTinIMR(ScalarIMR imr) {
        IMT_NewGuiBean.setIMTinIMR(this.getSelectedIM(), imr);
    }

    public void setIMTinIMRs(Map<TectonicRegionType, ScalarIMR> imrMap) {
        IMT_NewGuiBean.setIMTinIMRs(this.getSelectedIM(), imrMap);
    }

    public static void setIMTinIMR(Parameter<Double> imt, ScalarIMR imr) {
        imr.setIntensityMeasure(imt.getName());
        Parameter newIMT = imr.getIntensityMeasure();
        for (Parameter<?> toBeSet : newIMT.getIndependentParameterList()) {
            Parameter newVal = imt.getIndependentParameter(toBeSet.getName());
            toBeSet.setValue(newVal.getValue());
        }
    }

    public static void setIMTinIMRs(Parameter<Double> imt, Map<TectonicRegionType, ScalarIMR> imrMap) {
        for (TectonicRegionType trt : imrMap.keySet()) {
            ScalarIMR imr = imrMap.get(trt);
            IMT_NewGuiBean.setIMTinIMR(imt, imr);
        }
    }

    public void setSupportedPeriods(List<Double> supportedPeriods) {
        this.currentSupportedPeriods = new ArrayList<Double>(supportedPeriods.size());
        this.currentSupportedPeriods.addAll(supportedPeriods);
        Collections.sort(this.currentSupportedPeriods);
        this.updateGUI();
    }

    public static ArrayList<Double> getCommonPeriods(Collection<? extends ScalarIMR> imrs) {
        ArrayList<Double> allPeriods = IMT_NewGuiBean.getAllSupportedPeriods(imrs);
        ArrayList<Double> commonPeriods = new ArrayList<Double>();
        for (Double period : allPeriods) {
            boolean include = true;
            for (ScalarIMR scalarIMR : imrs) {
                if (!scalarIMR.isIntensityMeasureSupported("SA")) {
                    return new ArrayList<Double>();
                }
                scalarIMR.setIntensityMeasure("SA");
                SA_Param saParam = (SA_Param)scalarIMR.getIntensityMeasure();
                PeriodParam periodParam = saParam.getPeriodParam();
                if (periodParam.isAllowed(period)) continue;
                include = false;
                break;
            }
            if (!include) continue;
            commonPeriods.add(period);
        }
        return commonPeriods;
    }

    public static ArrayList<Double> getAllSupportedPeriods(Collection<? extends ScalarIMR> imrs) {
        ArrayList<Double> periods = new ArrayList<Double>();
        for (ScalarIMR scalarIMR : imrs) {
            if (!scalarIMR.isIntensityMeasureSupported("SA")) continue;
            scalarIMR.setIntensityMeasure("SA");
            SA_Param saParam = (SA_Param)scalarIMR.getIntensityMeasure();
            PeriodParam periodParam = saParam.getPeriodParam();
            for (double period : periodParam.getAllowedDoubles()) {
                if (periods.contains(period)) continue;
                periods.add(period);
            }
        }
        return periods;
    }

    @Override
    public void imrChange(ScalarIMRChangeEvent event) {
        this.setSupportedPeriods(IMT_NewGuiBean.getCommonPeriods(event.getNewIMRs().values()));
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(600, 800);
        List<AttenuationRelationship> imrs = AttenRelRef.instanceList(null, true, ServerPrefUtils.SERVER_PREFS);
        for (ScalarIMR scalarIMR : imrs) {
            scalarIMR.setParamDefaults();
        }
        IMT_NewGuiBean choose = new IMT_NewGuiBean(imrs);
        frame.setContentPane(choose);
        frame.setVisible(true);
    }
}

