/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.sha.gui.beans.IMT_GuiBean;
import org.opensha.sha.gui.controls.GenerateHazusFilesConrolPanelAPI;
import org.opensha.sha.gui.infoTools.CalcProgressBar;
import org.opensha.sha.imr.AttenuationRelationship;

public class GenerateHazusFilesControlPanel
extends JFrame {
    private JPanel jPanel1 = new JPanel();
    private JTextPane infoPanel = new JTextPane();
    private BorderLayout borderLayout1 = new BorderLayout();
    private GenerateHazusFilesConrolPanelAPI application;
    private GeoDataSet sa03_xyzdata;
    private GeoDataSet sa10_xyzdata;
    private GeoDataSet pga_xyzdata;
    private GeoDataSet pgv_xyzdata;
    private String metadata;
    private JButton generateHazusShapeFilesButton = new JButton();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private IMT_GuiBean imtGuiBean;
    boolean generatingXYZDataForShapeFiles = false;
    CalcProgressBar calcProgress;

    public GenerateHazusFilesControlPanel(Component parent, IMT_GuiBean imtGui, GenerateHazusFilesConrolPanelAPI api) {
        this.imtGuiBean = imtGui;
        this.setLocation(parent.getX() + parent.getWidth() / 2, parent.getY() + parent.getHeight() / 2);
        this.application = api;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.setTitle("Hazus Shapefiles Control");
        this.infoPanel.setBackground(SystemColor.menu);
        this.infoPanel.setEnabled(false);
        String info = new String("This generates a set of Hazus shapefiles (sa-0.3sec, sa-1.0sec, pga and pgv) for the selected Earthquake Rupture and IMR.  Be sure to have selected Average-Horizontal component, and note that PGV in these files is in units of inches/sec (as assumed by Hazus)");
        this.infoPanel.setPreferredSize(new Dimension(812, 16));
        this.infoPanel.setEditable(false);
        this.infoPanel.setText(info);
        this.jPanel1.setMinimumSize(new Dimension(350, 70));
        this.jPanel1.setPreferredSize(new Dimension(350, 125));
        this.generateHazusShapeFilesButton.setText("Generate Hazus Shape Files");
        this.generateHazusShapeFilesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerateHazusFilesControlPanel.this.generateHazusShapeFilesButton_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.infoPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 42, 19, 41), 0, 0));
        this.jPanel1.add((Component)this.generateHazusShapeFilesButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(14, 49, 6, 54), 87, 8));
    }

    private void generateHazusFiles(AttenuationRelationship imr) {
        String sa = "SA";
        String pga = "PGA";
        String pgv = "PGV";
        this.imtGuiBean.getParameterList().getParameter("IMT").setValue(sa);
        this.imtGuiBean.getParameterList().getParameter("SA Period").setValue(0.3);
        this.sa03_xyzdata = this.application.generateShakeMap();
        this.metadata = this.imtGuiBean.getVisibleParameters().getParameterListMetadataString() + "<br>\n";
        this.imtGuiBean.getParameterList().getParameter("SA Period").setValue(1.0);
        this.sa10_xyzdata = this.application.generateShakeMap();
        this.metadata = this.metadata + this.imtGuiBean.getVisibleParameters().getParameterListMetadataString() + "<br>\n";
        if (imr.isIntensityMeasureSupported(pgv)) {
            this.imtGuiBean.getParameterList().getParameter("IMT").setValue(pgv);
            this.pgv_xyzdata = this.application.generateShakeMap();
            this.metadata = this.metadata + this.imtGuiBean.getVisibleParameters().getParameterListMetadataString() + "<br>\n";
        } else {
            this.pgv_xyzdata = this.sa10_xyzdata.copy();
            this.pgv_xyzdata.scale(94.5896);
            this.metadata = this.metadata + "IMT: PGV<br>\n";
        }
        this.imtGuiBean.getParameterList().getParameter("IMT").setValue(pga);
        this.pga_xyzdata = this.application.generateShakeMap();
        this.metadata = this.metadata + this.imtGuiBean.getVisibleParameters().getParameterListMetadataString() + "<br>\n";
        this.calcProgress.showProgress(false);
        this.calcProgress.dispose();
        this.imtGuiBean.refreshParamEditor();
    }

    public String getIMT_Metadata() {
        return this.metadata;
    }

    public GeoDataSet getXYZ_DataForSA_03() {
        return this.sa03_xyzdata;
    }

    public GeoDataSet getXYZ_DataForSA_10() {
        return this.sa10_xyzdata;
    }

    public GeoDataSet getXYZ_DataForPGA() {
        return this.pga_xyzdata;
    }

    public GeoDataSet getXYZ_DataForPGV() {
        return this.pgv_xyzdata;
    }

    void generateHazusShapeFilesButton_actionPerformed(ActionEvent e) {
        this.getRegionAndMapType();
        this.generateShapeFilesForHazus();
    }

    public void generateShapeFilesForHazus() {
        this.calcProgress = new CalcProgressBar("Hazus Shape file data", "Starting Calculation...");
        this.calcProgress.setProgressMessage("Doing Calculation for the Hazus ShapeFile Data...");
        this.generateHazusFiles(this.application.getSelectedAttenuationRelationship());
        this.generatingXYZDataForShapeFiles = true;
    }

    public void getRegionAndMapType() {
        this.application.getGriddedSitesAndMapType();
    }

    public boolean isHazusShapeFilesButtonPressed() {
        return this.generatingXYZDataForShapeFiles;
    }
}

