/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.gui.ControlPanel;
import org.opensha.commons.param.ParameterList;
import org.opensha.sha.earthquake.rupForecastImpl.PEER_TestCases.PEER_LogicTreeERF_List;
import org.opensha.sha.earthquake.rupForecastImpl.PEER_TestCases.PEER_NonPlanarFaultForecast;
import org.opensha.sha.gui.HazardCurveApplication;
import org.opensha.sha.gui.beans.ERF_GuiBean;
import org.opensha.sha.gui.beans.IMR_MultiGuiBean;
import org.opensha.sha.gui.beans.IMT_NewGuiBean;
import org.opensha.sha.gui.beans.Site_GuiBean;
import org.opensha.sha.gui.beans.TimeSpanGuiBean;
import org.opensha.sha.gui.controls.CalculationSettingsControlPanelAPI;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.magdist.GaussianMagFreqDist;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.SingleMagFreqDist;
import org.opensha.sha.magdist.YC_1985_CharMagFreqDist;
import org.opensha.sha.param.MagFreqDistParameter;
import org.opensha.sha.param.editor.MagFreqDistParameterEditor;
import org.opensha.sha.param.editor.gui.SimpleFaultParameterEditorPanel;

public class PEER_TestCaseSelectorControlPanel
extends ControlPanel {
    public static final String NAME = "PEER Test Case Selector";
    protected static final String C = "PEER_TestCaseSelectorControlPanel";
    protected static final boolean D = false;
    public static final String PEER_TESTS_SET_ONE = "Set1";
    public static final String PEER_TESTS_SET_TWO = "Set2";
    public static final String TEST_CASE_ONE = "Case1";
    public static final String TEST_CASE_TWO = "Case2";
    public static final String TEST_CASE_THREE = "Case3";
    public static final String TEST_CASE_FOUR = "Case4";
    public static final String TEST_CASE_FIVE = "Case5";
    public static final String TEST_CASE_SIX = "Case6";
    public static final String TEST_CASE_SEVEN = "Case7";
    public static final String TEST_CASE_EIGHT_A = "Case8a";
    public static final String TEST_CASE_EIGHT_B = "Case8b";
    public static final String TEST_CASE_EIGHT_C = "Case8c";
    public static final String TEST_CASE_NINE_A = "Case9a";
    public static final String TEST_CASE_NINE_B = "Case9b";
    public static final String TEST_CASE_NINE_C = "Case9c";
    public static final String TEST_CASE_TEN = "Case10";
    public static final String TEST_CASE_ELEVEN = "Case11";
    public static final String TEST_CASE_TWELVE = "Case12";
    public static final String SITE_ONE = "Site1";
    public static final String SITE_TWO = "Site2";
    public static final String SITE_THREE = "Site3";
    public static final String SITE_FOUR = "Site4";
    public static final String SITE_FIVE = "Site5";
    public static final String SITE_SIX = "Site6";
    public static final String SITE_SEVEN = "Site7";
    private double MAX_DISTANCE = 300.0;
    private double GRID_SPACING = 1.0;
    private String FAULT_TYPE = "Stirling's";
    private IMT_NewGuiBean imtGuiBean;
    private IMR_MultiGuiBean imrGuiBean;
    private Site_GuiBean siteGuiBean;
    private ERF_GuiBean erfGuiBean;
    private TimeSpanGuiBean timeSpanGuiBean;
    CalculationSettingsControlPanelAPI application;
    private String selectedTest;
    private String selectedSite;
    private String selectedSet;
    private JLabel jLabel2 = new JLabel();
    private JComboBox testCaseComboBox = new JComboBox();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private ArrayList<String> peerTestSetOne = new ArrayList();
    private ArrayList<String> peerTestSetTwo = new ArrayList();
    private ArrayList fault1and2_Lats;
    private ArrayList fault1and2_Lons;
    private ArrayList fault1_Dips;
    private ArrayList fault2_Dips;
    private ArrayList fault1_Depths;
    private ArrayList fault2_Depths;
    private ArrayList faultE_Lats;
    private ArrayList faultE_Lons;
    private ArrayList faultE_Dips;
    private ArrayList faultE_Depths;
    HazardCurveApplication api;
    ArbitrarilyDiscretizedFunc function = new ArbitrarilyDiscretizedFunc();
    private JFrame frame;
    private Component parent;

    public PEER_TestCaseSelectorControlPanel(Component parent, HazardCurveApplication api, IMR_MultiGuiBean imrGuiBean, Site_GuiBean siteGuiBean, IMT_NewGuiBean imtGuiBean, ERF_GuiBean erfGuiBean, TimeSpanGuiBean timeSpanGuiBean, CalculationSettingsControlPanelAPI application) {
        super(NAME);
        this.parent = parent;
        this.api = api;
        this.imrGuiBean = imrGuiBean;
        this.siteGuiBean = siteGuiBean;
        this.imtGuiBean = imtGuiBean;
        this.erfGuiBean = erfGuiBean;
        this.timeSpanGuiBean = timeSpanGuiBean;
        this.application = application;
    }

    @Override
    public void doinit() {
        this.frame = new JFrame();
        this.initializeFaultData();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initializeTestsAndSites();
        this.frame.setLocation(this.parent.getX() + this.parent.getWidth() / 2, this.parent.getY() + this.parent.getHeight() / 2);
        this.createPEER_Function();
        this.setPEER_XValues();
    }

    private void jbInit() throws Exception {
        this.frame.getContentPane().setLayout(this.gridBagLayout1);
        this.jLabel2.setForeground(Color.black);
        this.jLabel2.setText("Select Test and Site:");
        this.testCaseComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PEER_TestCaseSelectorControlPanel.this.testCaseComboBox_actionPerformed(e);
            }
        });
        this.frame.setTitle(NAME);
        this.frame.getContentPane().add((Component)this.jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 7, 2, 240), 22, 5));
        this.frame.getContentPane().add((Component)this.testCaseComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(7, 145, 2, 13), 92, -1));
    }

    private void createPEER_Function() {
        this.function.set(0.001, 1.0);
        this.function.set(0.01, 1.0);
        this.function.set(0.05, 1.0);
        this.function.set(0.1, 1.0);
        this.function.set(0.15, 1.0);
        this.function.set(0.2, 1.0);
        this.function.set(0.25, 1.0);
        this.function.set(0.3, 1.0);
        this.function.set(0.35, 1.0);
        this.function.set(0.4, 1.0);
        this.function.set(0.45, 1.0);
        this.function.set(0.5, 1.0);
        this.function.set(0.55, 1.0);
        this.function.set(0.6, 1.0);
        this.function.set(0.7, 1.0);
        this.function.set(0.8, 1.0);
        this.function.set(0.9, 1.0);
        this.function.set(1.0, 1.0);
    }

    public void setPEER_XValues() {
        this.api.setCurveXValues(this.function);
    }

    public void setTestCaseAndSite(String testAndSite) {
        int firstIndex = testAndSite.indexOf("-");
        int lastIndex = testAndSite.lastIndexOf("-");
        this.selectedSet = testAndSite.substring(0, firstIndex);
        this.selectedTest = testAndSite.substring(firstIndex + 1, lastIndex);
        this.selectedSite = testAndSite.substring(lastIndex + 1);
        this.setParams();
    }

    public void setParams() {
        String S = "PEER_TestCaseSelectorControlPanel:setParams()";
        ParameterList siteParams = this.siteGuiBean.getParameterListEditor().getParameterList();
        this.application.getCalcAdjustableParams().getParameter("Maximum Distance").setValue(this.MAX_DISTANCE);
        this.application.getCalcAdjustableParams().getParameter("Use Mag-Distance Filter?").setValue(false);
        if (this.selectedSet.equalsIgnoreCase(PEER_TESTS_SET_ONE)) {
            this.set_Set1Params(siteParams);
        } else if (this.selectedSet.equalsIgnoreCase(PEER_TESTS_SET_TWO)) {
            this.set_Set2Params(siteParams);
        }
        this.imrGuiBean.rebuildGUI();
        this.imtGuiBean.refreshParamEditor();
        this.siteGuiBean.getParameterListEditor().refreshParamEditor();
        this.erfGuiBean.getERFParameterListEditor().refreshParamEditor();
        this.timeSpanGuiBean.getParameterListEditor().refreshParamEditor();
    }

    private void set_Set1Params(ParameterList siteParams) {
        this.imrGuiBean.setSelectedSingleIMR("Sadigh et al (1997)");
        ScalarIMR imr = this.imrGuiBean.getSelectedIMR();
        imr.getParameter("Gaussian Truncation").setValue("None");
        imr.getParameter("Std Dev Type").setValue("None (zero)");
        this.imtGuiBean.setSelectedIMT("PGA");
        siteParams.getParameter("Sadigh Site Type").setValue("Rock");
        if (this.selectedTest.equals(TEST_CASE_EIGHT_A)) {
            imr.getParameter("Gaussian Truncation").setValue("None");
            imr.getParameter("Std Dev Type").setValue("Total");
            this.imtGuiBean.setSelectedIMT("PGA");
        }
        if (this.selectedTest.equals(TEST_CASE_EIGHT_B)) {
            imr.getParameter("Gaussian Truncation").setValue("1 Sided");
            imr.getParameter("Truncation Level").setValue(2.0);
            imr.getParameter("Std Dev Type").setValue("Total");
            this.imtGuiBean.setSelectedIMT("PGA");
        }
        if (this.selectedTest.equals(TEST_CASE_EIGHT_C)) {
            imr.getParameter("Gaussian Truncation").setValue("1 Sided");
            imr.getParameter("Truncation Level").setValue(3.0);
            imr.getParameter("Std Dev Type").setValue("Total");
            this.imtGuiBean.setSelectedIMT("PGA");
        }
        if (this.selectedTest.equals(TEST_CASE_NINE_A)) {
            this.imrGuiBean.setSelectedSingleIMR("Sadigh et al (1997)");
            imr = this.imrGuiBean.getSelectedIMR();
            imr.getParameter("Gaussian Truncation").setValue("1 Sided");
            imr.getParameter("Truncation Level").setValue(3.0);
            imr.getParameter("Std Dev Type").setValue("Total");
            this.imtGuiBean.setSelectedIMT("PGA");
            siteParams.getParameter("Sadigh Site Type").setValue("Rock");
        }
        if (this.selectedTest.equals(TEST_CASE_NINE_B)) {
            this.imrGuiBean.setSelectedSingleIMR("Abrahamson & Silva (1997)");
            imr = this.imrGuiBean.getSelectedIMR();
            imr.getParameter("Gaussian Truncation").setValue("None");
            imr.getParameter("Truncation Level").setValue(3.0);
            imr.getParameter("Std Dev Type").setValue("None (zero)");
            this.imtGuiBean.setSelectedIMT("PGA");
            siteParams.getParameter("AS Site Type").setValue("Rock/Shallow-Soil");
        }
        if (this.selectedTest.equals(TEST_CASE_NINE_C)) {
            this.imrGuiBean.setSelectedSingleIMR("Campbell (1997) w/ erratum (2000) changes");
            imr = this.imrGuiBean.getSelectedIMR();
            imr.getParameter("Gaussian Truncation").setValue("1 Sided");
            imr.getParameter("Truncation Level").setValue(3.0);
            imr.getParameter("Std Dev Type").setValue("Total (PGA Dependent)");
            this.imtGuiBean.setSelectedIMT("PGA");
            this.siteGuiBean.getParameterListEditor().getParameterList().getParameter("Campbell Site Type").setValue("Soft-Rock");
            siteParams.getParameter("Campbell-Basin-Depth").setValue(2.0);
        }
        if (this.selectedTest.equals(TEST_CASE_TWELVE)) {
            imr.getParameter("Gaussian Truncation").setValue("1 Sided");
            imr.getParameter("Truncation Level").setValue(3.0);
            imr.getParameter("Std Dev Type").setValue("Total");
            this.imtGuiBean.setSelectedIMT("PGA");
        }
        if (!this.selectedTest.equalsIgnoreCase(TEST_CASE_TEN) && !this.selectedTest.equalsIgnoreCase(TEST_CASE_ELEVEN)) {
            this.erfGuiBean.getERFParameterList().getParameter("Eqk Rup Forecast").setValue("Floating Poisson Fault ERF");
            double gridSpacing = this.selectedTest.equals(TEST_CASE_ONE) || this.selectedTest.equals(TEST_CASE_TWO) || this.selectedTest.equals(TEST_CASE_FOUR) || this.selectedTest.equals(TEST_CASE_NINE_B) ? 0.05 : (this.selectedTest.equals(TEST_CASE_THREE) ? 0.25 : 0.5);
            if (this.selectedTest.equals(TEST_CASE_EIGHT_C) && this.selectedSite.equals(SITE_FIVE)) {
                gridSpacing = 0.05;
            }
            if (this.selectedTest.equals(TEST_CASE_NINE_C) && this.selectedSite.equals(SITE_SEVEN)) {
                gridSpacing = 0.1;
            }
            if (this.selectedTest.equals(TEST_CASE_TWO) && (this.selectedSite.equals(SITE_ONE) || this.selectedSite.equals(SITE_FOUR) || this.selectedSite.equals(SITE_SIX))) {
                gridSpacing = 0.025;
            }
            this.erfGuiBean.getERFParameterList().getParameter("Rupture Offset").setValue(gridSpacing);
            this.erfGuiBean.getERFParameterList().getParameter("Mag-Scaling Relationship").setValue("PEER Tests Mag-Area Rel.");
            this.erfGuiBean.getERFParameterList().getParameter("Mag Scaling Sigma").setValue(0.0);
            this.erfGuiBean.getERFParameterList().getParameter("Rupture Aspect Ratio").setValue(2.0);
            this.erfGuiBean.getERFParameterList().getParameter("Min Mag").setValue(5.0);
            this.timeSpanGuiBean.getParameterList().getParameter("Duration").setValue(1.0);
            if (this.selectedTest.equals(TEST_CASE_THREE)) {
                this.erfGuiBean.getERFParameterList().getParameter("Mag Scaling Sigma").setValue(0.25);
            }
            if (this.selectedTest.equals(TEST_CASE_FOUR) || this.selectedTest.equals(TEST_CASE_NINE_A) || this.selectedTest.equals(TEST_CASE_NINE_B) || this.selectedTest.equals(TEST_CASE_NINE_C)) {
                this.erfGuiBean.getERFParameterList().getParameter("Rake").setValue(90.0);
            } else {
                this.erfGuiBean.getERFParameterList().getParameter("Rake").setValue(0.0);
            }
            SimpleFaultParameterEditorPanel faultPanel = this.erfGuiBean.getSimpleFaultParamEditor().getParameterEditorPanel();
            if (this.selectedTest.equals(TEST_CASE_FOUR) || this.selectedTest.equals(TEST_CASE_NINE_A) || this.selectedTest.equals(TEST_CASE_NINE_B) || this.selectedTest.equals(TEST_CASE_NINE_C)) {
                faultPanel.setAll(gridSpacing, this.fault1and2_Lats, this.fault1and2_Lons, this.fault2_Dips, this.fault2_Depths, this.FAULT_TYPE);
            } else {
                faultPanel.setAll(gridSpacing, this.fault1and2_Lats, this.fault1and2_Lons, this.fault1_Dips, this.fault1_Depths, this.FAULT_TYPE);
            }
            faultPanel.setEvenlyGriddedSurfaceFromParams();
        } else {
            this.erfGuiBean.getERFParameterList().getParameter("Eqk Rup Forecast").setValue("PEER Area Forecast");
            this.erfGuiBean.getERFParameterList().getParameter("Upper Seis Depth").setValue(5.0);
            this.erfGuiBean.getERFParameterList().getParameter("Ave Dip").setValue(90.0);
            this.erfGuiBean.getERFParameterList().getParameter("Ave Rake").setValue(0.0);
            this.timeSpanGuiBean.getParameterList().getParameter("Duration").setValue(1.0);
            if (this.selectedTest.equals(TEST_CASE_TEN)) {
                this.erfGuiBean.getERFParameterList().getParameter("Lower Seis Depth").setValue(5.0);
                this.erfGuiBean.getERFParameterList().getParameter("Area Grid Spacing").setValue(1.0);
            } else {
                this.erfGuiBean.getERFParameterList().getParameter("Lower Seis Depth").setValue(10.0);
                this.erfGuiBean.getERFParameterList().getParameter("Area Grid Spacing").setValue(0.25);
            }
        }
        MagFreqDistParameterEditor magDistEditor = this.erfGuiBean.getMagDistEditor();
        this.setMagDistParams_Set1(magDistEditor);
        if (!this.selectedTest.equalsIgnoreCase(TEST_CASE_TEN) && !this.selectedTest.equalsIgnoreCase(TEST_CASE_ELEVEN)) {
            if (this.selectedSite.equals(SITE_ONE)) {
                this.siteGuiBean.getParameterListEditor().getParameterList().getParameter("Latitude").setValue(38.113);
                siteParams.getParameter("Longitude").setValue(-122.0);
            }
            if (this.selectedSite.equals(SITE_TWO)) {
                siteParams.getParameter("Latitude").setValue(38.113);
                siteParams.getParameter("Longitude").setValue(-122.114);
            }
            if (this.selectedSite.equals(SITE_THREE)) {
                siteParams.getParameter("Latitude").setValue(38.111);
                siteParams.getParameter("Longitude").setValue(-122.57);
            }
            if (this.selectedSite.equals(SITE_FOUR)) {
                siteParams.getParameter("Latitude").setValue(38.0);
                siteParams.getParameter("Longitude").setValue(-122.0);
            }
            if (this.selectedSite.equals(SITE_FIVE)) {
                siteParams.getParameter("Latitude").setValue(37.91);
                siteParams.getParameter("Longitude").setValue(-122.0);
            }
            if (this.selectedSite.equals(SITE_SIX)) {
                siteParams.getParameter("Latitude").setValue(38.225);
                siteParams.getParameter("Longitude").setValue(-122.0);
            }
            if (this.selectedSite.equals(SITE_SEVEN)) {
                siteParams.getParameter("Latitude").setValue(38.113);
                siteParams.getParameter("Longitude").setValue(-121.886);
            }
        } else {
            siteParams.getParameter("Longitude").setValue(-122.0);
            if (this.selectedSite.equals(SITE_ONE)) {
                siteParams.getParameter("Latitude").setValue(38.0);
            }
            if (this.selectedSite.equals(SITE_TWO)) {
                siteParams.getParameter("Latitude").setValue(37.55);
            }
            if (this.selectedSite.equals(SITE_THREE)) {
                siteParams.getParameter("Latitude").setValue(37.099);
            }
            if (this.selectedSite.equals(SITE_FOUR)) {
                siteParams.getParameter("Latitude").setValue(36.875);
            }
        }
    }

    private void set_Set2Params(ParameterList siteParams) {
        MagFreqDistParameterEditor magDistEditor;
        SimpleFaultParameterEditorPanel faultPanel;
        this.imrGuiBean.setSelectedSingleIMR("Sadigh et al (1997)");
        ScalarIMR imr = this.imrGuiBean.getSelectedIMR();
        imr.getParameter("Gaussian Truncation").setValue("None");
        imr.getParameter("Std Dev Type").setValue("None (zero)");
        this.imtGuiBean.setSelectedIMT("PGA");
        siteParams.getParameter("Sadigh Site Type").setValue("Rock");
        if (this.selectedTest.equalsIgnoreCase(TEST_CASE_TWO) || this.selectedTest.equalsIgnoreCase(TEST_CASE_FIVE)) {
            imr.getParameter("Gaussian Truncation").setValue("1 Sided");
            imr.getParameter("Truncation Level").setValue(3.0);
            imr.getParameter("Std Dev Type").setValue("Total");
        }
        if (this.selectedTest.equals(TEST_CASE_ONE) || this.selectedTest.equals(TEST_CASE_FIVE)) {
            if (this.selectedSite.equals(SITE_ONE) || this.selectedSite.equals(SITE_FOUR)) {
                siteParams.getParameter("Latitude").setValue(38.1126);
                siteParams.getParameter("Longitude").setValue(-121.886);
            } else if (this.selectedSite.equalsIgnoreCase(SITE_TWO) || this.selectedSite.equals(SITE_FIVE)) {
                siteParams.getParameter("Latitude").setValue(38.18);
                siteParams.getParameter("Longitude").setValue(-121.886);
            } else if (this.selectedSite.equalsIgnoreCase(SITE_THREE) || this.selectedSite.equals(SITE_SIX)) {
                siteParams.getParameter("Latitude").setValue(38.2696);
                siteParams.getParameter("Longitude").setValue(-122.114);
            }
        } else if (this.selectedTest.equalsIgnoreCase(TEST_CASE_TWO)) {
            siteParams.getParameter("Longitude").setValue(-122.0);
            if (this.selectedSite.equalsIgnoreCase(SITE_ONE)) {
                siteParams.getParameter("Latitude").setValue(37.5495);
            } else if (this.selectedSite.equalsIgnoreCase(SITE_TWO)) {
                siteParams.getParameter("Latitude").setValue(37.099);
            } else if (this.selectedSite.equalsIgnoreCase(SITE_THREE)) {
                siteParams.getParameter("Latitude").setValue(36.8737);
            }
        } else if (this.selectedSite.equalsIgnoreCase(SITE_ONE)) {
            siteParams.getParameter("Longitude").setValue(-121.886);
            siteParams.getParameter("Latitude").setValue(38.1126);
        } else if (this.selectedSite.equalsIgnoreCase(SITE_TWO)) {
            siteParams.getParameter("Longitude").setValue(-122.0);
            siteParams.getParameter("Latitude").setValue(38.2252);
        } else if (this.selectedSite.equalsIgnoreCase(SITE_THREE)) {
            siteParams.getParameter("Longitude").setValue(-122.0);
            siteParams.getParameter("Latitude").setValue(38.0);
        }
        if (this.selectedTest.equalsIgnoreCase(TEST_CASE_ONE)) {
            this.erfGuiBean.getERFParameterList().getParameter("Eqk Rup Forecast").setValue("PEER Non Planar Fault Forecast");
            this.erfGuiBean.getERFParameterList().getParameter("Mag Length Sigma").setValue(0.0);
            this.timeSpanGuiBean.getParameterList().getParameter("Duration").setValue(1.0);
            this.erfGuiBean.getERFParameterList().getParameter("Fault Grid Spacing").setValue(1.0);
            this.erfGuiBean.getERFParameterList().getParameter("Offset").setValue(1.0);
            this.erfGuiBean.getERFParameterList().getParameter(PEER_NonPlanarFaultForecast.GR_MAG_UPPER).setValue(6.95);
            this.erfGuiBean.getERFParameterList().getParameter("Slip Rate").setValue(2.0);
            this.erfGuiBean.getERFParameterList().getParameter(PEER_NonPlanarFaultForecast.SEGMENTATION_NAME).setValue(PEER_NonPlanarFaultForecast.SEGMENTATION_NO);
            this.erfGuiBean.getERFParameterList().getParameter(PEER_NonPlanarFaultForecast.FAULT_MODEL_NAME).setValue(PEER_NonPlanarFaultForecast.FAULT_MODEL_STIRLING);
            if (this.selectedSite.equals(SITE_ONE) || this.selectedSite.equals(SITE_TWO) || this.selectedSite.equals(SITE_THREE)) {
                this.erfGuiBean.getERFParameterList().getParameter(PEER_NonPlanarFaultForecast.DIP_DIRECTION_NAME).setValue(PEER_NonPlanarFaultForecast.DIP_DIRECTION_EAST);
            } else {
                this.erfGuiBean.getERFParameterList().getParameter(PEER_NonPlanarFaultForecast.DIP_DIRECTION_NAME).setValue(PEER_NonPlanarFaultForecast.DIP_DIRECTION_WEST);
            }
        }
        if (this.selectedTest.equalsIgnoreCase(TEST_CASE_TWO)) {
            this.erfGuiBean.getERFParameterList().getParameter("Eqk Rup Forecast").setValue("PEER Multi Source");
            this.erfGuiBean.getERFParameterList().getParameter("Area Lower Seis Depth").setValue(10.0);
            this.erfGuiBean.getERFParameterList().getParameter("Area Upper Seis Depth").setValue(5.0);
            this.erfGuiBean.getERFParameterList().getParameter("Grid Spacing of Sources").setValue(1.0);
            this.erfGuiBean.getERFParameterList().getParameter("Offset").setValue(1.0);
            this.timeSpanGuiBean.getParameterList().getParameter("Duration").setValue(1.0);
        }
        if (this.selectedTest.equalsIgnoreCase(TEST_CASE_THREE) || this.selectedTest.equalsIgnoreCase(TEST_CASE_FOUR)) {
            this.erfGuiBean.getERFParameterList().getParameter("Eqk Rup Forecast").setValue("Floating Poisson Fault ERF");
            this.erfGuiBean.getERFParameterList().getParameter("Rupture Offset").setValue(1.0);
            this.erfGuiBean.getERFParameterList().getParameter("Mag-Scaling Relationship").setValue("PEER Tests Mag-Area Rel.");
            this.erfGuiBean.getERFParameterList().getParameter("Mag Scaling Sigma").setValue(0.0);
            this.erfGuiBean.getERFParameterList().getParameter("Rupture Aspect Ratio").setValue(2.0);
            this.erfGuiBean.getERFParameterList().getParameter("Min Mag").setValue(5.0);
            this.timeSpanGuiBean.getParameterList().getParameter("Duration").setValue(1.0);
            this.erfGuiBean.getERFParameterList().getParameter("Rake").setValue(0.0);
            faultPanel = this.erfGuiBean.getSimpleFaultParamEditor().getParameterEditorPanel();
            faultPanel.setAll(this.GRID_SPACING, this.fault1and2_Lats, this.fault1and2_Lons, this.fault1_Dips, this.fault1_Depths, this.FAULT_TYPE);
            faultPanel.setEvenlyGriddedSurfaceFromParams();
        }
        if (this.selectedTest.equalsIgnoreCase(TEST_CASE_FIVE)) {
            this.erfGuiBean.getERFParameterList().getParameter("Eqk Rup Forecast").setValue(PEER_LogicTreeERF_List.NAME);
            this.erfGuiBean.getERFParameterList().getParameter(PEER_LogicTreeERF_List.FAULT_MODEL_NAME).setValue(PEER_LogicTreeERF_List.FAULT_MODEL_STIRLING);
            this.erfGuiBean.getERFParameterList().getParameter("Offset").setValue(1.0);
            this.erfGuiBean.getERFParameterList().getParameter("Fault Grid Spacing").setValue(1.0);
            this.erfGuiBean.getERFParameterList().getParameter("Mag Length Sigma").setValue(0.0);
            this.timeSpanGuiBean.getParameterList().getParameter("Duration").setValue(1.0);
        }
        if (this.selectedTest.equalsIgnoreCase(TEST_CASE_SIX)) {
            this.erfGuiBean.getERFParameterList().getParameter("Eqk Rup Forecast").setValue("Floating Poisson Fault ERF");
            this.erfGuiBean.getERFParameterList().getParameter("Rupture Offset").setValue(1.0);
            this.erfGuiBean.getERFParameterList().getParameter("Mag-Scaling Relationship").setValue("PEER Tests Mag-Area Rel.");
            this.erfGuiBean.getERFParameterList().getParameter("Mag Scaling Sigma").setValue(0.0);
            this.erfGuiBean.getERFParameterList().getParameter("Rupture Aspect Ratio").setValue(2.0);
            this.erfGuiBean.getERFParameterList().getParameter("Min Mag").setValue(5.0);
            this.timeSpanGuiBean.getParameterList().getParameter("Duration").setValue(1.0);
            this.erfGuiBean.getERFParameterList().getParameter("Rake").setValue(0.0);
            faultPanel = this.erfGuiBean.getSimpleFaultParamEditor().getParameterEditorPanel();
            faultPanel.setAll(this.GRID_SPACING, this.faultE_Lats, this.faultE_Lons, this.faultE_Dips, this.faultE_Depths, this.FAULT_TYPE);
            faultPanel.setEvenlyGriddedSurfaceFromParams();
        }
        if ((magDistEditor = this.erfGuiBean.getMagDistEditor()) != null) {
            this.setMagDistParams_Set2(magDistEditor);
        }
    }

    private void setMagDistParams_Set2(MagFreqDistParameterEditor magEditor) {
        if (this.selectedTest.equalsIgnoreCase(TEST_CASE_THREE)) {
            magEditor.getParameter("Distribution Type").setValue(YC_1985_CharMagFreqDist.NAME);
            magEditor.getParameter(MagFreqDistParameter.MIN).setValue(0.0);
            magEditor.getParameter(MagFreqDistParameter.MAX).setValue(10.0);
            magEditor.getParameter(MagFreqDistParameter.NUM).setValue(1001);
            magEditor.getParameter(MagFreqDistParameter.GR_BVALUE).setValue(0.9);
            magEditor.getParameter(MagFreqDistParameter.YC_DELTA_MAG_CHAR).setValue(0.5);
            magEditor.getParameter(MagFreqDistParameter.YC_DELTA_MAG_PRIME).setValue(1.0);
            magEditor.getParameter(MagFreqDistParameter.GR_MAG_LOWER).setValue(0.01);
            magEditor.getParameter(MagFreqDistParameter.YC_MAG_PRIME).setValue(5.95);
            magEditor.getParameter(MagFreqDistParameter.GR_MAG_UPPER).setValue(6.45);
            magEditor.getParameter(MagFreqDistParameter.SET_ALL_PARAMS_BUT).setValue(MagFreqDistParameter.TOT_MO_RATE);
            magEditor.getParameter(MagFreqDistParameter.YC_TOT_CHAR_RATE).setValue(0.001);
        }
        if (this.selectedTest.equalsIgnoreCase(TEST_CASE_FOUR)) {
            magEditor.getParameter("Distribution Type").setValue(GaussianMagFreqDist.NAME);
            magEditor.getParameter(MagFreqDistParameter.MIN).setValue(0.05);
            magEditor.getParameter(MagFreqDistParameter.MAX).setValue(9.95);
            magEditor.getParameter(MagFreqDistParameter.NUM).setValue(100);
            magEditor.getParameter(MagFreqDistParameter.SET_ALL_PARAMS_BUT).setValue(MagFreqDistParameter.TOT_MO_RATE);
            magEditor.getParameter(MagFreqDistParameter.TOT_CUM_RATE).setValue(0.001);
            magEditor.getParameter(MagFreqDistParameter.STD_DEV).setValue(0.25);
            magEditor.getParameter(MagFreqDistParameter.MEAN).setValue(6.2);
            magEditor.getParameter(MagFreqDistParameter.TRUNCATION_REQ).setValue(MagFreqDistParameter.TRUNCATE_UPPER_ONLY);
            magEditor.getParameter(MagFreqDistParameter.TRUNCATE_NUM_OF_STD_DEV).setValue(1.0);
        }
        if (this.selectedTest.equalsIgnoreCase(TEST_CASE_SIX)) {
            magEditor.getParameter("Distribution Type").setValue(GutenbergRichterMagFreqDist.NAME);
            magEditor.getParameter(MagFreqDistParameter.SET_ALL_PARAMS_BUT).setValue(MagFreqDistParameter.TOT_CUM_RATE);
            magEditor.getParameter(MagFreqDistParameter.MIN).setValue(0.05);
            magEditor.getParameter(MagFreqDistParameter.MAX).setValue(9.95);
            magEditor.getParameter(MagFreqDistParameter.NUM).setValue(100);
            magEditor.getParameter(MagFreqDistParameter.GR_MAG_LOWER).setValue(0.05);
            magEditor.getParameter(MagFreqDistParameter.GR_MAG_UPPER).setValue(6.45);
            magEditor.getParameter(MagFreqDistParameter.GR_BVALUE).setValue(0.9);
            magEditor.getParameter(MagFreqDistParameter.TOT_MO_RATE).setValue(3.8055E16);
        }
        magEditor.setMagDistFromParams();
    }

    private void setMagDistParams_Set1(MagFreqDistParameterEditor magEditor) {
        magEditor.getParameter(MagFreqDistParameter.MIN).setValue(6.0);
        magEditor.getParameter(MagFreqDistParameter.MAX).setValue(6.5);
        magEditor.getParameter(MagFreqDistParameter.NUM).setValue(6);
        if (this.selectedTest.equalsIgnoreCase(TEST_CASE_ONE) || this.selectedTest.equalsIgnoreCase(TEST_CASE_TWELVE)) {
            magEditor.getParameter("Distribution Type").setValue(SingleMagFreqDist.NAME);
            magEditor.getParameter(MagFreqDistParameter.SINGLE_PARAMS_TO_SET).setValue(MagFreqDistParameter.MAG_AND_MO_RATE);
            magEditor.getParameter(MagFreqDistParameter.MAG).setValue(6.5);
            magEditor.getParameter(MagFreqDistParameter.MO_RATE).setValue(1.8E16);
        } else if (this.selectedTest.equalsIgnoreCase(TEST_CASE_TWO)) {
            magEditor.getParameter("Distribution Type").setValue(SingleMagFreqDist.NAME);
            magEditor.getParameter(MagFreqDistParameter.SINGLE_PARAMS_TO_SET).setValue(MagFreqDistParameter.MAG_AND_MO_RATE);
            magEditor.getParameter(MagFreqDistParameter.MAG).setValue(6.0);
            magEditor.getParameter(MagFreqDistParameter.MO_RATE).setValue(1.8E16);
        } else if (this.selectedTest.equalsIgnoreCase(TEST_CASE_THREE)) {
            magEditor.getParameter("Distribution Type").setValue(SingleMagFreqDist.NAME);
            magEditor.getParameter(MagFreqDistParameter.SINGLE_PARAMS_TO_SET).setValue(MagFreqDistParameter.MAG_AND_MO_RATE);
            magEditor.getParameter(MagFreqDistParameter.MAG).setValue(6.0);
            magEditor.getParameter(MagFreqDistParameter.MO_RATE).setValue(1.8E16);
        } else if (this.selectedTest.equalsIgnoreCase(TEST_CASE_FOUR)) {
            magEditor.getParameter("Distribution Type").setValue(SingleMagFreqDist.NAME);
            magEditor.getParameter(MagFreqDistParameter.SINGLE_PARAMS_TO_SET).setValue(MagFreqDistParameter.MAG_AND_MO_RATE);
            magEditor.getParameter(MagFreqDistParameter.MAG).setValue(6.0);
            magEditor.getParameter(MagFreqDistParameter.MO_RATE).setValue(1.905E16);
        } else if (this.selectedTest.equalsIgnoreCase(TEST_CASE_FIVE)) {
            magEditor.getParameter("Distribution Type").setValue(GutenbergRichterMagFreqDist.NAME);
            magEditor.getParameter(MagFreqDistParameter.MIN).setValue(0.005);
            magEditor.getParameter(MagFreqDistParameter.MAX).setValue(9.995);
            magEditor.getParameter(MagFreqDistParameter.NUM).setValue(1000);
            magEditor.getParameter(MagFreqDistParameter.SET_ALL_PARAMS_BUT).setValue(MagFreqDistParameter.TOT_CUM_RATE);
            magEditor.getParameter(MagFreqDistParameter.GR_MAG_LOWER).setValue(0.005);
            magEditor.getParameter(MagFreqDistParameter.GR_MAG_UPPER).setValue(6.495);
            magEditor.getParameter(MagFreqDistParameter.GR_BVALUE).setValue(0.9);
            magEditor.getParameter(MagFreqDistParameter.TOT_MO_RATE).setValue(1.8E16);
            magEditor.getParameter(MagFreqDistParameter.SET_ALL_PARAMS_BUT).setValue(MagFreqDistParameter.TOT_CUM_RATE);
        } else if (this.selectedTest.equalsIgnoreCase(TEST_CASE_SIX)) {
            magEditor.getParameter("Distribution Type").setValue(GaussianMagFreqDist.NAME);
            magEditor.getParameter(MagFreqDistParameter.MIN).setValue(0.005);
            magEditor.getParameter(MagFreqDistParameter.MAX).setValue(9.995);
            magEditor.getParameter(MagFreqDistParameter.NUM).setValue(1000);
            magEditor.getParameter(MagFreqDistParameter.SET_ALL_PARAMS_BUT).setValue(MagFreqDistParameter.TOT_CUM_RATE);
            magEditor.getParameter(MagFreqDistParameter.TOT_MO_RATE).setValue(1.8E16);
            magEditor.getParameter(MagFreqDistParameter.STD_DEV).setValue(0.25);
            magEditor.getParameter(MagFreqDistParameter.MEAN).setValue(6.2);
            magEditor.getParameter(MagFreqDistParameter.TRUNCATION_REQ).setValue(MagFreqDistParameter.TRUNCATE_UPPER_ONLY);
            magEditor.getParameter(MagFreqDistParameter.TRUNCATE_NUM_OF_STD_DEV).setValue(1.19);
        } else if (this.selectedTest.equalsIgnoreCase(TEST_CASE_SEVEN)) {
            magEditor.getParameter("Distribution Type").setValue(YC_1985_CharMagFreqDist.NAME);
            magEditor.getParameter(MagFreqDistParameter.MIN).setValue(0.005);
            magEditor.getParameter(MagFreqDistParameter.MAX).setValue(10.005);
            magEditor.getParameter(MagFreqDistParameter.NUM).setValue(1001);
            magEditor.getParameter(MagFreqDistParameter.GR_BVALUE).setValue(0.9);
            magEditor.getParameter(MagFreqDistParameter.YC_DELTA_MAG_CHAR).setValue(0.49);
            magEditor.getParameter(MagFreqDistParameter.YC_DELTA_MAG_PRIME).setValue(1.0);
            magEditor.getParameter(MagFreqDistParameter.GR_MAG_LOWER).setValue(0.005);
            magEditor.getParameter(MagFreqDistParameter.YC_MAG_PRIME).setValue(5.945);
            magEditor.getParameter(MagFreqDistParameter.GR_MAG_UPPER).setValue(6.445);
            magEditor.getParameter(MagFreqDistParameter.TOT_MO_RATE).setValue(1.8E16);
        } else if (this.selectedTest.equalsIgnoreCase(TEST_CASE_EIGHT_A)) {
            magEditor.getParameter("Distribution Type").setValue(SingleMagFreqDist.NAME);
            magEditor.getParameter(MagFreqDistParameter.SINGLE_PARAMS_TO_SET).setValue(MagFreqDistParameter.MAG_AND_MO_RATE);
            magEditor.getParameter(MagFreqDistParameter.MAG).setValue(6.0);
            magEditor.getParameter(MagFreqDistParameter.MO_RATE).setValue(1.8E16);
        } else if (this.selectedTest.equalsIgnoreCase(TEST_CASE_EIGHT_B)) {
            magEditor.getParameter("Distribution Type").setValue(SingleMagFreqDist.NAME);
            magEditor.getParameter(MagFreqDistParameter.SINGLE_PARAMS_TO_SET).setValue(MagFreqDistParameter.MAG_AND_MO_RATE);
            magEditor.getParameter(MagFreqDistParameter.MAG).setValue(6.0);
            magEditor.getParameter(MagFreqDistParameter.MO_RATE).setValue(1.8E16);
        } else if (this.selectedTest.equalsIgnoreCase(TEST_CASE_EIGHT_C)) {
            magEditor.getParameter("Distribution Type").setValue(SingleMagFreqDist.NAME);
            magEditor.getParameter(MagFreqDistParameter.SINGLE_PARAMS_TO_SET).setValue(MagFreqDistParameter.MAG_AND_MO_RATE);
            magEditor.getParameter(MagFreqDistParameter.MAG).setValue(6.0);
            magEditor.getParameter(MagFreqDistParameter.MO_RATE).setValue(1.8E16);
        } else if (this.selectedTest.equalsIgnoreCase(TEST_CASE_NINE_A)) {
            magEditor.getParameter("Distribution Type").setValue(SingleMagFreqDist.NAME);
            magEditor.getParameter(MagFreqDistParameter.SINGLE_PARAMS_TO_SET).setValue(MagFreqDistParameter.MAG_AND_MO_RATE);
            magEditor.getParameter(MagFreqDistParameter.MAG).setValue(6.0);
            magEditor.getParameter(MagFreqDistParameter.MO_RATE).setValue(1.905E16);
        } else if (this.selectedTest.equalsIgnoreCase(TEST_CASE_NINE_B)) {
            magEditor.getParameter("Distribution Type").setValue(SingleMagFreqDist.NAME);
            magEditor.getParameter(MagFreqDistParameter.SINGLE_PARAMS_TO_SET).setValue(MagFreqDistParameter.MAG_AND_MO_RATE);
            magEditor.getParameter(MagFreqDistParameter.MAG).setValue(6.0);
            magEditor.getParameter(MagFreqDistParameter.MO_RATE).setValue(1.905E16);
        } else if (this.selectedTest.equalsIgnoreCase(TEST_CASE_NINE_C)) {
            magEditor.getParameter("Distribution Type").setValue(SingleMagFreqDist.NAME);
            magEditor.getParameter(MagFreqDistParameter.SINGLE_PARAMS_TO_SET).setValue(MagFreqDistParameter.MAG_AND_MO_RATE);
            magEditor.getParameter(MagFreqDistParameter.MAG).setValue(6.0);
            magEditor.getParameter(MagFreqDistParameter.MO_RATE).setValue(1.905E16);
        } else if (this.selectedTest.equalsIgnoreCase(TEST_CASE_TEN)) {
            magEditor.getParameter("Distribution Type").setValue(GutenbergRichterMagFreqDist.NAME);
            magEditor.getParameter(MagFreqDistParameter.MIN).setValue(0.05);
            magEditor.getParameter(MagFreqDistParameter.MAX).setValue(9.95);
            magEditor.getParameter(MagFreqDistParameter.NUM).setValue(100);
            magEditor.getParameter(MagFreqDistParameter.SET_ALL_PARAMS_BUT).setValue(MagFreqDistParameter.TOT_MO_RATE);
            magEditor.getParameter(MagFreqDistParameter.GR_MAG_LOWER).setValue(5.05);
            magEditor.getParameter(MagFreqDistParameter.GR_MAG_UPPER).setValue(6.45);
            magEditor.getParameter(MagFreqDistParameter.GR_BVALUE).setValue(0.9);
            magEditor.getParameter(MagFreqDistParameter.TOT_CUM_RATE).setValue(0.0395);
        } else if (this.selectedTest.equalsIgnoreCase(TEST_CASE_ELEVEN)) {
            magEditor.getParameter("Distribution Type").setValue(GutenbergRichterMagFreqDist.NAME);
            magEditor.getParameter(MagFreqDistParameter.MIN).setValue(0.05);
            magEditor.getParameter(MagFreqDistParameter.MAX).setValue(9.95);
            magEditor.getParameter(MagFreqDistParameter.NUM).setValue(100);
            magEditor.getParameter(MagFreqDistParameter.SET_ALL_PARAMS_BUT).setValue(MagFreqDistParameter.TOT_MO_RATE);
            magEditor.getParameter(MagFreqDistParameter.GR_MAG_LOWER).setValue(5.05);
            magEditor.getParameter(MagFreqDistParameter.GR_MAG_UPPER).setValue(6.45);
            magEditor.getParameter(MagFreqDistParameter.GR_BVALUE).setValue(0.9);
            magEditor.getParameter(MagFreqDistParameter.TOT_CUM_RATE).setValue(0.0395);
        }
        magEditor.setMagDistFromParams();
    }

    private void initializeFaultData() {
        this.fault1and2_Lats = new ArrayList();
        this.fault1and2_Lats.add(38.2248);
        this.fault1and2_Lats.add(38.0);
        this.fault1and2_Lons = new ArrayList();
        this.fault1and2_Lons.add(-122.0);
        this.fault1and2_Lons.add(-122.0);
        this.fault1_Dips = new ArrayList();
        this.fault1_Dips.add(90.0);
        this.fault1_Depths = new ArrayList();
        this.fault1_Depths.add(0.0);
        this.fault1_Depths.add(12.0);
        this.fault2_Dips = new ArrayList();
        this.fault2_Dips.add(60.0);
        this.fault2_Depths = new ArrayList();
        this.fault2_Depths.add(1.0);
        this.fault2_Depths.add(12.0);
        this.faultE_Lats = new ArrayList();
        this.faultE_Lats.add(38.0);
        this.faultE_Lats.add(38.2248);
        this.faultE_Lons = new ArrayList();
        this.faultE_Lons.add(-122.0);
        this.faultE_Lons.add(-122.0);
        this.faultE_Dips = new ArrayList();
        this.faultE_Dips.add(50.0);
        this.faultE_Dips.add(20.0);
        this.faultE_Depths = new ArrayList();
        this.faultE_Depths.add(0.0);
        this.faultE_Depths.add(6.0);
        this.faultE_Depths.add(12.0);
    }

    private void initializeTestsAndSites() {
        int i;
        ArrayList<String> v = new ArrayList<String>();
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_ONE + "-" + SITE_ONE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_ONE + "-" + SITE_TWO));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_ONE + "-" + SITE_THREE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_ONE + "-" + SITE_FOUR));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_ONE + "-" + SITE_FIVE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_ONE + "-" + SITE_SIX));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_ONE + "-" + SITE_SEVEN));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_TWO + "-" + SITE_ONE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_TWO + "-" + SITE_TWO));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_TWO + "-" + SITE_THREE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_TWO + "-" + SITE_FOUR));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_TWO + "-" + SITE_FIVE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_TWO + "-" + SITE_SIX));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_TWO + "-" + SITE_SEVEN));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_THREE + "-" + SITE_ONE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_THREE + "-" + SITE_TWO));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_THREE + "-" + SITE_THREE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_THREE + "-" + SITE_FOUR));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_THREE + "-" + SITE_FIVE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_THREE + "-" + SITE_SIX));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_THREE + "-" + SITE_SEVEN));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_FOUR + "-" + SITE_ONE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_FOUR + "-" + SITE_TWO));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_FOUR + "-" + SITE_THREE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_FOUR + "-" + SITE_FOUR));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_FOUR + "-" + SITE_FIVE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_FOUR + "-" + SITE_SIX));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_FOUR + "-" + SITE_SEVEN));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_FIVE + "-" + SITE_ONE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_FIVE + "-" + SITE_TWO));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_FIVE + "-" + SITE_THREE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_FIVE + "-" + SITE_FOUR));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_FIVE + "-" + SITE_FIVE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_FIVE + "-" + SITE_SIX));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_FIVE + "-" + SITE_SEVEN));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_SIX + "-" + SITE_ONE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_SIX + "-" + SITE_TWO));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_SIX + "-" + SITE_THREE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_SIX + "-" + SITE_FOUR));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_SIX + "-" + SITE_FIVE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_SIX + "-" + SITE_SIX));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_SIX + "-" + SITE_SEVEN));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_SEVEN + "-" + SITE_ONE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_SEVEN + "-" + SITE_TWO));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_SEVEN + "-" + SITE_THREE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_SEVEN + "-" + SITE_FOUR));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_SEVEN + "-" + SITE_FIVE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_SEVEN + "-" + SITE_SIX));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_SEVEN + "-" + SITE_SEVEN));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_EIGHT_A + "-" + SITE_ONE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_EIGHT_A + "-" + SITE_TWO));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_EIGHT_A + "-" + SITE_THREE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_EIGHT_A + "-" + SITE_FOUR));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_EIGHT_A + "-" + SITE_FIVE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_EIGHT_A + "-" + SITE_SIX));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_EIGHT_A + "-" + SITE_SEVEN));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_EIGHT_B + "-" + SITE_ONE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_EIGHT_B + "-" + SITE_TWO));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_EIGHT_B + "-" + SITE_THREE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_EIGHT_B + "-" + SITE_FOUR));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_EIGHT_B + "-" + SITE_FIVE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_EIGHT_B + "-" + SITE_SIX));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_EIGHT_B + "-" + SITE_SEVEN));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_EIGHT_C + "-" + SITE_ONE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_EIGHT_C + "-" + SITE_TWO));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_EIGHT_C + "-" + SITE_THREE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_EIGHT_C + "-" + SITE_FOUR));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_EIGHT_C + "-" + SITE_FIVE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_EIGHT_C + "-" + SITE_SIX));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_EIGHT_C + "-" + SITE_SEVEN));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_NINE_A + "-" + SITE_ONE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_NINE_A + "-" + SITE_TWO));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_NINE_A + "-" + SITE_THREE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_NINE_A + "-" + SITE_FOUR));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_NINE_A + "-" + SITE_FIVE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_NINE_A + "-" + SITE_SIX));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_NINE_A + "-" + SITE_SEVEN));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_NINE_B + "-" + SITE_ONE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_NINE_B + "-" + SITE_TWO));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_NINE_B + "-" + SITE_THREE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_NINE_B + "-" + SITE_FOUR));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_NINE_B + "-" + SITE_FIVE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_NINE_B + "-" + SITE_SIX));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_NINE_B + "-" + SITE_SEVEN));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_NINE_C + "-" + SITE_ONE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_NINE_C + "-" + SITE_TWO));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_NINE_C + "-" + SITE_THREE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_NINE_C + "-" + SITE_FOUR));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_NINE_C + "-" + SITE_FIVE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_NINE_C + "-" + SITE_SIX));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_NINE_C + "-" + SITE_SEVEN));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_TEN + "-" + SITE_ONE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_TEN + "-" + SITE_TWO));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_TEN + "-" + SITE_THREE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_TEN + "-" + SITE_FOUR));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_ELEVEN + "-" + SITE_ONE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_ELEVEN + "-" + SITE_TWO));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_ELEVEN + "-" + SITE_THREE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_ELEVEN + "-" + SITE_FOUR));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_TWELVE + "-" + SITE_ONE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_TWELVE + "-" + SITE_TWO));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_TWELVE + "-" + SITE_THREE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_TWELVE + "-" + SITE_FOUR));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_TWELVE + "-" + SITE_FIVE));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_TWELVE + "-" + SITE_SIX));
        v.add(new String(PEER_TESTS_SET_ONE + "-" + TEST_CASE_TWELVE + "-" + SITE_SEVEN));
        int size = v.size();
        for (i = 0; i < size; ++i) {
            this.peerTestSetOne.add((String)v.get(i));
        }
        v.clear();
        v.add(new String(PEER_TESTS_SET_TWO + "-" + TEST_CASE_ONE + "-" + SITE_ONE));
        v.add(new String(PEER_TESTS_SET_TWO + "-" + TEST_CASE_ONE + "-" + SITE_TWO));
        v.add(new String(PEER_TESTS_SET_TWO + "-" + TEST_CASE_ONE + "-" + SITE_THREE));
        v.add(new String(PEER_TESTS_SET_TWO + "-" + TEST_CASE_ONE + "-" + SITE_FOUR));
        v.add(new String(PEER_TESTS_SET_TWO + "-" + TEST_CASE_ONE + "-" + SITE_FIVE));
        v.add(new String(PEER_TESTS_SET_TWO + "-" + TEST_CASE_ONE + "-" + SITE_SIX));
        v.add(new String(PEER_TESTS_SET_TWO + "-" + TEST_CASE_TWO + "-" + SITE_ONE));
        v.add(new String(PEER_TESTS_SET_TWO + "-" + TEST_CASE_TWO + "-" + SITE_TWO));
        v.add(new String(PEER_TESTS_SET_TWO + "-" + TEST_CASE_TWO + "-" + SITE_THREE));
        v.add(new String(PEER_TESTS_SET_TWO + "-" + TEST_CASE_THREE + "-" + SITE_ONE));
        v.add(new String(PEER_TESTS_SET_TWO + "-" + TEST_CASE_THREE + "-" + SITE_TWO));
        v.add(new String(PEER_TESTS_SET_TWO + "-" + TEST_CASE_THREE + "-" + SITE_THREE));
        v.add(new String(PEER_TESTS_SET_TWO + "-" + TEST_CASE_FOUR + "-" + SITE_ONE));
        v.add(new String(PEER_TESTS_SET_TWO + "-" + TEST_CASE_FOUR + "-" + SITE_TWO));
        v.add(new String(PEER_TESTS_SET_TWO + "-" + TEST_CASE_FOUR + "-" + SITE_THREE));
        v.add(new String(PEER_TESTS_SET_TWO + "-" + TEST_CASE_FIVE + "-" + SITE_ONE));
        v.add(new String(PEER_TESTS_SET_TWO + "-" + TEST_CASE_FIVE + "-" + SITE_TWO));
        v.add(new String(PEER_TESTS_SET_TWO + "-" + TEST_CASE_FIVE + "-" + SITE_THREE));
        v.add(new String(PEER_TESTS_SET_TWO + "-" + TEST_CASE_SIX + "-" + SITE_ONE));
        v.add(new String(PEER_TESTS_SET_TWO + "-" + TEST_CASE_SIX + "-" + SITE_TWO));
        v.add(new String(PEER_TESTS_SET_TWO + "-" + TEST_CASE_SIX + "-" + SITE_THREE));
        size = v.size();
        for (i = 0; i < size; ++i) {
            this.peerTestSetTwo.add((String)v.get(i));
        }
        size = this.peerTestSetOne.size();
        for (i = 0; i < size; ++i) {
            this.testCaseComboBox.addItem(this.peerTestSetOne.get(i));
        }
        size = this.peerTestSetTwo.size();
        for (i = 0; i < size; ++i) {
            this.testCaseComboBox.addItem(this.peerTestSetTwo.get(i));
        }
    }

    void testCaseComboBox_actionPerformed(ActionEvent e) {
        String testSelected = this.testCaseComboBox.getSelectedItem().toString();
        this.setTestCaseAndSite(testSelected);
    }

    public ArrayList<String> getPEER_SetOneTestCasesNames() {
        return this.peerTestSetOne;
    }

    public ArrayList<String> getPEER_SetTwoTestCasesNames() {
        return this.peerTestSetTwo;
    }

    @Override
    public Window getComponent() {
        return this.frame;
    }
}

