/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.controls;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.StringTokenizer;
import org.opensha.commons.param.editor.ParameterEditor;
import org.opensha.sha.earthquake.rupForecastImpl.Frankel02.Frankel02_AdjustableEqkRupForecast;
import org.opensha.sha.gui.beans.AttenuationRelationshipGuiBean;
import org.opensha.sha.gui.beans.ERF_GuiBean;
import org.opensha.sha.gui.beans.EqkRupSelectorGuiBean;
import org.opensha.sha.gui.beans.EqkRuptureFromERFSelectorPanel;
import org.opensha.sha.gui.beans.MapGuiBean;
import org.opensha.sha.gui.beans.SitesInGriddedRectangularRegionGuiBean;
import org.opensha.sha.gui.controls.GenerateHazusControlPanelForSingleMultipleIMRs;

public class SF_BayAreaScenarioControlPanel {
    protected static final boolean D = false;
    private EqkRupSelectorGuiBean erfGuiBean;
    private AttenuationRelationshipGuiBean imrGuiBean;
    private SitesInGriddedRectangularRegionGuiBean regionGuiBean;
    private MapGuiBean mapGuiBean;
    private GenerateHazusControlPanelForSingleMultipleIMRs hazusControlPanel;
    private static final String fileToRead = "shakemaps_request.txt";

    public SF_BayAreaScenarioControlPanel(EqkRupSelectorGuiBean erfGuiBean, AttenuationRelationshipGuiBean imrGuiBean, SitesInGriddedRectangularRegionGuiBean regionGuiBean, MapGuiBean mapGuiBean, GenerateHazusControlPanelForSingleMultipleIMRs hazusControl) {
        this.erfGuiBean = erfGuiBean;
        this.imrGuiBean = imrGuiBean;
        this.regionGuiBean = regionGuiBean;
        this.mapGuiBean = mapGuiBean;
        this.hazusControlPanel = hazusControl;
    }

    public void setParamsForSF_BayAreaScenario() {
        try {
            boolean isSingleAttenRelSelected = this.imrGuiBean.isSingleAttenRelTypeSelected();
            if (!isSingleAttenRelSelected) {
                this.imrGuiBean.toggleBetweenSingleAndMultipleAttenRelGuiSelection();
            }
            this.imrGuiBean.setIMR_Selected("ShakeMap (2003)");
            this.imrGuiBean.getSingleAttenRelParamListEditor().refreshParamEditor();
            this.regionGuiBean.getParameterList().getParameter("Min  Latitude").setValue(36.55);
            this.regionGuiBean.getParameterList().getParameter("Max  Latitude").setValue(39.6167);
            this.regionGuiBean.getParameterList().getParameter("Min Longitude").setValue(-124.7333);
            this.regionGuiBean.getParameterList().getParameter("Max Longitude").setValue(-120.1333);
            this.regionGuiBean.getParameterList().getParameter("Grid Spacing").setValue(0.016667);
            this.regionGuiBean.getParameterList().getParameter("Set Site Params").setValue("Use site data providers");
            this.regionGuiBean.refreshParamEditor();
            EqkRuptureFromERFSelectorPanel erfPanel = (EqkRuptureFromERFSelectorPanel)this.erfGuiBean.getEqkRuptureSelectorPanel();
            erfPanel.showAllParamsForForecast(false);
            ParameterEditor paramEditor = this.erfGuiBean.getParameterEditor("Eqk Rup Forecast");
            paramEditor.setValue(Frankel02_AdjustableEqkRupForecast.NAME);
            paramEditor.refreshParamEditor();
            ERF_GuiBean erfParamGuiBean = erfPanel.getERF_ParamEditor();
            FileReader fr = new FileReader(fileToRead);
            BufferedReader br = new BufferedReader(fr);
            String fileLines = br.readLine();
            while (fileLines != null) {
                StringTokenizer st = new StringTokenizer(fileLines);
                int sourceIndex = Integer.parseInt(st.nextToken().trim());
                int ruptureIndex = 0;
                String rupIndex = st.nextToken().trim();
                ruptureIndex = Integer.parseInt(rupIndex);
                String ruptureOffset = st.nextToken().trim();
                double rupOffset = 100.0;
                rupOffset = Double.parseDouble(ruptureOffset);
                st.nextToken();
                String directoryName = st.nextToken().trim();
                fileLines = br.readLine();
                erfParamGuiBean.getERFParameterList().getParameter("Rupture Offset").setValue(rupOffset);
                erfParamGuiBean.getSelectedERF().updateForecast();
                erfPanel.setSourceFromSelectedERF(sourceIndex);
                erfPanel.setRuptureForSelectedSource(ruptureIndex);
                erfPanel.getHypocenterLocationsForSelectedRupture();
                this.mapGuiBean.setDirectoryName(directoryName);
                this.hazusControlPanel.runToGenerateShapeFilesAndMaps();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

