/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.controls;

import java.util.ArrayList;
import org.opensha.commons.geo.Location;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.param.editor.ParameterEditor;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.impl.CPTParameter;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.SimpleFaultData;
import org.opensha.sha.gui.beans.AttenuationRelationshipGuiBean;
import org.opensha.sha.gui.beans.EqkRupSelectorGuiBean;
import org.opensha.sha.gui.beans.EqkRuptureCreationPanel;
import org.opensha.sha.gui.beans.MapGuiBean;
import org.opensha.sha.gui.beans.SitesInGriddedRectangularRegionGuiBean;
import org.opensha.sha.gui.controls.ConfirmDialogControlPanel;
import org.opensha.sha.imr.param.OtherParams.Component;
import org.opensha.sha.param.SimpleFaultParameter;
import org.opensha.sha.param.editor.SimpleFaultParameterEditor;
import org.opensha.sha.param.editor.gui.SimpleFaultParameterEditorPanel;

public class SanAndreasScenarioControlPanel
extends ConfirmDialogControlPanel {
    public static final String NAME = "Set Params for SAF Shakeout Quake Scenario";
    public static final String MESSAGE = "Are you sure to set the parameters for a San Andreas scenario?";
    protected static final boolean D = false;
    private EqkRupSelectorGuiBean erfGuiBean;
    private AttenuationRelationshipGuiBean imrGuiBean;
    private SitesInGriddedRectangularRegionGuiBean regionGuiBean;
    private MapGuiBean mapGuiBean;
    private SimpleFaultData sanAndreasFaultData;
    private double aveDipDir;
    private double magnitude = 7.8;

    public SanAndreasScenarioControlPanel(EqkRupSelectorGuiBean erfGuiBean, AttenuationRelationshipGuiBean imrGuiBean, SitesInGriddedRectangularRegionGuiBean regionGuiBean, MapGuiBean mapGuiBean, java.awt.Component parent) {
        super(NAME, MESSAGE, parent);
        this.erfGuiBean = erfGuiBean;
        this.imrGuiBean = imrGuiBean;
        this.regionGuiBean = regionGuiBean;
        this.mapGuiBean = mapGuiBean;
    }

    @Override
    public void doinit() {
        this.mkFaultTrace();
    }

    private void mkFaultTrace() {
        FaultTrace faultTrace1 = new FaultTrace("San Andreas Fault Trace(Mojave S)");
        faultTrace1.add(new Location(34.698495, -118.508948));
        faultTrace1.add(new Location(34.547849, -118.103936));
        faultTrace1.add(new Location(34.402927, -117.753579));
        faultTrace1.add(new Location(34.3163, -117.549));
        SimpleFaultData faultData1 = new SimpleFaultData(90.0, 13.1, 0.0, faultTrace1);
        FaultTrace faultTrace2 = new FaultTrace("San Andreas (San Bernardino N)");
        faultTrace2.add(new Location(34.3163, -117.549));
        faultTrace2.add(new Location(34.2709, -117.451));
        faultTrace2.add(new Location(34.232843, -117.388692));
        faultTrace2.add(new Location(34.173137, -117.274161));
        faultTrace2.add(new Location(34.150027, -117.222023));
        SimpleFaultData faultData2 = new SimpleFaultData(90.0, 12.8, 0.0, faultTrace2);
        FaultTrace faultTrace3 = new FaultTrace("San Andreas (San Bernardino S)");
        faultTrace3.add(new Location(34.150027, -117.222023));
        faultTrace3.add(new Location(34.092795, -117.067674));
        faultTrace3.add(new Location(34.073768, -117.0139));
        faultTrace3.add(new Location(34.033837, -116.90235));
        faultTrace3.add(new Location(34.011347, -116.873541));
        faultTrace3.add(new Location(33.959114, -116.819795));
        SimpleFaultData faultData3 = new SimpleFaultData(90.0, 12.8, 0.0, faultTrace3);
        FaultTrace faultTrace4 = new FaultTrace("San Andreas (San Gorgonio Pass-Garnet HIll)");
        faultTrace4.add(new Location(33.78825, -116.24629));
        faultTrace4.add(new Location(33.848518, -116.383007));
        faultTrace4.add(new Location(33.848123, -116.426527));
        faultTrace4.add(new Location(33.884664, -116.516889));
        faultTrace4.add(new Location(33.907018, -116.584856));
        faultTrace4.add(new Location(33.917569, -116.623871));
        faultTrace4.add(new Location(33.944163, -116.685809));
        faultTrace4.add(new Location(33.937411, -116.778598));
        faultTrace4.add(new Location(33.953154, -116.801391));
        SimpleFaultData faultData4 = new SimpleFaultData(58.0, 12.8, 0.0, faultTrace4);
        FaultTrace faultTrace5 = new FaultTrace("San Andreas (Coachella) rev");
        faultTrace5.add(new Location(33.78825, -116.24629));
        faultTrace5.add(new Location(33.35009, -115.71192));
        SimpleFaultData faultData5 = new SimpleFaultData(90.0, 11.1, 0.0, faultTrace5);
        ArrayList<SimpleFaultData> faultList = new ArrayList<SimpleFaultData>();
        faultList.add(faultData1);
        faultList.add(faultData2);
        faultList.add(faultData3);
        faultList.add(faultData4);
        faultList.add(faultData5);
        this.sanAndreasFaultData = SimpleFaultData.getCombinedSimpleFaultData(faultList);
    }

    @Override
    public void applyControl() {
        ParameterEditor paramEditor = this.erfGuiBean.getParameterEditor("Select method of getting EqkRupture");
        paramEditor.setValue("Custom Eqk Rupture");
        paramEditor.refreshParamEditor();
        EqkRuptureCreationPanel erfPanel = (EqkRuptureCreationPanel)this.erfGuiBean.getEqkRuptureSelectorPanel();
        paramEditor = erfPanel.getParameterEditor("Rupture Type");
        paramEditor.setValue("Finite source rupture");
        paramEditor.refreshParamEditor();
        erfPanel.getParameter("Rake").setValue(180.0);
        SimpleFaultParameterEditorPanel faultPanel = ((SimpleFaultParameterEditor)erfPanel.getParameterEditor("Set Fault Surface")).getParameterEditorPanel();
        ArrayList<Double> lats = new ArrayList<Double>();
        ArrayList<Double> lons = new ArrayList<Double>();
        FaultTrace faultTrace = this.sanAndreasFaultData.getFaultTrace();
        for (int i = 0; i < faultTrace.getNumLocations(); ++i) {
            lats.add(((Location)faultTrace.get(i)).getLatitude());
            lons.add(((Location)faultTrace.get(i)).getLongitude());
        }
        ArrayList<Double> dips = new ArrayList<Double>();
        dips.add(this.sanAndreasFaultData.getAveDip());
        ArrayList<Double> depths = new ArrayList<Double>();
        depths.add(this.sanAndreasFaultData.getUpperSeismogenicDepth());
        depths.add(this.sanAndreasFaultData.getLowerSeismogenicDepth());
        SimpleFaultParameter cfr_ignored_0 = (SimpleFaultParameter)faultPanel.getParameter();
        SimpleFaultParameter cfr_ignored_1 = (SimpleFaultParameter)faultPanel.getParameter();
        faultPanel.setAll(1.0, lats, lons, dips, depths, "Stirling's");
        faultPanel.setEvenlyGriddedSurfaceFromParams();
        erfPanel.getParameter("Magnitude").setValue(this.magnitude);
        erfPanel.getParameterListEditor().refreshParamEditor();
        boolean isSingleAttenRelSelected = this.imrGuiBean.isSingleAttenRelTypeSelected();
        if (!isSingleAttenRelSelected) {
            this.imrGuiBean.toggleBetweenSingleAndMultipleAttenRelGuiSelection();
        }
        ParameterListEditor editor = this.imrGuiBean.getIntensityMeasureParamEditor();
        editor.getParameterList().getParameter("IMT").setValue("PGV");
        editor.refreshParamEditor();
        this.imrGuiBean.setIMR_Selected("Field (2000)");
        this.imrGuiBean.getSelectedIMR_Instance().getParameter("Component").setValue(Component.AVE_HORZ);
        this.imrGuiBean.getSingleAttenRelParamListEditor().refreshParamEditor();
        this.regionGuiBean.getParameterList().getParameter("Min  Latitude").setValue(32.3);
        this.regionGuiBean.getParameterList().getParameter("Max  Latitude").setValue(35.5);
        this.regionGuiBean.getParameterList().getParameter("Min Longitude").setValue(-119.5);
        this.regionGuiBean.getParameterList().getParameter("Max Longitude").setValue(-115.0);
        this.regionGuiBean.getParameterList().getParameter("Grid Spacing").setValue(0.02);
        this.regionGuiBean.getParameterList().getParameter("Set Site Params").setValue("Use site data providers");
        this.regionGuiBean.refreshParamEditor();
        CPTParameter cptParam = (CPTParameter)this.mapGuiBean.getParameterList().getParameter("Color Scheme");
        cptParam.setByName(GMT_CPT_Files.SHAKEMAP.getFileName());
        this.mapGuiBean.getParameterList().getParameter("Color Scale Limits").setValue("Manually");
        this.mapGuiBean.getParameterList().getParameter("Color-Scale Min").setValue(-0.39);
        this.mapGuiBean.getParameterList().getParameter("Color-Scale Max").setValue(2.2);
        this.mapGuiBean.getParameterList().getParameter("Highways in plot").setValue("ca_hiwys.all.xy");
        this.mapGuiBean.getParameterList().getParameter("Use GMT WebService").setValue(true);
        this.mapGuiBean.getParameterList().getParameter("Plot Log").setValue(true);
        this.mapGuiBean.refreshParamEditor();
    }
}

