/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensha.commons.data.siteData.OrderedSiteDataProviderList;
import org.opensha.commons.data.siteData.SiteDataValue;
import org.opensha.commons.data.siteData.gui.beans.OrderedSiteDataGUIBean;
import org.opensha.commons.geo.Location;
import org.opensha.commons.gui.ControlPanel;
import org.opensha.sha.gui.beans.IMR_MultiGuiBean;
import org.opensha.sha.gui.beans.Site_GuiBean;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.event.ScalarIMRChangeEvent;
import org.opensha.sha.imr.event.ScalarIMRChangeListener;
import org.opensha.sha.util.SiteTranslator;

public class SiteDataControlPanel
extends ControlPanel
implements ScalarIMRChangeListener,
ActionListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "Set Site Params from Web Services";
    private IMR_MultiGuiBean imrGuiBean;
    private Site_GuiBean siteGuiBean;
    private OrderedSiteDataGUIBean dataGuiBean;
    private JPanel mainPanel = new JPanel(new BorderLayout());
    private JButton setButton = new JButton("Set IMR Params");
    private JButton viewButton = new JButton("View Data");
    private static final String SET_ALL_IMRS = "All IMRs";
    private static final String SET_SELECTED_IMR = "Selected IMR(s) only";
    private static final String SET_DEFAULT = "Selected IMR(s) only";
    private JComboBox allSingleComboBox;
    private Collection<? extends ScalarIMR> selectedIMRs;
    private Collection<? extends ScalarIMR> allIMRs;
    private SiteTranslator trans = null;
    private JFrame frame;

    public SiteDataControlPanel(Component parent, IMR_MultiGuiBean imrGuiBean, Site_GuiBean siteGuiBean) {
        super(NAME);
        this.imrGuiBean = imrGuiBean;
        this.siteGuiBean = siteGuiBean;
    }

    @Override
    public void doinit() {
        this.frame = new JFrame();
        this.imrGuiBean.addIMRChangeListener(this);
        this.allIMRs = this.imrGuiBean.getIMRs();
        this.selectedIMRs = this.imrGuiBean.getIMRMap().values();
        this.dataGuiBean = new OrderedSiteDataGUIBean(OrderedSiteDataProviderList.createCachedSiteDataProviderDefaults(), this.imrGuiBean.getIMRMap().values());
        this.viewButton.addActionListener(this);
        this.setButton.addActionListener(this);
        String[] comboItems = new String[]{"Selected IMR(s) only", SET_ALL_IMRS};
        this.allSingleComboBox = new JComboBox<String>(comboItems);
        this.allSingleComboBox.setMaximumSize(new Dimension(200, 30));
        this.allSingleComboBox.setSelectedItem("Selected IMR(s) only");
        this.allSingleComboBox.addActionListener(this);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
        bottomPanel.add(this.allSingleComboBox);
        bottomPanel.add(this.setButton);
        bottomPanel.add(this.viewButton);
        this.mainPanel.add((Component)this.dataGuiBean, "Center");
        this.mainPanel.add((Component)bottomPanel, "South");
        this.updateIMRs();
        this.dataGuiBean.getProviderList().addChangeListener(this);
        this.frame.setContentPane(this.mainPanel);
        this.frame.setSize(OrderedSiteDataGUIBean.width, 600);
        this.frame.setDefaultCloseOperation(2);
    }

    private void updateIMRs() {
        if (this.isSetAllSelected()) {
            this.dataGuiBean.setIMR(this.allIMRs);
        } else {
            this.dataGuiBean.setIMR(this.selectedIMRs);
        }
        this.enableButtons();
    }

    public boolean isSetAllSelected() {
        return SET_ALL_IMRS.equals(this.allSingleComboBox.getSelectedItem());
    }

    @Override
    public void imrChange(ScalarIMRChangeEvent event) {
        this.selectedIMRs = event.getNewIMRs().values();
        this.updateIMRs();
    }

    public void setSiteParams() {
        ArrayList<SiteDataValue<?>> data = this.loadData();
        if (data == null || data.size() == 0) {
            return;
        }
        for (SiteDataValue<?> val : data) {
            System.out.println(val);
        }
        if (this.trans == null) {
            this.trans = new SiteTranslator();
        }
        if (this.isSetAllSelected()) {
            this.trans.setAllSiteParams(this.allIMRs, data);
        } else {
            this.trans.setAllSiteParams(this.selectedIMRs, data);
        }
        this.siteGuiBean.getParameterListEditor().refreshParamEditor();
        this.frame.dispose();
    }

    public void displayData(ArrayList<SiteDataValue<?>> datas) {
        OrderedSiteDataGUIBean.showDataDisplayDialog(datas, this.frame, this.siteGuiBean.getSite().getLocation());
    }

    private ArrayList<SiteDataValue<?>> loadData() {
        return this.loadData(false);
    }

    private ArrayList<SiteDataValue<?>> loadData(boolean all) {
        OrderedSiteDataProviderList list = this.dataGuiBean.getProviderList();
        Location loc = this.siteGuiBean.getSite().getLocation();
        if (all) {
            return list.getAllAvailableData(loc);
        }
        return list.getBestAvailableData(loc);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.setButton) {
            this.setSiteParams();
        } else if (e.getSource() == this.viewButton) {
            ArrayList<SiteDataValue<?>> data = this.loadData(true);
            this.displayData(data);
        } else if (e.getSource() == this.allSingleComboBox) {
            this.updateIMRs();
        }
    }

    private void enableButtons() {
        boolean enable = this.dataGuiBean.getProviderList().isAtLeastOneEnabled();
        this.setButton.setEnabled(enable);
        this.viewButton.setEnabled(enable);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.dataGuiBean.getProviderList()) {
            this.enableButtons();
        }
    }

    @Override
    public Window getComponent() {
        return this.frame;
    }
}

