/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.infoTools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;

public class CalcProgressBar
extends JDialog {
    private static final long serialVersionUID = -8635759695925774449L;
    private static final int DIALOG_WIDTH = 320;
    private static final int B = 20;
    private static Font font;
    private static Font boldFont;
    private JProgressBar progress;
    private JLabel info;
    private JLabel alert;

    public CalcProgressBar(String title, String message) {
        this(null, title, message);
    }

    public CalcProgressBar(Component owner, String title, String info) {
        this(owner, title, info, true);
    }

    public CalcProgressBar(Component owner, String title, String info, boolean visible) {
        super(JOptionPane.getFrameForComponent(owner), title);
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(BorderFactory.createEmptyBorder(16, 20, 4, 20));
        content.add((Component)this.buildContent(info), "Center");
        this.getContentPane().add(content);
        this.pack();
        this.setLocationRelativeTo(JOptionPane.getFrameForComponent(owner));
        this.setVisible(visible);
    }

    private JPanel buildContent(String s) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        s = StringUtils.isEmpty((CharSequence)s) ? " " : s;
        this.info = new JLabel(s);
        this.info.setFont(boldFont);
        this.info.setOpaque(false);
        this.info.setAlignmentX(0.0f);
        panel.add(this.info);
        panel.add(Box.createVerticalStrut(10));
        this.progress = new JProgressBar(0, 100);
        this.progress.setValue(0);
        this.progress.putClientProperty("JComponent.sizeVariant", "mini");
        this.progress.setAlignmentX(0.0f);
        panel.add(this.progress);
        panel.add(Box.createVerticalStrut(2));
        this.alert = new JLabel(" ");
        this.alert.setFont(font);
        panel.add(this.alert);
        JComponent c = (JComponent)Box.createHorizontalStrut(320);
        c.setAlignmentX(0.0f);
        panel.add(c);
        panel.add(Box.createVerticalGlue());
        return panel;
    }

    public void setProgressMessage(String s) {
        this.info.setText(StringUtils.isEmpty((CharSequence)s) ? " " : s);
        this.info.paintImmediately(this.info.getBounds());
    }

    public void setIndeterminate(boolean indep) {
        this.progress.setIndeterminate(indep);
    }

    @Deprecated
    public void displayProgressBar() {
    }

    public void updateProgress(int count, int total) {
        if (total != 0) {
            int value = count * 100 / total;
            StringBuilder sb = new StringBuilder();
            sb.append(count).append(" of ").append(total).append(" Complete");
            this.info.setText(sb.toString());
            this.progress.setValue(value);
        }
    }

    public void updateProgress(long count, long total) {
        this.updateProgress(count, total, null);
    }

    public void updateProgress(long count, long total, String message) {
        if (total != 0L) {
            int value = (int)(count * 100L / total);
            if (message == null) {
                message = count + " of " + total + " Complete";
            }
            if (this.progress.isIndeterminate()) {
                this.progress.setIndeterminate(false);
            }
            this.progress.setValue(value);
        }
        if (message != null) {
            this.setProgressMessage(message);
        }
    }

    public void showProgress(boolean show) {
        this.setVisible(show);
        if (!show) {
            this.dispose();
        }
    }

    public void alert(String s) {
        this.alert.setText(StringUtils.isEmpty((CharSequence)s) ? " " : s);
        this.alert.paintImmediately(this.alert.getBounds());
    }

    public static void main(String[] args) {
        CalcProgressBar dialog = new CalcProgressBar(null, "Calculation Monitor", "Please wait while ruptures are being updated\u2026");
        dialog.showProgress(true);
    }

    static {
        Font baseFont = UIManager.getFont("Label.font");
        font = baseFont.deriveFont(baseFont.getSize2D() - 2.0f);
        boldFont = font.deriveFont(1);
    }
}

