/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.infoTools;

import com.google.common.base.Preconditions;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.PRAcroForm;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.SimpleBookmark;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jfree.chart3d.Chart3DPanel;
import org.jpedal.PdfDecoder;
import org.opensha.commons.util.BrowserUtils;
import org.opensha.commons.util.CustomFileFilter;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.calc.disaggregation.DisaggregationCalculatorAPI;
import org.opensha.sha.calc.disaggregation.chart3d.PureJavaDisaggPlotter;

public class DisaggregationPlotViewerWindow
extends JFrame
implements HyperlinkListener {
    private static final int W = 830;
    private static final int H = 1000;
    private static final String MAP_WINDOW = "Maps using GMT";
    private JSplitPane mapSplitPane = new JSplitPane();
    private JScrollPane mapScrollPane = new JScrollPane();
    private JMenuBar menuBar = new JMenuBar();
    private JMenu fileMenu = new JMenu();
    private JMenuItem fileSaveMenu = new JMenuItem();
    private JToolBar jToolBar = new JToolBar();
    private JButton saveButton = new JButton();
    private ImageIcon saveFileImage = new ImageIcon(FileUtils.loadImage("icons/saveFile.jpg"));
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel mapPanel = new JPanel();
    private GridBagLayout layout = new GridBagLayout();
    private String imagePDF_URL;
    private Chart3DPanel imagePanel;
    private JTabbedPane infoTabPane = new JTabbedPane();
    private JScrollPane meanModeScrollPane = new JScrollPane();
    private JScrollPane metadataScrollPane = new JScrollPane();
    private JScrollPane sourceListDataScrollPane;
    private JScrollPane consolidatedSourceListDataScrollPane;
    private JScrollPane binnedDataScrollPane;
    private JTextPane meanModePane = new JTextPane();
    private JTextPane metadataPane = new JTextPane();
    private JTextPane sourceListDataPane;
    private JTextPane consolidatedSourceListDataPane;
    private JTextPane binnedDataPane;
    private String meanModeText;
    private String metadataText;
    private String binDataText;
    private String sourceDataText;
    private String consolidatedSourceDataText;
    private JFileChooser fileChooser;

    public DisaggregationPlotViewerWindow(String imagePDF_URL, DisaggregationCalculatorAPI calc, String meanModeText, String metadataText, boolean showBinData) throws RuntimeException {
        this(null, imagePDF_URL, calc, meanModeText, metadataText, showBinData);
    }

    public DisaggregationPlotViewerWindow(Chart3DPanel imagePanel, DisaggregationCalculatorAPI calc, String meanModeText, String metadataText, boolean showBinData) {
        this(imagePanel, null, calc, meanModeText, metadataText, showBinData);
    }

    private DisaggregationPlotViewerWindow(Chart3DPanel imagePanel, String imagePDF_URL, DisaggregationCalculatorAPI calc, String meanModeText, String metadataText, boolean showBinData) {
        this(imagePanel, imagePDF_URL, meanModeText, metadataText, showBinData ? calc.getBinData() : null, calc.getNumSourcesToShow() > 0 ? calc.getDisaggregationSourceInfo() : null, calc.getNumSourcesToShow() > 0 ? calc.getConsolidatedDisaggregationSourceInfo() : null);
    }

    public DisaggregationPlotViewerWindow(Chart3DPanel imagePanel, String imagePDF_URL, String meanModeText, String metadataText, String binDataText, String sourceDataText, String consolidatedSourceDataText) {
        Preconditions.checkState((imagePanel != null || imagePDF_URL != null ? 1 : 0) != 0, (Object)"Both imagePanel and imagePDF_URL are null");
        Preconditions.checkState((imagePanel == null || imagePDF_URL == null ? 1 : 0) != 0, (Object)"Both imagePanel and imagePDF_URL are non-null");
        this.imagePanel = imagePanel;
        this.imagePDF_URL = imagePDF_URL;
        this.meanModeText = meanModeText;
        this.metadataText = metadataText;
        this.binDataText = binDataText;
        this.sourceDataText = sourceDataText;
        this.consolidatedSourceDataText = consolidatedSourceDataText;
        try {
            this.jbInit();
            if (binDataText != null && !binDataText.isBlank()) {
                this.binnedDataScrollPane = new JScrollPane();
                this.binnedDataPane = new JTextPane();
                this.infoTabPane.addTab("Bin Data", this.binnedDataScrollPane);
                this.binnedDataScrollPane.getViewport().add((Component)this.binnedDataPane, null);
                this.binnedDataPane.setText(binDataText);
                this.binnedDataPane.setEditable(false);
            }
            if (sourceDataText != null && !sourceDataText.isBlank()) {
                this.sourceListDataScrollPane = new JScrollPane();
                this.sourceListDataPane = new JTextPane();
                this.infoTabPane.addTab("Source List Data", this.sourceListDataScrollPane);
                this.sourceListDataScrollPane.getViewport().add((Component)this.sourceListDataPane, null);
                this.sourceListDataPane.setText(sourceDataText);
                this.sourceListDataPane.setEditable(false);
            }
            if (consolidatedSourceDataText != null && !consolidatedSourceDataText.isBlank()) {
                this.consolidatedSourceListDataScrollPane = new JScrollPane();
                this.consolidatedSourceListDataPane = new JTextPane();
                this.infoTabPane.addTab("Consolidated Source List Data", this.consolidatedSourceListDataScrollPane);
                this.consolidatedSourceListDataScrollPane.getViewport().add((Component)this.consolidatedSourceListDataPane, null);
                this.consolidatedSourceListDataPane.setText(consolidatedSourceDataText);
                this.consolidatedSourceListDataPane.setEditable(false);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        if (imagePDF_URL != null) {
            int currentPage = 1;
            PdfDecoder pdfDecoder = new PdfDecoder();
            try {
                pdfDecoder.openPdfFileFromURL(imagePDF_URL);
                pdfDecoder.decodePage(currentPage);
                pdfDecoder.setPageParameters(1.0f, 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.mapScrollPane.setViewportView((Component)pdfDecoder);
        } else {
            this.mapScrollPane.setViewportView((Component)imagePanel);
        }
        this.setVisible(true);
    }

    protected void jbInit() throws RuntimeException {
        this.setDefaultCloseOperation(2);
        this.setSize(830, 1000);
        this.setTitle(MAP_WINDOW);
        this.getContentPane().setLayout(this.borderLayout1);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DisaggregationPlotViewerWindow.this.saveButton_actionPerformed(actionEvent);
            }
        });
        this.fileSaveMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisaggregationPlotViewerWindow.this.fileSaveMenu_actionPerformed(e);
            }
        });
        this.fileSaveMenu.setText("Save");
        this.fileMenu.setText("File");
        this.menuBar.add(this.fileMenu);
        this.fileMenu.add(this.fileSaveMenu);
        this.setJMenuBar(this.menuBar);
        Dimension d = this.saveButton.getSize();
        this.jToolBar.add(this.saveButton);
        this.saveButton.setIcon(this.saveFileImage);
        this.saveButton.setToolTipText("Save Graph as image");
        this.saveButton.setSize(d);
        this.jToolBar.add(this.saveButton);
        this.jToolBar.setFloatable(false);
        this.getContentPane().add((Component)this.jToolBar, "North");
        this.mapSplitPane.setOrientation(0);
        this.infoTabPane.addTab("Mean/Mode", this.meanModeScrollPane);
        this.infoTabPane.addTab("Metadata", this.metadataScrollPane);
        this.meanModeScrollPane.getViewport().add((Component)this.meanModePane, null);
        this.metadataScrollPane.getViewport().add((Component)this.metadataPane, null);
        this.metadataPane.setContentType("text/html");
        this.metadataPane.setText(this.metadataText);
        this.metadataPane.setEditable(false);
        this.metadataPane.addHyperlinkListener(this);
        this.meanModePane.setText(this.meanModeText);
        this.meanModePane.setEditable(false);
        this.getContentPane().add((Component)this.mapSplitPane, "Center");
        this.mapSplitPane.add((Component)this.mapScrollPane, "top");
        this.mapSplitPane.add((Component)this.infoTabPane, "bottom");
        this.infoTabPane.setTabPlacement(3);
        this.mapPanel.setLayout(this.layout);
        this.mapScrollPane.getViewport().add((Component)this.mapPanel, null);
        this.mapSplitPane.setDividerLocation(714);
    }

    protected void save() throws IOException {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            CustomFileFilter pdfChooser = new CustomFileFilter(".pdf", "PDF File");
            CustomFileFilter txtChooser = new CustomFileFilter(".txt", "TXT File");
            this.fileChooser.addChoosableFileFilter(pdfChooser);
            this.fileChooser.addChoosableFileFilter(txtChooser);
            this.fileChooser.setAcceptAllFileFilterUsed(false);
            this.fileChooser.setFileFilter(pdfChooser);
        }
        int option = this.fileChooser.showSaveDialog(this);
        Object fileName = null;
        if (option == 0) {
            fileName = this.fileChooser.getSelectedFile().getAbsolutePath();
            CustomFileFilter filter = (CustomFileFilter)this.fileChooser.getFileFilter();
            String ext = filter.getExtension();
            if (!((String)fileName).toLowerCase().endsWith(ext)) {
                fileName = (String)fileName + ext;
            }
            if (ext.equals(".pdf")) {
                this.saveAsPDF((String)fileName);
            } else if (ext.equals(".txt")) {
                this.saveAsTXT((String)fileName);
            } else {
                throw new RuntimeException("Unkown save type: " + ext);
            }
        }
    }

    private String getDissaggText() {
        return DisaggregationPlotViewerWindow.getDisaggText(this.meanModeText, this.metadataText, this.binDataText, this.sourceDataText, this.consolidatedSourceDataText);
    }

    public static String getDisaggText(String meanModeText, String metadataText, String binDataText, String sourceDataText, String consolidatedSourceDataText) {
        StringBuilder str = new StringBuilder("Mean/Mode Metadata :\n");
        str.append(meanModeText);
        str.append("\n\nDisaggregation Plot Parameters Info :\n");
        str.append(metadataText);
        if (binDataText != null && !binDataText.isBlank()) {
            str.append("\n\nDisaggregation Bin Data :\n");
            str.append(binDataText);
        }
        if (sourceDataText != null && !sourceDataText.isBlank()) {
            str.append("\n\nDisaggregation Source List Info:\n");
            str.append(sourceDataText);
        }
        if (consolidatedSourceDataText != null && !consolidatedSourceDataText.isBlank()) {
            str.append("\n\nDisaggregation Source List Info:\n");
            str.append(sourceDataText);
        }
        return str.toString();
    }

    protected void saveAsTXT(String outputFileName) {
        DisaggregationPlotViewerWindow.saveAsTXT(outputFileName, this.meanModeText, this.metadataText, this.binDataText, this.sourceDataText, this.consolidatedSourceDataText);
    }

    public static void saveAsTXT(String outputFileName, String meanModeText, String metadataText, String binDataText, String sourceDataText, String consolidatedSourceDataText) {
        FileUtils.save(outputFileName, DisaggregationPlotViewerWindow.getDisaggText(meanModeText, metadataText, binDataText, sourceDataText, consolidatedSourceDataText));
    }

    public static void saveAsPDF(Chart3DPanel disaggPanel, String outputFileName, String meanModeText, String metadataText, String binDataText, String sourceDataText, String consolidatedSourceDataText) throws IOException {
        DisaggregationPlotViewerWindow.saveAsPDF(disaggPanel, null, outputFileName, meanModeText, metadataText, binDataText, sourceDataText, consolidatedSourceDataText);
    }

    public static void saveAsPDF(String disaggPDF_URL, String outputFileName, String meanModeText, String metadataText, String binDataText, String sourceDataText, String consolidatedSourceDataText) throws IOException {
        DisaggregationPlotViewerWindow.saveAsPDF(null, disaggPDF_URL, outputFileName, meanModeText, metadataText, binDataText, sourceDataText, consolidatedSourceDataText);
    }

    private static void saveAsPDF(Chart3DPanel disaggPanel, String disaggPDF_URL, String outputFileName, String meanModeText, String metadataText, String binDataText, String sourceDataText, String consolidatedSourceDataText) throws IOException {
        String disaggregationInfoString = DisaggregationPlotViewerWindow.getDisaggText(meanModeText, metadataText, binDataText, sourceDataText, consolidatedSourceDataText);
        if (disaggPanel != null) {
            PureJavaDisaggPlotter.writeChartPDF(new File(outputFileName), disaggPanel, disaggregationInfoString);
        } else {
            Document document = new Document();
            Document document_temp = new Document();
            String[] pdfFiles = new String[]{disaggPDF_URL, outputFileName + ".tmp"};
            try {
                PdfWriter.getInstance((Document)document_temp, (OutputStream)new FileOutputStream(pdfFiles[1]));
                document_temp.open();
                document_temp.add((Element)new Paragraph(disaggregationInfoString));
                document_temp.close();
                int pageOffset = 0;
                ArrayList master = new ArrayList();
                PdfCopy writer = null;
                for (int f = 0; f < pdfFiles.length; ++f) {
                    PdfReader reader = null;
                    reader = f == 0 ? new PdfReader(new URL(pdfFiles[f])) : new PdfReader(pdfFiles[f]);
                    reader.consolidateNamedDestinations();
                    int n = reader.getNumberOfPages();
                    List bookmarks = SimpleBookmark.getBookmark((PdfReader)reader);
                    if (bookmarks != null) {
                        if (pageOffset != 0) {
                            SimpleBookmark.shiftPageNumbers((List)bookmarks, (int)pageOffset, null);
                        }
                        master.addAll(bookmarks);
                    }
                    pageOffset += n;
                    if (f == 0) {
                        document = new Document(reader.getPageSizeWithRotation(1));
                        writer = new PdfCopy(document, (OutputStream)new FileOutputStream(outputFileName));
                        document.open();
                    }
                    int i = 0;
                    while (i < n) {
                        PdfImportedPage page = writer.getImportedPage(reader, ++i);
                        writer.addPage(page);
                    }
                    PRAcroForm form = reader.getAcroForm();
                    if (form == null) continue;
                    System.err.println("TODO: replace old copyAcroForm method");
                }
                if (master.size() > 0) {
                    writer.setOutlines(master);
                }
                document.close();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            File f = new File(pdfFiles[1]);
            f.delete();
        }
    }

    protected void saveAsPDF(String fileName) throws IOException {
        DisaggregationPlotViewerWindow.saveAsPDF(this.imagePanel, this.imagePDF_URL, fileName, this.meanModeText, this.metadataText, this.binDataText, this.sourceDataText, this.consolidatedSourceDataText);
    }

    private void saveButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.save();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Save File Error", 0);
            return;
        }
    }

    private void fileSaveMenu_actionPerformed(ActionEvent actionEvent) {
        try {
            this.save();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Save File Error", 0);
            return;
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        HyperlinkEvent.EventType type = e.getEventType();
        if (type == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                BrowserUtils.launch(e.getURL().toURI());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

