/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.infoTools;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class IndeterminateProgressBar
extends JProgressBar {
    private static final long serialVersionUID = -8490124049802986652L;
    private Timer timer;
    private int offset = 0;
    private int direction = 1;
    private final int step = 10;

    public IndeterminateProgressBar(String loadingMessage) {
        this.setString(loadingMessage);
        this.setPreferredSize(new Dimension(300, 24));
    }

    public IndeterminateProgressBar() {
        this.setString("Loading...");
    }

    @Override
    public void setIndeterminate(boolean newValue) {
        super.setIndeterminate(newValue);
        if (newValue) {
            if (this.timer == null) {
                this.timer = new Timer(100, e -> {
                    this.offset += this.direction * 10;
                    if (this.offset + this.getBarWidth() >= this.getWidth()) {
                        this.offset = this.getWidth() - this.getBarWidth();
                        this.direction = -1;
                    } else if (this.offset <= 0) {
                        this.offset = 0;
                        this.direction = 1;
                    }
                    this.repaint();
                });
            }
            this.timer.start();
        } else if (this.timer != null) {
            this.timer.stop();
            this.offset = 0;
            this.repaint();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isIndeterminate()) {
            Graphics2D g2 = (Graphics2D)g.create();
            int barHeight = this.getHeight() / 2;
            g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
            g2.setColor(Color.BLUE);
            g2.fillRoundRect(this.offset, 0, this.getBarWidth(), barHeight, 10, 10);
            if (this.isStringPainted() && this.getString() != null) {
                g2.setColor(this.getForeground());
                g2.setComposite(AlphaComposite.SrcOver);
                FontMetrics fm = g2.getFontMetrics();
                String text = this.getString();
                int textWidth = fm.stringWidth(text);
                int textHeight = fm.getAscent();
                int x = (this.getWidth() - textWidth) / 2;
                int y = (this.getHeight() + textHeight) / 2 - fm.getDescent();
                g2.drawString(text, x, y);
            }
            g2.dispose();
        } else {
            super.paintComponent(g);
        }
    }

    private int getBarWidth() {
        return this.getWidth() / 5;
    }

    public void toggle() {
        this.setStringPainted(!this.isIndeterminate());
        this.setIndeterminate(!this.isIndeterminate());
    }

    public static void main(String[] args) {
        IndeterminateProgressBar indBar = new IndeterminateProgressBar();
        indBar.setPreferredSize(new Dimension(200, 24));
        indBar.toggle();
        JPanel mainPanel = new JPanel();
        mainPanel.add(indBar);
        JFrame demoApp = new JFrame("Progress Demo");
        demoApp.setDefaultCloseOperation(3);
        demoApp.add(mainPanel);
        demoApp.pack();
        demoApp.setLocationRelativeTo(null);
        demoApp.setVisible(true);
    }
}

