/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.servlets;

import com.google.common.base.Preconditions;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensha.commons.mapping.servlet.GMT_MapGeneratorServlet;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.RunScript;
import org.opensha.sha.calc.disaggregation.DisaggregationCalculator;
import org.opensha.sha.calc.disaggregation.DisaggregationPlotData;

public class DisaggregationPlotServlet
extends HttpServlet {
    private static final String GMT_URL_PATH = GMT_MapGeneratorServlet.GMT_URL_PATH;
    private static final File GMT_DATA_DIR = GMT_MapGeneratorServlet.GMT_DATA_DIR;
    private static final String GMT_SCRIPT_FILE = "gmtScript.txt";
    private static final String METADATA_FILE_NAME = "metadata.txt";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.out.println("DisaggregationPlotServlet: Handling GET");
        ObjectOutputStream outputToApplet = new ObjectOutputStream((OutputStream)response.getOutputStream());
        try {
            if (!GMT_DATA_DIR.exists()) {
                GMT_DATA_DIR.mkdir();
            }
            Preconditions.checkState((boolean)GMT_DATA_DIR.exists());
            ObjectInputStream inputFromApplet = new ObjectInputStream((InputStream)request.getInputStream());
            File newDir = GMT_MapGeneratorServlet.createUniqueDir(GMT_DATA_DIR);
            Preconditions.checkState((newDir.exists() || newDir.mkdir() ? 1 : 0) != 0);
            File gmtScriptFile = new File(newDir, GMT_SCRIPT_FILE);
            System.out.println("DisaggregationPlotServlet: fetching disagg data");
            DisaggregationPlotData data = (DisaggregationPlotData)inputFromApplet.readObject();
            System.out.println("DisaggregationPlotServlet: creating disagg GMT script");
            ArrayList<String> gmtMapScript = DisaggregationCalculator.createGMTScriptForDisaggregationPlot(data, newDir.getAbsolutePath());
            System.out.println("DisaggregationPlotServlet: fetching disagg metadata");
            String metadata = (String)inputFromApplet.readObject();
            System.out.println("DisaggregationPlotServlet: writing disagg script");
            FileWriter fw = new FileWriter(gmtScriptFile);
            BufferedWriter bw = new BufferedWriter(fw);
            int size = gmtMapScript.size();
            for (int i = 0; i < size; ++i) {
                bw.write(gmtMapScript.get(i) + "\n");
            }
            bw.close();
            File metadataFile = new File(newDir, METADATA_FILE_NAME);
            System.out.println("DisaggregationPlotServlet: writing disagg metadata");
            fw = new FileWriter(metadataFile);
            bw = new BufferedWriter(fw);
            bw.write(" " + metadata + "\n");
            bw.close();
            System.out.println("DisaggregationPlotServlet: running disagg script");
            String[] command = new String[]{"sh", "-c", "sh " + String.valueOf(gmtScriptFile)};
            RunScript.runScript(command);
            System.out.println("DisaggregationPlotServlet: done running disagg script");
            System.out.println("DisaggregationPlotServlet: zipping output files");
            FileUtils.createZipFile(newDir.getAbsolutePath());
            String mapImagePath = GMT_URL_PATH + newDir.getName() + File.separator;
            System.out.println("DisaggregationPlotServlet: sending image path to application");
            outputToApplet.writeObject(mapImagePath);
            outputToApplet.close();
        }
        catch (Exception e) {
            outputToApplet.writeObject(new RuntimeException(e.getMessage()));
            outputToApplet.close();
        }
        System.out.println("DisaggregationPlotServlet: DONE with disagg plot");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

