/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.servlets;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.xyz.ArbDiscrGeoDataSet;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.commons.geo.Location;
import org.opensha.commons.mapping.gmt.GMT_MapGenerator;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.calc.hazardMap.MakeXYZFromHazardMapDir;

public class HazardMapXMLViewerServlet
extends HttpServlet {
    public static final String GET_DATA = "Get Data";
    public static final String MAKE_MAP = "Make Map";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block10: {
            System.out.println("HazardMapXMLViewerServlet: Handling GET");
            try {
                ObjectInputStream inputFromApplet = new ObjectInputStream((InputStream)request.getInputStream());
                String functionDesired = (String)inputFromApplet.readObject();
                if (functionDesired.equalsIgnoreCase(GET_DATA)) {
                    this.loadDataSets(new ObjectOutputStream((OutputStream)response.getOutputStream()));
                    break block10;
                }
                if (!functionDesired.equalsIgnoreCase(MAKE_MAP)) break block10;
                String selectedSet = (String)inputFromApplet.readObject();
                GMT_MapGenerator map = (GMT_MapGenerator)inputFromApplet.readObject();
                boolean isProbAt_IML = (Boolean)inputFromApplet.readObject();
                double value = (Double)inputFromApplet.readObject();
                String metadata = "TEMP META!";
                String localDir = "/opt/install/apache-tomcat-5.5.20/webapps/OpenSHA/HazardMapXMLDatasets/" + selectedSet;
                String outFile = localDir + "/xyzCurves_inv";
                outFile = isProbAt_IML ? outFile + "_PROB" : outFile + "_IML";
                outFile = outFile + "_" + value + ".txt";
                try {
                    if (!new File(outFile).exists()) {
                        MakeXYZFromHazardMapDir maker = new MakeXYZFromHazardMapDir(localDir + "/curves", false, true);
                        maker.writeXYZFile(isProbAt_IML, value, outFile);
                    }
                    ArbDiscrGeoDataSet xyzData = null;
                    if (outFile != null) {
                        try {
                            xyzData = new ArbDiscrGeoDataSet(true);
                            ArrayList<String> fileLines = FileUtils.loadFile(outFile);
                            ListIterator<String> it = fileLines.listIterator();
                            while (it.hasNext()) {
                                StringTokenizer st = new StringTokenizer(it.next());
                                double lat = Double.valueOf(st.nextToken().trim());
                                double lon = Double.valueOf(st.nextToken().trim());
                                double val = Double.valueOf(st.nextToken().trim());
                                xyzData.set(new Location(lat, lon), val);
                            }
                        }
                        catch (Exception ee) {
                            ee.printStackTrace();
                        }
                    }
                    String mapLabel = this.getMapLabel(isProbAt_IML);
                    String jpgFileName = map.makeMapUsingServlet(xyzData, mapLabel, metadata, null);
                    ObjectOutputStream outputToApplet = new ObjectOutputStream((OutputStream)response.getOutputStream());
                    outputToApplet.writeObject(jpgFileName);
                    outputToApplet.close();
                    return;
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    ObjectOutputStream outputToApplet = new ObjectOutputStream((OutputStream)response.getOutputStream());
                    outputToApplet.writeObject(false);
                    outputToApplet.close();
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ObjectOutputStream outputToApplet = new ObjectOutputStream((OutputStream)response.getOutputStream());
                outputToApplet.writeObject(false);
                outputToApplet.close();
                return;
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private String getMapLabel(boolean isProbAtIML) {
        String label = isProbAtIML ? "Prob" : "IML";
        return label;
    }

    private void loadDataSets(ObjectOutputStream outputToApplet) {
        try {
            File dirs = new File("/opt/install/apache-tomcat-5.5.20/webapps/OpenSHA/HazardMapXMLDatasets");
            File[] dirList = dirs.listFiles();
            ArrayList<Document> docs = new ArrayList<Document>();
            block4: for (int i = 0; i < dirList.length; ++i) {
                File[] subDirList;
                File dir = dirList[i];
                if (!dir.isDirectory()) continue;
                for (File file : subDirList = dir.listFiles()) {
                    if (!file.getName().toLowerCase().endsWith(".xml")) continue;
                    try {
                        SAXReader reader = new SAXReader();
                        Document document = reader.read(file);
                        docs.add(document);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue block4;
                }
            }
            outputToApplet.writeObject(docs);
            outputToApplet.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private GeoDataSet getXYZ_DataSet(String dirName, boolean isProbAt_IML, double val) {
        File masterDir = new File("/opt/install/apache-tomcat-5.5.20/webapps/OpenSHA/HazardMapXMLDatasets/" + dirName);
        File[] dirList = masterDir.listFiles();
        ArbDiscrGeoDataSet xyzData = new ArbDiscrGeoDataSet(true);
        for (File dir : dirList) {
            File[] subDirList;
            if (!dir.isDirectory() || dir.getName().endsWith(".")) continue;
            for (File file : subDirList = dir.listFiles()) {
                int lastIndex;
                String fileName;
                if (!file.isFile() || !(fileName = file.getName()).endsWith(".txt")) continue;
                int index = fileName.indexOf("_");
                int firstIndex = fileName.indexOf(".");
                if (firstIndex == (lastIndex = fileName.lastIndexOf("."))) continue;
                Double latVal = Double.valueOf(fileName.substring(0, index).trim());
                Double lonVal = Double.valueOf(fileName.substring(index + 1, lastIndex).trim());
                double writeVal = this.handleFile(latVal, lonVal, file.getAbsolutePath(), isProbAt_IML, val);
                xyzData.set(new Location(latVal, lonVal), writeVal);
            }
        }
        return xyzData;
    }

    public double handleFile(double lat, double lon, String fileName, boolean isProbAt_IML, double val) {
        try {
            ArrayList<String> fileLines = FileUtils.loadFile(fileName);
            ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
            for (int i = 0; i < fileLines.size(); ++i) {
                String dataLine = fileLines.get(i);
                StringTokenizer st = new StringTokenizer(dataLine);
                double currentIML = Double.parseDouble(st.nextToken());
                double currentProb = Double.parseDouble(st.nextToken());
                func.set(currentIML, currentProb);
            }
            double interpolatedVal = 0.0;
            if (isProbAt_IML) {
                return func.getInterpolatedY_inLogXLogYDomain(val);
            }
            try {
                double out = func.getFirstInterpolatedX_inLogXLogYDomain(val);
                return out;
            }
            catch (RuntimeException e) {
                System.err.println("WARNING: Probability value doesn't exist, setting IMT to NaN");
                return Double.NaN;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Double.NaN;
    }
}

