/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.dom4j.Element;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.IMRException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.metadata.MetadataLoader;
import org.opensha.commons.param.AbstractParameter;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.IntensityMeasureRelationship;

public abstract class AbstractIMR
implements IntensityMeasureRelationship {
    private static final String NAME = "Intensity Measure Relationship";
    protected String url_info_string;
    public static final String XML_METADATA_NAME = "IMR";
    public static final String XML_METADATA_IMT_NAME = "IntensityMeasure";
    public static final String XML_METADATA_SITE_PARAMETERS_NAME = "SiteParameters";
    protected static final String C = "IntensityMeasureRelationship";
    protected static final boolean D = false;
    protected DoubleParameter exceedProbParam = null;
    public static final String EXCEED_PROB_NAME = "Exceed. Prob.";
    protected static final Double EXCEED_PROB_DEFAULT = 0.5;
    public static final String EXCEED_PROB_INFO = "Exceedance Probability";
    public static final Double EXCEED_PROB_MIN = 1.0E-6;
    public static final Double EXCEED_PROB_MAX = 0.999999;
    protected ParameterList siteParams = new ParameterList();
    protected ParameterList eqkRuptureParams = new ParameterList();
    protected ParameterList propagationEffectParams = new ParameterList();
    protected ParameterList supportedIMParams = new ParameterList();
    protected ParameterList otherParams = new ParameterList();
    protected Site site;
    protected EqkRupture eqkRupture;
    protected Parameter im;
    protected boolean intensityMeasureChanged;
    protected transient ParameterChangeWarningListener listener = null;

    public AbstractIMR() {
        this.exceedProbParam = new DoubleParameter(EXCEED_PROB_NAME, EXCEED_PROB_MIN, EXCEED_PROB_MAX, EXCEED_PROB_DEFAULT);
        this.exceedProbParam.setInfo(EXCEED_PROB_INFO);
        this.exceedProbParam.setNonEditable();
    }

    public void setWarningListener(ParameterChangeWarningListener listener) {
        this.listener = listener;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int compareTo(IntensityMeasureRelationship imr) {
        return this.getName().compareToIgnoreCase(imr.getName());
    }

    @Override
    public void setSite(Site site) {
        this.site = site;
    }

    @Override
    public Site getSite() {
        return this.site;
    }

    @Override
    public EqkRupture getEqkRupture() {
        return this.eqkRupture;
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) {
        this.eqkRupture = eqkRupture;
    }

    @Override
    public Object getIntensityMeasureLevel() {
        return this.im.getValue();
    }

    @Override
    public void setIntensityMeasureLevel(Object iml) throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("IntensityMeasureRelationship: setIntensityMeasureLevel(): The Intensity Measure has not been set yet, unable to set the level.");
        }
        this.im.setValue(iml);
    }

    @Override
    public Parameter getIntensityMeasure() {
        return this.im;
    }

    @Override
    public void setIntensityMeasure(Parameter intensityMeasure) throws ParameterException, ConstraintException {
        if (this.isIntensityMeasureSupported(intensityMeasure)) {
            this.setIntensityMeasure(intensityMeasure.getName());
            for (Parameter<?> param : intensityMeasure.getIndependentParameterList()) {
                this.getParameter(param.getName()).setValue(param.getValue());
            }
        } else {
            throw new ParameterException("This im is not supported, name = " + intensityMeasure.getName());
        }
    }

    @Override
    public void setIntensityMeasure(String intensityMeasureName) throws ParameterException {
        this.im = this.supportedIMParams.getParameter(intensityMeasureName);
        this.intensityMeasureChanged = true;
    }

    @Override
    public void setExceedProb(double prob) throws ParameterException {
        this.exceedProbParam.setValue(prob);
    }

    @Override
    public boolean isIntensityMeasureSupported(Parameter intensityMeasure) {
        if (this.supportedIMParams.containsParameter(intensityMeasure)) {
            int numIndParams = this.supportedIMParams.getParameter(intensityMeasure.getName()).getNumIndependentParameters();
            for (Parameter<?> param : intensityMeasure.getIndependentParameterList()) {
                if (this.getParameter(param.getName()).isAllowed(param.getValue())) continue;
                return false;
            }
            return intensityMeasure.getNumIndependentParameters() == numIndParams;
        }
        return false;
    }

    @Override
    public boolean isIntensityMeasureSupported(String intensityMeasure) {
        return this.supportedIMParams.containsParameter(intensityMeasure);
    }

    @Override
    public void setAll(EqkRupture eqkRupture, Site site, Parameter intensityMeasure) throws ParameterException, IMRException, ConstraintException {
        this.setSite(site);
        this.setEqkRupture(eqkRupture);
        this.setIntensityMeasure(intensityMeasure);
    }

    @Override
    public Parameter getParameter(String name) throws ParameterException {
        if (name.equals(EXCEED_PROB_NAME)) {
            return this.exceedProbParam;
        }
        try {
            return this.siteParams.getParameter(name);
        }
        catch (ParameterException parameterException) {
            try {
                return this.eqkRuptureParams.getParameter(name);
            }
            catch (ParameterException parameterException2) {
                try {
                    return this.propagationEffectParams.getParameter(name);
                }
                catch (ParameterException parameterException3) {
                    try {
                        return this.supportedIMParams.getParameter(name);
                    }
                    catch (ParameterException parameterException4) {
                        ListIterator<Parameter<?>> it = this.supportedIMParams.getParametersIterator();
                        while (it.hasNext()) {
                            Parameter<?> param = it.next();
                            if (!param.containsIndependentParameter(name)) continue;
                            return param.getIndependentParameter(name);
                        }
                        try {
                            return this.otherParams.getParameter(name);
                        }
                        catch (ParameterException parameterException5) {
                            throw new ParameterException("IntensityMeasureRelationship: getParameter(): Parameter doesn't exist named " + name);
                        }
                    }
                }
            }
        }
    }

    @Override
    public ListIterator<Parameter<?>> getSiteParamsIterator() {
        return this.siteParams.getParametersIterator();
    }

    @Override
    public ParameterList getSiteParams() {
        return this.siteParams;
    }

    @Override
    public ListIterator<Parameter<?>> getOtherParamsIterator() {
        return this.otherParams.getParametersIterator();
    }

    @Override
    public ParameterList getOtherParams() {
        return this.otherParams;
    }

    @Override
    public ListIterator<Parameter<?>> getEqkRuptureParamsIterator() {
        return this.eqkRuptureParams.getParametersIterator();
    }

    @Override
    public ParameterList getEqkRuptureParams() {
        return this.eqkRuptureParams;
    }

    @Override
    public ListIterator<Parameter<?>> getPropagationEffectParamsIterator() {
        return this.propagationEffectParams.getParametersIterator();
    }

    @Override
    public ParameterList getPropagationEffectParams() {
        return this.propagationEffectParams;
    }

    @Override
    public ListIterator<Parameter<?>> getSupportedIntensityMeasuresIterator() {
        return this.supportedIMParams.getParametersIterator();
    }

    @Override
    public ParameterList getSupportedIntensityMeasures() {
        return this.supportedIMParams;
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element xml = root.addElement(XML_METADATA_NAME);
        xml.addAttribute("className", this.getClass().getName());
        ListIterator<Parameter<?>> paramIt = this.getOtherParamsIterator();
        Element paramsElement = xml.addElement("Parameters");
        while (paramIt.hasNext()) {
            AbstractParameter param = (AbstractParameter)paramIt.next();
            paramsElement = param.toXMLMetadata(paramsElement);
        }
        paramIt = this.getSiteParamsIterator();
        Element siteParamsElement = xml.addElement(XML_METADATA_SITE_PARAMETERS_NAME);
        while (paramIt.hasNext()) {
            AbstractParameter param = (AbstractParameter)paramIt.next();
            siteParamsElement = param.toXMLMetadata(siteParamsElement);
        }
        Parameter imt = this.getIntensityMeasure();
        if (imt != null) {
            imt.toXMLMetadata(xml, XML_METADATA_IMT_NAME);
        }
        return root;
    }

    public static AbstractIMR fromXMLMetadata(Element root, ParameterChangeWarningListener listener) throws InvocationTargetException {
        Element imtElem;
        String className = root.attribute("className").getValue();
        ArrayList<Object> args = new ArrayList<Object>();
        ArrayList<String> argNames = new ArrayList<String>();
        args.add(listener);
        argNames.add(ParameterChangeWarningListener.class.getName());
        AbstractIMR imr = (AbstractIMR)MetadataLoader.createClassInstance(className, args, argNames);
        imr.setParamDefaults();
        Element paramsElement = root.element("Parameters");
        ListIterator<Parameter<?>> paramIt = imr.getOtherParamsIterator();
        while (paramIt.hasNext()) {
            AbstractParameter param = (AbstractParameter)paramIt.next();
            if (param.getName().equals("Tectonic Region")) continue;
            Iterator it = paramsElement.elementIterator();
            while (it.hasNext()) {
                Element el = (Element)it.next();
                if (!param.getName().equals(el.attribute("name").getValue()) || param.setValueFromXMLMetadata(el)) continue;
                System.err.println("Parameter " + param.getName() + " could not be set from XML!");
            }
        }
        Element siteParamsElement = root.element(XML_METADATA_SITE_PARAMETERS_NAME);
        if (siteParamsElement != null) {
            paramIt = imr.getSiteParamsIterator();
            while (paramIt.hasNext()) {
                AbstractParameter param = (AbstractParameter)paramIt.next();
                Iterator it = siteParamsElement.elementIterator();
                while (it.hasNext()) {
                    Element el = (Element)it.next();
                    if (!param.getName().equals(el.attribute("name").getValue()) || param.setValueFromXMLMetadata(el)) continue;
                    System.err.println("Parameter " + param.getName() + " could not be set from XML!");
                    System.err.println("It is possible that the parameter type doesn't yet support loading from XML");
                }
            }
        }
        if ((imtElem = root.element(XML_METADATA_IMT_NAME)) != null) {
            String imtName = imtElem.attributeValue("name");
            imr.setIntensityMeasure(imtName);
            Parameter imt = imr.getIntensityMeasure();
            imt.setValueFromXMLMetadata(imtElem);
        }
        return imr;
    }

    @Override
    public URL getInfoURL() throws MalformedURLException {
        return new URL(null);
    }
}

