/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr;

import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import org.opensha.commons.calc.GaussianDistCalc;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.exceptions.IMRException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.impl.WarningDoubleParameter;
import org.opensha.sha.gcim.imr.param.EqkRuptureParams.FocalDepthParam;
import org.opensha.sha.gcim.imr.param.IntensityMeasureParams.CAV_Param;
import org.opensha.sha.gcim.imr.param.IntensityMeasureParams.Ds575_Param;
import org.opensha.sha.gcim.imr.param.IntensityMeasureParams.Ds595_Param;
import org.opensha.sha.imr.AbstractIMR;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.param.EqkRuptureParams.AftershockParam;
import org.opensha.sha.imr.param.EqkRuptureParams.DipParam;
import org.opensha.sha.imr.param.EqkRuptureParams.FaultTypeParam;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.EqkRuptureParams.RakeParam;
import org.opensha.sha.imr.param.EqkRuptureParams.RupTopDepthParam;
import org.opensha.sha.imr.param.EqkRuptureParams.RupWidthParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGD_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGV_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.OtherParams.SigmaTruncLevelParam;
import org.opensha.sha.imr.param.OtherParams.SigmaTruncTypeParam;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;
import org.opensha.sha.imr.param.OtherParams.TectonicRegionTypeParam;
import org.opensha.sha.imr.param.PropagationEffectParams.DistRupMinusDistX_OverRupParam;
import org.opensha.sha.imr.param.PropagationEffectParams.DistRupMinusJB_OverRupParameter;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceJBParameter;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceRupParameter;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceSeisParameter;
import org.opensha.sha.imr.param.PropagationEffectParams.HangingWallFlagParam;
import org.opensha.sha.imr.param.SiteParams.DepthTo1pt0kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.DepthTo2pt5kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;
import org.opensha.sha.imr.param.SiteParams.Vs30_TypeParam;
import org.opensha.sha.util.TectonicRegionType;

public abstract class AttenuationRelationship
extends AbstractIMR
implements ScalarIMR {
    public static final String C = "AttenuationRelationship";
    protected static final boolean D = false;
    protected PGA_Param pgaParam = null;
    protected PGV_Param pgvParam = null;
    protected PGD_Param pgdParam = null;
    protected SA_Param saParam = null;
    protected PeriodParam saPeriodParam = null;
    protected DampingParam saDampingParam = null;
    protected CAV_Param cavParam = null;
    protected Ds575_Param ds575Param = null;
    protected Ds595_Param ds595Param = null;
    protected StdDevTypeParam stdDevTypeParam = null;
    protected SigmaTruncTypeParam sigmaTruncTypeParam = null;
    protected SigmaTruncLevelParam sigmaTruncLevelParam = null;
    protected ComponentParam componentParam = null;
    protected TectonicRegionTypeParam tectonicRegionTypeParam = null;
    protected MagParam magParam = null;
    protected FaultTypeParam fltTypeParam = null;
    protected AftershockParam aftershockParam = null;
    protected RakeParam rakeParam = null;
    protected DipParam dipParam = null;
    protected RupTopDepthParam rupTopDepthParam = null;
    protected RupWidthParam rupWidthParam;
    protected FocalDepthParam focalDepthParam;
    protected DistanceRupParameter distanceRupParam = null;
    protected DistanceJBParameter distanceJBParam = null;
    protected DistanceSeisParameter distanceSeisParam = null;
    protected DistRupMinusJB_OverRupParameter distRupMinusJB_OverRupParam = null;
    protected DistRupMinusDistX_OverRupParam distRupMinusDistX_OverRupParam = null;
    protected HangingWallFlagParam hangingWallFlagParam = null;
    protected Vs30_Param vs30Param = null;
    protected Vs30_TypeParam vs30_TypeParam;
    protected DepthTo2pt5kmPerSecParam depthTo2pt5kmPerSecParam = null;
    protected DepthTo1pt0kmPerSecParam depthTo1pt0kmPerSecParam;
    protected double USER_MAX_DISTANCE = Double.MAX_VALUE;
    protected static final double VERY_SMALL_MEAN = -35.0;
    protected static final String ERR = "Not all parameters have been set";
    protected ParameterList meanIndependentParams = new ParameterList();
    protected ParameterList stdDevIndependentParams = new ParameterList();
    protected ParameterList exceedProbIndependentParams = new ParameterList();
    protected ParameterList imlAtExceedProbIndependentParams = new ParameterList();

    @Override
    public void setUserMaxDistance(double maxDist) {
        this.USER_MAX_DISTANCE = maxDist;
    }

    @Override
    public void setIntensityMeasureLevel(Object iml) throws ParameterException {
        if (!(iml instanceof Double)) {
            throw new ParameterException("AttenuationRelationship: setIntensityMeasureLevel(): Object not a DoubleParameter, unable to set.");
        }
        this.setIntensityMeasureLevel((Double)iml);
    }

    @Override
    public void setIntensityMeasureLevel(Double iml) throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("AttenuationRelationship: setIntensityMeasureLevel(): Intensity Measure is null, unable to set.");
        }
        if (this.im instanceof WarningDoubleParameter) {
            ((WarningDoubleParameter)this.im).setValueIgnoreWarning(iml);
        } else {
            this.im.setValue(iml);
        }
    }

    @Override
    public void setSiteLocation(Location loc) {
        if (this.site == null) {
            this.site = new Site();
        }
        this.site.setLocation(loc);
        this.setPropagationEffectParams();
    }

    protected abstract void setPropagationEffectParams();

    @Override
    public double getExceedProbability() throws ParameterException, IMRException {
        double iml = (Double)this.im.getValue();
        double stdDev = this.getStdDev();
        double mean = this.getMean();
        return this.getExceedProbability(mean, stdDev, iml);
    }

    @Override
    public double getExceedProbability(double iml) throws ParameterException, IMRException {
        this.setIntensityMeasureLevel(iml);
        return this.getExceedProbability();
    }

    @Override
    public DiscretizedFunc getSA_ExceedProbSpectrum(double iml) throws ParameterException, IMRException {
        this.setIntensityMeasure("SA");
        this.setIntensityMeasureLevel(iml);
        ArbitrarilyDiscretizedFunc exeedProbFunction = new ArbitrarilyDiscretizedFunc();
        List<Double> allowedSA_Periods = this.saPeriodParam.getAllowedDoubles();
        int size = allowedSA_Periods.size();
        for (int i = 0; i < size; ++i) {
            Double saPeriod = allowedSA_Periods.get(i);
            this.getParameter("SA Period").setValue(saPeriod);
            exeedProbFunction.set(saPeriod, this.getExceedProbability());
        }
        return exeedProbFunction;
    }

    @Override
    public DiscretizedFunc getSA_IML_AtExceedProbSpectrum(double exceedProb) throws ParameterException, IMRException {
        this.setIntensityMeasure("SA");
        this.exceedProbParam.setValue(exceedProb);
        ArbitrarilyDiscretizedFunc imlFunction = new ArbitrarilyDiscretizedFunc();
        List<Double> allowedSA_Periods = this.saPeriodParam.getAllowedDoubles();
        int size = allowedSA_Periods.size();
        for (int i = 0; i < size; ++i) {
            Double saPeriod = allowedSA_Periods.get(i);
            this.getParameter("SA Period").setValue(saPeriod);
            imlFunction.set(saPeriod, this.getIML_AtExceedProb());
        }
        return imlFunction;
    }

    @Override
    public double getEpsilon() {
        double iml = (Double)this.im.getValue();
        return (iml - this.getMean()) / this.getStdDev();
    }

    @Override
    public double getEpsilon(double iml) {
        this.setIntensityMeasureLevel(iml);
        return this.getEpsilon();
    }

    protected double getExceedProbability(double mean, double stdDev, double iml) throws ParameterException, IMRException {
        return AttenuationRelationship.getExceedProbability(mean, stdDev, iml, this.sigmaTruncTypeParam, this.sigmaTruncLevelParam);
    }

    public static double getExceedProbability(double mean, double stdDev, double iml, SigmaTruncTypeParam sigmaTruncTypeParam, SigmaTruncLevelParam sigmaTruncLevelParam) {
        if (stdDev != 0.0) {
            double stRndVar = (iml - mean) / stdDev;
            if (sigmaTruncTypeParam == null || ((String)sigmaTruncTypeParam.getValue()).equals("None")) {
                return GaussianDistCalc.getExceedProb(stRndVar);
            }
            double numSig = (Double)sigmaTruncLevelParam.getValue();
            if (((String)sigmaTruncTypeParam.getValue()).equals("1 Sided")) {
                return GaussianDistCalc.getExceedProb(stRndVar, 1, numSig);
            }
            return GaussianDistCalc.getExceedProb(stRndVar, 2, numSig);
        }
        if (iml > mean) {
            return 0.0;
        }
        return 1.0;
    }

    @Override
    public double getRandomIML(Random randomSampler) {
        double stdDev = this.getStdDev();
        double mean = this.getMean();
        if (randomSampler == null) {
            randomSampler = new Random();
        }
        if (this.sigmaTruncTypeParam == null || ((String)this.sigmaTruncTypeParam.getValue()).equals("None")) {
            return mean + stdDev * randomSampler.nextGaussian();
        }
        double numSig = (Double)this.sigmaTruncLevelParam.getValue();
        boolean done = false;
        double randIML = Double.NaN;
        if (((String)this.sigmaTruncTypeParam.getValue()).equals("1 Sided")) {
            while (!done) {
                randIML = mean + stdDev * randomSampler.nextGaussian();
                if (!(randIML < mean + numSig * stdDev)) continue;
                done = true;
            }
            return randIML;
        }
        while (!done) {
            randIML = mean + stdDev * randomSampler.nextGaussian();
            if (!(randIML < mean + numSig * stdDev) || !(randIML > mean - numSig * stdDev)) continue;
            done = true;
        }
        return randIML;
    }

    @Override
    public DiscretizedFunc getExceedProbabilities(DiscretizedFunc intensityMeasureLevels) throws ParameterException {
        double stdDev = this.getStdDev();
        double mean = this.getMean();
        for (int i = 0; i < intensityMeasureLevels.size(); ++i) {
            double x = intensityMeasureLevels.getX(i);
            double y = this.getExceedProbability(mean, stdDev, x);
            intensityMeasureLevels.set(i, y);
        }
        return intensityMeasureLevels;
    }

    @Override
    public double getIML_AtExceedProb() throws ParameterException {
        if (this.exceedProbParam.getValue() == null) {
            throw new ParameterException("AttenuationRelationship: getExceedProbability(): exceedProbParam or its value is null, unable to run this calculation.");
        }
        double exceedProb = (Double)this.exceedProbParam.getValue();
        return this.getIML_AtExceedProb(this.getMean(), this.getStdDev(), exceedProb, this.sigmaTruncTypeParam, this.sigmaTruncLevelParam);
    }

    protected double getIML_AtExceedProb(double mean, double stdDev, double exceedProb, SigmaTruncTypeParam sigmaTruncTypeParam, SigmaTruncLevelParam sigmaTruncLevelParam) {
        double stRndVar;
        String sigTrType = (String)sigmaTruncTypeParam.getValue();
        if (!sigTrType.equals("1 Sided") && exceedProb == 0.5) {
            return this.getMean();
        }
        if (sigTrType.equals("None")) {
            stRndVar = GaussianDistCalc.getStandRandVar(exceedProb, 0, 0.0, 1.0E-6);
        } else {
            double numSig = (Double)sigmaTruncLevelParam.getValue();
            stRndVar = sigTrType.equals("1 Sided") ? GaussianDistCalc.getStandRandVar(exceedProb, 1, numSig, 1.0E-6) : GaussianDistCalc.getStandRandVar(exceedProb, 2, numSig, 1.0E-6);
        }
        return mean + stRndVar * stdDev;
    }

    @Override
    public double getIML_AtExceedProb(double exceedProb) throws ParameterException {
        this.exceedProbParam.setValue(exceedProb);
        return this.getIML_AtExceedProb();
    }

    @Override
    public ListIterator<Parameter<?>> getMeanIndependentParamsIterator() {
        return this.getMeanIndependentParams().getParametersIterator();
    }

    @Override
    public ParameterList getMeanIndependentParams() {
        return this.meanIndependentParams;
    }

    @Override
    public ListIterator<Parameter<?>> getStdDevIndependentParamsIterator() {
        return this.getStdDevIndependentParams().getParametersIterator();
    }

    @Override
    public ParameterList getStdDevIndependentParams() {
        return this.stdDevIndependentParams;
    }

    @Override
    public ListIterator<Parameter<?>> getExceedProbIndependentParamsIterator() {
        return this.getExceedProbIndependentParams().getParametersIterator();
    }

    @Override
    public ParameterList getExceedProbIndependentParams() {
        return this.exceedProbIndependentParams;
    }

    @Override
    public ListIterator<Parameter<?>> getIML_AtExceedProbIndependentParamsIterator() {
        return this.getIML_AtExceedProbIndependentParams().getParametersIterator();
    }

    @Override
    public ParameterList getIML_AtExceedProbIndependentParams() {
        return this.imlAtExceedProbIndependentParams;
    }

    @Override
    public String getAllParamMetadata() {
        Object metadata = this.imlAtExceedProbIndependentParams.getParameterListMetadataString();
        metadata = (String)metadata + "; " + this.im.getMetadataString() + " [ ";
        for (Parameter<?> param : this.im.getIndependentParameterList()) {
            metadata = (String)metadata + param.getMetadataString() + "; ";
        }
        metadata = ((String)metadata).substring(0, ((String)metadata).length() - 2);
        metadata = (String)metadata + " ]";
        return metadata;
    }

    protected abstract void initSupportedIntensityMeasureParams();

    protected abstract void initSiteParams();

    protected abstract void initEqkRuptureParams();

    protected abstract void initPropagationEffectParams();

    protected void initOtherParams() {
        this.sigmaTruncTypeParam = new SigmaTruncTypeParam();
        this.sigmaTruncLevelParam = new SigmaTruncLevelParam();
        this.tectonicRegionTypeParam = new TectonicRegionTypeParam();
        this.tectonicRegionTypeParam.setValueAsDefault();
        this.otherParams.clear();
        this.otherParams.addParameter(this.sigmaTruncTypeParam);
        this.otherParams.addParameter(this.sigmaTruncLevelParam);
        this.otherParams.addParameter(this.tectonicRegionTypeParam);
    }

    protected void initParameterEventListeners() {
    }

    @Override
    public void resetParameterEventListeners() {
    }

    @Override
    public boolean isTectonicRegionSupported(String tectRegionName) {
        if (this.tectonicRegionTypeParam == null) {
            return false;
        }
        return this.tectonicRegionTypeParam.isAllowed(tectRegionName);
    }

    @Override
    public boolean isTectonicRegionSupported(TectonicRegionType tectRegion) {
        return this.isTectonicRegionSupported(tectRegion.toString());
    }
}

