/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import org.opensha.commons.data.Named;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.IMRException;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.param.EqkRuptureParams.FaultTypeParam;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.OtherParams.Component;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceJBParameter;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceSeisParameter;

public class CB_2003_AttenRel
extends AttenuationRelationship {
    private static final String C = "CB_2003_AttenRel";
    private static final boolean D = false;
    public static final String NAME = "Campbell and Bozorgnia (2003)";
    public static final String SHORT_NAME = "CB2003";
    private static final long serialVersionUID = 1234567890987654357L;
    public static final String FLT_TYPE_THRUST = "Thrust (dip<45)";
    public static final String FLT_TYPE_REVERSE = "Reverse (dip>45)";
    public static final String FLT_TYPE_REVERSE_THRUST = "Reverse or Thrust";
    public static final String FLT_TYPE_OTHER = "Strike Slip or Normal";
    public static final String FLT_TYPE_UNKNOWN = "Unknown";
    private StringParameter siteTypeParam = null;
    public static final String SITE_TYPE_NAME = "Campbell-2003 Site Type";
    public static final String SITE_TYPE_INFO = "Geological conditions as the site";
    public static final String SITE_TYPE_FIRM_SOIL = "Firm-Soil";
    public static final String SITE_TYPE_VERY_FIRM_SOIL = "Very-Firm-Soil";
    public static final String SITE_TYPE_SOFT_ROCK = "Soft-Rock";
    public static final String SITE_TYPE_FIRM_ROCK = "Firm-Rock";
    public static final String SITE_TYPE_SOIL = "Generic-Soil";
    public static final String SITE_TYPE_ROCK = "Generic-Rock";
    public static final String SITE_TYPE_NEHRP_BC = "BC-Boundary";
    public static final String SITE_TYPE_DEFAULT = "Firm-Soil";
    protected static final Double MAG_WARN_MIN = 5.0;
    protected static final Double MAG_WARN_MAX = 8.0;
    protected static final Double DISTANCE_SEIS_WARN_MIN = 3.0;
    protected static final Double DISTANCE_SEIS_WARN_MAX = 60.0;
    protected DoubleParameter hangingWallParam = null;
    public static final String HANGING_WALL_NAME = "Hanging Wall Param.";
    public static final String HANGING_WALL_INFO = "1.0 if site is within surface projection of rupture, tapering (linearly) to 0.0 at 5 km beyond";
    protected static final Double HANGING_WALL_MIN = 0.0;
    protected static final Double HANGING_WALL_MAX = 1.0;
    protected static final Double HANGING_WALL_DEFAULT = 0.0;
    private CB_2003_AttenRelCoefficients coeff = null;
    protected Hashtable horzCoefficients = new Hashtable();
    protected Hashtable vertCoefficients = new Hashtable();

    protected void setFaultTypeFromRake(double rake, double dip) throws InvalidRangeException {
        FaultUtils.assertValidRake(rake);
        FaultUtils.assertValidDip(dip);
        if (rake >= 22.5 && rake <= 157.5) {
            if (dip >= 45.0) {
                this.fltTypeParam.setValue(FLT_TYPE_REVERSE);
            } else {
                this.fltTypeParam.setValue(FLT_TYPE_THRUST);
            }
        } else {
            this.fltTypeParam.setValue(FLT_TYPE_OTHER);
        }
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.magParam.setValueIgnoreWarning(eqkRupture.getMag());
        this.setFaultTypeFromRake(eqkRupture.getAveRake(), eqkRupture.getRuptureSurface().getAveDip());
        this.eqkRupture = eqkRupture;
        this.setPropagationEffectParams();
    }

    @Override
    public void setSite(Site site) throws ParameterException {
        this.siteTypeParam.setValue((String)site.getParameter(SITE_TYPE_NAME).getValue());
        this.site = site;
        this.setPropagationEffectParams();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceSeisParam.setValue(this.eqkRupture, this.site);
            double dip = this.eqkRupture.getRuptureSurface().getAveDip();
            String fltType = (String)this.fltTypeParam.getValue();
            if (dip <= 70.0 && fltType != FLT_TYPE_OTHER && !this.eqkRupture.getRuptureSurface().isPointSurface()) {
                double jbDist = (Double)this.distanceJBParam.getValue(this.eqkRupture, this.site);
                if (jbDist < 1.0) {
                    this.hangingWallParam.setValue(1.0);
                } else if (jbDist < 5.0) {
                    this.hangingWallParam.setValue((5.0 - jbDist) / 5.0);
                } else {
                    this.hangingWallParam.setValue(0.0);
                }
            } else {
                this.hangingWallParam.setValue(0.0);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void updateCoefficients() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("CB_2003_AttenRel: updateCoefficients(): The Intensity Measusre Parameter has not been set yet, unable to process.");
        }
        StringBuffer key = new StringBuffer(this.im.getName());
        if (this.im.getName().equalsIgnoreCase("SA")) {
            key.append("/" + String.valueOf(this.saPeriodParam.getValue()));
        }
        if (this.componentParam.getValue() == Component.AVE_HORZ) {
            if (!this.horzCoefficients.containsKey(key.toString())) throw new ParameterException("CB_2003_AttenRel: setIntensityMeasureType(): Unable to locate coefficients with key = " + String.valueOf(key));
            this.coeff = (CB_2003_AttenRelCoefficients)this.horzCoefficients.get(key.toString());
            return;
        } else {
            if (!this.vertCoefficients.containsKey(key.toString())) throw new ParameterException("CB_2003_AttenRel: setIntensityMeasureType(): Unable to locate coefficients with key = " + String.valueOf(key));
            this.coeff = (CB_2003_AttenRelCoefficients)this.vertCoefficients.get(key.toString());
        }
    }

    public CB_2003_AttenRel(ParameterChangeWarningListener listener) {
        this.listener = listener;
        this.initCoefficients();
        this.initSupportedIntensityMeasureParams();
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
    }

    @Override
    public double getMean() throws IMRException {
        this.updateCoefficients();
        return this.calcMean();
    }

    protected double calcMean() throws IMRException {
        double F_th;
        double F_rv;
        String siteType;
        String fltType;
        double hw;
        double dist;
        double mag;
        double S_vfs = 0.0;
        double S_sr = 0.0;
        double S_fr = 0.0;
        try {
            mag = (Double)this.magParam.getValue();
            dist = (Double)this.distanceSeisParam.getValue();
            hw = (Double)this.hangingWallParam.getValue();
            fltType = ((String)this.fltTypeParam.getValue()).toString();
            siteType = ((String)this.siteTypeParam.getValue()).toString();
        }
        catch (NullPointerException e) {
            throw new IMRException("CB_2003_AttenRel: getMean(): Not all parameters have been set");
        }
        if (dist > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        if (this.componentParam.getValue() == Component.VERT && siteType.equals(SITE_TYPE_NEHRP_BC)) {
            throw new RuntimeException("BC-Boundary site type is not supported for the vertical component. Please choose a different site type.");
        }
        if (fltType.equals(FLT_TYPE_REVERSE)) {
            F_rv = 1.0;
            F_th = 0.0;
        } else if (fltType.equals(FLT_TYPE_THRUST)) {
            F_rv = 0.0;
            F_th = 1.0;
        } else if (fltType.equals(FLT_TYPE_REVERSE_THRUST)) {
            F_rv = 0.5;
            F_th = 0.5;
        } else if (fltType.equals(FLT_TYPE_OTHER)) {
            F_rv = 0.0;
            F_th = 0.0;
        } else {
            F_rv = 0.25;
            F_th = 0.25;
        }
        if (siteType.equals(SITE_TYPE_VERY_FIRM_SOIL)) {
            S_vfs = 1.0;
        } else if (siteType.equals(SITE_TYPE_SOFT_ROCK)) {
            S_sr = 1.0;
        } else if (siteType.equals(SITE_TYPE_FIRM_ROCK)) {
            S_fr = 1.0;
        } else if (siteType.equals(SITE_TYPE_SOIL)) {
            S_vfs = 0.25;
        } else if (siteType.equals(SITE_TYPE_ROCK)) {
            S_fr = 0.5;
            S_sr = 0.5;
        } else if (siteType.equals(SITE_TYPE_NEHRP_BC)) {
            S_fr = 0.5;
            S_sr = 0.5;
        }
        double f1 = this.coeff.c2 * mag + this.coeff.c3 * (8.5 - mag) * (8.5 - mag);
        double g = this.coeff.c5 + this.coeff.c6 * (S_vfs + S_sr) + this.coeff.c7 * S_fr;
        double temp = Math.exp(this.coeff.c8 * mag + this.coeff.c9 * (8.5 - mag) * (8.5 - mag));
        double f2 = dist * dist + g * g * temp * temp;
        double f3 = this.coeff.c10 * F_rv + this.coeff.c11 * F_th;
        double f4 = this.coeff.c12 * S_vfs + this.coeff.c13 * S_sr + this.coeff.c14 * S_fr;
        double f_HW_m = mag < 5.5 ? 0.0 : (mag >= 5.5 && mag < 6.5 ? mag - 5.5 : 1.0);
        double f_HW_r = dist < 8.0 ? this.coeff.c15 * (dist / 8.0) : this.coeff.c15;
        double f5 = hw * (S_vfs + S_sr + S_fr) * f_HW_m * f_HW_r;
        if (siteType.equals(SITE_TYPE_NEHRP_BC)) {
            f1 += this.coeff.bv * Math.log(1.2258064516129032);
        }
        return this.coeff.c1 + f1 + this.coeff.c4 * 0.5 * Math.log(f2) + f3 + f4 + f5;
    }

    @Override
    public double getStdDev() throws IMRException {
        String stdevType = ((String)this.stdDevTypeParam.getValue()).toString();
        if (this.componentParam.getValue() == Component.VERT && ((String)this.siteTypeParam.getValue()).toString().equals(SITE_TYPE_NEHRP_BC)) {
            throw new RuntimeException("BC-Boundary site type is not supported for the vertical component. Please choose a different site type.");
        }
        if (stdevType.equals("None (zero)")) {
            return 0.0;
        }
        if (stdevType.equals("Total (Mag Dependent)")) {
            double mag;
            try {
                mag = (Double)this.magParam.getValue();
            }
            catch (NullPointerException e) {
                throw new IMRException("CB_2003_AttenRel: getStdDev(): Not all parameters have been set");
            }
            this.updateCoefficients();
            if (mag < 7.4) {
                return this.coeff.c16 - 0.07 * mag;
            }
            return this.coeff.c16 - 0.518;
        }
        Component component = (Component)this.componentParam.getValue();
        StringBuffer key = new StringBuffer(this.im.getName());
        if (this.im.getName().equalsIgnoreCase("SA")) {
            key.append("/0.0");
        }
        this.coeff = component == Component.AVE_HORZ ? (CB_2003_AttenRelCoefficients)this.horzCoefficients.get(key.toString()) : (CB_2003_AttenRelCoefficients)this.vertCoefficients.get(key.toString());
        double pga = Math.exp(this.calcMean());
        this.updateCoefficients();
        if (pga <= 0.07) {
            return this.coeff.c17 + 0.351;
        }
        if (pga > 0.07 && pga < 0.25) {
            return this.coeff.c17 - 0.132 * Math.log(pga);
        }
        return this.coeff.c17 + 0.183;
    }

    @Override
    public void setParamDefaults() {
        this.siteTypeParam.setValue("Firm-Soil");
        this.magParam.setValueAsDefault();
        this.fltTypeParam.setValueAsDefault();
        this.distanceSeisParam.setValueAsDefault();
        this.hangingWallParam.setValue(HANGING_WALL_DEFAULT);
        this.saParam.setValueAsDefault();
        this.saPeriodParam.setValueAsDefault();
        this.saDampingParam.setValueAsDefault();
        this.pgaParam.setValueAsDefault();
        this.componentParam.setValueAsDefault();
        this.stdDevTypeParam.setValueAsDefault();
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.distanceSeisParam);
        this.meanIndependentParams.addParameter(this.siteTypeParam);
        this.meanIndependentParams.addParameter(this.magParam);
        this.meanIndependentParams.addParameter(this.fltTypeParam);
        this.meanIndependentParams.addParameter(this.hangingWallParam);
        this.meanIndependentParams.addParameter(this.componentParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameter(this.stdDevTypeParam);
        this.stdDevIndependentParams.addParameter(this.distanceSeisParam);
        this.stdDevIndependentParams.addParameter(this.siteTypeParam);
        this.stdDevIndependentParams.addParameter(this.magParam);
        this.stdDevIndependentParams.addParameter(this.fltTypeParam);
        this.stdDevIndependentParams.addParameter(this.hangingWallParam);
        this.stdDevIndependentParams.addParameter(this.componentParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameter(this.distanceSeisParam);
        this.exceedProbIndependentParams.addParameter(this.siteTypeParam);
        this.exceedProbIndependentParams.addParameter(this.magParam);
        this.exceedProbIndependentParams.addParameter(this.fltTypeParam);
        this.exceedProbIndependentParams.addParameter(this.hangingWallParam);
        this.exceedProbIndependentParams.addParameter(this.componentParam);
        this.exceedProbIndependentParams.addParameter(this.stdDevTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    @Override
    protected void initSiteParams() {
        StringConstraint siteConstraint = new StringConstraint();
        siteConstraint.addString("Firm-Soil");
        siteConstraint.addString(SITE_TYPE_VERY_FIRM_SOIL);
        siteConstraint.addString(SITE_TYPE_SOFT_ROCK);
        siteConstraint.addString(SITE_TYPE_FIRM_ROCK);
        siteConstraint.addString(SITE_TYPE_SOIL);
        siteConstraint.addString(SITE_TYPE_ROCK);
        siteConstraint.addString(SITE_TYPE_NEHRP_BC);
        siteConstraint.setNonEditable();
        this.siteTypeParam = new StringParameter(SITE_TYPE_NAME, siteConstraint, null);
        this.siteTypeParam.setInfo(SITE_TYPE_INFO);
        this.siteTypeParam.setNonEditable();
        this.siteParams.clear();
        this.siteParams.addParameter(this.siteTypeParam);
    }

    @Override
    protected void initEqkRuptureParams() {
        this.magParam = new MagParam(MAG_WARN_MIN, (double)MAG_WARN_MAX);
        StringConstraint constraint = new StringConstraint();
        constraint.addString(FLT_TYPE_OTHER);
        constraint.addString(FLT_TYPE_THRUST);
        constraint.addString(FLT_TYPE_REVERSE);
        constraint.addString(FLT_TYPE_REVERSE_THRUST);
        constraint.addString(FLT_TYPE_UNKNOWN);
        constraint.setNonEditable();
        this.fltTypeParam = new FaultTypeParam(constraint, FLT_TYPE_OTHER);
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
        this.eqkRuptureParams.addParameter(this.fltTypeParam);
    }

    @Override
    protected void initPropagationEffectParams() {
        this.distanceSeisParam = new DistanceSeisParameter(3.0);
        this.distanceSeisParam.addParameterChangeWarningListener(this.listener);
        DoubleConstraint warn = new DoubleConstraint(DISTANCE_SEIS_WARN_MIN, DISTANCE_SEIS_WARN_MAX);
        warn.setNonEditable();
        this.distanceSeisParam.setWarningConstraint(warn);
        this.distanceSeisParam.setNonEditable();
        this.distanceJBParam = new DistanceJBParameter();
        this.hangingWallParam = new DoubleParameter(HANGING_WALL_NAME, HANGING_WALL_MIN, HANGING_WALL_MAX);
        this.hangingWallParam.setInfo(HANGING_WALL_INFO);
        this.hangingWallParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceSeisParam);
        this.propagationEffectParams.addParameter(this.hangingWallParam);
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        DoubleDiscreteConstraint periodConstraint = new DoubleDiscreteConstraint();
        TreeSet<Double> set = new TreeSet<Double>();
        Enumeration keys = this.horzCoefficients.keys();
        while (keys.hasMoreElements()) {
            CB_2003_AttenRelCoefficients coeff = (CB_2003_AttenRelCoefficients)this.horzCoefficients.get(keys.nextElement());
            if (!(coeff.period >= 0.0)) continue;
            set.add(coeff.period);
        }
        Iterator it = set.iterator();
        while (it.hasNext()) {
            periodConstraint.addDouble((Double)it.next());
        }
        this.saPeriodParam = new PeriodParam(periodConstraint);
        this.saDampingParam = new DampingParam();
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saParam.setNonEditable();
        this.pgaParam = new PGA_Param();
        this.pgaParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.listener);
        this.pgaParam.addParameterChangeWarningListener(this.listener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        this.componentParam = new ComponentParam(Component.AVE_HORZ, Component.AVE_HORZ, Component.VERT);
        StringConstraint stdDevTypeConstraint = new StringConstraint();
        stdDevTypeConstraint.addString("Total (Mag Dependent)");
        stdDevTypeConstraint.addString("Total (PGA Dependent)");
        stdDevTypeConstraint.addString("None (zero)");
        stdDevTypeConstraint.setNonEditable();
        this.stdDevTypeParam = new StdDevTypeParam(stdDevTypeConstraint, "Total (Mag Dependent)");
        this.otherParams.addParameter(this.componentParam);
        this.otherParams.addParameter(this.stdDevTypeParam);
    }

    protected void initCoefficients() {
        this.initHorzCoefficients();
        this.initVertCoefficients();
    }

    protected void initHorzCoefficients() {
        String S = "CB_2003_AttenRel: initCoefficients():";
        this.horzCoefficients.clear();
        CB_2003_AttenRelCoefficients coeffPGA = new CB_2003_AttenRelCoefficients("PGA", -1.0, -4.033, 0.812, 0.036, -1.061, 0.041, -0.005, -0.018, 0.766, 0.034, 0.343, 0.351, -0.123, -0.138, -0.289, 0.37, 0.92, 0.219, -0.371);
        CB_2003_AttenRelCoefficients coeff0 = new CB_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.0"), 0.0, -4.033, 0.812, 0.036, -1.061, 0.041, -0.005, -0.018, 0.766, 0.034, 0.343, 0.351, -0.123, -0.138, -0.289, 0.37, 0.92, 0.219, -0.371);
        CB_2003_AttenRelCoefficients coeff1 = new CB_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.05"), 0.05, -3.74, 0.812, 0.036, -1.121, 0.058, -0.004, -0.028, 0.724, 0.032, 0.302, 0.362, -0.14, -0.158, -0.205, 0.37, 0.94, 0.239, -0.304);
        CB_2003_AttenRelCoefficients coeff2 = new CB_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.075"), 0.075, -3.076, 0.812, 0.05, -1.252, 0.121, -0.005, -0.051, 0.648, 0.04, 0.243, 0.333, -0.15, -0.196, -0.208, 0.37, 0.952, 0.251, -0.25);
        CB_2003_AttenRelCoefficients coeff3 = new CB_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.1"), 0.1, -2.661, 0.812, 0.06, -1.308, 0.166, -0.009, -0.068, 0.621, 0.046, 0.224, 0.313, -0.146, -0.253, -0.258, 0.37, 0.958, 0.257, -0.212);
        CB_2003_AttenRelCoefficients coeff4 = new CB_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.15"), 0.15, -2.27, 0.812, 0.041, -1.324, 0.212, -0.033, -0.081, 0.613, 0.031, 0.318, 0.344, -0.176, -0.267, -0.284, 0.37, 0.974, 0.273, -0.238);
        CB_2003_AttenRelCoefficients coeff5 = new CB_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.2"), 0.2, -2.771, 0.812, 0.03, -1.153, 0.098, -0.014, -0.038, 0.704, 0.026, 0.296, 0.342, -0.148, -0.183, -0.359, 0.37, 0.981, 0.28, -0.292);
        CB_2003_AttenRelCoefficients coeff6 = new CB_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.3"), 0.3, -2.999, 0.812, 0.007, -1.08, 0.059, -0.007, -0.022, 0.752, 0.007, 0.359, 0.385, -0.162, -0.157, -0.585, 0.37, 0.984, 0.283, -0.401);
        CB_2003_AttenRelCoefficients coeff7 = new CB_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.4"), 0.4, -3.511, 0.812, -0.015, -0.964, 0.024, -0.002, -0.005, 0.842, -0.016, 0.379, 0.438, -0.078, -0.129, -0.557, 0.37, 0.987, 0.286, -0.487);
        CB_2003_AttenRelCoefficients coeff8 = new CB_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.5"), 0.5, -3.556, 0.812, -0.035, -0.964, 0.023, -0.002, -0.004, 0.842, -0.036, 0.406, 0.479, -0.122, -0.13, -0.701, 0.37, 0.99, 0.289, -0.553);
        CB_2003_AttenRelCoefficients coeff9 = new CB_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.75"), 0.75, -3.709, 0.812, -0.071, -0.964, 0.021, -0.002, -0.002, 0.842, -0.074, 0.347, 0.419, -0.108, -0.124, -0.796, 0.331, 1.021, 0.32, -0.653);
        CB_2003_AttenRelCoefficients coeff10 = new CB_2003_AttenRelCoefficients("SA/" + Double.valueOf("1.0"), 1.0, -3.867, 0.812, -0.101, -0.964, 0.019, 0.0, 0.0, 0.842, -0.105, 0.329, 0.338, -0.073, -0.072, -0.858, 0.281, 1.021, 0.32, -0.698);
        CB_2003_AttenRelCoefficients coeff11 = new CB_2003_AttenRelCoefficients("SA/" + Double.valueOf("1.5"), 1.5, -4.093, 0.812, -0.15, -0.964, 0.019, 0.0, 0.0, 0.842, -0.155, 0.217, 0.188, -0.079, -0.056, -0.954, 0.21, 1.021, 0.32, -0.704);
        CB_2003_AttenRelCoefficients coeff12 = new CB_2003_AttenRelCoefficients("SA/" + Double.valueOf("2.0"), 2.0, -4.311, 0.812, -0.18, -0.964, 0.019, 0.0, 0.0, 0.842, -0.187, 0.06, 0.064, -0.124, -0.116, -0.916, 0.16, 1.021, 0.32, -0.655);
        CB_2003_AttenRelCoefficients coeff13 = new CB_2003_AttenRelCoefficients("SA/" + Double.valueOf("3.0"), 3.0, -4.817, 0.812, -0.193, -0.964, 0.019, 0.0, 0.0, 0.842, -0.2, -0.079, 0.021, -0.154, -0.117, -0.873, 0.089, 1.021, 0.32, -0.655);
        CB_2003_AttenRelCoefficients coeff14 = new CB_2003_AttenRelCoefficients("SA/" + Double.valueOf("4.0"), 4.0, -5.211, 0.812, -0.202, -0.964, 0.019, 0.0, 0.0, 0.842, -0.209, -0.061, 0.057, -0.054, -0.261, -0.889, 0.039, 1.021, 0.32, -0.655);
        this.horzCoefficients.put(coeffPGA.getName(), coeffPGA);
        this.horzCoefficients.put(coeff0.getName(), coeff0);
        this.horzCoefficients.put(coeff1.getName(), coeff1);
        this.horzCoefficients.put(coeff2.getName(), coeff2);
        this.horzCoefficients.put(coeff3.getName(), coeff3);
        this.horzCoefficients.put(coeff4.getName(), coeff4);
        this.horzCoefficients.put(coeff5.getName(), coeff5);
        this.horzCoefficients.put(coeff6.getName(), coeff6);
        this.horzCoefficients.put(coeff7.getName(), coeff7);
        this.horzCoefficients.put(coeff8.getName(), coeff8);
        this.horzCoefficients.put(coeff9.getName(), coeff9);
        this.horzCoefficients.put(coeff10.getName(), coeff10);
        this.horzCoefficients.put(coeff11.getName(), coeff11);
        this.horzCoefficients.put(coeff12.getName(), coeff12);
        this.horzCoefficients.put(coeff13.getName(), coeff13);
        this.horzCoefficients.put(coeff14.getName(), coeff14);
    }

    protected void initVertCoefficients() {
        String S = "CB_2003_AttenRel: initCoefficients():";
        this.vertCoefficients.clear();
        CB_2003_AttenRelCoefficients coeffPGA = new CB_2003_AttenRelCoefficients("PGA", -1.0, -3.108, 0.756, 0.0, -1.287, 0.142, 0.046, -0.04, 0.587, 0.0, 0.253, 0.173, -0.135, -0.138, -0.256, 0.63, 0.975, 0.274, -0.371);
        CB_2003_AttenRelCoefficients coeff0 = new CB_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.0"), 0.0, -3.108, 0.756, 0.0, -1.287, 0.142, 0.046, -0.04, 0.587, 0.0, 0.253, 0.173, -0.135, -0.138, -0.256, 0.63, 0.975, 0.274, -0.371);
        CB_2003_AttenRelCoefficients coeff1 = new CB_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.05"), 0.05, -1.918, 0.756, 0.0, -1.517, 0.309, 0.069, -0.023, 0.498, 0.0, 0.058, 0.1, -0.195, -0.274, -0.219, 0.63, 1.031, 0.33, -0.304);
        CB_2003_AttenRelCoefficients coeff2 = new CB_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.075"), 0.075, -1.504, 0.756, 0.0, -1.551, 0.343, 0.083, 0.0, 0.487, 0.0, 0.135, 0.182, -0.224, -0.303, -0.263, 0.63, 1.031, 0.33, -0.25);
        CB_2003_AttenRelCoefficients coeff3 = new CB_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.1"), 0.1, -1.672, 0.756, 0.0, -1.473, 0.282, 0.062, 0.001, 0.513, 0.0, 0.168, 0.21, -0.198, -0.275, -0.252, 0.63, 1.031, 0.33, -0.212);
        CB_2003_AttenRelCoefficients coeff4 = new CB_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.15"), 0.15, -2.323, 0.756, 0.0, -1.28, 0.171, 0.045, 0.008, 0.591, 0.0, 0.223, 0.238, -0.17, -0.175, -0.27, 0.63, 1.031, 0.33, -0.238);
        CB_2003_AttenRelCoefficients coeff5 = new CB_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.2"), 0.2, -2.998, 0.756, 0.0, -1.131, 0.089, 0.028, 0.004, 0.668, 0.0, 0.234, 0.256, -0.098, -0.041, -0.311, 0.571, 1.031, 0.33, -0.292);
        CB_2003_AttenRelCoefficients coeff6 = new CB_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.3"), 0.3, -3.721, 0.756, 0.007, -1.028, 0.05, 0.01, 0.004, 0.736, 0.007, 0.249, 0.328, -0.026, 0.082, -0.265, 0.488, 1.031, 0.33, -0.401);
        CB_2003_AttenRelCoefficients coeff7 = new CB_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.4"), 0.4, -4.536, 0.756, -0.015, -0.812, 0.012, 0.0, 0.0, 0.931, -0.018, 0.299, 0.317, -0.017, 0.022, -0.257, 0.428, 1.031, 0.33, -0.487);
        CB_2003_AttenRelCoefficients coeff8 = new CB_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.5"), 0.5, -4.651, 0.756, -0.035, -0.812, 0.012, 0.0, 0.0, 0.931, -0.043, 0.243, 0.354, -0.02, 0.092, -0.293, 0.383, 1.031, 0.33, -0.553);
        CB_2003_AttenRelCoefficients coeff9 = new CB_2003_AttenRelCoefficients("SA/" + Double.valueOf("0.75"), 0.75, -4.903, 0.756, -0.071, -0.812, 0.012, 0.0, 0.0, 0.931, -0.087, 0.295, 0.418, 0.078, 0.091, -0.349, 0.299, 1.031, 0.33, -0.653);
        CB_2003_AttenRelCoefficients coeff10 = new CB_2003_AttenRelCoefficients("SA/" + Double.valueOf("1.0"), 1.0, -4.95, 0.756, -0.101, -0.812, 0.012, 0.0, 0.0, 0.931, -0.124, 0.266, 0.315, 0.043, 0.101, -0.481, 0.24, 1.031, 0.33, -0.698);
        CB_2003_AttenRelCoefficients coeff11 = new CB_2003_AttenRelCoefficients("SA/" + Double.valueOf("1.5"), 1.5, -5.073, 0.756, -0.15, -0.812, 0.012, 0.0, 0.0, 0.931, -0.184, 0.171, 0.211, -0.038, -0.018, -0.518, 0.24, 1.031, 0.33, -0.704);
        CB_2003_AttenRelCoefficients coeff12 = new CB_2003_AttenRelCoefficients("SA/" + Double.valueOf("2.0"), 2.0, -5.292, 0.756, -0.18, -0.812, 0.012, 0.0, 0.0, 0.931, -0.222, 0.114, 0.115, 0.033, -0.022, -0.503, 0.24, 1.031, 0.33, -0.655);
        CB_2003_AttenRelCoefficients coeff13 = new CB_2003_AttenRelCoefficients("SA/" + Double.valueOf("3.0"), 3.0, -5.748, 0.756, -0.193, -0.812, 0.012, 0.0, 0.0, 0.931, -0.238, 0.179, 0.159, -0.01, -0.047, -0.539, 0.24, 1.031, 0.33, -0.655);
        CB_2003_AttenRelCoefficients coeff14 = new CB_2003_AttenRelCoefficients("SA/" + Double.valueOf("4.0"), 4.0, -6.042, 0.756, -0.202, -0.812, 0.012, 0.0, 0.0, 0.931, -0.248, 0.237, 0.134, -0.059, -0.267, -0.606, 0.24, 1.031, 0.33, -0.655);
        this.vertCoefficients.put(coeffPGA.getName(), coeffPGA);
        this.vertCoefficients.put(coeff0.getName(), coeff0);
        this.vertCoefficients.put(coeff1.getName(), coeff1);
        this.vertCoefficients.put(coeff2.getName(), coeff2);
        this.vertCoefficients.put(coeff3.getName(), coeff3);
        this.vertCoefficients.put(coeff4.getName(), coeff4);
        this.vertCoefficients.put(coeff5.getName(), coeff5);
        this.vertCoefficients.put(coeff6.getName(), coeff6);
        this.vertCoefficients.put(coeff7.getName(), coeff7);
        this.vertCoefficients.put(coeff8.getName(), coeff8);
        this.vertCoefficients.put(coeff9.getName(), coeff9);
        this.vertCoefficients.put(coeff10.getName(), coeff10);
        this.vertCoefficients.put(coeff11.getName(), coeff11);
        this.vertCoefficients.put(coeff12.getName(), coeff12);
        this.vertCoefficients.put(coeff13.getName(), coeff13);
        this.vertCoefficients.put(coeff14.getName(), coeff14);
    }

    @Override
    public URL getInfoURL() throws MalformedURLException {
        return new URL("http://www.opensha.org/glossary-attenuationRelation-CAMPBELL_BOZORG_2003");
    }

    class CB_2003_AttenRelCoefficients
    implements Named {
        private static final long serialVersionUID = 1234567890987654325L;
        protected static final String C = "CB_2003_AttenRelCoefficients";
        protected static final boolean D = true;
        protected String name;
        protected double period = -1.0;
        protected double c1;
        protected double c2;
        protected double c3;
        protected double c4;
        protected double c5;
        protected double c6;
        protected double c7;
        protected double c8;
        protected double c9;
        protected double c10;
        protected double c11;
        protected double c12;
        protected double c13;
        protected double c14;
        protected double c15;
        protected double c16;
        protected double c17;
        protected double bv;

        public CB_2003_AttenRelCoefficients(String name) {
            this.name = name;
        }

        public CB_2003_AttenRelCoefficients(String name, double period, double c1, double c2, double c3, double c4, double c5, double c6, double c7, double c8, double c9, double c10, double c11, double c12, double c13, double c14, double c15, double c16, double c17, double bv) {
            this.name = name;
            this.period = period;
            this.c1 = c1;
            this.c2 = c2;
            this.c3 = c3;
            this.c4 = c4;
            this.c5 = c5;
            this.c6 = c6;
            this.c7 = c7;
            this.c8 = c8;
            this.c9 = c9;
            this.c10 = c10;
            this.c11 = c11;
            this.c12 = c12;
            this.c13 = c13;
            this.c14 = c14;
            this.c15 = c15;
            this.c16 = c16;
            this.c17 = c17;
            this.bv = bv;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            b.append(C);
            b.append("\n  Period = " + this.period);
            b.append("\n  Name = " + this.name);
            b.append("\n  c1 = " + this.c1);
            b.append("\n  c2 = " + this.c2);
            b.append("\n  c3 = " + this.c3);
            b.append("\n  c4 = " + this.c4);
            b.append("\n  c5 = " + this.c5);
            b.append("\n  c6 = " + this.c6);
            b.append("\n  c7 = " + this.c7);
            b.append("\n  c8 = " + this.c8);
            b.append("\n  c9 = " + this.c9);
            b.append("\n  c10 = " + this.c10);
            b.append("\n  c11 = " + this.c11);
            b.append("\n  c12 = " + this.c12);
            b.append("\n  c13 = " + this.c13);
            b.append("\n  c14 = " + this.c14);
            b.append("\n  c15 = " + this.c15);
            b.append("\n  c16 = " + this.c16);
            b.append("\n  c17 = " + this.c17);
            b.append("\n  bv = " + this.bv);
            return b.toString();
        }
    }
}

