/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.param.EqkRuptureParams.AftershockParam;
import org.opensha.sha.imr.param.EqkRuptureParams.DipParam;
import org.opensha.sha.imr.param.EqkRuptureParams.FaultTypeParam;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.EqkRuptureParams.RupTopDepthParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGV_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.OtherParams.Component;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;
import org.opensha.sha.imr.param.PropagationEffectParams.DistRupMinusDistX_OverRupParam;
import org.opensha.sha.imr.param.PropagationEffectParams.DistRupMinusJB_OverRupParameter;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceRupParameter;
import org.opensha.sha.imr.param.PropagationEffectParams.HangingWallFlagParam;
import org.opensha.sha.imr.param.SiteParams.DepthTo1pt0kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;
import org.opensha.sha.imr.param.SiteParams.Vs30_TypeParam;

public class CY_2008_AttenRel
extends AttenuationRelationship
implements ParameterChangeListener {
    private static final String C = "CY_2008_AttenRel";
    private static final boolean D = false;
    public static final String NAME = "Chiou & Youngs (2008)";
    public static final String SHORT_NAME = "CY2008";
    private static final long serialVersionUID = 1L;
    protected static final double[] period = new double[]{0.01, 0.02, 0.03, 0.04, 0.05, 0.075, 0.1, 0.15, 0.2, 0.25, 0.3, 0.4, 0.5, 0.75, 1.0, 1.5, 2.0, 3.0, 4.0, 5.0, 7.5, 10.0, 0.0, -1.0};
    protected static final double[] c1 = new double[]{-1.2687, -1.2515, -1.1744, -1.0671, -0.9464, -0.7051, -0.5747, -0.5309, -0.6352, -0.7766, -0.9278, -1.2176, -1.4695, -1.9278, -2.2453, -2.7307, -3.1413, -3.7413, -4.1814, -4.5187, -5.1224, -5.5872, -1.2687, 2.2884};
    protected static final double[] c1a = new double[]{0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.0999, 0.0997, 0.0991, 0.0936, 0.0766, 0.0022, -0.0591, -0.0931, -0.0982, -0.0994, -0.0999, -0.1, 0.1, 0.1094};
    protected static final double[] c1b = new double[]{-0.255, -0.255, -0.255, -0.255, -0.255, -0.254, -0.253, -0.25, -0.2449, -0.2382, -0.2313, -0.2146, -0.1972, -0.162, -0.14, -0.1184, -0.11, -0.104, -0.102, -0.101, -0.101, -0.1, -0.255, -0.0626};
    protected static final double[] cn = new double[]{2.996, 3.292, 3.514, 3.563, 3.547, 3.448, 3.312, 3.044, 2.831, 2.658, 2.505, 2.261, 2.087, 1.812, 1.648, 1.511, 1.47, 1.456, 1.465, 1.478, 1.498, 1.502, 2.996, 1.648};
    protected static final double[] cm = new double[]{4.184, 4.1879, 4.1556, 4.1226, 4.1011, 4.086, 4.103, 4.1717, 4.2476, 4.3184, 4.3844, 4.4979, 4.5881, 4.7571, 4.882, 5.0697, 5.2173, 5.4385, 5.5977, 5.7276, 5.9891, 6.193, 4.184, 4.2979};
    protected static final double[] c5 = new double[]{6.16, 6.158, 6.155, 6.1508, 6.1441, 6.12, 6.085, 5.9871, 5.8699, 5.7547, 5.6527, 5.4997, 5.4029, 5.29, 5.248, 5.2194, 5.2099, 5.204, 5.202, 5.201, 5.2, 5.2, 6.16, 5.17};
    protected static final double[] c6 = new double[]{0.4893, 0.4892, 0.489, 0.4888, 0.4884, 0.4872, 0.4854, 0.4808, 0.4755, 0.4706, 0.4665, 0.4607, 0.4571, 0.4531, 0.4517, 0.4507, 0.4504, 0.4501, 0.4501, 0.45, 0.45, 0.45, 0.4893, 0.4407};
    protected static final double[] c7 = new double[]{0.0512, 0.0512, 0.0511, 0.0508, 0.0504, 0.0495, 0.0489, 0.0479, 0.0471, 0.0464, 0.0458, 0.0445, 0.0429, 0.0387, 0.035, 0.028, 0.0213, 0.0106, 0.0041, 0.001, 0.0, 0.0, 0.0512, 0.0207};
    protected static final double[] c7a = new double[]{0.086, 0.086, 0.086, 0.086, 0.086, 0.086, 0.086, 0.086, 0.086, 0.086, 0.086, 0.085, 0.083, 0.069, 0.045, 0.0134, 0.004, 0.001, 0.0, 0.0, 0.0, 0.0, 0.086, 0.0437};
    protected static final double[] c9 = new double[]{0.79, 0.8129, 0.8439, 0.874, 0.8996, 0.9442, 0.9677, 0.966, 0.9334, 0.8946, 0.859, 0.8019, 0.7578, 0.6788, 0.6196, 0.5101, 0.3917, 0.1244, 0.0086, 0.0, 0.0, 0.0, 0.79, 0.3079};
    protected static final double[] c9a = new double[]{1.5005, 1.5028, 1.5071, 1.5138, 1.523, 1.5597, 1.6104, 1.7549, 1.9157, 2.0709, 2.2005, 2.3886, 2.5, 2.6224, 2.669, 2.6985, 2.7085, 2.7145, 2.7164, 2.7172, 2.7177, 2.718, 1.5005, 2.669};
    protected static final double[] c10 = new double[]{-0.3218, -0.3323, -0.3394, -0.3453, -0.3502, -0.3579, -0.3604, -0.3565, -0.347, -0.3379, -0.3314, -0.3256, -0.3189, -0.2702, -0.2059, -0.0852, 0.016, 0.1876, 0.3378, 0.4579, 0.7514, 1.1856, -0.3218, -0.1166};
    protected static final double[] cg1 = new double[]{-0.00804, -0.00811, -0.00839, -0.00875, -0.00912, -0.00973, -0.00975, -0.00883, -0.00778, -0.00688, -0.00612, -0.00498, -0.0042, -0.00308, -0.00246, -0.0018, -0.00147, -0.00117, -0.00107, -0.00102, -9.6E-4, -9.4E-4, -0.00804, -0.00275};
    protected static final double[] cg2 = new double[]{-0.00785, -0.00792, -0.00819, -0.00855, -0.00891, -0.0095, -0.00952, -0.00862, -0.00759, -0.00671, -0.00598, -0.00486, -0.0041, -0.00301, -0.00241, -0.00176, -0.00143, -0.00115, -0.00104, -9.9E-4, -9.4E-4, -9.1E-4, -0.00785, -0.00625};
    protected static final double[] phi1 = new double[]{-0.4417, -0.434, -0.4177, -0.4, -0.3903, -0.404, -0.4423, -0.5162, -0.5697, -0.6109, -0.6444, -0.6931, -0.7246, -0.7708, -0.799, -0.8382, -0.8663, -0.9032, -0.9231, -0.9222, -0.8346, -0.7332, -0.4417, -0.7861};
    protected static final double[] phi2 = new double[]{-0.1417, -0.1364, -0.1403, -0.1591, -0.1862, -0.2538, -0.2943, -0.3113, -0.2927, -0.2662, -0.2405, -0.1975, -0.1633, -0.1028, -0.0699, -0.0425, -0.0302, -0.0129, -0.0016, 0.0, 0.0, 0.0, -0.1417, -0.0699};
    protected static final double[] phi3 = new double[]{-0.00701, -0.007279, -0.007354, -0.006977, -0.006467, -0.005734, -0.005604, -0.005845, -0.006141, -0.006439, -0.006704, -0.007125, -0.007435, -0.00812, -0.008444, -0.007707, -0.004792, -0.001828, -0.001523, -0.00144, -0.001369, -0.001361, -0.00701, -0.008444};
    protected static final double[] phi4 = new double[]{0.102151, 0.10836, 0.119888, 0.133641, 0.148927, 0.190596, 0.230662, 0.266468, 0.255253, 0.231541, 0.207277, 0.165464, 0.133828, 0.085153, 0.058595, 0.031787, 0.019716, 0.009643, 0.005379, 0.003223, 0.001134, 5.15E-4, 0.102151, 5.41};
    protected static final double[] phi5 = new double[]{0.2289, 0.2289, 0.2289, 0.2289, 0.229, 0.2292, 0.2297, 0.2326, 0.2386, 0.2497, 0.2674, 0.312, 0.361, 0.4353, 0.4629, 0.4756, 0.4785, 0.4796, 0.4799, 0.4799, 0.48, 0.48, 0.2289, 0.2899};
    protected static final double[] phi6 = new double[]{0.014996, 0.014996, 0.014996, 0.014996, 0.014996, 0.014996, 0.014996, 0.014988, 0.014964, 0.014881, 0.014639, 0.013493, 0.011133, 0.006739, 0.005749, 0.005544, 0.005521, 0.005517, 0.005517, 0.005517, 0.005517, 0.005517, 0.014996, 0.006718};
    protected static final double[] phi7 = new double[]{580.0, 580.0, 580.0, 579.9, 579.9, 579.6, 579.2, 577.2, 573.9, 568.5, 560.5, 540.0, 512.9, 441.9, 391.8, 348.1, 332.5, 324.1, 321.7, 320.9, 320.3, 320.1, 580.0, 459.0};
    protected static final double[] phi8 = new double[]{0.07, 0.0699, 0.0701, 0.0702, 0.0701, 0.0686, 0.0646, 0.0494, -0.0019, -0.0479, -0.0756, -0.096, -0.0998, -0.0765, -0.0412, 0.014, 0.0544, 0.1232, 0.1859, 0.2295, 0.266, 0.2682, 0.07, 0.1138};
    protected static final double[] tau1 = new double[]{0.3437, 0.3471, 0.3603, 0.3718, 0.3848, 0.3878, 0.3835, 0.3719, 0.3601, 0.3522, 0.3438, 0.3351, 0.3353, 0.3429, 0.3577, 0.3769, 0.4023, 0.4406, 0.4784, 0.5074, 0.5328, 0.5542, 0.3437, 0.2539};
    protected static final double[] tau2 = new double[]{0.2637, 0.2671, 0.2803, 0.2918, 0.3048, 0.3129, 0.3152, 0.3128, 0.3076, 0.3047, 0.3005, 0.2984, 0.3036, 0.3205, 0.3419, 0.3703, 0.4023, 0.4406, 0.4784, 0.5074, 0.5328, 0.5542, 0.2637, 0.2381};
    protected static final double[] sig1 = new double[]{0.4458, 0.4458, 0.4535, 0.4589, 0.463, 0.4702, 0.4747, 0.4798, 0.4816, 0.4815, 0.4801, 0.4758, 0.471, 0.4621, 0.4581, 0.4493, 0.4459, 0.4433, 0.4424, 0.442, 0.4416, 0.4414, 0.4458, 0.4496};
    protected static final double[] sig2 = new double[]{0.3459, 0.3459, 0.3537, 0.3592, 0.3635, 0.3713, 0.3769, 0.3847, 0.3902, 0.3946, 0.3981, 0.4036, 0.4079, 0.4157, 0.4213, 0.4213, 0.4213, 0.4213, 0.4213, 0.4213, 0.4213, 0.4213, 0.3459, 0.3554};
    protected static final double[] sig3 = new double[]{0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.7999, 0.7997, 0.7988, 0.7966, 0.7792, 0.7504, 0.7136, 0.7035, 0.7006, 0.7001, 0.7, 0.7, 0.7, 0.8, 0.7504};
    protected static final double[] sig4 = new double[]{0.0663, 0.0663, 0.0663, 0.0663, 0.0663, 0.0663, 0.0663, 0.0612, 0.053, 0.0457, 0.0398, 0.0312, 0.0255, 0.0175, 0.0133, 0.009, 0.0068, 0.0045, 0.0034, 0.0027, 0.0018, 0.0014, 0.0663, 0.0133};
    protected static final double c2 = 1.06;
    protected static final double c3 = 3.45;
    protected static final double c4 = -2.1;
    protected static final double c4a = -0.5;
    protected static final double crb = 50.0;
    protected static final double chm = 3.0;
    protected static final double cg3 = 4.0;
    protected static final Double PERIOD_DEFAULT = 1.0;
    private HashMap indexFromPerHashMap;
    private int iper;
    private double vs30;
    private double rRup;
    private double distRupMinusJB_OverRup;
    private double dip;
    private double mag;
    private double f_rv;
    private double f_nm;
    private double depthTop;
    private double distRupMinusDistX_OverRup;
    private double aftershock;
    private double f_meas;
    private double f_hw;
    private String stdDevType;
    private double depthTo1pt0kmPerSec;
    protected double lnYref;
    protected boolean lnYref_is_not_fresh;
    protected static final double MAG_WARN_MIN = 4.0;
    protected static final double MAG_WARN_MAX = 8.5;
    protected static final double DISTANCE_RUP_WARN_MIN = 0.0;
    protected static final double DISTANCE_RUP_WARN_MAX = 200.0;
    protected static final double DISTANCE_MINUS_WARN_MIN = 0.0;
    protected static final double DISTANCE_MINUS_WARN_MAX = 50.0;
    protected static final double DISTANCE_X_WARN_MIN = -500.0;
    protected static final double DISTANCE_X_WARN_MAX = 500.0;
    protected static final double VS30_WARN_MIN = 150.0;
    protected static final double VS30_WARN_MAX = 1500.0;
    protected static final double RUP_TOP_WARN_MIN = 0.0;
    protected static final double RUP_TOP_WARN_MAX = 20.0;
    protected static final double DEPTH_1pt0_WARN_MIN = 0.0;
    protected static final double DEPTH_1pt0_WARN_MAX = 10000.0;
    public static final String FLT_TYPE_STRIKE_SLIP = "Strike-Slip";
    public static final String FLT_TYPE_REVERSE = "Reverse";
    public static final String FLT_TYPE_NORMAL = "Normal";

    public CY_2008_AttenRel(ParameterChangeWarningListener listener) {
        this.listener = listener;
        this.initSupportedIntensityMeasureParams();
        this.indexFromPerHashMap = new HashMap();
        for (int i = 0; i < period.length - 2; ++i) {
            this.indexFromPerHashMap.put(period[i], i);
        }
        this.initEqkRuptureParams();
        this.initSiteParams();
        this.initPropagationEffectParams();
        this.initOtherParams();
        this.initIndependentParamLists();
        this.initParameterEventListeners();
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.eqkRupture = eqkRupture;
        this.magParam.setValueIgnoreWarning(eqkRupture.getMag());
        this.setFaultTypeFromRake(eqkRupture.getAveRake());
        RuptureSurface surface = eqkRupture.getRuptureSurface();
        this.dipParam.setValue(surface.getAveDip());
        this.rupTopDepthParam.setValueIgnoreWarning(surface.getAveRupTopDepth());
        this.aftershockParam.setValue(false);
        this.setPropagationEffectParams();
    }

    @Override
    public void setSite(Site site) throws ParameterException {
        this.site = site;
        this.vs30Param.setValueIgnoreWarning((Double)site.getParameter("Vs30").getValue());
        this.depthTo1pt0kmPerSecParam.setValueIgnoreWarning((Double)site.getParameter("Depth 1.0 km/sec").getValue());
        this.vs30_TypeParam.setValue((String)site.getParameter("Vs30 Type").getValue());
        this.setPropagationEffectParams();
    }

    @Override
    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.propEffectUpdate();
        }
    }

    private void propEffectUpdate() {
        this.distanceRupParam.setValueIgnoreWarning(this.eqkRupture.getRuptureSurface().getDistanceRup(this.site.getLocation()));
        double dist_jb = this.eqkRupture.getRuptureSurface().getDistanceJB(this.site.getLocation());
        double distX = this.eqkRupture.getRuptureSurface().getDistanceX(this.site.getLocation());
        if (this.rRup > 0.0) {
            this.distRupMinusJB_OverRupParam.setValueIgnoreWarning((this.rRup - dist_jb) / this.rRup);
            if (distX >= 0.0) {
                this.distRupMinusDistX_OverRupParam.setValue((this.rRup - distX) / this.rRup);
                this.hangingWallFlagParam.setValue(true);
            } else {
                this.distRupMinusDistX_OverRupParam.setValue((this.rRup + distX) / this.rRup);
                this.hangingWallFlagParam.setValue(false);
            }
        } else {
            this.distRupMinusJB_OverRupParam.setValueIgnoreWarning(0.0);
            this.distRupMinusDistX_OverRupParam.setValue(0.0);
            this.hangingWallFlagParam.setValue(true);
        }
    }

    protected void setFaultTypeFromRake(double rake) {
        if (rake > 30.0 && rake < 150.0) {
            this.fltTypeParam.setValue(FLT_TYPE_REVERSE);
        } else if (rake > -120.0 && rake < -60.0) {
            this.fltTypeParam.setValue(FLT_TYPE_NORMAL);
        } else {
            this.fltTypeParam.setValue(FLT_TYPE_STRIKE_SLIP);
        }
    }

    protected void setCoeffIndex() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("CY_2008_AttenRel: updateCoefficients(): The Intensity Measusre Parameter has not been set yet, unable to process.");
        }
        this.iper = this.im.getName().equalsIgnoreCase("SA") ? (Integer)this.indexFromPerHashMap.get(this.saPeriodParam.getValue()) : (this.im.getName().equalsIgnoreCase("PGA") ? 22 : 23);
        this.intensityMeasureChanged = false;
    }

    @Override
    public double getMean() {
        if (this.rRup > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
            this.lnYref_is_not_fresh = true;
        }
        return this.getMean(this.iper, this.vs30, this.f_rv, this.f_nm, this.rRup, this.distRupMinusJB_OverRup, this.depthTo1pt0kmPerSec, this.distRupMinusDistX_OverRup, this.f_hw, this.dip, this.mag, this.depthTop, this.aftershock);
    }

    @Override
    public double getStdDev() {
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
            this.lnYref_is_not_fresh = true;
        }
        return this.getStdDev(this.iper, this.vs30, this.f_rv, this.f_nm, this.rRup, this.distRupMinusJB_OverRup, this.distRupMinusDistX_OverRup, this.f_hw, this.dip, this.mag, this.depthTop, this.aftershock, this.stdDevType, this.f_meas);
    }

    @Override
    public void setParamDefaults() {
        this.magParam.setValueAsDefault();
        this.fltTypeParam.setValueAsDefault();
        this.rupTopDepthParam.setValueAsDefault();
        this.dipParam.setValueAsDefault();
        this.aftershockParam.setValueAsDefault();
        this.vs30Param.setValueAsDefault();
        this.vs30_TypeParam.setValue("Inferred");
        this.depthTo1pt0kmPerSecParam.setValueAsDefault();
        this.distanceRupParam.setValueAsDefault();
        this.distRupMinusJB_OverRupParam.setValueAsDefault();
        this.distRupMinusDistX_OverRupParam.setValueAsDefault();
        this.hangingWallFlagParam.setValueAsDefault();
        this.componentParam.setValueAsDefault();
        this.stdDevTypeParam.setValueAsDefault();
        this.saParam.setValueAsDefault();
        this.saPeriodParam.setValueAsDefault();
        this.saDampingParam.setValueAsDefault();
        this.pgaParam.setValueAsDefault();
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.magParam);
        this.meanIndependentParams.addParameter(this.fltTypeParam);
        this.meanIndependentParams.addParameter(this.rupTopDepthParam);
        this.meanIndependentParams.addParameter(this.dipParam);
        this.meanIndependentParams.addParameter(this.aftershockParam);
        this.meanIndependentParams.addParameter(this.vs30Param);
        this.meanIndependentParams.addParameter(this.depthTo1pt0kmPerSecParam);
        this.meanIndependentParams.addParameter(this.distanceRupParam);
        this.meanIndependentParams.addParameter(this.distRupMinusJB_OverRupParam);
        this.meanIndependentParams.addParameter(this.distRupMinusDistX_OverRupParam);
        this.meanIndependentParams.addParameter(this.hangingWallFlagParam);
        this.meanIndependentParams.addParameter(this.componentParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameter(this.magParam);
        this.stdDevIndependentParams.addParameter(this.fltTypeParam);
        this.stdDevIndependentParams.addParameter(this.rupTopDepthParam);
        this.stdDevIndependentParams.addParameter(this.dipParam);
        this.stdDevIndependentParams.addParameter(this.aftershockParam);
        this.stdDevIndependentParams.addParameter(this.vs30Param);
        this.stdDevIndependentParams.addParameter(this.vs30_TypeParam);
        this.stdDevIndependentParams.addParameter(this.distanceRupParam);
        this.stdDevIndependentParams.addParameter(this.distRupMinusJB_OverRupParam);
        this.stdDevIndependentParams.addParameter(this.distRupMinusDistX_OverRupParam);
        this.stdDevIndependentParams.addParameter(this.hangingWallFlagParam);
        this.stdDevIndependentParams.addParameter(this.componentParam);
        this.stdDevIndependentParams.addParameter(this.stdDevTypeParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameterList(this.meanIndependentParams);
        this.exceedProbIndependentParams.addParameter(this.vs30_TypeParam);
        this.exceedProbIndependentParams.addParameter(this.stdDevTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    @Override
    protected void initSiteParams() {
        this.vs30Param = new Vs30_Param(150.0, 1500.0);
        this.vs30_TypeParam = new Vs30_TypeParam();
        this.depthTo1pt0kmPerSecParam = new DepthTo1pt0kmPerSecParam(0.0, 10000.0);
        this.depthTo1pt0kmPerSecParam.setValue(null);
        this.siteParams.clear();
        this.siteParams.addParameter(this.vs30Param);
        this.siteParams.addParameter(this.vs30_TypeParam);
        this.siteParams.addParameter(this.depthTo1pt0kmPerSecParam);
    }

    @Override
    protected void initEqkRuptureParams() {
        this.magParam = new MagParam(4.0, 8.5);
        this.aftershockParam = new AftershockParam();
        this.dipParam = new DipParam();
        this.rupTopDepthParam = new RupTopDepthParam(0.0, 20.0);
        StringConstraint constraint = new StringConstraint();
        constraint.addString(FLT_TYPE_STRIKE_SLIP);
        constraint.addString(FLT_TYPE_NORMAL);
        constraint.addString(FLT_TYPE_REVERSE);
        constraint.setNonEditable();
        this.fltTypeParam = new FaultTypeParam(constraint, FLT_TYPE_STRIKE_SLIP);
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
        this.eqkRuptureParams.addParameter(this.fltTypeParam);
        this.eqkRuptureParams.addParameter(this.rupTopDepthParam);
        this.eqkRuptureParams.addParameter(this.dipParam);
        this.eqkRuptureParams.addParameter(this.aftershockParam);
    }

    @Override
    protected void initPropagationEffectParams() {
        this.distanceRupParam = new DistanceRupParameter(0.0);
        this.distanceRupParam.addParameterChangeWarningListener(this.listener);
        DoubleConstraint warn = new DoubleConstraint(0.0, 200.0);
        warn.setNonEditable();
        this.distanceRupParam.setWarningConstraint(warn);
        this.distanceRupParam.setNonEditable();
        this.distRupMinusJB_OverRupParam = new DistRupMinusJB_OverRupParameter(0.0);
        DoubleConstraint warn2 = new DoubleConstraint(0.0, 50.0);
        this.distRupMinusJB_OverRupParam.addParameterChangeWarningListener(this.listener);
        warn.setNonEditable();
        this.distRupMinusJB_OverRupParam.setWarningConstraint(warn2);
        this.distRupMinusJB_OverRupParam.setNonEditable();
        this.distRupMinusDistX_OverRupParam = new DistRupMinusDistX_OverRupParam();
        this.hangingWallFlagParam = new HangingWallFlagParam();
        this.propagationEffectParams.addParameter(this.distanceRupParam);
        this.propagationEffectParams.addParameter(this.distRupMinusJB_OverRupParam);
        this.propagationEffectParams.addParameter(this.distRupMinusDistX_OverRupParam);
        this.propagationEffectParams.addParameter(this.hangingWallFlagParam);
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        DoubleDiscreteConstraint periodConstraint = new DoubleDiscreteConstraint();
        for (int i = 0; i < period.length - 2; ++i) {
            periodConstraint.addDouble((Double)period[i]);
        }
        periodConstraint.setNonEditable();
        this.saPeriodParam = new PeriodParam(periodConstraint);
        this.saDampingParam = new DampingParam();
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saParam.setNonEditable();
        this.pgaParam = new PGA_Param();
        this.pgaParam.setNonEditable();
        this.pgvParam = new PGV_Param();
        this.pgvParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.listener);
        this.pgaParam.addParameterChangeWarningListener(this.listener);
        this.pgvParam.addParameterChangeWarningListener(this.listener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
        this.supportedIMParams.addParameter(this.pgvParam);
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        this.componentParam = new ComponentParam(Component.GMRotI50, Component.GMRotI50);
        StringConstraint stdDevTypeConstraint = new StringConstraint();
        stdDevTypeConstraint.addString("Total");
        stdDevTypeConstraint.addString("None (zero)");
        stdDevTypeConstraint.addString("Inter-Event");
        stdDevTypeConstraint.addString("Intra-Event");
        stdDevTypeConstraint.setNonEditable();
        this.stdDevTypeParam = new StdDevTypeParam(stdDevTypeConstraint);
        this.otherParams.addParameter(this.componentParam);
        this.otherParams.addParameter(this.stdDevTypeParam);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    public double getMean(int iper, double vs30, double f_rv, double f_nm, double rRup, double distRupMinusJB_OverRup, double depthTo1pt0kmPerSec, double distRupMinusDistX_OverRup, double f_hw, double dip, double mag, double depthTop, double aftershock) {
        if (this.lnYref_is_not_fresh) {
            this.compute_lnYref(iper, f_rv, f_nm, rRup, distRupMinusJB_OverRup, distRupMinusDistX_OverRup, f_hw, dip, mag, depthTop, aftershock);
        }
        double basinDepth = Double.isNaN(depthTo1pt0kmPerSec) ? (Math.abs(vs30 - 760.0) < 20.0 ? 40.0 : Math.exp(28.5 - 3.82 * Math.log(Math.pow(vs30, 8.0) + Math.pow(378.7, 8.0)) / 8.0)) : depthTo1pt0kmPerSec;
        double exp1 = Math.exp(phi3[iper] * (Math.min(vs30, 1130.0) - 360.0));
        double exp2 = Math.exp(phi3[iper] * 770.0);
        double lnY = this.lnYref + phi1[iper] * Math.min(Math.log(vs30 / 1130.0), 0.0) + phi2[iper] * (exp1 - exp2) * Math.log((Math.exp(this.lnYref) + phi4[iper]) / phi4[iper]) + phi5[iper] * (1.0 - 1.0 / Math.cosh(phi6[iper] * Math.max(0.0, basinDepth - phi7[iper]))) + phi8[iper] / Math.cosh(0.15 * Math.max(0.0, basinDepth - 15.0));
        return lnY;
    }

    protected void compute_lnYref(int iper, double f_rv, double f_nm, double rRup, double distRupMinusJB_OverRup, double distRupMinusDistX_OverRup, double f_hw, double dip, double mag, double depthTop, double aftershock) {
        double distanceJB = rRup - distRupMinusJB_OverRup * rRup;
        double distX = rRup - distRupMinusDistX_OverRup * rRup;
        double cosDelta = Math.cos(dip * Math.PI / 180.0);
        double altDist = Math.sqrt(distanceJB * distanceJB + depthTop * depthTop);
        this.lnYref = c1[iper] + (c1a[iper] * f_rv + c1b[iper] * f_nm + c7[iper] * (depthTop - 4.0)) * (1.0 - aftershock) + (c10[iper] + c7a[iper] * (depthTop - 4.0)) * aftershock + 1.06 * (mag - 6.0) + -2.39 / cn[iper] * Math.log(1.0 + Math.exp(cn[iper] * (cm[iper] - mag))) + -2.1 * Math.log(rRup + c5[iper] * Math.cosh(c6[iper] * Math.max(mag - 3.0, 0.0))) + 0.8 * Math.log(rRup * rRup + 2500.0) + (cg1[iper] + cg2[iper] / Math.cosh(Math.max(mag - 4.0, 0.0))) * rRup + c9[iper] * f_hw * Math.tanh(distX * cosDelta * cosDelta / c9a[iper]) * (1.0 - altDist / (rRup + 0.001));
        this.lnYref_is_not_fresh = false;
    }

    public double getStdDev(int iper, double vs30, double f_rv, double f_nm, double rRup, double distRupMinusJB_OverRup, double distRupMinusDistX_OverRup, double f_hw, double dip, double mag, double depthTop, double aftershock, String stdDevType, double f_meas) {
        double magTest = Math.min(Math.max(mag, 5.0), 7.0) - 5.0;
        double tau = tau1[iper] + (tau2[iper] - tau1[iper]) / 2.0 * magTest;
        if (this.lnYref_is_not_fresh) {
            this.compute_lnYref(iper, f_rv, f_nm, rRup, distRupMinusJB_OverRup, distRupMinusDistX_OverRup, f_hw, dip, mag, depthTop, aftershock);
        }
        double b = phi2[iper] * (Math.exp(phi3[iper] * (Math.min(vs30, 1130.0) - 360.0)) - Math.exp(phi3[iper] * 770.0));
        double c = phi4[iper];
        double NLo = b * Math.exp(this.lnYref) / (Math.exp(this.lnYref) + c);
        double sigma = sig1[iper] + 0.5 * (sig2[iper] - sig1[iper]) * magTest + sig4[iper] * aftershock;
        sigma *= Math.sqrt(sig3[iper] * (1.0 - f_meas) + 0.7 * f_meas + (1.0 + NLo) * (1.0 + NLo));
        if (stdDevType.equals("Total")) {
            return Math.sqrt((1.0 + NLo) * (1.0 + NLo) * tau * tau + sigma * sigma);
        }
        if (stdDevType.equals("None (zero)")) {
            return 0.0;
        }
        if (stdDevType.equals("Intra-Event")) {
            return sigma;
        }
        if (stdDevType.equals("Inter-Event")) {
            return (1.0 + NLo) * tau;
        }
        return Double.NaN;
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        String pName = e.getParameterName();
        Object val = e.getNewValue();
        this.lnYref_is_not_fresh = true;
        if (pName.equals("Magnitude")) {
            this.mag = (Double)val;
        } else if (pName.equals("Fault Type")) {
            String fltType = (String)this.fltTypeParam.getValue();
            if (fltType.equals(FLT_TYPE_NORMAL)) {
                this.f_rv = 0.0;
                this.f_nm = 1.0;
            } else if (fltType.equals(FLT_TYPE_REVERSE)) {
                this.f_rv = 1.0;
                this.f_nm = 0.0;
            } else {
                this.f_rv = 0.0;
                this.f_nm = 0.0;
            }
        } else if (pName.equals("Rupture Top Depth")) {
            this.depthTop = (Double)val;
        } else if (pName.equals("Dip")) {
            this.dip = (Double)val;
        } else if (pName.equals("Aftershock")) {
            this.aftershock = ((Boolean)val).booleanValue() ? 1.0 : 0.0;
        } else if (pName.equals("Vs30")) {
            this.vs30 = (Double)val;
        } else if (pName.equals("Vs30 Type")) {
            this.f_meas = ((String)val).equals("Measured") ? 1.0 : 0.0;
        } else if (pName.equals("Depth 1.0 km/sec")) {
            this.depthTo1pt0kmPerSec = val == null ? Double.NaN : (Double)val;
        } else if (pName.equals("DistanceRup")) {
            this.rRup = (Double)val;
        } else if (pName.equals("(distRup-distJB)/distRup")) {
            this.distRupMinusJB_OverRup = (Double)val;
        } else if (pName.equals(this.distRupMinusDistX_OverRupParam.getName())) {
            this.distRupMinusDistX_OverRup = (Double)val;
        } else if (pName.equals("Site on Hanging Wall")) {
            this.f_hw = ((Boolean)val).booleanValue() ? 1.0 : 0.0;
        } else if (pName.equals("Std Dev Type")) {
            this.stdDevType = (String)val;
        } else if (pName.equals("SA Period")) {
            this.intensityMeasureChanged = true;
        }
    }

    @Override
    public void resetParameterEventListeners() {
        this.magParam.removeParameterChangeListener(this);
        this.fltTypeParam.removeParameterChangeListener(this);
        this.rupTopDepthParam.removeParameterChangeListener(this);
        this.dipParam.removeParameterChangeListener(this);
        this.aftershockParam.removeParameterChangeListener(this);
        this.vs30Param.removeParameterChangeListener(this);
        this.vs30_TypeParam.removeParameterChangeListener(this);
        this.depthTo1pt0kmPerSecParam.removeParameterChangeListener(this);
        this.distanceRupParam.removeParameterChangeListener(this);
        this.distRupMinusJB_OverRupParam.removeParameterChangeListener(this);
        this.distRupMinusDistX_OverRupParam.removeParameterChangeListener(this);
        this.hangingWallFlagParam.removeParameterChangeListener(this);
        this.stdDevTypeParam.removeParameterChangeListener(this);
        this.saPeriodParam.removeParameterChangeListener(this);
        this.initParameterEventListeners();
    }

    @Override
    protected void initParameterEventListeners() {
        this.magParam.addParameterChangeListener(this);
        this.fltTypeParam.addParameterChangeListener(this);
        this.rupTopDepthParam.addParameterChangeListener(this);
        this.dipParam.addParameterChangeListener(this);
        this.aftershockParam.addParameterChangeListener(this);
        this.vs30Param.addParameterChangeListener(this);
        this.vs30_TypeParam.addParameterChangeListener(this);
        this.depthTo1pt0kmPerSecParam.addParameterChangeListener(this);
        this.distanceRupParam.addParameterChangeListener(this);
        this.distRupMinusJB_OverRupParam.addParameterChangeListener(this);
        this.distRupMinusDistX_OverRupParam.addParameterChangeListener(this);
        this.hangingWallFlagParam.addParameterChangeListener(this);
        this.stdDevTypeParam.addParameterChangeListener(this);
        this.saPeriodParam.addParameterChangeListener(this);
    }

    @Override
    public URL getInfoURL() throws MalformedURLException {
        return new URL("http://www.opensha.org/glossary-attenuationRelation-CHIOU_YOUNGS_2008");
    }
}

