/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.exceptions.IMRException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.faultSurface.PointSurface;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.attenRelImpl.BA_2008_AttenRel;
import org.opensha.sha.imr.attenRelImpl.CB_2008_AttenRel;
import org.opensha.sha.imr.attenRelImpl.CY_2008_AttenRel;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGV_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.OtherParams.Component;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.OtherParams.SigmaTruncLevelParam;
import org.opensha.sha.imr.param.OtherParams.SigmaTruncTypeParam;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;
import org.opensha.sha.imr.param.SiteParams.DepthTo1pt0kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.DepthTo2pt5kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;
import org.opensha.sha.imr.param.SiteParams.Vs30_TypeParam;
import org.opensha.sha.util.NSHMP_Util;

public class NSHMP_2008_CA
extends AttenuationRelationship
implements ParameterChangeListener {
    public static final String NAME = "NSHMP 2008 California Combined";
    public static final String SHORT_NAME = "NSHMP_2008_CA";
    private static final long serialVersionUID = 1L;
    private NSHMP_BA_2008 ba08;
    private NSHMP_CB_2008 cb08;
    private NSHMP_CY_2008 cy08;
    private List<AttenuationRelationship> arList;
    private static final double VS30_WARN_MIN = 80.0;
    private static final double VS30_WARN_MAX = 1300.0;
    public static final String IMR_UNCERT_PARAM_NAME = "IMR uncertainty";
    private boolean includeImrUncert = false;
    private static final String HW_EFFECT_PARAM_NAME = "Hanging Wall Effect Approx.";
    private boolean hwEffectApprox = true;
    private double imrUncert = 0.0;
    private static double[] imrUncertSign = new double[]{-1.0, 0.0, 1.0, 0.0};
    private static double[] imrUncertWeights = new double[]{0.185, 0.63, 0.185};
    private static double[][] imrUncertVals = new double[][]{{0.375, 0.21, 0.245}, {0.23, 0.225, 0.23}, {0.4, 0.36, 0.31}};

    public NSHMP_2008_CA(ParameterChangeWarningListener listener) {
        this.ba08 = new NSHMP_BA_2008(listener);
        this.cb08 = new NSHMP_CB_2008(listener);
        this.cy08 = new NSHMP_CY_2008(listener);
        this.arList = new ArrayList<AttenuationRelationship>();
        this.arList.add(this.ba08);
        this.arList.add(this.cb08);
        this.arList.add(this.cy08);
        this.initSupportedIntensityMeasureParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initParameterEventListeners();
    }

    @Override
    public void setParamDefaults() {
        this.vs30Param.setValueAsDefault();
        this.depthTo2pt5kmPerSecParam.setValueAsDefault();
        this.depthTo1pt0kmPerSecParam.setValueAsDefault();
        this.saParam.setValueAsDefault();
        this.saPeriodParam.setValueAsDefault();
        this.saDampingParam.setValueAsDefault();
        this.pgaParam.setValueAsDefault();
        this.pgvParam.setValueAsDefault();
        this.componentParam.setValueAsDefault();
        this.stdDevTypeParam.setValueAsDefault();
        this.sigmaTruncTypeParam.setValueAsDefault();
        this.sigmaTruncLevelParam.setValueAsDefault();
        for (ScalarIMR scalarIMR : this.arList) {
            scalarIMR.setParamDefaults();
        }
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected void setPropagationEffectParams() {
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        DoubleDiscreteConstraint periodConstraint = new DoubleDiscreteConstraint(((SA_Param)this.ba08.getSupportedIntensityMeasures().getParameter("SA")).getPeriodParam().getAllowedDoubles());
        periodConstraint.setNonEditable();
        this.saPeriodParam = new PeriodParam(periodConstraint, 1.0, false);
        this.saPeriodParam.addParameterChangeListener(this);
        this.saDampingParam = new DampingParam();
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saParam.setNonEditable();
        this.pgaParam = new PGA_Param();
        this.pgaParam.setNonEditable();
        this.pgvParam = new PGV_Param();
        this.pgvParam.setNonEditable();
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
        this.supportedIMParams.addParameter(this.pgvParam);
    }

    @Override
    protected void initSiteParams() {
        this.siteParams.clear();
        this.vs30Param = new Vs30_Param(80.0, 1300.0);
        this.siteParams.addParameter(this.vs30Param);
        this.vs30Param.setValueAsDefault();
        this.depthTo2pt5kmPerSecParam = new DepthTo2pt5kmPerSecParam(null, 0.0, 10.0, true);
        this.depthTo2pt5kmPerSecParam.setValueAsDefault();
        this.siteParams.addParameter(this.depthTo2pt5kmPerSecParam);
        this.depthTo1pt0kmPerSecParam = new DepthTo1pt0kmPerSecParam(null, true);
        this.depthTo1pt0kmPerSecParam.setValueAsDefault();
        this.siteParams.addParameter(this.depthTo1pt0kmPerSecParam);
        this.vs30_TypeParam = new Vs30_TypeParam();
        this.vs30_TypeParam.getEditor().setVisible(false);
        this.siteParams.addParameter(this.vs30_TypeParam);
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        this.componentParam = new ComponentParam(Component.GMRotI50, Component.GMRotI50);
        this.componentParam.setValueAsDefault();
        StringConstraint stdDevTypeConstraint = new StringConstraint();
        stdDevTypeConstraint.addString("Total");
        stdDevTypeConstraint.addString("None (zero)");
        stdDevTypeConstraint.addString("Inter-Event");
        stdDevTypeConstraint.addString("Intra-Event");
        stdDevTypeConstraint.setNonEditable();
        this.stdDevTypeParam = new StdDevTypeParam(stdDevTypeConstraint);
        this.stdDevTypeParam.setValueAsDefault();
        BooleanParameter imrUncertParam = new BooleanParameter(IMR_UNCERT_PARAM_NAME, this.includeImrUncert);
        BooleanParameter hwEffectApproxParam = new BooleanParameter(HW_EFFECT_PARAM_NAME, this.hwEffectApprox);
        this.otherParams.addParameter(this.componentParam);
        this.otherParams.addParameter(this.stdDevTypeParam);
        this.otherParams.addParameter(imrUncertParam);
        this.otherParams.addParameter(hwEffectApproxParam);
        this.otherParams.removeParameter(this.sigmaTruncTypeParam);
        this.otherParams.removeParameter(this.sigmaTruncLevelParam);
        this.sigmaTruncTypeParam = new SigmaTruncTypeParam("1 Sided");
        this.sigmaTruncLevelParam = new SigmaTruncLevelParam(3.0);
        this.sigmaTruncTypeParam.addParameterChangeListener(this);
        this.sigmaTruncLevelParam.addParameterChangeListener(this);
        this.tectonicRegionTypeParam.addParameterChangeListener(this);
        this.componentParam.addParameterChangeListener(this);
        this.stdDevTypeParam.addParameterChangeListener(this);
        imrUncertParam.addParameterChangeListener(this);
        hwEffectApproxParam.addParameterChangeListener(this);
        for (AttenuationRelationship ar : this.arList) {
            ParameterList list = ar.getOtherParams();
            ComponentParam cp = (ComponentParam)list.getParameter("Component");
            cp.setValue(Component.GMRotI50);
            StdDevTypeParam stp = (StdDevTypeParam)list.getParameter("Std Dev Type");
            stp.setValue("Total");
            SigmaTruncTypeParam sttp = (SigmaTruncTypeParam)list.getParameter("Gaussian Truncation");
            sttp.setValue("1 Sided");
            SigmaTruncLevelParam stlp = (SigmaTruncLevelParam)list.getParameter("Truncation Level");
            stlp.setValue(3.0);
        }
    }

    @Override
    protected void initEqkRuptureParams() {
    }

    @Override
    protected void initPropagationEffectParams() {
    }

    @Override
    protected void initParameterEventListeners() {
        this.vs30Param.addParameterChangeListener(this);
        this.depthTo1pt0kmPerSecParam.addParameterChangeListener(this);
        this.depthTo2pt5kmPerSecParam.addParameterChangeListener(this);
        this.saPeriodParam.addParameterChangeListener(this);
    }

    @Override
    public void setSite(Site site) {
        this.site = site;
        this.vs30Param.setValueIgnoreWarning((Double)site.getParameter("Vs30").getValue());
        if (this.eqkRupture != null) {
            this.setPropagationEffect();
        }
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) {
        this.eqkRupture = eqkRupture;
        if (this.site != null) {
            this.setPropagationEffect();
        }
    }

    public void setPropagationEffect() {
        for (AttenuationRelationship ar : this.arList) {
            ar.setEqkRupture(this.eqkRupture);
            ar.setSite(this.site);
        }
    }

    @Override
    public double getMean() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getStdDev() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getEpsilon() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getEpsilon(double iml) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DiscretizedFunc getExceedProbabilities(DiscretizedFunc imls) throws ParameterException {
        HashMap<DiscretizedFunc, Double> funcs = new HashMap<DiscretizedFunc, Double>();
        double imrWeight = 1.0 / (double)this.arList.size();
        if (this.includeImrUncert) {
            double mag = this.eqkRupture.getMag();
            double dist = this.eqkRupture.getRuptureSurface().getDistanceJB(this.site.getLocation());
            double uncert = NSHMP_2008_CA.getUncertainty(mag, dist);
            for (AttenuationRelationship ar : this.arList) {
                for (int i = 0; i < 3; ++i) {
                    this.imrUncert = imrUncertSign[i] * uncert;
                    DiscretizedFunc func = imls.deepClone();
                    funcs.put(ar.getExceedProbabilities(func), imrWeight * imrUncertWeights[i]);
                }
            }
        } else {
            this.imrUncert = 0.0;
            for (AttenuationRelationship ar : this.arList) {
                DiscretizedFunc func = imls.deepClone();
                funcs.put(ar.getExceedProbabilities(func), imrWeight);
            }
        }
        for (int i = 0; i < imls.size(); ++i) {
            double val = 0.0;
            for (DiscretizedFunc f : funcs.keySet()) {
                val += f.getY(i) * (Double)funcs.get(f);
            }
            imls.set(i, val);
        }
        return imls;
    }

    @Override
    public double getExceedProbability() throws ParameterException, IMRException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected double getExceedProbability(double mean, double stdDev, double iml) throws ParameterException, IMRException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getExceedProbability(double iml) throws ParameterException, IMRException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getIML_AtExceedProb() throws ParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getIML_AtExceedProb(double exceedProb) throws ParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DiscretizedFunc getSA_ExceedProbSpectrum(double iml) throws ParameterException, IMRException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DiscretizedFunc getSA_IML_AtExceedProbSpectrum(double exceedProb) throws ParameterException, IMRException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setIntensityMeasureLevel(Double iml) throws ParameterException {
        for (AttenuationRelationship ar : this.arList) {
            ar.setIntensityMeasureLevel(iml);
        }
    }

    @Override
    public void setIntensityMeasureLevel(Object iml) throws ParameterException {
        for (AttenuationRelationship ar : this.arList) {
            ar.setIntensityMeasureLevel(iml);
        }
    }

    @Override
    public void setIntensityMeasure(String intensityMeasureName) throws ParameterException {
        super.setIntensityMeasure(intensityMeasureName);
        for (ScalarIMR scalarIMR : this.arList) {
            scalarIMR.setIntensityMeasure(intensityMeasureName);
        }
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        ParameterList pList;
        for (AttenuationRelationship ar : this.arList) {
            ParameterChangeListener pcl = (ParameterChangeListener)((Object)ar);
            pcl.parameterChange(e);
        }
        if (this.otherParams.containsParameter(e.getParameter())) {
            for (AttenuationRelationship ar : this.arList) {
                String pName;
                pList = ar.getOtherParams();
                if (!pList.containsParameter(pName = e.getParameterName())) continue;
                Parameter param = ar.getOtherParams().getParameter(e.getParameterName());
                if (param instanceof StringParameter) {
                    ((StringParameter)param).setValue((String)e.getParameter().getValue());
                    continue;
                }
                ((DoubleParameter)param).setValue((Double)e.getParameter().getValue());
            }
        }
        if (e.getParameterName().equals("SA Period")) {
            for (AttenuationRelationship ar : this.arList) {
                pList = ar.getSupportedIntensityMeasures();
                SA_Param sap = (SA_Param)pList.getParameter("SA");
                sap.getPeriodParam().setValue((Double)this.saPeriodParam.getValue());
            }
        }
        if (e.getParameterName().equals(IMR_UNCERT_PARAM_NAME)) {
            this.includeImrUncert = (Boolean)e.getParameter().getValue();
        }
        if (e.getParameterName().equals(HW_EFFECT_PARAM_NAME)) {
            this.hwEffectApprox = (Boolean)e.getParameter().getValue();
        }
    }

    private static double getUncertainty(double M, double D) {
        int mi;
        int n = M < 6.0 ? 0 : (mi = M < 7.0 ? 1 : 2);
        int di = D < 10.0 ? 0 : (D < 30.0 ? 1 : 2);
        return imrUncertVals[di][mi];
    }

    private String getFaultTypeForRake(double rake) {
        if (rake >= 45.0 && rake <= 135.0) {
            return "Reverse";
        }
        if (rake >= -135.0 && rake <= -45.0) {
            return "Normal";
        }
        return "Strike-Slip";
    }

    public static void main(String[] args) {
        Site s = new Site(new Location(34.0, -118.0));
        System.out.println(s.clone());
    }

    private class NSHMP_BA_2008
    extends BA_2008_AttenRel {
        public NSHMP_BA_2008(ParameterChangeWarningListener listener) {
            super(listener);
        }

        @Override
        public double getExceedProbability(double mean, double stdDev, double iml) {
            return super.getExceedProbability(mean + NSHMP_2008_CA.this.imrUncert, stdDev, iml);
        }

        @Override
        public void setFaultTypeFromRake(double rake) {
            this.fltTypeParam.setValue(NSHMP_2008_CA.this.getFaultTypeForRake(rake));
        }
    }

    private class NSHMP_CB_2008
    extends CB_2008_AttenRel {
        public NSHMP_CB_2008(ParameterChangeWarningListener listener) {
            super(listener);
        }

        @Override
        public double getExceedProbability(double mean, double stdDev, double iml) {
            return super.getExceedProbability(mean + NSHMP_2008_CA.this.imrUncert, stdDev, iml);
        }

        @Override
        public void setFaultTypeFromRake(double rake) {
            this.fltTypeParam.setValue(NSHMP_2008_CA.this.getFaultTypeForRake(rake));
        }

        @Override
        public double getMean(int iper, double vs30, double rRup, double distJB, double f_rv, double f_nm, double mag, double dip, double depthTop, double depthTo2pt5kmPerSec, boolean magSaturation, double pga_rock) {
            double fmag = mag <= 5.5 ? this.c0[iper] + this.c1[iper] * mag : (mag > 5.5 && mag <= 6.5 ? this.c0[iper] + this.c1[iper] * mag + this.c2[iper] * (mag - 5.5) : this.c0[iper] + this.c1[iper] * mag + this.c2[iper] * (mag - 5.5) + this.c3[iper] * (mag - 6.5));
            double fdis = (this.c4[iper] + this.c5[iper] * mag) * Math.log(Math.sqrt(rRup * rRup + this.c6[iper] * this.c6[iper]));
            double ffltz = depthTop < 1.0 ? depthTop : 1.0;
            double fflt = this.c7[iper] * f_rv * ffltz + this.c8[iper] * f_nm;
            double fhng = 0.0;
            if (NSHMP_2008_CA.this.hwEffectApprox && this.eqkRupture.getRuptureSurface() instanceof PointSurface) {
                if (dip != 90.0) {
                    fhng = NSHMP_Util.getAvgHW_CB(mag, rRup, this.per[iper]);
                }
            } else {
                double fhngr = distJB == 0.0 ? 1.0 : (depthTop < 1.0 && distJB > 0.0 ? (Math.max(rRup, Math.sqrt(distJB * distJB + 1.0)) - distJB) / Math.max(rRup, Math.sqrt(distJB * distJB + 1.0)) : (rRup - distJB) / rRup);
                double fhngm = mag <= 6.0 ? 0.0 : (mag > 6.0 && mag < 6.5 ? 2.0 * (mag - 6.0) : 1.0);
                double fhngz = depthTop >= 20.0 ? 0.0 : (20.0 - depthTop) / 20.0;
                double fhngd = dip <= 70.0 ? 1.0 : (90.0 - dip) / 20.0;
                fhng = this.c9[iper] * fhngr * fhngm * fhngz * fhngd;
            }
            double fsite = vs30 < this.k1[iper] ? this.c10[iper] * Math.log(vs30 / this.k1[iper]) + this.k2[iper] * (Math.log(pga_rock + 1.88 * Math.pow(vs30 / this.k1[iper], 1.18)) - Math.log(pga_rock + 1.88)) : (vs30 < 1100.0 ? (this.c10[iper] + this.k2[iper] * 1.18) * Math.log(vs30 / this.k1[iper]) : (this.c10[iper] + this.k2[iper] * 1.18) * Math.log(1100.0 / this.k1[iper]));
            double fsed = depthTo2pt5kmPerSec < 1.0 ? this.c11[iper] * (depthTo2pt5kmPerSec - 1.0) : (depthTo2pt5kmPerSec <= 3.0 ? 0.0 : this.c12[iper] * this.k3[iper] * Math.exp(-0.75) * (1.0 - Math.exp(-0.25 * (depthTo2pt5kmPerSec - 3.0))));
            return fmag + fdis + fflt + fhng + fsite + fsed;
        }
    }

    private class NSHMP_CY_2008
    extends CY_2008_AttenRel {
        public NSHMP_CY_2008(ParameterChangeWarningListener listener) {
            super(listener);
        }

        @Override
        public double getExceedProbability(double mean, double stdDev, double iml) {
            return super.getExceedProbability(mean + NSHMP_2008_CA.this.imrUncert, stdDev, iml);
        }

        @Override
        public void setFaultTypeFromRake(double rake) {
            this.fltTypeParam.setValue(NSHMP_2008_CA.this.getFaultTypeForRake(rake));
        }

        @Override
        protected void compute_lnYref(int iper, double f_rv, double f_nm, double rRup, double distRupMinusJB_OverRup, double distRupMinusDistX_OverRup, double f_hw, double dip, double mag, double depthTop, double aftershock) {
            double distanceJB = rRup - distRupMinusJB_OverRup * rRup;
            double distX = rRup - distRupMinusDistX_OverRup * rRup;
            double cosDelta = Math.cos(dip * Math.PI / 180.0);
            double altDist = Math.sqrt(distanceJB * distanceJB + depthTop * depthTop);
            double hw_effect = 0.0;
            if (NSHMP_2008_CA.this.hwEffectApprox && this.eqkRupture.getRuptureSurface() instanceof PointSurface && iper != 23) {
                if (dip != 90.0) {
                    hw_effect = NSHMP_Util.getAvgHW_CY(mag, rRup, period[iper]);
                }
            } else {
                hw_effect = c9[iper] * f_hw * Math.tanh(distX * cosDelta * cosDelta / c9a[iper]) * (1.0 - altDist / (rRup + 0.001));
            }
            this.lnYref = c1[iper] + (c1a[iper] * f_rv + c1b[iper] * f_nm + c7[iper] * (depthTop - 4.0)) * (1.0 - aftershock) + (c10[iper] + c7a[iper] * (depthTop - 4.0)) * aftershock + 1.06 * (mag - 6.0) + -2.39 / cn[iper] * Math.log(1.0 + Math.exp(cn[iper] * (cm[iper] - mag))) + -2.1 * Math.log(rRup + c5[iper] * Math.cosh(c6[iper] * Math.max(mag - 3.0, 0.0))) + 0.8 * Math.log(rRup * rRup + 2500.0) + (cg1[iper] + cg2[iper] / Math.cosh(Math.max(mag - 4.0, 0.0))) * rRup + hw_effect;
            this.lnYref_is_not_fresh = false;
        }
    }
}

