/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl.SA_InterpolatedWrapperAttenRel;

import java.net.MalformedURLException;
import java.net.URL;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodInterpolatedParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_InterpolatedParam;
import org.opensha.sha.imr.param.OtherParams.SigmaTruncLevelParam;
import org.opensha.sha.imr.param.OtherParams.SigmaTruncTypeParam;

public class InterpolatedSA_AttenRelWrapper
extends AttenuationRelationship
implements ParameterChangeListener {
    private static final String C = "InterpolatedSA_AttenRelWrapper";
    private static final boolean D = false;
    public static final String SHORT_NAME = "SA Interp";
    private static final long serialVersionUID = 1234567890987654353L;
    private AttenuationRelationship attenRelToWrap;
    PeriodParam origPeriodParam;
    private SA_InterpolatedParam saInterpParam;
    private PeriodInterpolatedParam periodInterpParam;
    double period;
    double periodBelow;
    double periodAbove;
    double[] periods;
    public static final String NAME = "Interpolated SA Atten Rel Wrapper";
    private static final String URL_INFO_STRING = null;
    private boolean parameterChange;

    public InterpolatedSA_AttenRelWrapper() {
    }

    public InterpolatedSA_AttenRelWrapper(ParameterChangeWarningListener listener, AttenuationRelationship attenRelToWrap) {
        this.attenRelToWrap = attenRelToWrap;
        attenRelToWrap.setIntensityMeasure("SA");
        this.listener = listener;
        this.initSupportedIntensityMeasureParams();
        this.siteParams = attenRelToWrap.getSiteParams();
        this.eqkRuptureParams = attenRelToWrap.getEqkRuptureParams();
        this.propagationEffectParams = attenRelToWrap.getPropagationEffectParams();
        this.otherParams = attenRelToWrap.getOtherParams();
        this.sigmaTruncTypeParam = (SigmaTruncTypeParam)this.otherParams.getParameter("Gaussian Truncation");
        this.sigmaTruncLevelParam = (SigmaTruncLevelParam)this.otherParams.getParameter("Truncation Level");
        this.initIndependentParamLists();
        this.initParameterEventListeners();
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.attenRelToWrap.setEqkRupture(eqkRupture);
        this.eqkRupture = eqkRupture;
    }

    @Override
    public void setSite(Site site) throws ParameterException {
        this.attenRelToWrap.setSite(site);
        this.site = site;
    }

    @Override
    protected void setPropagationEffectParams() {
    }

    @Override
    public double getMean() {
        if (this.intensityMeasureChanged) {
            this.setPeriodsAboveAndBelow();
        }
        this.origPeriodParam.setValue(this.periodBelow);
        double meanBelow = this.attenRelToWrap.getMean();
        this.origPeriodParam.setValue(this.periodAbove);
        double meanAbove = this.attenRelToWrap.getMean();
        return meanBelow + (meanAbove - meanBelow) * Math.log(this.period / this.periodBelow) / Math.log(this.periodAbove / this.periodBelow);
    }

    @Override
    public double getStdDev() {
        if (this.intensityMeasureChanged) {
            this.setPeriodsAboveAndBelow();
        }
        this.origPeriodParam.setValue(this.periodAbove);
        double stdAbove = this.attenRelToWrap.getStdDev();
        this.origPeriodParam.setValue(this.periodBelow);
        double stdBelow = this.attenRelToWrap.getStdDev();
        return stdBelow + (stdAbove - stdBelow) * Math.log(this.period / this.periodBelow) / Math.log(this.periodAbove / this.periodBelow);
    }

    private void setPeriodsAboveAndBelow() {
        for (int i = 0; i < this.periods.length - 1; ++i) {
            if (!(this.periods[i] <= this.period) || !(this.period <= this.periods[i + 1])) continue;
            this.periodBelow = this.periods[i];
            this.periodAbove = this.periods[i + 1];
            break;
        }
    }

    @Override
    public void setParamDefaults() {
        this.attenRelToWrap.setParamDefaults();
        this.saInterpParam.setValueAsDefault();
        this.periodInterpParam.setValueAsDefault();
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams = this.attenRelToWrap.getMeanIndependentParams();
        this.stdDevIndependentParams = this.attenRelToWrap.getStdDevIndependentParams();
        this.exceedProbIndependentParams = this.attenRelToWrap.getExceedProbIndependentParams();
        this.imlAtExceedProbIndependentParams = this.attenRelToWrap.getIML_AtExceedProbIndependentParams();
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        this.origPeriodParam = (PeriodParam)this.attenRelToWrap.getParameter("SA Period");
        this.periodInterpParam = new PeriodInterpolatedParam(this.origPeriodParam.getMinPeriod(), this.origPeriodParam.getMaxPeriod(), (double)((Double)this.origPeriodParam.getDefaultValue()), false);
        this.periodInterpParam.addParameterChangeListener(this);
        this.periodInterpParam.setValue((Double)this.origPeriodParam.getDefaultValue());
        this.saInterpParam = new SA_InterpolatedParam(this.periodInterpParam, new DampingParam());
        this.saInterpParam.setNonEditable();
        this.periods = this.origPeriodParam.getPeriods();
        this.saInterpParam.addParameterChangeWarningListener(this.listener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saInterpParam);
    }

    @Override
    protected void initSiteParams() {
    }

    @Override
    protected void initEqkRuptureParams() {
    }

    @Override
    protected void initPropagationEffectParams() {
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        String pName = e.getParameterName();
        Object val = e.getNewValue();
        if (pName.equals("SA Interpolated Period")) {
            this.period = (Double)val;
            this.intensityMeasureChanged = true;
        }
    }

    @Override
    public void resetParameterEventListeners() {
        this.attenRelToWrap.resetParameterEventListeners();
        this.initParameterEventListeners();
    }

    @Override
    protected void initParameterEventListeners() {
    }

    @Override
    public URL getInfoURL() throws MalformedURLException {
        return new URL(URL_INFO_STRING);
    }
}

