/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import org.opensha.commons.data.Named;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.IMRException;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.OtherParams.Component;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceJBParameter;

public class SEA_1999_AttenRel
extends AttenuationRelationship {
    private static final String C = "SEA_1999_AttenRel";
    private static final boolean D = false;
    public static final String NAME = "SEA (Spudich et al., 1999)";
    public static final String SHORT_NAME = "Spudich1999";
    private static final long serialVersionUID = 1234567890987654367L;
    protected static final Double MAG_WARN_MIN = 5.0;
    protected static final Double MAG_WARN_MAX = 7.7;
    protected static final Double DISTANCE_JB_WARN_MIN = 0.0;
    protected static final Double DISTANCE_JB_WARN_MAX = 100.0;
    private StringParameter siteTypeParam = null;
    public static final String SITE_TYPE_NAME = "SEA Site Type";
    public static final String SITE_TYPE_INFO = "Geological conditions at the site";
    public static final String SITE_TYPE_ROCK = "Rock";
    public static final String SITE_TYPE_SOIL = "Soil";
    public static final String SITE_TYPE_DEFAULT = "Rock";
    private double log2ln = 2.302585;
    private SEA_1999_AttenRelCoefficients coeff = null;
    protected Hashtable coefficients = new Hashtable();

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.magParam.setValueIgnoreWarning(eqkRupture.getMag());
        this.eqkRupture = eqkRupture;
        this.setPropagationEffectParams();
    }

    @Override
    public void setSite(Site site) throws ParameterException {
        this.siteTypeParam.setValue((String)site.getParameter(SITE_TYPE_NAME).getValue());
        this.site = site;
        this.setPropagationEffectParams();
    }

    @Override
    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceJBParam.setValue(this.eqkRupture, this.site);
        }
    }

    protected void updateCoefficients() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("SEA_1999_AttenRel: updateCoefficients(): The Intensity Measusre Parameter has not been set yet, unable to process.");
        }
        StringBuffer key = new StringBuffer(this.im.getName());
        if (this.im.getName().equalsIgnoreCase("SA")) {
            key.append("/" + String.valueOf(this.saPeriodParam.getValue()));
        }
        this.coeff = (SEA_1999_AttenRelCoefficients)this.coefficients.get(key.toString());
    }

    public SEA_1999_AttenRel(ParameterChangeWarningListener listener) {
        this.listener = listener;
        this.initCoefficients();
        this.initSupportedIntensityMeasureParams();
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
    }

    @Override
    public double getMean() throws IMRException {
        double distanceJB;
        String siteTypeValue;
        double mag;
        try {
            mag = (Double)this.magParam.getValue();
            siteTypeValue = (String)this.siteTypeParam.getValue();
            distanceJB = (Double)this.distanceJBParam.getValue();
        }
        catch (NullPointerException e) {
            throw new IMRException("SEA_1999_AttenRel: getMean(): Not all parameters have been set");
        }
        if (distanceJB > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        this.updateCoefficients();
        double mean = this.coeff.b1 + this.coeff.b2 * (mag - 6.0) + this.coeff.b3 * Math.pow(mag - 6.0, 2.0) + this.coeff.b5 * Math.log(Math.pow(distanceJB * distanceJB + this.coeff.h * this.coeff.h, 0.5)) / this.log2ln;
        if (siteTypeValue.equals(SITE_TYPE_SOIL)) {
            mean += this.coeff.b6;
        }
        mean *= this.log2ln;
        if (this.im.getName().equals("SA") && this.coeff.period != 0.0) {
            mean += Math.log(Math.PI * 2 / (this.coeff.period * 980.0));
        }
        return mean;
    }

    @Override
    public double getStdDev() throws IMRException {
        String stdDevType = ((String)this.stdDevTypeParam.getValue()).toString();
        Component component = (Component)this.componentParam.getValue();
        this.updateCoefficients();
        if (component == Component.AVE_HORZ) {
            if (stdDevType.equals("Total")) {
                return this.log2ln * Math.pow(this.coeff.sigma1 * this.coeff.sigma1 + this.coeff.sigma2 * this.coeff.sigma2, 0.5);
            }
            if (stdDevType.equals("Inter-Event")) {
                return this.log2ln * this.coeff.sigma2;
            }
            if (stdDevType.equals("Intra-Event")) {
                return this.log2ln * this.coeff.sigma1;
            }
            if (stdDevType.equals("None (zero)")) {
                return 0.0;
            }
            throw new ParameterException("SEA_1999_AttenRel: getStdDev(): Invalid StdDevType");
        }
        if (component == Component.RANDOM_HORZ) {
            if (stdDevType.equals("Total")) {
                return this.log2ln * Math.pow(this.coeff.sigma1 * this.coeff.sigma1 + this.coeff.sigma2 * this.coeff.sigma2 + this.coeff.sigma3 * this.coeff.sigma3, 0.5);
            }
            if (stdDevType.equals("Inter-Event")) {
                return this.log2ln * this.coeff.sigma2;
            }
            if (stdDevType.equals("Intra-Event")) {
                return this.log2ln * Math.pow(this.coeff.sigma1 * this.coeff.sigma1 + this.coeff.sigma3 * this.coeff.sigma3, 0.5);
            }
            if (stdDevType.equals("None (zero)")) {
                return 0.0;
            }
            throw new ParameterException("SEA_1999_AttenRel: getStdDev(): Invalid StdDevType");
        }
        throw new ParameterException("SEA_1999_AttenRel: getStdDev(): Invalid component type");
    }

    @Override
    public void setParamDefaults() {
        this.siteTypeParam.setValue("Rock");
        this.magParam.setValueAsDefault();
        this.distanceJBParam.setValueAsDefault();
        this.saParam.setValueAsDefault();
        this.saPeriodParam.setValueAsDefault();
        this.saDampingParam.setValueAsDefault();
        this.pgaParam.setValueAsDefault();
        this.componentParam.setValueAsDefault();
        this.stdDevTypeParam.setValueAsDefault();
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.distanceJBParam);
        this.meanIndependentParams.addParameter(this.siteTypeParam);
        this.meanIndependentParams.addParameter(this.magParam);
        this.meanIndependentParams.addParameter(this.componentParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameter(this.stdDevTypeParam);
        this.stdDevIndependentParams.addParameter(this.componentParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameter(this.distanceJBParam);
        this.exceedProbIndependentParams.addParameter(this.siteTypeParam);
        this.exceedProbIndependentParams.addParameter(this.magParam);
        this.exceedProbIndependentParams.addParameter(this.componentParam);
        this.exceedProbIndependentParams.addParameter(this.stdDevTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    @Override
    protected void initSiteParams() {
        StringConstraint siteConstraint = new StringConstraint();
        siteConstraint.addString("Rock");
        siteConstraint.addString(SITE_TYPE_SOIL);
        siteConstraint.setNonEditable();
        this.siteTypeParam = new StringParameter(SITE_TYPE_NAME, siteConstraint, null);
        this.siteTypeParam.setInfo(SITE_TYPE_INFO);
        this.siteTypeParam.setNonEditable();
        this.siteParams.clear();
        this.siteParams.addParameter(this.siteTypeParam);
    }

    @Override
    protected void initEqkRuptureParams() {
        this.magParam = new MagParam(MAG_WARN_MIN, (double)MAG_WARN_MAX);
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
    }

    @Override
    protected void initPropagationEffectParams() {
        this.distanceJBParam = new DistanceJBParameter(0.0);
        this.distanceJBParam.addParameterChangeWarningListener(this.listener);
        DoubleConstraint warn = new DoubleConstraint(DISTANCE_JB_WARN_MIN, DISTANCE_JB_WARN_MAX);
        warn.setNonEditable();
        this.distanceJBParam.setWarningConstraint(warn);
        this.distanceJBParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceJBParam);
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        DoubleDiscreteConstraint periodConstraint = new DoubleDiscreteConstraint();
        TreeSet<Double> set = new TreeSet<Double>();
        Enumeration keys = this.coefficients.keys();
        while (keys.hasMoreElements()) {
            SEA_1999_AttenRelCoefficients coeff = (SEA_1999_AttenRelCoefficients)this.coefficients.get(keys.nextElement());
            if (!(coeff.period >= 0.0)) continue;
            set.add(coeff.period);
        }
        Iterator it = set.iterator();
        while (it.hasNext()) {
            periodConstraint.addDouble((Double)it.next());
        }
        periodConstraint.setNonEditable();
        this.saPeriodParam = new PeriodParam(periodConstraint);
        this.saDampingParam = new DampingParam();
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saParam.setNonEditable();
        this.pgaParam = new PGA_Param();
        this.pgaParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.listener);
        this.pgaParam.addParameterChangeWarningListener(this.listener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        this.componentParam = new ComponentParam(Component.AVE_HORZ, Component.AVE_HORZ, Component.RANDOM_HORZ);
        StringConstraint stdDevTypeConstraint = new StringConstraint();
        stdDevTypeConstraint.addString("Total");
        stdDevTypeConstraint.addString("Inter-Event");
        stdDevTypeConstraint.addString("Intra-Event");
        stdDevTypeConstraint.addString("None (zero)");
        stdDevTypeConstraint.setNonEditable();
        this.stdDevTypeParam = new StdDevTypeParam(stdDevTypeConstraint);
        this.otherParams.addParameter(this.componentParam);
        this.otherParams.addParameter(this.stdDevTypeParam);
    }

    private void runTest() {
        double per;
        this.setParamDefaults();
        System.out.println("\nRepreduction of Table 3:");
        for (double mag = 5.5; mag <= 7.5; mag += 1.0) {
            this.magParam.setValue(mag);
            for (double dist = 0.0; dist <= 70.0; dist += 70.0) {
                this.distanceJBParam.setValue(dist);
                this.siteTypeParam.setValue("Rock");
                System.out.print(mag + "\t" + dist + "\tRock");
                this.setIntensityMeasure("PGA");
                System.out.print("\t" + (float)Math.exp(this.getMean()));
                this.setIntensityMeasure("SA");
                per = 0.1;
                this.saPeriodParam.setValue(per);
                System.out.print("\t" + (float)(Math.exp(this.getMean()) * (980.0 * per) / (Math.PI * 2)));
                this.setIntensityMeasure("SA");
                per = 0.5;
                this.saPeriodParam.setValue(per);
                System.out.print("\t" + (float)(Math.exp(this.getMean()) * (980.0 * per) / (Math.PI * 2)));
                this.setIntensityMeasure("SA");
                per = 2.0;
                this.saPeriodParam.setValue(per);
                System.out.print("\t" + (float)(Math.exp(this.getMean()) * (980.0 * per) / (Math.PI * 2)) + "\n");
                this.siteTypeParam.setValue(SITE_TYPE_SOIL);
                System.out.print(mag + "\t" + dist + "\tSoil");
                this.setIntensityMeasure("PGA");
                System.out.print("\t" + (float)Math.exp(this.getMean()));
                this.setIntensityMeasure("SA");
                per = 0.1;
                this.saPeriodParam.setValue(per);
                System.out.print("\t" + (float)(Math.exp(this.getMean()) * (980.0 * per) / (Math.PI * 2)));
                this.setIntensityMeasure("SA");
                per = 0.5;
                this.saPeriodParam.setValue(per);
                System.out.print("\t" + (float)(Math.exp(this.getMean()) * (980.0 * per) / (Math.PI * 2)));
                this.setIntensityMeasure("SA");
                per = 2.0;
                this.saPeriodParam.setValue(per);
                System.out.print("\t" + (float)(Math.exp(this.getMean()) * (980.0 * per) / (Math.PI * 2)) + "\n");
            }
        }
        System.out.print("sigma_ave_horz\t\t");
        this.setIntensityMeasure("PGA");
        System.out.print("\t" + (float)(this.getStdDev() / this.log2ln));
        this.setIntensityMeasure("SA");
        per = 0.1;
        this.saPeriodParam.setValue(per);
        System.out.print("\t" + (float)(this.getStdDev() / this.log2ln));
        this.setIntensityMeasure("SA");
        per = 0.5;
        this.saPeriodParam.setValue(per);
        System.out.print("\t" + (float)(this.getStdDev() / this.log2ln));
        this.setIntensityMeasure("SA");
        per = 2.0;
        this.saPeriodParam.setValue(per);
        System.out.print("\t" + (float)(this.getStdDev() / this.log2ln) + "\n");
        System.out.print("sigma_rand_horz\t\t");
        this.componentParam.setValue(Component.RANDOM_HORZ);
        this.setIntensityMeasure("PGA");
        System.out.print("\t" + (float)(this.getStdDev() / this.log2ln));
        this.setIntensityMeasure("SA");
        per = 0.1;
        this.saPeriodParam.setValue(per);
        System.out.print("\t" + (float)(this.getStdDev() / this.log2ln));
        this.setIntensityMeasure("SA");
        per = 0.5;
        this.saPeriodParam.setValue(per);
        System.out.print("\t" + (float)(this.getStdDev() / this.log2ln));
        this.setIntensityMeasure("SA");
        per = 2.0;
        this.saPeriodParam.setValue(per);
        System.out.print("\t" + (float)(this.getStdDev() / this.log2ln));
    }

    public static void main(String[] args) {
        new SEA_1999_AttenRel(null);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    protected void initCoefficients() {
        String S = "SEA_1999_AttenRel: initCoefficients():";
        this.coefficients.clear();
        SEA_1999_AttenRelCoefficients coeff = new SEA_1999_AttenRelCoefficients("PGA", 0.0, 0.299, 0.229, 0.0, -1.052, 0.112, 7.27, 0.172, 0.108, 0.094);
        SEA_1999_AttenRelCoefficients coeff0 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.00"), 0.0, 0.299, 0.229, 0.0, -1.052, 0.112, 7.27, 0.172, 0.108, 0.094);
        SEA_1999_AttenRelCoefficients coeff1 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.100"), 0.1, 2.144, 0.327, -0.098, -1.25, 0.064, 9.99, 0.205, 0.181, 0.11);
        SEA_1999_AttenRelCoefficients coeff2 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.110"), 0.11, 2.155, 0.318, -0.1, -1.207, 0.064, 9.84, 0.205, 0.168, 0.111);
        SEA_1999_AttenRelCoefficients coeff3 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.120"), 0.12, 2.165, 0.313, -0.101, -1.173, 0.065, 9.69, 0.204, 0.156, 0.113);
        SEA_1999_AttenRelCoefficients coeff4 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.130"), 0.13, 2.174, 0.309, -0.101, -1.145, 0.067, 9.54, 0.205, 0.146, 0.114);
        SEA_1999_AttenRelCoefficients coeff5 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.140"), 0.14, 2.183, 0.307, -0.1, -1.122, 0.069, 9.39, 0.205, 0.137, 0.115);
        SEA_1999_AttenRelCoefficients coeff6 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.150"), 0.15, 2.191, 0.305, -0.099, -1.103, 0.072, 9.25, 0.205, 0.129, 0.116);
        SEA_1999_AttenRelCoefficients coeff7 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.160"), 0.16, 2.199, 0.305, -0.098, -1.088, 0.075, 9.12, 0.206, 0.122, 0.117);
        SEA_1999_AttenRelCoefficients coeff8 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.170"), 0.17, 2.206, 0.305, -0.096, -1.075, 0.078, 8.99, 0.207, 0.116, 0.118);
        SEA_1999_AttenRelCoefficients coeff9 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.180"), 0.18, 2.212, 0.306, -0.094, -1.064, 0.081, 8.86, 0.208, 0.11, 0.119);
        SEA_1999_AttenRelCoefficients coeff10 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.190"), 0.19, 2.218, 0.308, -0.092, -1.055, 0.085, 8.74, 0.209, 0.105, 0.119);
        SEA_1999_AttenRelCoefficients coeff11 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.200"), 0.2, 2.224, 0.309, -0.09, -1.047, 0.088, 8.63, 0.21, 0.1, 0.12);
        SEA_1999_AttenRelCoefficients coeff12 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.220"), 0.22, 2.234, 0.313, -0.086, -1.036, 0.095, 8.41, 0.212, 0.092, 0.121);
        SEA_1999_AttenRelCoefficients coeff13 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.240"), 0.24, 2.242, 0.318, -0.082, -1.029, 0.102, 8.22, 0.214, 0.086, 0.122);
        SEA_1999_AttenRelCoefficients coeff14 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.260"), 0.26, 2.25, 0.323, -0.078, -1.024, 0.108, 8.04, 0.216, 0.081, 0.123);
        SEA_1999_AttenRelCoefficients coeff15 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.280"), 0.28, 2.257, 0.329, -0.073, -1.021, 0.115, 7.87, 0.218, 0.076, 0.124);
        SEA_1999_AttenRelCoefficients coeff16 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.300"), 0.3, 2.263, 0.334, -0.07, -1.02, 0.121, 7.72, 0.22, 0.073, 0.125);
        SEA_1999_AttenRelCoefficients coeff17 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.320"), 0.32, 2.268, 0.34, -0.066, -1.019, 0.126, 7.58, 0.221, 0.07, 0.126);
        SEA_1999_AttenRelCoefficients coeff18 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.340"), 0.34, 2.272, 0.345, -0.062, -1.02, 0.132, 7.45, 0.223, 0.067, 0.126);
        SEA_1999_AttenRelCoefficients coeff19 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.360"), 0.36, 2.276, 0.35, -0.059, -1.021, 0.137, 7.33, 0.225, 0.065, 0.127);
        SEA_1999_AttenRelCoefficients coeff20 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.380"), 0.38, 2.279, 0.356, -0.055, -1.023, 0.142, 7.22, 0.227, 0.064, 0.128);
        SEA_1999_AttenRelCoefficients coeff21 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.400"), 0.4, 2.282, 0.361, -0.052, -1.025, 0.147, 7.11, 0.228, 0.063, 0.128);
        SEA_1999_AttenRelCoefficients coeff22 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.420"), 0.42, 2.285, 0.365, -0.049, -1.027, 0.151, 7.02, 0.23, 0.062, 0.129);
        SEA_1999_AttenRelCoefficients coeff23 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.440"), 0.44, 2.287, 0.37, -0.047, -1.03, 0.155, 6.93, 0.231, 0.061, 0.129);
        SEA_1999_AttenRelCoefficients coeff24 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.460"), 0.46, 2.289, 0.375, -0.044, -1.032, 0.159, 6.85, 0.233, 0.061, 0.129);
        SEA_1999_AttenRelCoefficients coeff25 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.480"), 0.48, 2.291, 0.379, -0.042, -1.035, 0.163, 6.77, 0.234, 0.06, 0.13);
        SEA_1999_AttenRelCoefficients coeff26 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.500"), 0.5, 2.292, 0.384, -0.039, -1.038, 0.166, 6.7, 0.235, 0.061, 0.13);
        SEA_1999_AttenRelCoefficients coeff27 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.550"), 0.55, 2.294, 0.394, -0.034, -1.044, 0.174, 6.55, 0.238, 0.061, 0.131);
        SEA_1999_AttenRelCoefficients coeff28 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.600"), 0.6, 2.295, 0.403, -0.03, -1.051, 0.181, 6.42, 0.241, 0.063, 0.132);
        SEA_1999_AttenRelCoefficients coeff29 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.650"), 0.65, 2.295, 0.411, -0.026, -1.057, 0.187, 6.32, 0.243, 0.065, 0.132);
        SEA_1999_AttenRelCoefficients coeff30 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.700"), 0.7, 2.294, 0.418, -0.023, -1.062, 0.192, 6.23, 0.245, 0.068, 0.133);
        SEA_1999_AttenRelCoefficients coeff31 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.750"), 0.75, 2.292, 0.425, -0.02, -1.067, 0.197, 6.17, 0.247, 0.071, 0.133);
        SEA_1999_AttenRelCoefficients coeff32 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.800"), 0.8, 2.29, 0.431, -0.018, -1.071, 0.2, 6.11, 0.249, 0.074, 0.134);
        SEA_1999_AttenRelCoefficients coeff33 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.850"), 0.85, 2.287, 0.437, -0.016, -1.075, 0.203, 6.07, 0.25, 0.077, 0.134);
        SEA_1999_AttenRelCoefficients coeff34 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.900"), 0.9, 2.284, 0.442, -0.015, -1.078, 0.206, 6.04, 0.251, 0.081, 0.134);
        SEA_1999_AttenRelCoefficients coeff35 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("0.950"), 0.95, 2.28, 0.446, -0.014, -1.081, 0.208, 6.02, 0.253, 0.085, 0.135);
        SEA_1999_AttenRelCoefficients coeff36 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("1.000"), 1.0, 2.276, 0.45, -0.014, -1.083, 0.21, 6.01, 0.254, 0.089, 0.135);
        SEA_1999_AttenRelCoefficients coeff37 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("1.100"), 1.1, 2.267, 0.457, -0.013, -1.085, 0.213, 6.01, 0.255, 0.097, 0.135);
        SEA_1999_AttenRelCoefficients coeff38 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("1.200"), 1.2, 2.258, 0.462, -0.014, -1.086, 0.214, 6.03, 0.257, 0.106, 0.136);
        SEA_1999_AttenRelCoefficients coeff39 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("1.300"), 1.3, 2.248, 0.466, -0.015, -1.085, 0.214, 6.07, 0.258, 0.115, 0.136);
        SEA_1999_AttenRelCoefficients coeff40 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("1.400"), 1.4, 2.237, 0.469, -0.017, -1.083, 0.213, 6.13, 0.258, 0.123, 0.136);
        SEA_1999_AttenRelCoefficients coeff41 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("1.500"), 1.5, 2.226, 0.471, -0.019, -1.079, 0.212, 6.21, 0.259, 0.132, 0.137);
        SEA_1999_AttenRelCoefficients coeff42 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("1.600"), 1.6, 2.215, 0.472, -0.022, -1.075, 0.21, 6.29, 0.259, 0.141, 0.137);
        SEA_1999_AttenRelCoefficients coeff43 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("1.700"), 1.7, 2.203, 0.473, -0.025, -1.07, 0.207, 6.39, 0.259, 0.15, 0.137);
        SEA_1999_AttenRelCoefficients coeff44 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("1.800"), 1.8, 2.192, 0.472, -0.029, -1.063, 0.204, 6.49, 0.259, 0.158, 0.137);
        SEA_1999_AttenRelCoefficients coeff45 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("1.900"), 1.9, 2.18, 0.472, -0.032, -1.056, 0.201, 6.6, 0.258, 0.167, 0.137);
        SEA_1999_AttenRelCoefficients coeff46 = new SEA_1999_AttenRelCoefficients("SA/" + Double.valueOf("2.000"), 2.0, 2.168, 0.471, -0.037, -1.049, 0.197, 6.71, 0.258, 0.175, 0.137);
        this.coefficients.put(coeff.getName(), coeff);
        this.coefficients.put(coeff0.getName(), coeff0);
        this.coefficients.put(coeff1.getName(), coeff1);
        this.coefficients.put(coeff2.getName(), coeff2);
        this.coefficients.put(coeff3.getName(), coeff3);
        this.coefficients.put(coeff4.getName(), coeff4);
        this.coefficients.put(coeff5.getName(), coeff5);
        this.coefficients.put(coeff6.getName(), coeff6);
        this.coefficients.put(coeff7.getName(), coeff7);
        this.coefficients.put(coeff8.getName(), coeff8);
        this.coefficients.put(coeff9.getName(), coeff9);
        this.coefficients.put(coeff10.getName(), coeff10);
        this.coefficients.put(coeff11.getName(), coeff11);
        this.coefficients.put(coeff12.getName(), coeff12);
        this.coefficients.put(coeff13.getName(), coeff13);
        this.coefficients.put(coeff14.getName(), coeff14);
        this.coefficients.put(coeff15.getName(), coeff15);
        this.coefficients.put(coeff16.getName(), coeff16);
        this.coefficients.put(coeff17.getName(), coeff17);
        this.coefficients.put(coeff18.getName(), coeff18);
        this.coefficients.put(coeff19.getName(), coeff19);
        this.coefficients.put(coeff20.getName(), coeff20);
        this.coefficients.put(coeff21.getName(), coeff21);
        this.coefficients.put(coeff22.getName(), coeff22);
        this.coefficients.put(coeff23.getName(), coeff23);
        this.coefficients.put(coeff24.getName(), coeff24);
        this.coefficients.put(coeff25.getName(), coeff25);
        this.coefficients.put(coeff26.getName(), coeff26);
        this.coefficients.put(coeff27.getName(), coeff27);
        this.coefficients.put(coeff28.getName(), coeff28);
        this.coefficients.put(coeff29.getName(), coeff29);
        this.coefficients.put(coeff30.getName(), coeff30);
        this.coefficients.put(coeff31.getName(), coeff31);
        this.coefficients.put(coeff32.getName(), coeff32);
        this.coefficients.put(coeff33.getName(), coeff33);
        this.coefficients.put(coeff34.getName(), coeff34);
        this.coefficients.put(coeff35.getName(), coeff35);
        this.coefficients.put(coeff36.getName(), coeff36);
        this.coefficients.put(coeff37.getName(), coeff37);
        this.coefficients.put(coeff38.getName(), coeff38);
        this.coefficients.put(coeff39.getName(), coeff39);
        this.coefficients.put(coeff40.getName(), coeff40);
        this.coefficients.put(coeff41.getName(), coeff41);
        this.coefficients.put(coeff42.getName(), coeff42);
        this.coefficients.put(coeff43.getName(), coeff43);
        this.coefficients.put(coeff44.getName(), coeff44);
        this.coefficients.put(coeff45.getName(), coeff45);
        this.coefficients.put(coeff46.getName(), coeff46);
    }

    @Override
    public URL getInfoURL() throws MalformedURLException {
        return new URL("http://www.opensha.org/glossary-attenuationRelation-SPUDICH_ETAL_1999");
    }

    class SEA_1999_AttenRelCoefficients
    implements Named {
        protected static final String C = "SEA_1999_AttenRelCoefficients";
        protected static final boolean D = false;
        private static final long serialVersionUID = 1234567890987654329L;
        protected String name;
        protected double period = -1.0;
        protected double b1;
        protected double b2;
        protected double b3;
        protected double b5;
        protected double b6;
        protected double h;
        protected double sigma1;
        protected double sigma2;
        protected double sigma3;

        public SEA_1999_AttenRelCoefficients(String name, double period, double b1, double b2, double b3, double b5, double b6, double h, double sigma1, double sigma2, double sigma3) {
            this.name = name;
            this.period = period;
            this.b1 = b1;
            this.b2 = b2;
            this.b3 = b3;
            this.b5 = b5;
            this.b6 = b6;
            this.h = h;
            this.sigma1 = sigma1;
            this.sigma2 = sigma2;
            this.sigma3 = sigma3;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            b.append(C);
            b.append("\n  Name = " + this.name);
            b.append("\n  Period = " + this.period);
            b.append("\n  b1 = " + this.b1);
            b.append("\n  b2 = " + this.b2);
            b.append("\n  b3 = " + this.b3);
            b.append("\n  b5 = " + this.b5);
            b.append("\n  b6 = " + this.b6);
            b.append("\n  h = " + this.h);
            b.append("\n  sigma1 = " + this.sigma1);
            b.append("\n  sigma2 = " + this.sigma2);
            b.append("\n  sigma3 = " + this.sigma3);
            return b.toString();
        }
    }
}

