/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl.ngaw2;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import org.opensha.commons.geo.GeoTools;
import org.opensha.sha.imr.attenRelImpl.ngaw2.Coefficients;
import org.opensha.sha.imr.attenRelImpl.ngaw2.DefaultGroundMotion;
import org.opensha.sha.imr.attenRelImpl.ngaw2.FaultStyle;
import org.opensha.sha.imr.attenRelImpl.ngaw2.IMT;
import org.opensha.sha.imr.attenRelImpl.ngaw2.NGAW2_GMM;
import org.opensha.sha.imr.attenRelImpl.ngaw2.ScalarGroundMotion;
import org.opensha.sha.util.TectonicRegionType;

public class CB_2014
implements NGAW2_GMM {
    public static final String NAME = "Campbell & Bozorgnia (2014)";
    public static final String SHORT_NAME = "CB2014";
    private final Coeffs coeffs;
    private final Coeffs coeffsPGA;
    private static final Set<IMT> SHORT_PERIODS = EnumSet.range(IMT.SA0P01, IMT.SA0P25);
    private static final double H4 = 1.0;
    private static final double C = 1.88;
    private static final double N = 1.18;
    private static final double PHI_LNAF_SQ = 0.09;
    private IMT imt = null;
    private double Mw = Double.NaN;
    private double rJB = Double.NaN;
    private double rRup = Double.NaN;
    private double rX = Double.NaN;
    private double dip = Double.NaN;
    private double width = Double.NaN;
    private double zTop = Double.NaN;
    private double zHyp = Double.NaN;
    private double vs30 = Double.NaN;
    private double z2p5 = Double.NaN;
    private FaultStyle style = FaultStyle.UNKNOWN;

    public CB_2014() {
        this.coeffs = new Coeffs();
        this.coeffsPGA = new Coeffs();
    }

    @Override
    public ScalarGroundMotion calc() {
        return this.calc(this.imt, this.Mw, this.rJB, this.rRup, this.rX, this.dip, this.width, this.zTop, this.zHyp, this.vs30, this.z2p5, this.style);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void set_IMT(IMT imt) {
        this.imt = imt;
    }

    @Override
    public void set_Mw(double Mw) {
        this.Mw = Mw;
    }

    @Override
    public void set_rJB(double rJB) {
        this.rJB = rJB;
    }

    @Override
    public void set_rRup(double rRup) {
        this.rRup = rRup;
    }

    @Override
    public void set_rX(double rX) {
        this.rX = rX;
    }

    @Override
    public void set_dip(double dip) {
        this.dip = dip;
    }

    @Override
    public void set_width(double width) {
        this.width = width;
    }

    @Override
    public void set_zTop(double zTop) {
        this.zTop = zTop;
    }

    @Override
    public void set_zHyp(double zHyp) {
        this.zHyp = zHyp;
    }

    @Override
    public void set_vs30(double vs30) {
        this.vs30 = vs30;
    }

    @Override
    public void set_vsInf(boolean vsInf) {
    }

    @Override
    public void set_z2p5(double z2p5) {
        this.z2p5 = z2p5;
    }

    @Override
    public void set_z1p0(double z1p0) {
    }

    @Override
    public void set_fault(FaultStyle style) {
        this.style = style;
    }

    @Override
    public TectonicRegionType get_TRT() {
        return TectonicRegionType.ACTIVE_SHALLOW;
    }

    @Override
    public Collection<IMT> getSupportedIMTs() {
        return this.coeffs.getSupportedIMTs();
    }

    public final ScalarGroundMotion calc(IMT imt, double Mw, double rJB, double rRup, double rX, double dip, double width, double zTop, double zHyp, double vs30, double z2p5, FaultStyle style) {
        this.coeffs.set(imt);
        double pgaRock = vs30 < this.coeffs.k1 ? Math.exp(CB_2014.calcMean(this.coeffsPGA, Mw, rJB, rRup, rX, dip, width, zTop, zHyp, 1100.0, 0.398, style, 0.0)) : 0.0;
        double mean = CB_2014.calcMean(this.coeffs, Mw, rJB, rRup, rX, dip, width, zTop, zHyp, vs30, z2p5, style, pgaRock);
        if (SHORT_PERIODS.contains((Object)imt)) {
            double pgaMean = CB_2014.calcMean(this.coeffsPGA, Mw, rJB, rRup, rX, dip, width, zTop, zHyp, vs30, z2p5, style, pgaRock);
            mean = Math.max(mean, pgaMean);
        }
        double alpha = CB_2014.calcAlpha(this.coeffs, vs30, pgaRock);
        double phiSq = CB_2014.calcPhiSq(this.coeffs, Mw, alpha);
        double tauSq = CB_2014.calcTauSq(this.coeffs, Mw, alpha);
        double stdDev = CB_2014.calcStdDev(phiSq, tauSq);
        return new DefaultGroundMotion(mean, stdDev, Math.sqrt(phiSq), Math.sqrt(tauSq));
    }

    private static final double calcMean(Coeffs c, double Mw, double rJB, double rRup, double rX, double dip, double width, double zTop, double zHyp, double vs30, double z2p5, FaultStyle style, double pgaRock) {
        double Fhyp;
        double Fsite;
        double Fmag = c.c0 + c.c1 * Mw;
        if (Mw > 6.5) {
            Fmag += c.c2 * (Mw - 4.5) + c.c3 * (Mw - 5.5) + c.c4 * (Mw - 6.5);
        } else if (Mw > 5.5) {
            Fmag += c.c2 * (Mw - 4.5) + c.c3 * (Mw - 5.5);
        } else if (Mw > 4.5) {
            Fmag += c.c2 * (Mw - 4.5);
        }
        double r = Math.sqrt(rRup * rRup + c.c7 * c.c7);
        double Fr = (c.c5 + c.c6 * Mw) * Math.log(r);
        double Fflt = 0.0;
        if (style == FaultStyle.NORMAL && Mw > 4.5) {
            Fflt = c.c9;
            if (Mw <= 5.5) {
                Fflt *= Mw - 4.5;
            }
        }
        double Fhw = 0.0;
        if (rX >= 0.0 && Mw > 5.5 && zTop <= 16.66) {
            double r1 = width * Math.cos(dip * GeoTools.TO_RAD);
            double r2 = 62.0 * Mw - 350.0;
            double rXr1 = rX / r1;
            double rXr2r1 = (rX - r1) / (r2 - r1);
            double f1_rX = c.h1 + c.h2 * rXr1 + c.h3 * (rXr1 * rXr1);
            double f2_rX = 1.0 + c.h5 * rXr2r1 + c.h6 * rXr2r1 * rXr2r1;
            double Fhw_rX = rX >= r1 ? Math.max(f2_rX, 0.0) : f1_rX;
            double Fhw_rRup = rRup == 0.0 ? 1.0 : (rRup - rJB) / rRup;
            double Fhw_m = 1.0 + c.a2 * (Mw - 6.5);
            if (Mw <= 6.5) {
                Fhw_m *= Mw - 5.5;
            }
            double Fhw_z = 1.0 - 0.06 * zTop;
            double Fhw_d = (90.0 - dip) / 45.0;
            Fhw = c.c10 * Fhw_rX * Fhw_rRup * Fhw_m * Fhw_z * Fhw_d;
        }
        double vsk1 = vs30 / c.k1;
        double d = Fsite = vs30 <= c.k1 ? c.c11 * Math.log(vsk1) + c.k2 * (Math.log(pgaRock + 1.88 * Math.pow(vsk1, 1.18)) - Math.log(pgaRock + 1.88)) : (c.c11 + c.k2 * 1.18) * Math.log(vsk1);
        if (Double.isNaN(z2p5)) {
            z2p5 = CB_2014.calcZ25ref(vs30);
        }
        double Fsed = 0.0;
        if (z2p5 <= 1.0) {
            Fsed = c.c14 * (z2p5 - 1.0);
        } else if (z2p5 > 3.0) {
            Fsed = c.c16 * c.k3 * Math.exp(-0.75) * (1.0 - Math.exp(-0.25 * (z2p5 - 3.0)));
        }
        double d2 = zHyp <= 7.0 ? 0.0 : (Fhyp = zHyp <= 20.0 ? zHyp - 7.0 : 13.0);
        Fhyp = Mw <= 5.5 ? (Fhyp *= c.c17) : (Mw <= 6.5 ? (Fhyp *= c.c17 + (c.c18 - c.c17) * (Mw - 5.5)) : (Fhyp *= c.c18));
        double Fdip = Mw > 5.5 ? 0.0 : (Mw > 4.5 ? c.c19 * (5.5 - Mw) * dip : c.c19 * dip);
        double Fatn = rRup > 80.0 ? c.c20 * (rRup - 80.0) : 0.0;
        return Fmag + Fr + Fflt + Fhw + Fsite + Fsed + Fhyp + Fdip + Fatn;
    }

    public static double calcZ25ref(double vs30) {
        return Math.exp(7.089 - 1.144 * Math.log(vs30));
    }

    private static final double calcStdDev(Coeffs c, double Mw, double vs30, double pgaRock) {
        double alpha = CB_2014.calcAlpha(c, vs30, pgaRock);
        double tauSq = CB_2014.calcTauSq(c, Mw, alpha);
        double phiSq = CB_2014.calcPhiSq(c, Mw, alpha);
        return CB_2014.calcStdDev(phiSq, tauSq);
    }

    private static final double calcStdDev(double phiSq, double tauSq) {
        return Math.sqrt(phiSq + tauSq);
    }

    private static double calcAlpha(Coeffs c, double vs30, double pgaRock) {
        double vsk1 = vs30 / c.k1;
        double alpha = vs30 < c.k1 ? c.k2 * pgaRock * (1.0 / (pgaRock + 1.88 * Math.pow(vsk1, 1.18)) - 1.0 / (pgaRock + 1.88)) : 0.0;
        return alpha;
    }

    private static double calcPhiSq(Coeffs c, double Mw, double alpha) {
        double phi_lnPGAB;
        double phi_lnY;
        if (Mw <= 4.5) {
            phi_lnY = c.phi1;
            phi_lnPGAB = c.phi_lo_PGA;
        } else if (Mw < 5.5) {
            phi_lnY = CB_2014.stdMagDep(c.phi1, c.phi2, Mw);
            phi_lnPGAB = CB_2014.stdMagDep(c.phi_lo_PGA, c.phi_hi_PGA, Mw);
        } else {
            phi_lnY = c.phi2;
            phi_lnPGAB = c.phi_hi_PGA;
        }
        double phi_lnYB = Math.sqrt(phi_lnY * phi_lnY - 0.09);
        phi_lnPGAB = Math.sqrt(phi_lnPGAB * phi_lnPGAB - 0.09);
        double aPhi_lnPGAB = alpha * phi_lnPGAB;
        double phiSq = phi_lnY * phi_lnY + aPhi_lnPGAB * aPhi_lnPGAB + 2.0 * c.rho * phi_lnYB * aPhi_lnPGAB;
        return phiSq;
    }

    private static double calcTauSq(Coeffs c, double Mw, double alpha) {
        double tau_lnPGAB;
        double tau_lnYB;
        if (Mw <= 4.5) {
            tau_lnYB = c.tau1;
            tau_lnPGAB = c.tau_lo_PGA;
        } else if (Mw < 5.5) {
            tau_lnYB = CB_2014.stdMagDep(c.tau1, c.tau2, Mw);
            tau_lnPGAB = CB_2014.stdMagDep(c.tau_lo_PGA, c.tau_hi_PGA, Mw);
        } else {
            tau_lnYB = c.tau2;
            tau_lnPGAB = c.tau_hi_PGA;
        }
        double alphaTau = alpha * tau_lnPGAB;
        double tauSq = tau_lnYB * tau_lnYB + alphaTau * alphaTau + 2.0 * alpha * c.rho * tau_lnYB * tau_lnPGAB;
        return tauSq;
    }

    private static final double stdMagDep(double lo, double hi, double Mw) {
        return hi + (lo - hi) * (5.5 - Mw);
    }

    private static class Coeffs
    extends Coefficients {
        double c0;
        double c1;
        double c2;
        double c3;
        double c4;
        double c5;
        double c6;
        double c7;
        double c9;
        double c10;
        double c11;
        double c14;
        double c16;
        double c17;
        double c18;
        double c19;
        double c20;
        double a2;
        double h1;
        double h2;
        double h3;
        double h5;
        double h6;
        double k1;
        double k2;
        double k3;
        double phi1;
        double phi2;
        double tau1;
        double tau2;
        double rho;
        double c8;
        double c12;
        double c13;
        double c15;
        double h4;
        double c;
        double n;
        double phi_lnaf;
        double Dc20_CA;
        double Dc20_JP;
        double Dc20_CH;
        double phiC;
        double tau_hi_PGA;
        double tau_lo_PGA;
        double phi_hi_PGA;
        double phi_lo_PGA;

        Coeffs() {
            super("CB14.csv");
            this.set(IMT.PGA);
            this.tau_hi_PGA = this.get(IMT.PGA, "tau2");
            this.tau_lo_PGA = this.get(IMT.PGA, "tau1");
            this.phi_hi_PGA = this.get(IMT.PGA, "phi2");
            this.phi_lo_PGA = this.get(IMT.PGA, "phi1");
        }
    }
}

