/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl.ngaw2;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ArrayTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.opensha.sha.imr.attenRelImpl.ngaw2.IMT;

public abstract class Coefficients {
    private static final String C_DIR = "/data/imr/ngaw2/coeff/";
    private Table<IMT, String, Double> table;
    private IMT imt;
    public static final Function<String, Double> STR_2_DBL = StringToDouble.INSTANCE;

    public Coefficients(String resource) {
        this.table = this.load(resource);
    }

    public void set(IMT imt) {
        if (this.imt == imt) {
            return;
        }
        try {
            Preconditions.checkState((boolean)this.table.rowKeySet().contains((Object)imt), (String)"no coeff for %s", (Object)((Object)imt));
            for (String name : this.table.columnKeySet()) {
                double value = (Double)this.table.get((Object)imt, (Object)name);
                this.getClass().getDeclaredField(name).set(this, value);
            }
            this.imt = imt;
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public IMT imt() {
        return this.imt;
    }

    public double get(IMT imt, String name) {
        return (Double)this.table.get((Object)imt, (Object)name);
    }

    public Collection<IMT> getSupportedIMTs() {
        return this.table.rowKeySet();
    }

    private Table<IMT, String, Double> load(String resource) {
        Splitter split = Splitter.on((char)',');
        List lines = null;
        try {
            URL url = Coefficients.class.getResource(C_DIR + resource);
            lines = Resources.readLines((URL)url, (Charset)Charsets.US_ASCII);
        }
        catch (IOException ioe) {
            Throwables.propagate((Throwable)ioe);
        }
        Iterable nameList = split.split((CharSequence)lines.get(0));
        Iterable names = Iterables.skip((Iterable)nameList, (int)1);
        HashMap valueMap = Maps.newHashMap();
        for (String line : Iterables.skip((Iterable)lines, (int)1)) {
            Iterable entries = split.split((CharSequence)line);
            String imtStr = (String)Iterables.get((Iterable)entries, (int)0);
            IMT imt = IMT.parseIMT(imtStr);
            Preconditions.checkNotNull((Object)((Object)imt), (Object)("Unparseable IMT: " + imtStr));
            Iterable valStrs = Iterables.skip((Iterable)entries, (int)1);
            Iterable values = Iterables.transform((Iterable)valStrs, STR_2_DBL);
            valueMap.put(imt, (Double[])Iterables.toArray((Iterable)values, Double.class));
        }
        ArrayTable table = ArrayTable.create(valueMap.keySet(), (Iterable)names);
        for (IMT imt : valueMap.keySet()) {
            Double[] values = (Double[])valueMap.get((Object)imt);
            int i = 0;
            for (String name : names) {
                table.put((Object)imt, (Object)name, (Object)values[i++]);
            }
        }
        return table;
    }

    private static enum StringToDouble implements Function<String, Double>
    {
        INSTANCE;


        public Double apply(String s) {
            return Double.valueOf(s);
        }
    }
}

