/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl.nshmp;

import gov.usgs.earthquake.nshmp.gmm.GmmInput;
import java.util.BitSet;

class MutableGmmInputBuilder {
    private static GmmInput.Field[] FIELDS = GmmInput.Field.values();
    private static final int LEN = FIELDS.length;
    private double[] values = new double[LEN];
    private BitSet bitSet = new BitSet(LEN);

    MutableGmmInputBuilder() {
    }

    void setValue(GmmInput.Field field, double value) {
        int index = field.ordinal();
        this.values[index] = value;
        this.bitSet.set(index);
    }

    static double valueForField(GmmInput input, GmmInput.Field field) {
        switch (field) {
            case DIP: {
                return input.dip;
            }
            case MW: {
                return input.Mw;
            }
            case RAKE: {
                return input.rake;
            }
            case RJB: {
                return input.rJB;
            }
            case RRUP: {
                return input.rRup;
            }
            case RX: {
                return input.rX;
            }
            case VS30: {
                return input.vs30;
            }
            case WIDTH: {
                return input.width;
            }
            case Z1P0: {
                return input.z1p0;
            }
            case Z2P5: {
                return input.z2p5;
            }
            case ZHYP: {
                return input.zHyp;
            }
            case ZSED: {
                return input.zSed;
            }
            case ZTOR: {
                return input.zTor;
            }
        }
        throw new IllegalStateException("Unsupported field: " + String.valueOf(field));
    }

    void setAll(GmmInput input) {
        for (GmmInput.Field field : FIELDS) {
            this.setValue(field, MutableGmmInputBuilder.valueForField(input, field));
        }
    }

    GmmInput build() {
        GmmInput.Builder builder = GmmInput.builder();
        block15: for (int i = 0; i < LEN; ++i) {
            double val = this.bitSet.get(i) ? this.values[i] : Double.NaN;
            switch (FIELDS[i]) {
                case DIP: {
                    builder.dip(val);
                    continue block15;
                }
                case MW: {
                    builder.mag(val);
                    continue block15;
                }
                case RAKE: {
                    builder.rake(val);
                    continue block15;
                }
                case RJB: {
                    builder.rJB(val);
                    continue block15;
                }
                case RRUP: {
                    builder.rRup(val);
                    continue block15;
                }
                case RX: {
                    builder.rX(val);
                    continue block15;
                }
                case VS30: {
                    builder.vs30(val);
                    continue block15;
                }
                case WIDTH: {
                    builder.width(val);
                    continue block15;
                }
                case Z1P0: {
                    builder.z1p0(val);
                    continue block15;
                }
                case Z2P5: {
                    builder.z2p5(val);
                    continue block15;
                }
                case ZHYP: {
                    builder.zHyp(val);
                    continue block15;
                }
                case ZSED: {
                    builder.zSed(val);
                    continue block15;
                }
                case ZTOR: {
                    builder.zTor(val);
                    continue block15;
                }
                default: {
                    throw new IllegalStateException("Unsupported field: " + String.valueOf(FIELDS[i]));
                }
            }
        }
        return builder.build();
    }
}

