/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl.nshmp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import gov.usgs.earthquake.nshmp.gmm.Gmm;
import gov.usgs.earthquake.nshmp.gmm.GmmInput;
import gov.usgs.earthquake.nshmp.gmm.GroundMotion;
import gov.usgs.earthquake.nshmp.gmm.GroundMotionModel;
import gov.usgs.earthquake.nshmp.gmm.Imt;
import gov.usgs.earthquake.nshmp.tree.Branch;
import gov.usgs.earthquake.nshmp.tree.LogicTree;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.opensha.commons.calc.GaussianExceedProbCalculator;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.WeightedList;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.LightFixedXFunc;
import org.opensha.commons.exceptions.IMRException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.geo.GeoTools;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.sha.earthquake.DistCachedERFWrapper;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.gcim.imr.param.EqkRuptureParams.FocalDepthParam;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.attenRelImpl.nshmp.FieldParameterValueManager;
import org.opensha.sha.imr.attenRelImpl.nshmp.GroundMotionLogicTreeFilter;
import org.opensha.sha.imr.param.EqkRuptureParams.DipParam;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.EqkRuptureParams.RakeParam;
import org.opensha.sha.imr.param.EqkRuptureParams.RupTopDepthParam;
import org.opensha.sha.imr.param.EqkRuptureParams.RupWidthParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGD_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGV_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.OtherParams.Component;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceJBParameter;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceRupParameter;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceX_Parameter;
import org.opensha.sha.imr.param.SiteParams.DepthTo1pt0kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.DepthTo2pt5kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.SedimentThicknessParam;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;
import org.opensha.sha.util.TectonicRegionType;

public abstract class NSHMP_GMM_Wrapper
extends AttenuationRelationship
implements ParameterChangeListener {
    public static final String C = "NSHMP_GMM_WrapperFullParam";
    private String name;
    private String shortName;
    private ImmutableList<GmmInput.Field> fieldsUsedList;
    private EnumSet<GmmInput.Field> fields;
    private final boolean parameterize;
    private Component component;
    private GroundMotionLogicTreeFilter treeFilter;
    private Imt imt;
    private FieldParameterValueManager valueManager;
    private GmmInput gmmInput;
    private LogicTree<GroundMotion> gmTree;
    private boolean cacheInputsPerRupture = false;
    private Map<EqkRupture, GmmInput> perRuptureInputCache;
    private DistanceX_Parameter distanceXParam;
    private SedimentThicknessParam zSedParam;
    private String defaultIMT = null;
    private Double defaultPeriod = null;
    private GaussianExceedProbCalculator exceedCalc;

    protected NSHMP_GMM_Wrapper(String name, String shortName, boolean parameterize, Component component) {
        this.name = name;
        this.shortName = shortName;
        this.component = component;
        this.parameterize = parameterize;
    }

    protected void init() {
        this.fieldsUsedList = this.initFieldsUsed();
        this.fields = EnumSet.copyOf(this.fieldsUsedList);
        this.valueManager = new FieldParameterValueManager(this);
        this.initSupportedIntensityMeasureParams();
        this.initSiteParams();
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initOtherParams();
        this.initIndependentParamLists();
    }

    protected abstract ImmutableList<GmmInput.Field> initFieldsUsed();

    public List<GmmInput.Field> getFieldsUsed() {
        return this.fieldsUsedList;
    }

    public Imt getCurrentIMT() {
        if (this.imt == null) {
            String imName = this.im.getName();
            if (imName.equals("SA")) {
                this.imt = Imt.fromPeriod((double)SA_Param.getPeriodInSA_Param(this.im));
            } else if (imName.equals("PGA")) {
                this.imt = Imt.PGA;
            } else if (imName.equals("PGV")) {
                this.imt = Imt.PGV;
            } else if (imName.equals("PGD")) {
                this.imt = Imt.PGD;
            } else {
                throw new IllegalStateException("Unexpected IM: " + imName);
            }
        }
        return this.imt;
    }

    public abstract Gmm.Type getType();

    public TectonicRegionType getTRT() {
        Gmm.Type type = this.getType();
        if (type == null) {
            return null;
        }
        return NSHMP_GMM_Wrapper.trtForType(type);
    }

    public GmmInput getCurrentGmmInput() {
        if (this.gmmInput == null) {
            this.gmmInput = this.valueManager.getGmmInput();
        }
        return this.gmmInput;
    }

    public void setCurrentGmmInput(GmmInput gmmInput) {
        this.clearCachedGmmInputs();
        this.gmmInput = gmmInput;
        this.valueManager.setGmmInput(gmmInput);
    }

    public void setCacheInputsPerRupture(boolean cacheInputsPerRupture) {
        this.cacheInputsPerRupture = cacheInputsPerRupture;
    }

    public void copyPerRuptureCacheFrom(NSHMP_GMM_Wrapper other) {
        this.perRuptureInputCache = other.perRuptureInputCache;
    }

    public void setGroundMotionTreeFilter(GroundMotionLogicTreeFilter treeFilter) {
        this.treeFilter = treeFilter;
        this.clearCachedGmmInputs();
    }

    public GroundMotionLogicTreeFilter getGroundMotionTreeFilter() {
        return this.treeFilter;
    }

    protected abstract LogicTree<GroundMotion> buildGroundMotionTree();

    public LogicTree<GroundMotion> getGroundMotionTree() {
        if (this.gmTree != null) {
            return this.gmTree;
        }
        LogicTree<GroundMotion> gmTree = this.buildGroundMotionTree();
        if (this.treeFilter != null) {
            gmTree = this.treeFilter.filter(gmTree);
        }
        this.gmTree = gmTree;
        return gmTree;
    }

    @Override
    public double getMean() {
        return NSHMP_GMM_Wrapper.getWeightedMean(this.getGroundMotionTree());
    }

    public static double getWeightedMean(LogicTree<GroundMotion> gmTree) {
        if (gmTree.size() == 1) {
            return ((GroundMotion)((Branch)gmTree.get(0)).value()).mean();
        }
        double weightSum = 0.0;
        double valWeightSum = 0.0;
        for (Branch branch : gmTree) {
            weightSum += branch.weight();
            valWeightSum = Math.fma(branch.weight(), ((GroundMotion)branch.value()).mean(), valWeightSum);
        }
        if (weightSum == 1.0) {
            return valWeightSum;
        }
        return valWeightSum / weightSum;
    }

    @Override
    public double getStdDev() {
        return NSHMP_GMM_Wrapper.getWeightedStdDev(this.getGroundMotionTree());
    }

    public static double getWeightedStdDev(LogicTree<GroundMotion> gmTree) {
        if (gmTree.size() == 1) {
            return ((GroundMotion)((Branch)gmTree.get(0)).value()).sigma();
        }
        double weightSum = 0.0;
        double valWeightSum = 0.0;
        for (Branch branch : gmTree) {
            weightSum += branch.weight();
            valWeightSum = Math.fma(branch.weight(), ((GroundMotion)branch.value()).sigma(), valWeightSum);
        }
        if (weightSum == 1.0) {
            return valWeightSum;
        }
        return valWeightSum / weightSum;
    }

    @Override
    public DiscretizedFunc getExceedProbabilities(DiscretizedFunc intensityMeasureLevels) throws ParameterException {
        return NSHMP_GMM_Wrapper.getWeightedExceedProbabilities(this.getGroundMotionTree(), this.exceedCalc, intensityMeasureLevels);
    }

    public static DiscretizedFunc getWeightedExceedProbabilities(LogicTree<GroundMotion> gmTree, GaussianExceedProbCalculator exceedCalc, DiscretizedFunc intensityMeasureLevels) throws ParameterException {
        int i;
        double[] yVals;
        double[] xVals;
        int size = intensityMeasureLevels.size();
        double weightSum = 0.0;
        boolean first = true;
        if (intensityMeasureLevels instanceof LightFixedXFunc) {
            xVals = ((LightFixedXFunc)intensityMeasureLevels).getXVals();
            yVals = ((LightFixedXFunc)intensityMeasureLevels).getYVals();
        } else {
            xVals = new double[size];
            yVals = new double[size];
            for (i = 0; i < size; ++i) {
                xVals[i] = intensityMeasureLevels.getX(i);
            }
        }
        for (Branch branch : gmTree) {
            double weight = branch.weight();
            weightSum += weight;
            double mean = ((GroundMotion)branch.value()).mean();
            double invStdDev = 1.0 / ((GroundMotion)branch.value()).sigma();
            for (i = 0; i < size; ++i) {
                double stRndVar = invStdDev * (xVals[i] - mean);
                double y = exceedCalc.getExceedProb(stRndVar);
                yVals[i] = first ? y * weight : Math.fma(y, weight, yVals[i]);
            }
            first = false;
        }
        if (weightSum != 1.0) {
            weightSum = 1.0 / weightSum;
            i = 0;
            while (i < size) {
                int n = i++;
                yVals[n] = yVals[n] * weightSum;
            }
        }
        if (!(intensityMeasureLevels instanceof LightFixedXFunc)) {
            for (i = 0; i < size; ++i) {
                intensityMeasureLevels.set(i, yVals[i]);
            }
        }
        return intensityMeasureLevels;
    }

    @Override
    public double getExceedProbability(double iml) throws ParameterException, IMRException {
        double weightSum = 0.0;
        double weightValSum = 0.0;
        for (Branch branch : this.getGroundMotionTree()) {
            double weight = branch.weight();
            weightSum += weight;
            double mean = ((GroundMotion)branch.value()).mean();
            double stdDev = ((GroundMotion)branch.value()).sigma();
            double prob = this.getExceedProbability(mean, stdDev, iml);
            weightValSum = Math.fma(prob, weight, weightValSum);
        }
        if (weightSum == 1.0) {
            return weightValSum;
        }
        return weightValSum / weightSum;
    }

    @Override
    public double getIML_AtExceedProb() throws ParameterException {
        if (this.exceedProbParam.getValue() == null) {
            throw new ParameterException("NSHMP_GMM_WrapperFullParam: getExceedProbability(): exceedProbParam or its value is null, unable to run this calculation.");
        }
        double exceedProb = (Double)this.exceedProbParam.getValue();
        double weightSum = 0.0;
        double weightValSum = 0.0;
        for (Branch branch : this.getGroundMotionTree()) {
            double weight = branch.weight();
            weightSum += weight;
            double mean = ((GroundMotion)branch.value()).mean();
            double stdDev = ((GroundMotion)branch.value()).sigma();
            double val = this.getIML_AtExceedProb(mean, stdDev, exceedProb, this.sigmaTruncTypeParam, this.sigmaTruncLevelParam);
            weightValSum = Math.fma(val, weight, weightValSum);
        }
        if (weightSum == 1.0) {
            return weightValSum;
        }
        return weightValSum / weightSum;
    }

    @Override
    public DiscretizedFunc getSA_ExceedProbSpectrum(double iml) throws ParameterException, IMRException {
        throw new UnsupportedOperationException("getSA_IML_AtExceedProbSpectrum is unsupported for NSHMP_GMM_WrapperFullParam");
    }

    @Override
    public DiscretizedFunc getSA_IML_AtExceedProbSpectrum(double exceedProb) throws ParameterException, IMRException {
        throw new UnsupportedOperationException("getSA_IML_AtExceedProbSpectrum is unsupported for NSHMP_GMM_WrapperFullParam");
    }

    protected abstract Set<Imt> getSupportedIMTs();

    @Override
    protected void initSupportedIntensityMeasureParams() {
        this.supportedIMParams.clear();
        Set<Imt> imts = this.getSupportedIMTs();
        if (imts == null) {
            return;
        }
        boolean hasSA = false;
        for (Imt imt : imts) {
            if (!imt.isSA()) continue;
            hasSA = true;
            break;
        }
        if (hasSA) {
            DoubleDiscreteConstraint periodConstraint = new DoubleDiscreteConstraint();
            Double firstPeriod = null;
            for (Imt imt : imts) {
                if (!imt.isSA()) continue;
                periodConstraint.addDouble(imt.period());
                if (firstPeriod == null) {
                    firstPeriod = imt.period();
                }
                if (imt.period() != 1.0) continue;
                this.defaultPeriod = imt.period();
            }
            periodConstraint.setNonEditable();
            this.defaultIMT = "SA";
            if (this.defaultPeriod == null) {
                this.defaultPeriod = firstPeriod;
            }
            this.saPeriodParam = new PeriodParam(periodConstraint, this.defaultPeriod, false);
            this.saPeriodParam.setValueAsDefault();
            this.saPeriodParam.addParameterChangeListener(this);
            this.saDampingParam = new DampingParam();
            this.saDampingParam.setValueAsDefault();
            this.saDampingParam.addParameterChangeListener(this);
            this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
            this.saParam.setNonEditable();
            this.saParam.addParameterChangeWarningListener(this.listener);
            this.supportedIMParams.addParameter(this.saParam);
        }
        if (imts.contains(Imt.PGA)) {
            this.pgaParam = new PGA_Param();
            this.pgaParam.setNonEditable();
            this.pgaParam.addParameterChangeWarningListener(this.listener);
            this.supportedIMParams.addParameter(this.pgaParam);
            if (this.defaultIMT == null) {
                this.defaultIMT = "PGA";
            }
        }
        if (imts.contains(Imt.PGV)) {
            this.pgvParam = new PGV_Param();
            this.pgvParam.setNonEditable();
            this.pgvParam.addParameterChangeWarningListener(this.listener);
            this.supportedIMParams.addParameter(this.pgvParam);
            if (this.defaultIMT == null) {
                this.defaultIMT = "PGV";
            }
        }
        if (imts.contains(Imt.PGD)) {
            this.pgdParam = new PGD_Param();
            this.pgdParam.setNonEditable();
            this.pgdParam.addParameterChangeWarningListener(this.listener);
            this.supportedIMParams.addParameter(this.pgdParam);
            if (this.defaultIMT == null) {
                this.defaultIMT = "PGD";
            }
        }
        Preconditions.checkNotNull((Object)this.defaultIMT, (String)"No supported IMTs found for %s", (Object)this.getName());
    }

    @Override
    protected void initSiteParams() {
        Range<Double> range;
        this.vs30Param = null;
        this.vs30_TypeParam = null;
        this.depthTo1pt0kmPerSecParam = null;
        this.depthTo2pt5kmPerSecParam = null;
        this.zSedParam = null;
        this.siteParams.clear();
        if (this.fields.contains(GmmInput.Field.VS30)) {
            range = this.getConstraintRange(GmmInput.Field.VS30, 150.0, 1500.0);
            this.vs30Param = new Vs30_Param(this.safeDefault(GmmInput.Field.VS30, range), (double)((Double)range.lowerEndpoint()), (double)((Double)range.upperEndpoint()));
            this.vs30Param.setValueAsDefault();
            this.siteParams.addParameter(this.vs30Param);
            this.valueManager.addParameterMapping(GmmInput.Field.VS30, this.vs30Param);
        }
        if (this.fields.contains(GmmInput.Field.Z1P0)) {
            range = this.getConstraintRange(GmmInput.Field.Z1P0, DepthTo1pt0kmPerSecParam.MIN, DepthTo1pt0kmPerSecParam.MAX);
            this.depthTo1pt0kmPerSecParam = new DepthTo1pt0kmPerSecParam(this.safeDefault(GmmInput.Field.Z1P0, range, true), (double)((Double)range.lowerEndpoint()), (double)((Double)range.upperEndpoint()), true);
            this.depthTo1pt0kmPerSecParam.setValueAsDefault();
            this.siteParams.addParameter(this.depthTo1pt0kmPerSecParam);
            this.valueManager.addParameterMapping(GmmInput.Field.Z1P0, this.depthTo1pt0kmPerSecParam);
        }
        if (this.fields.contains(GmmInput.Field.Z2P5)) {
            range = this.getConstraintRange(GmmInput.Field.Z2P5, DepthTo2pt5kmPerSecParam.MIN, DepthTo2pt5kmPerSecParam.MAX);
            this.depthTo2pt5kmPerSecParam = new DepthTo2pt5kmPerSecParam(this.safeDefault(GmmInput.Field.Z2P5, range, true), (double)((Double)range.lowerEndpoint()), (double)((Double)range.upperEndpoint()), true);
            this.depthTo2pt5kmPerSecParam.setValueAsDefault();
            this.siteParams.addParameter(this.depthTo2pt5kmPerSecParam);
            this.valueManager.addParameterMapping(GmmInput.Field.Z2P5, this.depthTo2pt5kmPerSecParam);
        }
        if (this.fields.contains(GmmInput.Field.ZSED)) {
            range = this.getConstraintRange(GmmInput.Field.ZSED);
            Double defaultValue = this.safeDefault(GmmInput.Field.ZSED, range, true);
            this.zSedParam = range == null ? new SedimentThicknessParam(defaultValue, true) : new SedimentThicknessParam(defaultValue, (double)((Double)range.lowerEndpoint()), (double)((Double)range.upperEndpoint()), true);
            this.zSedParam.setValueAsDefault();
            this.siteParams.addParameter(this.zSedParam);
            this.valueManager.addParameterMapping(GmmInput.Field.ZSED, this.zSedParam);
        }
    }

    private Range<Double> getConstraintRange(GmmInput.Field field) {
        return this.getConstraintRange(field, null);
    }

    private Range<Double> getConstraintRange(GmmInput.Field field, double min, double max) {
        return this.getConstraintRange(field, (Range<Double>)Range.closed((Comparable)Double.valueOf(min), (Comparable)Double.valueOf(max)));
    }

    protected abstract Object getCustomConstraintRange(GmmInput.Field var1);

    private Range<Double> getConstraintRange(GmmInput.Field field, Range<Double> defaultRange) {
        Object constraintRange = this.getCustomConstraintRange(field);
        if (constraintRange instanceof Range && ((Range)constraintRange).lowerEndpoint() instanceof Double) {
            Range range = (Range)constraintRange;
            range = Range.closed((Comparable)FieldParameterValueManager.nshmpToOpenSHA(field, (Double)range.lowerEndpoint()), (Comparable)FieldParameterValueManager.nshmpToOpenSHA(field, (Double)range.upperEndpoint()));
            return range;
        }
        return defaultRange;
    }

    private double safeDefault(GmmInput.Field field, Range<Double> range) {
        return this.safeDefault(field, range, false);
    }

    private Double safeDefault(GmmInput.Field field, Range<Double> range, boolean nanAsNull) {
        if (Double.isNaN(field.defaultValue)) {
            return nanAsNull ? null : Double.valueOf(Double.NaN);
        }
        if (range != null && !range.contains((Comparable)Double.valueOf(field.defaultValue))) {
            return (Double)range.lowerEndpoint() + 0.5 * ((Double)range.upperEndpoint() - (Double)range.lowerEndpoint());
        }
        return field.defaultValue;
    }

    @Override
    protected void initEqkRuptureParams() {
        Range<Double> range;
        this.eqkRuptureParams.clear();
        this.magParam = null;
        this.dipParam = null;
        this.rupWidthParam = null;
        this.rakeParam = null;
        this.rupTopDepthParam = null;
        this.focalDepthParam = null;
        if (!this.parameterize) {
            return;
        }
        if (this.fields.contains(GmmInput.Field.MW)) {
            range = this.getConstraintRange(GmmInput.Field.MW, 4.0, 9.0);
            this.magParam = new MagParam((Double)range.lowerEndpoint(), (double)((Double)range.upperEndpoint()), this.safeDefault(GmmInput.Field.MW, range));
            this.magParam.setValueAsDefault();
            this.eqkRuptureParams.addParameter(this.magParam);
            this.valueManager.addParameterMapping(GmmInput.Field.MW, this.magParam);
        }
        if (this.fields.contains(GmmInput.Field.DIP)) {
            range = this.getConstraintRange(GmmInput.Field.DIP, 15.0, 90.0);
            this.dipParam = new DipParam((Double)range.lowerEndpoint(), (double)((Double)range.upperEndpoint()), this.safeDefault(GmmInput.Field.DIP, range));
            this.dipParam.setValueAsDefault();
            this.eqkRuptureParams.addParameter(this.dipParam);
            this.valueManager.addParameterMapping(GmmInput.Field.DIP, this.dipParam);
        }
        if (this.fields.contains(GmmInput.Field.WIDTH)) {
            range = this.getConstraintRange(GmmInput.Field.WIDTH, 0.0, 500.0);
            this.rupWidthParam = new RupWidthParam((Double)range.lowerEndpoint(), (double)((Double)range.upperEndpoint()), this.safeDefault(GmmInput.Field.WIDTH, range));
            this.rupWidthParam.setValueAsDefault();
            this.eqkRuptureParams.addParameter(this.rupWidthParam);
            this.valueManager.addParameterMapping(GmmInput.Field.WIDTH, this.rupWidthParam);
        }
        if (this.fields.contains(GmmInput.Field.RAKE)) {
            this.rakeParam = new RakeParam(GmmInput.Field.RAKE.defaultValue, true);
            this.rakeParam.setValueAsDefault();
            this.eqkRuptureParams.addParameter(this.rakeParam);
            this.valueManager.addParameterMapping(GmmInput.Field.RAKE, this.rakeParam);
        }
        if (this.fields.contains(GmmInput.Field.ZTOR)) {
            range = this.getConstraintRange(GmmInput.Field.ZTOR, 0.0, 15.0);
            this.rupTopDepthParam = new RupTopDepthParam((Double)range.lowerEndpoint(), (double)((Double)range.upperEndpoint()), this.safeDefault(GmmInput.Field.ZTOR, range));
            this.rupTopDepthParam.setValueAsDefault();
            this.eqkRuptureParams.addParameter(this.rupTopDepthParam);
            this.valueManager.addParameterMapping(GmmInput.Field.ZTOR, this.rupTopDepthParam);
        }
        if (this.fields.contains(GmmInput.Field.ZHYP)) {
            range = this.getConstraintRange(GmmInput.Field.ZHYP, 0.0, 15.0);
            this.focalDepthParam = new FocalDepthParam((Double)range.lowerEndpoint(), (double)((Double)range.upperEndpoint()), this.safeDefault(GmmInput.Field.ZHYP, range));
            this.focalDepthParam.setValueAsDefault();
            this.eqkRuptureParams.addParameter(this.focalDepthParam);
            this.valueManager.addParameterMapping(GmmInput.Field.ZHYP, this.focalDepthParam);
        }
    }

    @Override
    protected void initPropagationEffectParams() {
        Range<Double> range;
        this.propagationEffectParams.clear();
        this.distanceJBParam = null;
        this.distanceRupParam = null;
        this.distanceSeisParam = null;
        this.distanceXParam = null;
        if (!this.parameterize) {
            return;
        }
        if (this.fields.contains(GmmInput.Field.RJB)) {
            range = this.getConstraintRange(GmmInput.Field.RJB, 0.0, 400.0);
            this.distanceJBParam = new DistanceJBParameter(new DoubleConstraint((Double)range.lowerEndpoint(), (Double)range.upperEndpoint()), this.safeDefault(GmmInput.Field.RJB, range));
            this.distanceJBParam.setValueAsDefault();
            this.propagationEffectParams.addParameter(this.distanceJBParam);
            this.valueManager.addParameterMapping(GmmInput.Field.RJB, this.distanceJBParam);
        }
        if (this.fields.contains(GmmInput.Field.RRUP)) {
            range = this.getConstraintRange(GmmInput.Field.RRUP, 0.0, 400.0);
            this.distanceRupParam = new DistanceRupParameter(new DoubleConstraint((Double)range.lowerEndpoint(), (Double)range.upperEndpoint()), this.safeDefault(GmmInput.Field.RRUP, range));
            this.distanceRupParam.setValueAsDefault();
            this.propagationEffectParams.addParameter(this.distanceRupParam);
            this.valueManager.addParameterMapping(GmmInput.Field.RRUP, this.distanceRupParam);
        }
        if (this.fields.contains(GmmInput.Field.RX)) {
            range = this.getConstraintRange(GmmInput.Field.RX, -400.0, 400.0);
            this.distanceXParam = new DistanceX_Parameter(new DoubleConstraint((Double)range.lowerEndpoint(), (Double)range.upperEndpoint()), this.safeDefault(GmmInput.Field.RX, range));
            this.distanceXParam.setValueAsDefault();
            this.propagationEffectParams.addParameter(this.distanceXParam);
            this.valueManager.addParameterMapping(GmmInput.Field.RX, this.distanceXParam);
        }
    }

    @Override
    protected void initOtherParams() {
        Gmm.Type type;
        super.initOtherParams();
        this.sigmaTruncTypeParam.addParameterChangeListener(this);
        this.sigmaTruncLevelParam.addParameterChangeListener(this);
        this.updateExceedProbCalc();
        if (this.component != null) {
            this.componentParam = new ComponentParam(this.component, this.component);
            this.componentParam.setValueAsDefault();
            this.componentParam.addParameterChangeListener(this);
            this.otherParams.addParameter(this.componentParam);
        }
        if ((type = this.getType()) != null) {
            String typeStr = NSHMP_GMM_Wrapper.trtForType(type).toString();
            StringConstraint options = new StringConstraint();
            options.addString(typeStr);
            this.tectonicRegionTypeParam.setConstraint(options);
            this.tectonicRegionTypeParam.setDefaultValue(typeStr);
            this.tectonicRegionTypeParam.setValueAsDefault();
        }
    }

    private void updateExceedProbCalc() {
        int sigmaTruncType;
        if (this.sigmaTruncTypeParam == null || ((String)this.sigmaTruncTypeParam.getValue()).equals("None")) {
            sigmaTruncType = 0;
        } else if (((String)this.sigmaTruncTypeParam.getValue()).equals("1 Sided")) {
            sigmaTruncType = 1;
        } else if (((String)this.sigmaTruncTypeParam.getValue()).equals("2 Sided")) {
            sigmaTruncType = 2;
        } else {
            throw new IllegalStateException();
        }
        this.exceedCalc = GaussianExceedProbCalculator.getPrecomputedExceedProbCalc(sigmaTruncType, (Double)this.sigmaTruncLevelParam.getValue());
    }

    public static TectonicRegionType trtForType(Gmm.Type type) {
        switch (type) {
            case ACTIVE_CRUST: {
                return TectonicRegionType.ACTIVE_SHALLOW;
            }
            case STABLE_CRUST: {
                return TectonicRegionType.STABLE_SHALLOW;
            }
            case SUBDUCTION_INTERFACE: {
                return TectonicRegionType.SUBDUCTION_INTERFACE;
            }
            case SUBDUCTION_SLAB: {
                return TectonicRegionType.SUBDUCTION_SLAB;
            }
        }
        throw new IllegalStateException("Unexpected TRT: " + String.valueOf(type));
    }

    @Override
    public void setParamDefaults() {
        for (Parameter<?> param : this.siteParams) {
            param.setValueAsDefault();
        }
        for (Parameter<?> param : this.propagationEffectParams) {
            param.setValueAsDefault();
        }
        for (Parameter<?> param : this.eqkRuptureParams) {
            param.setValueAsDefault();
        }
        for (Parameter<?> param : this.otherParams) {
            param.setValueAsDefault();
        }
        this.setIntensityMeasure(this.defaultIMT);
        this.perRuptureInputCache = null;
        this.clearCachedGmmInputs();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public void setSite(Site site) {
        this.setSite(site, true);
    }

    @Override
    public void setSiteLocation(Location loc) {
        if (this.site == null || this.site.getLocation() != loc) {
            this.perRuptureInputCache = null;
            this.clearCachedGmmInputs();
        }
        super.setSiteLocation(loc);
    }

    protected void setSite(Site site, boolean requireAllParams) {
        if (site != this.site) {
            this.perRuptureInputCache = null;
        }
        super.setSite(site);
        this.clearCachedGmmInputs();
        if (this.fields.contains(GmmInput.Field.VS30) && (requireAllParams || site.containsParameter("Vs30"))) {
            this.valueManager.setParameterValue(GmmInput.Field.VS30, site.getParameter(Double.class, "Vs30").getValue());
        }
        if (this.fields.contains(GmmInput.Field.Z1P0) && (requireAllParams || site.containsParameter("Depth 1.0 km/sec"))) {
            this.valueManager.setParameterValue(GmmInput.Field.Z1P0, site.getParameter(Double.class, "Depth 1.0 km/sec").getValue());
        }
        if (this.fields.contains(GmmInput.Field.Z2P5) && (requireAllParams || site.containsParameter("Depth 2.5 km/sec"))) {
            this.valueManager.setParameterValue(GmmInput.Field.Z2P5, site.getParameter(Double.class, "Depth 2.5 km/sec").getValue());
        }
        if (this.fields.contains(GmmInput.Field.ZSED) && (requireAllParams || site.containsParameter("Sediment Thickness (zSed)"))) {
            this.valueManager.setParameterValue(GmmInput.Field.ZSED, site.getParameter(Double.class, "Sediment Thickness (zSed)").getValue());
        }
        this.setPropagationEffectParams();
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) {
        super.setEqkRupture(eqkRupture);
        this.clearCachedGmmInputs();
        boolean usePerRupCache = this.cacheInputsPerRupture && this.site != null;
        EqkRupture rupForCache = eqkRupture;
        if (usePerRupCache) {
            GmmInput cached;
            if (this.perRuptureInputCache == null) {
                this.perRuptureInputCache = new HashMap<EqkRupture, GmmInput>();
            }
            if (eqkRupture instanceof DistCachedERFWrapper.DistCacheWrapperRupture) {
                rupForCache = ((DistCachedERFWrapper.DistCacheWrapperRupture)eqkRupture).getOriginalRupture();
            }
            if ((cached = this.perRuptureInputCache.get(rupForCache)) != null) {
                this.setCurrentGmmInput(cached);
                return;
            }
        }
        RuptureSurface surf = eqkRupture.getRuptureSurface();
        if (this.fields.contains(GmmInput.Field.MW)) {
            this.valueManager.setParameterValue(GmmInput.Field.MW, eqkRupture.getMag());
        }
        if (this.fields.contains(GmmInput.Field.RAKE)) {
            this.valueManager.setParameterValue(GmmInput.Field.RAKE, eqkRupture.getAveRake());
        }
        if (this.fields.contains(GmmInput.Field.DIP)) {
            this.valueManager.setParameterValue(GmmInput.Field.DIP, surf.getAveDip());
        }
        if (this.fields.contains(GmmInput.Field.WIDTH)) {
            this.valueManager.setParameterValue(GmmInput.Field.WIDTH, surf.getAveWidth());
        }
        if (this.fields.contains(GmmInput.Field.ZTOR)) {
            this.valueManager.setParameterValue(GmmInput.Field.ZTOR, surf.getAveRupTopDepth());
        }
        if (this.fields.contains(GmmInput.Field.ZHYP)) {
            double zHyp = eqkRupture.getHypocenterLocation() != null ? eqkRupture.getHypocenterLocation().getDepth() : surf.getAveRupTopDepth() + Math.sin(surf.getAveDip() * GeoTools.TO_RAD) * surf.getAveWidth() / 2.0;
            this.valueManager.setParameterValue(GmmInput.Field.ZHYP, zHyp);
        }
        this.setPropagationEffectParams();
        if (usePerRupCache) {
            this.perRuptureInputCache.put(rupForCache, this.getCurrentGmmInput());
        }
    }

    @Override
    protected void setPropagationEffectParams() {
        this.clearCachedGmmInputs();
        if (this.site != null && this.eqkRupture != null) {
            Location siteLoc = this.site.getLocation();
            RuptureSurface surf = this.eqkRupture.getRuptureSurface();
            if (this.fields.contains(GmmInput.Field.RJB)) {
                this.valueManager.setParameterValue(GmmInput.Field.RJB, surf.getDistanceJB(siteLoc));
            }
            if (this.fields.contains(GmmInput.Field.RRUP)) {
                this.valueManager.setParameterValue(GmmInput.Field.RRUP, surf.getDistanceRup(siteLoc));
            }
            if (this.fields.contains(GmmInput.Field.RX)) {
                this.valueManager.setParameterValue(GmmInput.Field.RX, surf.getDistanceX(siteLoc));
            }
        }
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        Parameter param = event.getParameter();
        if (param == this.saPeriodParam || param == this.saPeriodParam) {
            this.clearCachedImt();
        } else if (param == this.sigmaTruncLevelParam || param == this.sigmaTruncTypeParam) {
            this.updateExceedProbCalc();
        } else {
            this.clearCachedGmmInputs();
            this.perRuptureInputCache = null;
        }
    }

    @Override
    public void setIntensityMeasure(String intensityMeasureName) throws ParameterException {
        super.setIntensityMeasure(intensityMeasureName);
        this.clearCachedImt();
    }

    protected void clearCachedImt() {
        this.imt = null;
        this.gmTree = null;
    }

    protected void clearCachedGmmInputs() {
        this.gmmInput = null;
        this.gmTree = null;
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        if (this.parameterize) {
            if (this.fields.contains(GmmInput.Field.RRUP)) {
                this.meanIndependentParams.addParameter(this.distanceRupParam);
            }
            if (this.fields.contains(GmmInput.Field.RJB)) {
                this.meanIndependentParams.addParameter(this.distanceJBParam);
            }
            if (this.fields.contains(GmmInput.Field.RX)) {
                this.meanIndependentParams.addParameter(this.distanceXParam);
            }
            if (this.fields.contains(GmmInput.Field.VS30)) {
                this.meanIndependentParams.addParameter(this.vs30Param);
            }
            if (this.fields.contains(GmmInput.Field.Z2P5)) {
                this.meanIndependentParams.addParameter(this.depthTo2pt5kmPerSecParam);
            }
            if (this.fields.contains(GmmInput.Field.Z1P0)) {
                this.meanIndependentParams.addParameter(this.depthTo1pt0kmPerSecParam);
            }
            if (this.fields.contains(GmmInput.Field.ZSED)) {
                this.meanIndependentParams.addParameter(this.zSedParam);
            }
            if (this.fields.contains(GmmInput.Field.MW)) {
                this.meanIndependentParams.addParameter(this.magParam);
            }
            if (this.fields.contains(GmmInput.Field.RAKE)) {
                this.meanIndependentParams.addParameter(this.rakeParam);
            }
            if (this.fields.contains(GmmInput.Field.DIP)) {
                this.meanIndependentParams.addParameter(this.dipParam);
            }
            if (this.fields.contains(GmmInput.Field.ZTOR)) {
                this.meanIndependentParams.addParameter(this.rupTopDepthParam);
            }
            if (this.fields.contains(GmmInput.Field.WIDTH)) {
                this.meanIndependentParams.addParameter(this.rupWidthParam);
            }
            if (this.fields.contains(GmmInput.Field.ZHYP)) {
                this.meanIndependentParams.addParameter(this.focalDepthParam);
            }
        }
        if (this.componentParam != null) {
            this.meanIndependentParams.addParameter(this.componentParam);
        }
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameterList(this.meanIndependentParams);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameterList(this.stdDevIndependentParams);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    public static class WeightedCombination
    extends NSHMP_GMM_Wrapper {
        private WeightedList<Gmm> gmms;
        private List<EnumMap<Imt, GroundMotionModel>> instanceMaps;
        private List<GmmInput.Constraints> constraintsList;

        public WeightedCombination(Map<Gmm, Double> gmms, String name, String shortName) {
            this(WeightedCombination.gmmMapToList(gmms), name, shortName);
        }

        public WeightedCombination(WeightedList<Gmm> gmms, String name, String shortName) {
            this(gmms, name, shortName, true);
        }

        public WeightedCombination(Map<Gmm, Double> gmms, String name, String shortName, boolean parameterize) {
            this(WeightedCombination.gmmMapToList(gmms), name, shortName, parameterize, null);
        }

        public WeightedCombination(WeightedList<Gmm> gmms, String name, String shortName, boolean parameterize) {
            this(gmms, name, shortName, parameterize, null);
        }

        public WeightedCombination(Map<Gmm, Double> gmms, String name, String shortName, boolean parameterize, Component component) {
            this(WeightedCombination.gmmMapToList(gmms), name, shortName, parameterize, component);
        }

        public WeightedCombination(WeightedList<Gmm> gmms, String name, String shortName, boolean parameterize, Component component) {
            super(name, shortName, parameterize, component);
            Preconditions.checkNotNull(gmms, (Object)"Gmms must be supplied; use InputCacheGen if you don't have any Gmms");
            if (!gmms.isNormalized()) {
                gmms.normalize();
            }
            if (!(gmms instanceof WeightedList.Unmodifiable)) {
                gmms = new WeightedList.Unmodifiable<Gmm>(gmms);
            }
            this.gmms = gmms;
            this.instanceMaps = new ArrayList<EnumMap<Imt, GroundMotionModel>>(gmms.size());
            for (int i = 0; i < gmms.size(); ++i) {
                this.instanceMaps.add(new EnumMap(Imt.class));
            }
            this.init();
        }

        private static WeightedList<Gmm> gmmMapToList(Map<Gmm, Double> map) {
            WeightedList<Gmm> list = new WeightedList<Gmm>(map.size());
            for (Gmm gmm : map.keySet()) {
                list.add(gmm, map.get(gmm));
            }
            return list;
        }

        @Override
        public Gmm.Type getType() {
            Gmm.Type type = null;
            for (int i = 0; i < this.gmms.size(); ++i) {
                Gmm.Type subType = this.gmms.getValue(i).type();
                if (subType == null || type != null && type != subType) {
                    return null;
                }
                if (type != null) continue;
                type = subType;
            }
            return type;
        }

        private GroundMotionModel getBuildGMM(Gmm gmm, EnumMap<Imt, GroundMotionModel> instanceMap, Imt imt) {
            Preconditions.checkNotNull((Object)imt);
            GroundMotionModel gmmInstance = instanceMap.get(imt);
            if (gmmInstance == null) {
                gmmInstance = gmm.instance(imt);
                instanceMap.put(imt, gmmInstance);
            }
            return gmmInstance;
        }

        @Override
        protected LogicTree<GroundMotion> buildGroundMotionTree() {
            LogicTree.Builder builder = LogicTree.builder((String)"multi-gmms");
            GmmInput input = this.getCurrentGmmInput();
            Imt imt = this.getCurrentIMT();
            for (int i = 0; i < this.gmms.size(); ++i) {
                Gmm gmm = this.gmms.getValue(i);
                double weight = this.gmms.getWeight(i);
                GroundMotionModel model = this.getBuildGMM(gmm, this.instanceMaps.get(i), imt);
                String prefix = gmm.name();
                LogicTree subTree = model.calc(input);
                if (subTree.size() == 1) {
                    builder.addBranch(prefix, (Object)((GroundMotion)((Branch)subTree.get(0)).value()), weight);
                    continue;
                }
                for (Branch branch : subTree) {
                    builder.addBranch(prefix + "-" + branch.id(), (Object)((GroundMotion)branch.value()), branch.weight() * weight);
                }
            }
            return builder.build();
        }

        @Override
        protected Set<Imt> getSupportedIMTs() {
            EnumSet ret = null;
            for (int i = 0; i < this.gmms.size(); ++i) {
                Set subIMTs = this.gmms.getValue(i).supportedImts();
                if (ret == null) {
                    ret = EnumSet.copyOf(subIMTs);
                    continue;
                }
                ret.retainAll(subIMTs);
            }
            Preconditions.checkState((!ret.isEmpty() ? 1 : 0) != 0, (Object)"No common IMTs found among passed in GMMs");
            return ret;
        }

        @Override
        protected ImmutableList<GmmInput.Field> initFieldsUsed() {
            this.constraintsList = new ArrayList<GmmInput.Constraints>(this.gmms.size());
            for (int i = 0; i < this.gmms.size(); ++i) {
                this.constraintsList.add(this.gmms.getValue(i).constraints());
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            block1: for (GmmInput.Field field : GmmInput.Field.values()) {
                for (GmmInput.Constraints constraints : this.constraintsList) {
                    if (!constraints.get(field).isPresent()) continue;
                    FieldParameterValueManager.ensureSupported(field);
                    builder.add((Object)field);
                    continue block1;
                }
            }
            return builder.build();
        }

        @Override
        protected Object getCustomConstraintRange(GmmInput.Field field) {
            for (GmmInput.Constraints constraints : this.constraintsList) {
                Optional optional = constraints.get(field);
                if (!optional.isPresent()) continue;
                return optional.get();
            }
            throw new IllegalStateException("No Gmms use field " + String.valueOf(field));
        }
    }

    public static class InputCacheGen
    extends NSHMP_GMM_Wrapper {
        public InputCacheGen() {
            super("Cache-generator", "CacheGen", false, null);
            this.init();
        }

        @Override
        public void setSite(Site site) {
            this.setSite(site, false);
        }

        @Override
        public Gmm.Type getType() {
            return null;
        }

        @Override
        protected LogicTree<GroundMotion> buildGroundMotionTree() {
            throw new UnsupportedOperationException("This is a cache-building instance only");
        }

        @Override
        protected Set<Imt> getSupportedIMTs() {
            return null;
        }

        @Override
        protected ImmutableList<GmmInput.Field> initFieldsUsed() {
            return ImmutableList.copyOf((Object[])GmmInput.Field.values());
        }

        @Override
        protected Object getCustomConstraintRange(GmmInput.Field field) {
            return null;
        }
    }

    public static class Single
    extends NSHMP_GMM_Wrapper {
        private Gmm gmm;
        private EnumMap<Imt, GroundMotionModel> instanceMap;

        public Single(Gmm gmm) {
            this(gmm, gmm.name());
        }

        public Single(Gmm gmm, boolean parameterize) {
            this(gmm, gmm.name(), parameterize);
        }

        public Single(Gmm gmm, String shortName) {
            this(gmm, shortName, true);
        }

        public Single(Gmm gmm, String shortName, boolean parameterize) {
            this(gmm, shortName, parameterize, null);
        }

        public Single(Gmm gmm, String shortName, boolean parameterize, Component component) {
            this(gmm, gmm.toString(), shortName, parameterize, component);
        }

        public Single(Gmm gmm, String name, String shortName, boolean parameterize, Component component) {
            super(name, shortName, parameterize, component);
            Preconditions.checkNotNull((Object)gmm, (Object)"Gmm must be supplied; use InputCacheGen if you don't have a Gmm");
            this.gmm = gmm;
            this.instanceMap = new EnumMap(Imt.class);
            this.init();
        }

        @Override
        public Gmm.Type getType() {
            return this.gmm.type();
        }

        public Gmm getGmmRef() {
            return this.gmm;
        }

        private GroundMotionModel getBuildGMM(Imt imt) {
            Preconditions.checkNotNull((Object)imt);
            GroundMotionModel gmmInstance = this.instanceMap.get(imt);
            if (gmmInstance == null) {
                gmmInstance = this.gmm.instance(imt);
                this.instanceMap.put(imt, gmmInstance);
            }
            return gmmInstance;
        }

        public GroundMotionModel getCurrentGMM_Instance() {
            return this.getBuildGMM(this.getCurrentIMT());
        }

        @Override
        public LogicTree<GroundMotion> buildGroundMotionTree() {
            GroundMotionModel gmmInstance = this.getCurrentGMM_Instance();
            return gmmInstance.calc(this.getCurrentGmmInput());
        }

        @Override
        protected Set<Imt> getSupportedIMTs() {
            return this.gmm.supportedImts();
        }

        @Override
        protected ImmutableList<GmmInput.Field> initFieldsUsed() {
            GmmInput.Constraints constraints = this.gmm.constraints();
            ImmutableList.Builder fieldsUsedListBuilder = ImmutableList.builder();
            for (GmmInput.Field field : GmmInput.Field.values()) {
                if (!constraints.get(field).isPresent()) continue;
                FieldParameterValueManager.ensureSupported(field);
                fieldsUsedListBuilder.add((Object)field);
            }
            return fieldsUsedListBuilder.build();
        }

        @Override
        protected Object getCustomConstraintRange(GmmInput.Field field) {
            return this.gmm.constraints().get(field).get();
        }
    }
}

