/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl.nshmp.util;

import com.google.common.base.Stopwatch;
import gov.usgs.earthquake.nshmp.gmm.Gmm;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.ParameterList;
import org.opensha.sha.calc.HazardCurveCalculator;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.RupMFDsModule;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;
import org.opensha.sha.earthquake.param.ProbabilityModelOptions;
import org.opensha.sha.gui.infoTools.IMT_Info;
import org.opensha.sha.imr.AttenRelRef;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.attenRelImpl.MultiIMR_Averaged_AttenRel;
import org.opensha.sha.imr.attenRelImpl.nshmp.NSHMP_GMM_Wrapper;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.SiteParams.DepthTo1pt0kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.DepthTo2pt5kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;
import org.opensha.sha.imr.param.SiteParams.Vs30_TypeParam;
import scratch.UCERF3.erf.FaultSystemSolutionERF;

class Benchmark {
    Benchmark() {
    }

    public static void main(String[] args) throws IOException {
        File solFile = new File("/data/kevin/nshm23/batch_inversions/2023_09_01-nshm23_branches-mod_pitas_ddw-NSHM23_v2-CoulombRupSet-DsrUni-TotNuclRate-NoRed-ThreshAvgIterRelGR/results_NSHM23_v2_CoulombRupSet_branch_averaged_gridded.zip");
        FaultSystemSolution fss = FaultSystemSolution.load(solFile);
        fss.removeAvailableModuleInstances(RupMFDsModule.class);
        FaultSystemSolutionERF erf = new FaultSystemSolutionERF(fss);
        erf.setParameter("Background Seismicity", (Object)IncludeBackgroundOption.INCLUDE);
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.POISSON);
        erf.getTimeSpan().setDuration(1.0);
        erf.updateForecast();
        Location baseLoc = new Location(34.0, -118.0);
        int benchmarkSites = 100;
        int numBurnerSites = 20;
        int totNumSites = benchmarkSites + numBurnerSites;
        double period = 1.0;
        File outputFile = new File("/tmp/gmm_benchmark.csv");
        ArrayList<ScalarIMR> gmms = new ArrayList<ScalarIMR>();
        ArrayList<String> gmmNames = new ArrayList<String>();
        gmms.add(new NSHMP_GMM_Wrapper.Single(Gmm.ASK_14_BASE, true));
        gmmNames.add("NSHMP ASK 2014 Base, Parameterized");
        gmms.add(new NSHMP_GMM_Wrapper.Single(Gmm.ASK_14_BASE, false));
        gmmNames.add("NSHMP ASK 2014 Base");
        gmms.add(new NSHMP_GMM_Wrapper.Single(Gmm.ASK_14, false));
        gmmNames.add("NSHMP ASK 2014 USGS");
        gmms.add(AttenRelRef.ASK_2014.get());
        gmmNames.add("Original ASK 2014");
        gmms.add(new NSHMP_GMM_Wrapper.Single(Gmm.BSSA_14_BASE, true));
        gmmNames.add("NSHMP BSSA 2014 Base, Parameterized");
        gmms.add(new NSHMP_GMM_Wrapper.Single(Gmm.BSSA_14_BASE, false));
        gmmNames.add("NSHMP BSSA 2014 Base");
        gmms.add(new NSHMP_GMM_Wrapper.Single(Gmm.BSSA_14, false));
        gmmNames.add("NSHMP BSSA 2014 USGS");
        gmms.add(AttenRelRef.BSSA_2014.get());
        gmmNames.add("Original BSSA 2014");
        gmms.add(new NSHMP_GMM_Wrapper.Single(Gmm.CB_14_BASE, true));
        gmmNames.add("NSHMP CB 2014 Base, Parameterized");
        gmms.add(new NSHMP_GMM_Wrapper.Single(Gmm.CB_14_BASE, false));
        gmmNames.add("NSHMP CB 2014 Base");
        gmms.add(new NSHMP_GMM_Wrapper.Single(Gmm.CB_14, false));
        gmmNames.add("NSHMP CB 2014 USGS");
        gmms.add(AttenRelRef.CB_2014.get());
        gmmNames.add("Original CB 2014");
        gmms.add(new NSHMP_GMM_Wrapper.Single(Gmm.CY_14_BASE, true));
        gmmNames.add("NSHMP CY 2014 Base, Parameterized");
        gmms.add(new NSHMP_GMM_Wrapper.Single(Gmm.CY_14_BASE, false));
        gmmNames.add("NSHMP CY 2014 Base");
        gmms.add(new NSHMP_GMM_Wrapper.Single(Gmm.CY_14, false));
        gmmNames.add("NSHMP CY 2014 USGS");
        gmms.add(AttenRelRef.CY_2014.get());
        gmmNames.add("Original CY 2014");
        gmms.add(new NSHMP_GMM_Wrapper.Single(Gmm.COMBINED_ACTIVE_CRUST_2014_42, true));
        gmmNames.add("NSHMP 2014 Combined, Parameterized");
        gmms.add(new NSHMP_GMM_Wrapper.Single(Gmm.COMBINED_ACTIVE_CRUST_2014_42, false));
        gmmNames.add("NSHMP 2014 Combined");
        gmms.add(AttenRelRef.NGAWest_2014_AVG_NOIDRISS.get());
        gmmNames.add("Original NGA-West2 (No Idriss)");
        gmms.add(new NSHMP_GMM_Wrapper.Single(Gmm.COMBINED_ACTIVE_CRUST_2023, true));
        gmmNames.add("NSHMP 2023 Combined, Parameterized");
        gmms.add(new NSHMP_GMM_Wrapper.Single(Gmm.COMBINED_ACTIVE_CRUST_2023, false));
        gmmNames.add("NSHMP 2023 Combined");
        gmms.add(new NSHMP_GMM_Wrapper.Single(Gmm.COMBINED_ACTIVE_CRUST_2023_LOS_ANGELES, false));
        gmmNames.add("NSHMP 2023 Combined, LA");
        gmms.add(new NSHMP_GMM_Wrapper.Single(Gmm.COMBINED_ACTIVE_CRUST_2023_SAN_FRANCISCO, false));
        gmmNames.add("NSHMP 2023 Combined, SF");
        Random rand = new Random(totNumSites * fss.getRupSet().getNumRuptures());
        ArrayList<Double> vs30s = new ArrayList<Double>(totNumSites);
        ArrayList<Double> z1s = new ArrayList<Double>(totNumSites);
        ArrayList<Double> z25s = new ArrayList<Double>(totNumSites);
        ArrayList<Location> siteLocs = new ArrayList<Location>(totNumSites);
        double shiftLocTol = 0.01;
        for (int s = 0; s < totNumSites; ++s) {
            siteLocs.add(new Location(baseLoc.getLatitude() + rand.nextDouble(), baseLoc.getLongitude() + rand.nextDouble()));
            vs30s.add(200.0 + 600.0 * rand.nextDouble());
            z1s.add(50.0 + 1000.0 * rand.nextDouble());
            z25s.add(rand.nextDouble() * 5.0);
        }
        CSVFile<String> csv = new CSVFile<String>(true);
        csv.addLine("Model", "Seconds Per Site", "Num Sub-Models", "Seconds Per Site-Model");
        for (int g = 0; g < gmms.size(); ++g) {
            Object site2;
            ScalarIMR gmm = (ScalarIMR)gmms.get(g);
            gmm.setParamDefaults();
            String name = (String)gmmNames.get(g);
            if (period > 0.0) {
                gmm.setIntensityMeasure("SA");
                SA_Param.setPeriodInSA_Param(gmm.getIntensityMeasure(), period);
            } else if (period == 0.0) {
                gmm.setIntensityMeasure("PGA");
            } else {
                throw new IllegalStateException();
            }
            ArbitrarilyDiscretizedFunc xVals = new IMT_Info().getDefaultHazardCurve(gmm.getIntensityMeasure().getName());
            ArbitrarilyDiscretizedFunc logXVals = new ArbitrarilyDiscretizedFunc();
            for (Point2D pt : xVals) {
                logXVals.set(Math.log(pt.getX()), 1.0);
            }
            ArrayList<Object> burnerSites = new ArrayList<Object>();
            ArrayList<Object> sites = new ArrayList<Object>();
            for (int s = 0; s < totNumSites; ++s) {
                Object loc = (Location)siteLocs.get(s);
                loc = new Location(((Location)loc).getLatitude() + rand.nextDouble() * shiftLocTol, ((Location)loc).getLongitude() + rand.nextDouble() * shiftLocTol);
                site2 = new Site((Location)loc);
                Vs30_Param vs30 = new Vs30_Param((Double)vs30s.get(s));
                vs30.setValue((Double)vs30s.get(s));
                ((ParameterList)site2).addParameter(vs30);
                DepthTo1pt0kmPerSecParam z10 = new DepthTo1pt0kmPerSecParam();
                z10.setValue((Double)z1s.get(s));
                ((ParameterList)site2).addParameter(z10);
                DepthTo2pt5kmPerSecParam z25 = new DepthTo2pt5kmPerSecParam();
                z25.setValue((Double)z25s.get(s));
                ((ParameterList)site2).addParameter(z25);
                Vs30_TypeParam type = new Vs30_TypeParam();
                type.setValue("Inferred");
                ((ParameterList)site2).addParameter(type);
                if (s < numBurnerSites) {
                    burnerSites.add(site2);
                    continue;
                }
                sites.add(site2);
            }
            HazardCurveCalculator calc = new HazardCurveCalculator();
            for (Object site2 : burnerSites) {
                calc.getHazardCurve((DiscretizedFunc)logXVals, (Site)site2, gmm, (ERF)erf);
            }
            System.out.println("Calculating " + sites.size() + " curves for " + name);
            Stopwatch watch = Stopwatch.createStarted();
            site2 = sites.iterator();
            while (site2.hasNext()) {
                Site site3 = (Site)site2.next();
                calc.getHazardCurve((DiscretizedFunc)logXVals, site3, gmm, (ERF)erf);
            }
            watch.stop();
            double secs = (double)watch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
            double secsEach = secs / (double)sites.size();
            System.out.println("\tTook " + (float)secs + " s;\t" + (float)secsEach + " s per site");
            int subModels = gmm instanceof NSHMP_GMM_Wrapper ? ((NSHMP_GMM_Wrapper)gmm).getGroundMotionTree().size() : (gmm instanceof MultiIMR_Averaged_AttenRel ? ((MultiIMR_Averaged_AttenRel)gmm).getIMRs().size() : 1);
            double secsPerSubModel = secsEach / (double)subModels;
            csv.addLine(name, "" + (float)secsEach, "" + subModels, "" + (float)secsPerSubModel);
        }
        csv.writeToFile(outputFile);
    }
}

