/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl.nshmp.util;

import com.google.common.base.Preconditions;
import gov.usgs.earthquake.nshmp.gmm.Gmm;
import gov.usgs.earthquake.nshmp.gmm.GmmInput;
import gov.usgs.earthquake.nshmp.gmm.GroundMotionModel;
import gov.usgs.earthquake.nshmp.gmm.Imt;
import gov.usgs.earthquake.nshmp.tree.Branch;
import gov.usgs.earthquake.nshmp.tree.LogicTree;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.opensha.commons.logicTree.LogicTreeLevel;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.util.FileNameUtils;
import org.opensha.sha.imr.attenRelImpl.nshmp.GroundMotionLogicTreeFilter;
import org.opensha.sha.imr.attenRelImpl.nshmp.util.NSHMP_GMM_Branch;

public abstract class NSHMP_GMM_EpistemicBranchLevel
extends LogicTreeLevel.AdapterBackedLevel {
    private List<NSHMP_GMM_Branch> nodes;

    public NSHMP_GMM_EpistemicBranchLevel(List<NSHMP_GMM_Branch> nodes, String name, String shortName) {
        super(name, shortName, NSHMP_GMM_Branch.class);
        this.nodes = nodes;
    }

    public static List<NSHMP_GMM_Branch> buildNodes(Gmm gmm, String shortName, boolean expandTree) {
        return NSHMP_GMM_EpistemicBranchLevel.buildNodes(List.of(gmm), List.of(shortName), List.of(Double.valueOf(1.0)), expandTree);
    }

    public static List<NSHMP_GMM_Branch> buildNodes(List<Gmm> gmms, List<String> gmmShortNames, List<Double> gmmWeights, boolean expandTree) {
        return NSHMP_GMM_EpistemicBranchLevel.buildNodes(gmms, gmmShortNames, gmmWeights, expandTree, null);
    }

    public static List<NSHMP_GMM_Branch> buildNodes(List<Gmm> gmms, List<String> gmmShortNames, List<Double> gmmWeights, boolean expandTree, String commonFilePrefix) {
        Preconditions.checkArgument((!gmms.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((gmmShortNames.size() == gmms.size() ? 1 : 0) != 0);
        Preconditions.checkArgument((gmmWeights.size() == gmms.size() ? 1 : 0) != 0);
        if (commonFilePrefix == null) {
            commonFilePrefix = "";
        }
        String commonShortPrefix = "";
        if (gmms.size() > 1) {
            commonShortPrefix = StringUtils.getCommonPrefix((String[])gmmShortNames.toArray(new String[0]));
        }
        GmmInput input = GmmInput.builder().withDefaults().build();
        ArrayList<NSHMP_GMM_Branch> nodes = new ArrayList<NSHMP_GMM_Branch>();
        for (int i = 0; i < gmms.size(); ++i) {
            String uniqueName;
            Gmm gmm = gmms.get(i);
            double gmmWeight = gmmWeights.get(i);
            boolean doExpand = expandTree;
            LogicTree result = null;
            if (doExpand) {
                GroundMotionModel gmmInstance = gmm.instance((Imt)gmm.supportedImts().iterator().next());
                result = gmmInstance.calc(input);
                doExpand = result.size() > 1;
            }
            String namePrefix = gmm.toString();
            String shortNamePrefix = gmms.size() > 1 ? (doExpand && !commonShortPrefix.isEmpty() ? (uniqueName = gmmShortNames.get(i).substring(commonShortPrefix.length()).trim()) : gmmShortNames.get(i)) : (doExpand ? "" : gmmShortNames.get(i));
            if (!doExpand) {
                nodes.add(new NSHMP_GMM_Branch(gmm, null, namePrefix, shortNamePrefix, commonFilePrefix + NSHMP_GMM_EpistemicBranchLevel.getFilePrefix(shortNamePrefix), gmmWeight));
                continue;
            }
            for (Branch branch : result) {
                String name = namePrefix + ": " + branch.id();
                Object shortName = shortNamePrefix;
                if (!((String)shortName).isBlank()) {
                    shortName = (String)shortName + ": ";
                }
                shortName = (String)shortName + branch.id();
                nodes.add(new NSHMP_GMM_Branch(gmm, new GroundMotionLogicTreeFilter.StringMatching(branch.id()), name, (String)shortName, commonFilePrefix + NSHMP_GMM_EpistemicBranchLevel.getFilePrefix((String)shortName), gmmWeight * branch.weight()));
            }
        }
        return nodes;
    }

    private static String getFilePrefix(String shortName) {
        String filePrefix = shortName.replace("\u03c3", "sig");
        return FileNameUtils.simplify(filePrefix);
    }

    @Override
    public List<? extends NSHMP_GMM_Branch> getNodes() {
        return this.nodes;
    }

    @Override
    public boolean isMember(LogicTreeNode node) {
        return this.nodes.contains(node);
    }
}

