/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.mod.impl;

import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.Parameter;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.mod.AbstractAttenRelMod;
import org.opensha.sha.imr.param.OtherParams.SigmaTruncLevelParam;
import org.opensha.sha.imr.param.OtherParams.SigmaTruncTypeParam;

public abstract class IML_DependentAttenRelMod
extends AbstractAttenRelMod {
    @Override
    public double getModMean(ScalarIMR imr) {
        if (this.isCurrentlyIML_Dependent()) {
            throw new UnsupportedOperationException("IML Dependent Modifier cannot call getModMean(imr), must call getModMean(imr, iml)");
        }
        return this.getModMean(imr, Double.NaN);
    }

    public abstract double getModMean(ScalarIMR var1, double var2);

    @Override
    public double getModStdDev(ScalarIMR imr) {
        if (this.isCurrentlyIML_Dependent()) {
            throw new UnsupportedOperationException("IML Dependent Modifier cannot call getModStdDev(imr), must call getModStdDev(imr, iml)");
        }
        return this.getModStdDev(imr, Double.NaN);
    }

    public abstract double getModStdDev(ScalarIMR var1, double var2);

    @Override
    public DiscretizedFunc getModExceedProbabilities(ScalarIMR imr, DiscretizedFunc intensityMeasureLevels) throws ParameterException {
        SigmaTruncLevelParam sigmaTruncLevelParam;
        SigmaTruncTypeParam sigmaTruncTypeParam;
        if (!this.isCurrentlyIML_Dependent()) {
            return super.getModExceedProbabilities(imr, intensityMeasureLevels);
        }
        Parameter truncParam = imr.getParameter("Gaussian Truncation");
        if (truncParam != null && truncParam instanceof SigmaTruncTypeParam) {
            sigmaTruncTypeParam = (SigmaTruncTypeParam)truncParam;
            sigmaTruncLevelParam = (SigmaTruncLevelParam)imr.getParameter("Truncation Level");
        } else {
            sigmaTruncTypeParam = null;
            sigmaTruncLevelParam = null;
        }
        for (int i = 0; i < intensityMeasureLevels.size(); ++i) {
            double x = intensityMeasureLevels.getX(i);
            double stdDev = this.getModStdDev(imr, x);
            double mean = this.getModMean(imr, x);
            double y = AttenuationRelationship.getExceedProbability(mean, stdDev, x, sigmaTruncTypeParam, sigmaTruncLevelParam);
            intensityMeasureLevels.set(i, y);
        }
        return intensityMeasureLevels;
    }

    protected boolean isCurrentlyIML_Dependent() {
        return true;
    }
}

