/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.mod.impl;

import com.google.common.primitives.Doubles;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.mod.AbstractAttenRelMod;

public class SimpleScaleMod
extends AbstractAttenRelMod {
    public static final String NAME = "Simple Scalar";
    public static final String SHORT_NAME = "SimpleScalar";
    private ParameterList modParams = new ParameterList();
    private DoubleParameter meanScaleParam = new DoubleParameter("Mean Scale Factor", 1.0);
    private DoubleParameter stdDevScaleParam;
    private BooleanParameter logSpaceScaleParam;

    public SimpleScaleMod() {
        this.meanScaleParam.setDefaultValue(1.0);
        this.meanScaleParam.setValueAsDefault();
        this.stdDevScaleParam = new DoubleParameter("Std. Dev. Scale Factor", 1.0);
        this.stdDevScaleParam.setDefaultValue(1.0);
        this.stdDevScaleParam.setValueAsDefault();
        this.logSpaceScaleParam = new BooleanParameter("Mean Scale In Log Space", false);
        this.logSpaceScaleParam.setValueAsDefault();
        this.modParams.addParameter(this.meanScaleParam);
        this.modParams.addParameter(this.stdDevScaleParam);
        this.modParams.addParameter(this.logSpaceScaleParam);
    }

    public void setMeanScaleFactor(double scale) {
        this.meanScaleParam.setValue(scale);
    }

    public void setMeanScaleInLogSpace(boolean logSpace) {
        this.logSpaceScaleParam.setValue(logSpace);
    }

    public void setStdDevScaleFactor(double scale) {
        this.stdDevScaleParam.setValue(scale);
    }

    @Override
    public void setIMRParams(ScalarIMR imr) {
    }

    @Override
    public double getModMean(ScalarIMR imr) {
        return this.getScaledVal((Double)this.meanScaleParam.getValue(), imr.getMean(), (Boolean)this.logSpaceScaleParam.getValue() == false);
    }

    @Override
    public double getModStdDev(ScalarIMR imr) {
        return this.getScaledVal((Double)this.stdDevScaleParam.getValue(), imr.getStdDev(), false);
    }

    private double getScaledVal(double scalar, double val, boolean convertToLinear) {
        if (scalar == 1.0) {
            return val;
        }
        if (convertToLinear) {
            if (!Doubles.isFinite((double)val)) {
                return val;
            }
            val = Math.exp(val);
            val *= scalar;
            val = Math.log(val);
            return val;
        }
        return val * scalar;
    }

    @Override
    public ParameterList getModParams() {
        return this.modParams;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

