/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.param.PropagationEffectParams;

import java.util.ListIterator;
import org.dom4j.Element;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.imr.param.PropagationEffectParams.AbstractDoublePropEffectParam;

public class DistanceRupParameter
extends AbstractDoublePropEffectParam {
    protected static final String C = "DistanceRupParameter";
    protected static final boolean D = false;
    public static final String NAME = "DistanceRup";
    public static final String UNITS = "km";
    public static final String INFO = "Rupture Distance (closest distance to fault surface)";
    private static final Double MIN = 0.0;
    private static final Double MAX = Double.MAX_VALUE;

    public DistanceRupParameter() {
        super(NAME);
        this.init();
    }

    public DistanceRupParameter(double defaultValue) {
        super(NAME);
        this.init();
        this.setDefaultValue(defaultValue);
    }

    public DistanceRupParameter(ParameterConstraint warningConstraint) throws ConstraintException {
        super(NAME);
        if (warningConstraint != null && !(warningConstraint instanceof DoubleConstraint)) {
            throw new ConstraintException("DistanceRupParameter : Constructor(): Input constraint must be a DoubleConstraint");
        }
        this.init((DoubleConstraint)warningConstraint);
    }

    public DistanceRupParameter(ParameterConstraint warningConstraint, double defaultValue) throws ConstraintException {
        super(NAME);
        if (warningConstraint != null && !(warningConstraint instanceof DoubleConstraint)) {
            throw new ConstraintException("DistanceRupParameter : Constructor(): Input constraint must be a DoubleConstraint");
        }
        this.init((DoubleConstraint)warningConstraint);
        this.setDefaultValue(defaultValue);
    }

    protected void init(DoubleConstraint warningConstraint) {
        this.warningConstraint = warningConstraint;
        this.constraint = new DoubleConstraint(MIN, MAX);
        this.constraint.setNullAllowed(false);
        this.name = NAME;
        this.constraint.setName(this.name);
        this.units = UNITS;
        this.info = INFO;
    }

    protected void init() {
        this.init(null);
    }

    @Override
    protected void calcValueFromSiteAndEqkRup() {
        if (this.site != null && this.eqkRupture != null) {
            this.setValueIgnoreWarning(this.eqkRupture.getRuptureSurface().getDistanceRup(this.site.getLocation()));
        } else {
            this.value = null;
        }
    }

    public static double getDistance(Location loc, RuptureSurface rupSurf) {
        double minDistance = Double.MAX_VALUE;
        ListIterator<Location> it = rupSurf.getAveDip() > 89.0 ? rupSurf.getEvenlyDiscritizedUpperEdge().listIterator() : rupSurf.getLocationsIterator();
        while (it.hasNext()) {
            double vertDist;
            Location loc2 = it.next();
            double horzDist = LocationUtils.horzDistance(loc, loc2);
            double totalDist = horzDist * horzDist + (vertDist = LocationUtils.vertDistance(loc, loc2)) * vertDist;
            if (!(totalDist < minDistance)) continue;
            minDistance = totalDist;
        }
        return Math.pow(minDistance, 0.5);
    }

    @Override
    public String getType() {
        Object type = "DoubleParameter";
        ParameterConstraint constraint = this.constraint;
        if (constraint != null) {
            type = "Constrained" + (String)type;
        }
        return type;
    }

    @Override
    public Object clone() {
        DoubleConstraint c1 = null;
        DoubleConstraint c2 = null;
        if (this.constraint != null) {
            c1 = (DoubleConstraint)this.constraint.clone();
        }
        if (this.warningConstraint != null) {
            c2 = (DoubleConstraint)this.warningConstraint.clone();
        }
        Double val = null;
        Double val2 = null;
        if (this.value != null) {
            val = (Double)this.value;
            val2 = (double)val;
        }
        DistanceRupParameter param = new DistanceRupParameter();
        param.value = val2;
        param.constraint = c1;
        param.warningConstraint = c2;
        param.name = this.name;
        param.info = this.info;
        param.site = this.site;
        param.eqkRupture = this.eqkRupture;
        if (!this.editable) {
            param.setNonEditable();
        }
        return param;
    }

    @Override
    public boolean setIndividualParamValueFromXML(Element el) {
        return false;
    }
}

