/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.magdist;

import java.awt.geom.Point2D;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class GaussianMagFreqDist
extends IncrementalMagFreqDist {
    public static String NAME = "Gaussian Dist";
    private double mean = Double.NaN;
    private double stdDev = Double.NaN;
    private double truncLevel = Double.NaN;
    private int truncType = 0;

    public GaussianMagFreqDist(double min, int num, double delta) throws InvalidRangeException {
        super(min, num, delta);
    }

    public GaussianMagFreqDist(double min, double max, int num) throws InvalidRangeException {
        super(min, max, num);
    }

    public GaussianMagFreqDist(double min, double max, int num, double mean, double stdDev, double totMoRate) throws InvalidRangeException {
        super(min, max, num);
        this.mean = mean;
        this.stdDev = stdDev;
        this.truncType = 0;
        this.calculateRelativeRates();
        this.scaleToTotalMomentRate(totMoRate);
    }

    public GaussianMagFreqDist(double min, int num, double delta, double mean, double stdDev, double totMoRate) throws InvalidRangeException {
        super(min, num, delta);
        this.mean = mean;
        this.stdDev = stdDev;
        this.truncType = 0;
        this.calculateRelativeRates();
        this.scaleToTotalMomentRate(totMoRate);
    }

    public GaussianMagFreqDist(double min, int num, double delta, double mean, double stdDev, double totMoRate, double truncLevel, int truncType) throws InvalidRangeException {
        super(min, num, delta);
        this.mean = mean;
        this.stdDev = stdDev;
        this.truncLevel = truncLevel;
        this.truncType = truncType;
        this.calculateRelativeRates();
        this.scaleToTotalMomentRate(totMoRate);
    }

    public GaussianMagFreqDist(double min, double max, int num, double mean, double stdDev, double totMoRate, double truncLevel, int truncType) throws InvalidRangeException {
        super(min, max, num);
        this.mean = mean;
        this.stdDev = stdDev;
        this.truncLevel = truncLevel;
        this.truncType = truncType;
        this.calculateRelativeRates();
        this.scaleToTotalMomentRate(totMoRate);
    }

    public void setAllButCumRate(double mean, double stdDev, double totMoRate) {
        this.mean = mean;
        this.stdDev = stdDev;
        this.truncType = 0;
        this.calculateRelativeRates();
        this.scaleToTotalMomentRate(totMoRate);
    }

    public void setAllButCumRate(double mean, double stdDev, double totMoRate, double truncLevel, int truncType) {
        this.mean = mean;
        this.stdDev = stdDev;
        this.truncLevel = truncLevel;
        this.truncType = truncType;
        this.calculateRelativeRates();
        this.scaleToTotalMomentRate(totMoRate);
    }

    public void setAllButTotMoRate(double mean, double stdDev, double totCumRate) {
        this.mean = mean;
        this.stdDev = stdDev;
        this.truncType = 0;
        this.calculateRelativeRates();
        this.scaleToCumRate(0, totCumRate);
    }

    public void setAllButTotMoRate(double mean, double stdDev, double totCumRate, double truncLevel, int truncType) {
        this.mean = mean;
        this.stdDev = stdDev;
        this.truncLevel = truncLevel;
        this.truncType = truncType;
        this.calculateRelativeRates();
        this.scaleToCumRate(0, totCumRate);
    }

    public double getMean() {
        return this.mean;
    }

    public double getStdDev() {
        return this.stdDev;
    }

    public double getTruncLevel() {
        return this.truncLevel;
    }

    public int getTruncType() {
        return this.truncType;
    }

    @Override
    public String getDefaultName() {
        return NAME;
    }

    @Override
    public String getDefaultInfo() {
        return "minMag=" + this.minX + "; maxMag=" + this.maxX + "; numMag=" + this.num + "; mean=" + this.mean + "; stdDev=" + this.stdDev + "; totMoRate=" + (float)this.getTotalMomentRate() + "; totCumRate=" + (float)this.getCumRate(0) + "; truncType=" + this.truncType + "; truncLevel=" + this.truncLevel;
    }

    @Override
    public void set(Point2D point) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(double x, double y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(int index, double y) {
        throw new UnsupportedOperationException();
    }

    private void calculateRelativeRates() {
        block8: {
            block7: {
                int index;
                if (this.stdDev == 0.0) break block7;
                for (int i = 0; i < this.num; ++i) {
                    double mag = this.getX(i);
                    double rate = Math.exp(-Math.pow(mag - this.mean, 2.0) / (2.0 * this.stdDev * this.stdDev));
                    super.set(i, rate);
                }
                if (this.truncType != 0) {
                    double magUpper = this.mean + this.truncLevel * this.stdDev;
                    index = Math.round((float)((magUpper - this.minX) / this.delta));
                    for (int i = index + 1; i >= 0 && i < this.num; ++i) {
                        super.set(i, 0.0);
                    }
                }
                if (this.truncType != 2) break block8;
                double magLower = this.mean - this.truncLevel * this.stdDev;
                index = Math.round((float)((magLower - this.minX) / this.delta));
                for (int i = 0; i < index && i < this.num; ++i) {
                    super.set(i, 0.0);
                }
                break block8;
            }
            for (int i = 0; i < this.num; ++i) {
                super.set(i, 0.0);
            }
            try {
                super.set(this.mean, 1.0);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("If sigma=0, then mean must equal one of the discrete X-axis magnitudes");
            }
        }
    }
}

