/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.magdist;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.function.Consumer;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.eq.MagUtils;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Region;
import org.opensha.commons.geo.json.Feature;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDistAPI;

@JsonAdapter(value=Adapter.class)
public class IncrementalMagFreqDist
extends EvenlyDiscretizedFunc
implements IncrementalMagFreqDistAPI,
Serializable {
    private boolean D = false;
    protected String defaultInfo;
    protected String defaultName;
    private boolean nameOverride = false;
    protected Region region;

    public IncrementalMagFreqDist(IncrementalMagFreqDist other) {
        super(other.minX, other.maxX, other.size());
        this.region = other.region;
        if (other.nameOverride) {
            this.setName(other.getName());
        }
        this.setInfo(other.getInfo());
        this.setTolerance(other.getTolerance());
        for (int i = 0; i < other.size(); ++i) {
            this.set(i, other.getY(i));
        }
    }

    public IncrementalMagFreqDist(double min, int num, double delta) throws InvalidRangeException {
        super(min, num, delta);
        this.setTolerance(delta / 1000000.0);
    }

    public IncrementalMagFreqDist(double min, double max, int num) throws InvalidRangeException {
        super(min, max, num);
        this.setTolerance(this.delta / 1000000.0);
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public Region getRegion() {
        return this.region;
    }

    @Override
    public double getIncrRate(double mag) {
        int xIndex = this.getXIndex(mag);
        return this.getIncrRate(xIndex);
    }

    @Override
    public double getIncrRate(int index) {
        return this.getY(index);
    }

    @Override
    public double getCumRate(double mag) {
        return this.getCumRate(this.getXIndex(mag));
    }

    @Override
    public double getCumRate(int index) {
        double sum = 0.0;
        for (int i = index; i < this.num; ++i) {
            sum += this.getIncrRate(i);
        }
        return sum;
    }

    @Override
    public double getMomentRate(double mag) {
        return this.getIncrRate(mag) * MagUtils.magToMoment(mag);
    }

    @Override
    public double getMomentRate(int index) {
        return this.getIncrRate(index) * MagUtils.magToMoment(this.getX(index));
    }

    @Override
    public double getTotalMomentRate() {
        double sum = 0.0;
        for (int i = 0; i < this.num; ++i) {
            sum += this.getMomentRate(i);
        }
        return sum;
    }

    @Override
    public double getTotalIncrRate() {
        double sum = 0.0;
        for (int i = 0; i < this.num; ++i) {
            sum += this.getIncrRate(i);
        }
        return sum;
    }

    @Override
    public void normalizeByTotalRate() {
        double totalIncrRate = this.getTotalIncrRate();
        for (int i = 0; i < this.num; ++i) {
            double newRate = this.getIncrRate(i) / totalIncrRate;
            super.set(i, newRate);
        }
    }

    public void normalizeToPDF() {
        double totalIncrRate = this.getTotalIncrRate() * this.delta;
        for (int i = 0; i < this.num; ++i) {
            double newRate = this.getIncrRate(i) / totalIncrRate;
            super.set(i, newRate);
        }
    }

    @Override
    public EvenlyDiscretizedFunc getCumRateDist() {
        EvenlyDiscretizedFunc cumRateDist = new EvenlyDiscretizedFunc(this.minX, this.num, this.delta);
        double sum = 0.0;
        for (int i = this.num - 1; i >= 0; --i) {
            cumRateDist.set(i, sum += this.getIncrRate(i));
        }
        cumRateDist.setInfo(this.getInfo());
        cumRateDist.setName(this.getName());
        return cumRateDist;
    }

    public EvenlyDiscretizedFunc getCumRateDistWithOffset() {
        EvenlyDiscretizedFunc cumRateDist = new EvenlyDiscretizedFunc(this.minX - this.delta / 2.0, this.num, this.delta);
        double sum = 0.0;
        for (int i = this.num - 1; i >= 0; --i) {
            cumRateDist.set(i, sum += this.getIncrRate(i));
        }
        cumRateDist.setInfo(this.getInfo());
        cumRateDist.setName(this.getName());
        return cumRateDist;
    }

    @Override
    public EvenlyDiscretizedFunc getMomentRateDist() {
        EvenlyDiscretizedFunc momentRateDist = new EvenlyDiscretizedFunc(this.minX, this.num, this.delta);
        for (int i = this.num - 1; i >= 0; --i) {
            momentRateDist.set(i, this.getMomentRate(i));
        }
        momentRateDist.setInfo(this.getInfo());
        momentRateDist.setName(this.getName());
        return momentRateDist;
    }

    public EvenlyDiscretizedFunc getCumMomentRateDist() {
        EvenlyDiscretizedFunc momentRateDist = new EvenlyDiscretizedFunc(this.minX, this.num, this.delta);
        double totMoRate = 0.0;
        for (int i = this.num - 1; i >= 0; --i) {
            momentRateDist.set(i, totMoRate += this.getMomentRate(i));
        }
        momentRateDist.setInfo(this.getInfo());
        momentRateDist.setName(this.getName());
        return momentRateDist;
    }

    @Override
    public void scaleToTotalMomentRate(double newTotMoRate) {
        double oldTotMoRate = this.getTotalMomentRate();
        if (this.D) {
            System.out.println("old Mo. Rate = " + oldTotMoRate);
        }
        if (this.D) {
            System.out.println("target Mo. Rate = " + newTotMoRate);
        }
        double scaleRate = newTotMoRate / oldTotMoRate;
        for (int i = 0; i < this.num; ++i) {
            super.set(i, scaleRate * this.getIncrRate(i));
        }
        if (this.D) {
            System.out.println("actual Mo. Rate = " + this.getTotalMomentRate());
        }
    }

    @Override
    public void scaleToCumRate(double mag, double rate) {
        int index = this.getXIndex(mag);
        this.scaleToCumRate(index, rate);
    }

    @Override
    public void scaleToCumRate(int index, double rate) {
        double temp = this.getCumRate(index);
        double scaleCumRate = rate / temp;
        for (int i = 0; i < this.num; ++i) {
            super.set(i, scaleCumRate * this.getIncrRate(i));
        }
    }

    @Override
    public void scaleToIncrRate(double mag, double newRate) {
        int index = this.getXIndex(mag);
        this.scaleToIncrRate(index, newRate);
    }

    @Override
    public void scaleToIncrRate(int index, double newRate) {
        double temp = this.getIncrRate(index);
        double scaleIncrRate = newRate / temp;
        for (int i = 0; i < this.num; ++i) {
            super.set(i, scaleIncrRate * this.getIncrRate(i));
        }
    }

    public String getDefaultInfo() {
        return this.defaultInfo;
    }

    public String getDefaultName() {
        this.defaultName = "Incremental Mag Freq Dist";
        return this.defaultName;
    }

    @Override
    public String getName() {
        if (this.name != null && !this.name.trim().equals("") || this.nameOverride) {
            return super.getName();
        }
        return this.getDefaultName();
    }

    @Override
    public void setName(String name) {
        this.nameOverride = true;
        super.setName(name);
    }

    @Override
    public String getInfo() {
        if (this.info != null && !this.info.equals("")) {
            return super.getInfo();
        }
        return this.getDefaultInfo();
    }

    @Override
    public IncrementalMagFreqDist deepClone() {
        IncrementalMagFreqDist f = new IncrementalMagFreqDist(this.minX, this.num, this.delta);
        f.setRegion(this.region);
        f.tolerance = this.tolerance;
        f.setInfo(this.getInfo());
        f.setName(this.getName());
        for (int i = 0; i < this.num; ++i) {
            f.set(i, this.points[i]);
        }
        return f;
    }

    public double getMinMagWithNonZeroRate() {
        for (int i = 0; i < this.num; ++i) {
            if (!(this.getY(i) > 0.0)) continue;
            return this.getX(i);
        }
        return Double.NaN;
    }

    public double getMaxMagWithNonZeroRate() {
        for (int i = this.num - 1; i >= 0; --i) {
            if (!(this.getY(i) > 0.0)) continue;
            return this.getX(i);
        }
        return Double.NaN;
    }

    public double compute_bValue(double min_bValMag, double max_bValMag) {
        int firstIndex = Double.isNaN(min_bValMag) ? this.getClosestXIndex(this.getMinMagWithNonZeroRate()) : this.getClosestXIndex(min_bValMag);
        int lastIndex = Double.isNaN(max_bValMag) ? this.getClosestXIndex(this.getMaxMagWithNonZeroRate()) : this.getClosestXIndex(max_bValMag);
        SimpleRegression regression = new SimpleRegression();
        for (int i = firstIndex; i <= lastIndex; ++i) {
            if (!(this.getY(i) > 0.0)) continue;
            regression.addData(this.getX(i), Math.log10(this.getY(i)));
        }
        return regression.getSlope();
    }

    public double compute_bValueAlt(double minMag, double maxMag) {
        int firstIndex = this.getClosestXIndex(minMag);
        int lastIndex = this.getClosestXIndex(maxMag);
        GutenbergRichterMagFreqDist gr = new GutenbergRichterMagFreqDist(this.getMinX(), this.size(), this.getDelta());
        gr.setAllButBvalue(this.getX(firstIndex), this.getX(lastIndex), this.getTotalMomentRate(), this.getTotalIncrRate());
        return gr.get_bValue();
    }

    public GutenbergRichterMagFreqDist getGR_fit(double minMag, double maxMag) {
        int firstIndex = this.getClosestXIndex(minMag);
        int lastIndex = this.getClosestXIndex(maxMag);
        GutenbergRichterMagFreqDist gr = new GutenbergRichterMagFreqDist(this.getMinX(), this.size(), this.getDelta());
        gr.setAllButBvalue(this.getX(firstIndex), this.getX(lastIndex), this.getTotalMomentRate(), this.getTotalIncrRate());
        return gr;
    }

    public void setValuesAboveMomentRateToZero(double moRate) {
        double mag = this.findMagJustAboveMomentRate(moRate);
        if (Double.isNaN(mag)) {
            return;
        }
        this.zeroAboveMag(mag);
    }

    public double findMagJustAboveMomentRate(double moRate) {
        double cumMoRate = 0.0;
        int targetIndex = -1;
        for (int i = 0; i < this.size(); ++i) {
            if (!((cumMoRate += this.getMomentRate(i)) > moRate)) continue;
            targetIndex = i - 1;
            break;
        }
        if (targetIndex == -1) {
            return Double.NaN;
        }
        return this.getX(targetIndex);
    }

    public void zeroAboveMag(double mag) {
        for (int i = this.getXIndex(mag) + 1; i < this.size(); ++i) {
            this.set(i, 0.0);
        }
    }

    public void zeroAtAndAboveMag(double mag) {
        for (int i = this.getXIndex(mag); i < this.size(); ++i) {
            this.set(i, 0.0);
        }
    }

    public double compute_bValue() {
        return this.compute_bValue(Double.NaN, Double.NaN);
    }

    public IncrementalMagFreqDist getAboveMagnitude(double minMag) {
        Preconditions.checkState(((float)minMag <= (float)this.maxX ? 1 : 0) != 0, (String)"new minMag=%s must be <= maxMag=%s", (Object)Float.valueOf((float)minMag), (Object)Float.valueOf((float)this.maxX));
        if ((float)minMag <= (float)this.minX) {
            return this;
        }
        int minMagIndex = this.getClosestXIndex(minMag);
        if ((float)minMag > (float)this.getX(minMagIndex)) {
            ++minMagIndex;
        }
        IncrementalMagFreqDist ret = new IncrementalMagFreqDist(this.getX(minMagIndex), this.num - minMagIndex, this.delta);
        for (int i = 0; i < ret.size(); ++i) {
            ret.set(i, this.getY(i + minMagIndex));
        }
        return ret;
    }

    public static abstract class GenericAdapter<E extends IncrementalMagFreqDist>
    extends DiscretizedFunc.AbstractAdapter<E> {
        private Feature.FeatureAdapter regionAdapter = new Feature.FeatureAdapter();

        @Override
        protected void serializeExtras(JsonWriter out, E xy) throws IOException {
            super.serializeExtras(out, xy);
            if (((IncrementalMagFreqDist)xy).region != null) {
                out.name("region");
                Region region = ((IncrementalMagFreqDist)xy).region;
                if (region instanceof GriddedRegion) {
                    region = new Region(region);
                }
                this.regionAdapter.write(out, region.toFeature());
            }
        }

        @Override
        protected Consumer<E> deserializeExtra(JsonReader in, String name) throws IOException {
            if (name.equals("region")) {
                if (in.peek() == JsonToken.NULL) {
                    return null;
                }
                final Region region = Region.fromFeature(this.regionAdapter.read(in));
                return new Consumer<E>(){
                    final /* synthetic */ GenericAdapter this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void accept(IncrementalMagFreqDist t) {
                        t.setRegion(region);
                    }
                };
            }
            return super.deserializeExtra(in, name);
        }
    }

    public static class Adapter
    extends GenericAdapter<IncrementalMagFreqDist> {
        @Override
        protected IncrementalMagFreqDist instance(Double minX, Double maxX, Integer size) {
            Preconditions.checkNotNull((Object)minX, (Object)"minX must be supplied before values to deserialize EvenlyDiscretizedFunc");
            Preconditions.checkNotNull((Object)maxX, (Object)"maxX must be supplied before values to deserialize EvenlyDiscretizedFunc");
            Preconditions.checkNotNull((Object)size, (Object)"size must be supplied before values to deserialize EvenlyDiscretizedFunc");
            return new IncrementalMagFreqDist((double)minX, maxX, size);
        }

        @Override
        protected Class<IncrementalMagFreqDist> getType() {
            return IncrementalMagFreqDist.class;
        }
    }
}

