/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.magdist;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.eq.MagUtils;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.TaperedGR_MagFreqDist;

public class SparseGutenbergRichterSolver {
    public static boolean D = false;
    public static SpreadingMethod METHOD_DEFAULT = SpreadingMethod.NEAREST_GROUP;

    public static IncrementalMagFreqDist getEquivGR(EvenlyDiscretizedFunc refFunc, Collection<Double> mags, double totMoRate, double targetBValue, double magCorner) {
        return SparseGutenbergRichterSolver.getEquivGR(refFunc, mags, null, false, totMoRate, targetBValue, magCorner);
    }

    public static IncrementalMagFreqDist getEquivGR(EvenlyDiscretizedFunc refFunc, Collection<Double> mags, Collection<Double> groupBinEdges, boolean groupEdgesIncreasingOnly, double totMoRate, double targetBValue, double magCorner) {
        return SparseGutenbergRichterSolver.getEquivGR(refFunc, mags, groupBinEdges, groupEdgesIncreasingOnly, totMoRate, targetBValue, magCorner, 0.0, METHOD_DEFAULT, false);
    }

    public static IncrementalMagFreqDist getEquivGR(EvenlyDiscretizedFunc refFunc, Collection<Double> mags, double totMoRate, double targetBValue, double magCorner, double sampleDiscr, SpreadingMethod method, boolean preserveRates) {
        return SparseGutenbergRichterSolver.getEquivGR(refFunc, mags, null, false, totMoRate, targetBValue, magCorner, sampleDiscr, method, preserveRates);
    }

    /*
     * Could not resolve type clashes
     */
    public static IncrementalMagFreqDist getEquivGR(EvenlyDiscretizedFunc refFunc, Collection<Double> mags, Collection<Double> groupBinEdges, boolean groupEdgesIncreasingOnly, double totMoRate, double targetBValue, double magCorner, double sampleDiscr, SpreadingMethod method, boolean preserveRates) {
        IncrementalMagFreqDist superSampledGR;
        int maxIndex;
        double minMag = Double.POSITIVE_INFINITY;
        double maxMag = Double.NEGATIVE_INFINITY;
        for (double mag : mags) {
            minMag = Math.min(minMag, mag);
            maxMag = Math.max(maxMag, mag);
        }
        int minIndex = refFunc.getClosestXIndex(minMag);
        if (minIndex == (maxIndex = refFunc.getClosestXIndex(maxMag))) {
            IncrementalMagFreqDist ret = new IncrementalMagFreqDist(refFunc.getMinX(), refFunc.size(), refFunc.getDelta());
            ret.set(minIndex, 1.0);
            ret.scaleToTotalMomentRate(totMoRate);
            return ret;
        }
        EvenlyDiscretizedFunc superSampledDiscretization = sampleDiscr >= refFunc.getDelta() || sampleDiscr == 0.0 ? new EvenlyDiscretizedFunc(refFunc.getX(minIndex), 1 + maxIndex - minIndex, refFunc.getDelta()) : HistogramFunction.getEncompassingHistogram(minMag, maxMag, sampleDiscr);
        boolean[] superSampledParticipation = new boolean[superSampledDiscretization.size()];
        for (double mag : mags) {
            superSampledParticipation[superSampledDiscretization.getClosestXIndex((double)mag)] = true;
        }
        IncrementalMagFreqDist ret = new IncrementalMagFreqDist(refFunc.getMinX(), refFunc.size(), refFunc.getDelta());
        if (magCorner > 0.0) {
            TaperedGR_MagFreqDist tapered = new TaperedGR_MagFreqDist(superSampledDiscretization.getMinX(), superSampledDiscretization.size(), superSampledDiscretization.getDelta());
            tapered.setAllButTotCumRate(superSampledDiscretization.getMinX(), magCorner, totMoRate, targetBValue);
            superSampledGR = tapered;
        } else {
            superSampledGR = new GutenbergRichterMagFreqDist(superSampledDiscretization.getMinX(), superSampledDiscretization.size(), superSampledDiscretization.getDelta(), totMoRate, targetBValue);
        }
        boolean allFilled = true;
        for (int i = 0; i < superSampledGR.size(); ++i) {
            if (superSampledParticipation[i]) {
                ret.add(ret.getClosestXIndex(superSampledGR.getX(i)), superSampledGR.getY(i));
                continue;
            }
            allFilled = false;
        }
        double targetRate = superSampledGR.calcSumOfY_Vals();
        if (!allFilled) {
            int prevNonEmptyIndex = -1;
            for (int i = 0; i < superSampledGR.size(); ++i) {
                List<Object> assignmentGroups;
                if (superSampledParticipation[i]) {
                    prevNonEmptyIndex = i;
                    continue;
                }
                Preconditions.checkState((i > 0 && i < superSampledGR.size() - 1 ? 1 : 0) != 0, (Object)"First and last bins of super-sampled should always have a rupture");
                if (method == SpreadingMethod.PREV) {
                    assignmentGroups = List.of(new int[]{prevNonEmptyIndex});
                } else if (method == SpreadingMethod.NEAREST || method == SpreadingMethod.NEAREST_GROUP) {
                    int[] assignedBins;
                    int numAway = 1;
                    while (true) {
                        boolean lower;
                        int upperIndex = i + numAway;
                        int lowerIndex = i - numAway;
                        int upper = upperIndex < superSampledParticipation.length && superSampledParticipation[upperIndex] ? 1 : 0;
                        boolean bl = lower = lowerIndex >= 0 && superSampledParticipation[lowerIndex];
                        if (upper != 0 || lower) {
                            if (upper != 0 && lower) {
                                assignedBins = new int[]{lowerIndex, upperIndex};
                                break;
                            }
                            if (upper != 0) {
                                assignedBins = new int[]{upperIndex};
                                break;
                            }
                            assignedBins = new int[]{lowerIndex};
                            break;
                        }
                        ++numAway;
                    }
                    if (method == SpreadingMethod.NEAREST_GROUP) {
                        assignmentGroups = new ArrayList();
                        for (int startBin : assignedBins) {
                            int direction = startBin > i ? 1 : -1;
                            ArrayList<Integer> group = new ArrayList<Integer>();
                            int prevBin = i;
                            for (int bin = startBin; bin >= 0 && bin < superSampledParticipation.length && superSampledParticipation[bin]; bin += direction) {
                                if (!(groupBinEdges == null || groupBinEdges.isEmpty() || direction <= 0 && groupEdgesIncreasingOnly)) {
                                    double magAfter;
                                    double magBefore = superSampledDiscretization.getX(prevBin);
                                    Range magRange = magBefore > (magAfter = superSampledDiscretization.getX(bin)) ? Range.closed((Comparable)Double.valueOf(magAfter), (Comparable)Double.valueOf(magBefore)) : Range.closed((Comparable)Double.valueOf(magBefore), (Comparable)Double.valueOf(magAfter));
                                    boolean crosses = false;
                                    for (Double edge : groupBinEdges) {
                                        if (!magRange.contains((Comparable)edge)) continue;
                                        if (D) {
                                            System.out.println("Crossed a bin edge " + edge + " from " + magBefore + " to " + magAfter);
                                        }
                                        crosses = true;
                                        break;
                                    }
                                    if (crosses) break;
                                }
                                group.add(bin);
                                prevBin = bin;
                            }
                            if (group.isEmpty()) continue;
                            assignmentGroups.add(Ints.toArray(group));
                        }
                    } else {
                        assignmentGroups = List.of(assignedBins);
                    }
                } else if (method == SpreadingMethod.ALL) {
                    assignmentGroups = List.of();
                } else {
                    throw new IllegalStateException("Unsupported method: " + String.valueOf((Object)method));
                }
                double valPerGroup = preserveRates ? superSampledGR.getIncrRate(i) : superSampledGR.getMomentRate(i);
                valPerGroup /= (double)assignmentGroups.size();
                if (D) {
                    System.out.println("Spreading to " + assignmentGroups.size() + " groups");
                }
                for (int[] assignedBins : assignmentGroups) {
                    if (D) {
                        int startBin;
                        System.out.print("Assignment group:");
                        int[] upper = assignedBins;
                        startBin = upper.length;
                        for (int j = 0; j < startBin; ++j) {
                            int bin = upper[j];
                            System.out.print(" " + bin + ". " + (float)superSampledDiscretization.getX(bin));
                        }
                        System.out.println();
                    }
                    if (preserveRates) {
                        double rateEachBin = valPerGroup / (double)assignedBins.length;
                        if (D) {
                            System.out.println("Adding " + rateEachBin + " to each bin");
                        }
                        for (int assignedBin : assignedBins) {
                            ret.add(ret.getClosestXIndex(superSampledGR.getX(assignedBin)), rateEachBin);
                        }
                        continue;
                    }
                    if (assignedBins.length == 1) {
                        int retIndex = ret.getClosestXIndex(superSampledGR.getX(assignedBins[0]));
                        double targetMag = ret.getX(retIndex);
                        double targetMo = MagUtils.magToMoment(targetMag);
                        double myTargetRate = valPerGroup / targetMo;
                        if (D) {
                            System.out.println("Adding " + myTargetRate + " to single bin");
                        }
                        ret.add(retIndex, myTargetRate);
                        continue;
                    }
                    int[] binIndexes = new int[assignedBins.length];
                    double curMomentRateInBins = 0.0;
                    for (int j = 0; j < assignedBins.length; ++j) {
                        binIndexes[j] = ret.getClosestXIndex(superSampledGR.getX(assignedBins[j]));
                        double binMoment = ret.getMomentRate(binIndexes[j]);
                        Preconditions.checkState((binMoment > 0.0 ? 1 : 0) != 0, (String)"Bin %s has zero moment but should have had matching ruptures", (int)assignedBins[j]);
                        curMomentRateInBins += binMoment;
                    }
                    double newMomentRate = curMomentRateInBins + valPerGroup;
                    double scalar = newMomentRate / curMomentRateInBins;
                    for (int index : binIndexes) {
                        if (D) {
                            System.out.println("Scaling bin " + index + ". " + (float)ret.getX(index) + " by " + (float)newMomentRate + " / " + (float)curMomentRateInBins + " = " + (float)scalar);
                        }
                        ret.set(index, ret.getY(index) * scalar);
                    }
                }
            }
        }
        if (method == SpreadingMethod.ALL) {
            if (preserveRates) {
                ret.scaleToCumRate(0, targetRate);
            } else {
                ret.scaleToTotalMomentRate(totMoRate);
            }
        }
        if (preserveRates) {
            Preconditions.checkState(((float)targetRate == (float)ret.calcSumOfY_Vals() ? 1 : 0) != 0, (String)"Target rate mismatch: %s != %s", (Object)Float.valueOf((float)targetRate), (Object)Float.valueOf((float)ret.calcSumOfY_Vals()));
        } else if (sampleDiscr >= refFunc.getDelta() || sampleDiscr == 0.0) {
            double retMoRate = ret.getTotalMomentRate();
            double pDiff = 100.0 * Math.abs(retMoRate - totMoRate) / totMoRate;
            Preconditions.checkState((pDiff < 0.001 || (float)targetRate == (float)retMoRate ? 1 : 0) != 0, (String)"Target moment rate mismatch: %s != %s, pDiff=%s %, sampleDiscr=%s, refDelta=%s", (Object[])new Object[]{Float.valueOf((float)totMoRate), Float.valueOf((float)retMoRate), Float.valueOf((float)pDiff), sampleDiscr, refFunc.getDelta()});
        }
        return ret;
    }

    public static enum SpreadingMethod {
        PREV,
        NEAREST,
        ALL,
        NEAREST_GROUP;

    }
}

