/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators;

import java.util.List;
import java.util.StringTokenizer;
import org.opensha.sha.simulators.EventRecord;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.Vertex;

public class EQSIM_EventRecord
extends EventRecord {
    double moment;
    double area;
    double magnitude;
    double duration;
    double depth_lo;
    double depth_hi;
    double das_lo;
    double das_hi;
    double hypo_depth;
    double hypo_das;
    double mean_slip;
    double shear_before;
    double shear_after;
    double normal_before;
    double normal_after;
    String comment_text;
    boolean hasElementSlipsAndIDs = true;
    Double tempSlip;

    public EQSIM_EventRecord(List<SimulatorElement> rectElementsList) {
        super(rectElementsList);
    }

    public EQSIM_EventRecord(String fileLine, List<SimulatorElement> rectElementsList) {
        super(rectElementsList);
        StringTokenizer tok = new StringTokenizer(fileLine);
        int kindOfLine = Integer.parseInt(tok.nextToken());
        if (kindOfLine != 200) {
            throw new RuntimeException("wrong line type");
        }
        String idString = tok.nextToken();
        try {
            this.event_id = Integer.parseInt(idString);
        }
        catch (NumberFormatException e2) {
            this.event_id = (int)Math.round(Double.parseDouble(idString));
        }
        this.magnitude = Double.parseDouble(tok.nextToken());
        this.time = Double.parseDouble(tok.nextToken());
        this.duration = Double.parseDouble(tok.nextToken());
        this.sectionID = Integer.parseInt(tok.nextToken());
        this.depth_lo = Double.parseDouble(tok.nextToken());
        this.depth_hi = Double.parseDouble(tok.nextToken());
        this.das_lo = Double.parseDouble(tok.nextToken());
        this.das_hi = Double.parseDouble(tok.nextToken());
        try {
            this.hypo_depth = Double.parseDouble(tok.nextToken());
        }
        catch (NumberFormatException e1) {
            this.hypo_depth = Double.NaN;
        }
        try {
            this.hypo_das = Double.parseDouble(tok.nextToken());
        }
        catch (NumberFormatException e1) {
            this.hypo_das = Double.NaN;
        }
        this.area = Double.parseDouble(tok.nextToken());
        this.mean_slip = Double.parseDouble(tok.nextToken());
        this.moment = Double.parseDouble(tok.nextToken());
        try {
            this.shear_before = Double.parseDouble(tok.nextToken());
        }
        catch (NumberFormatException e) {
            this.shear_before = Double.NaN;
        }
        try {
            this.shear_after = Double.parseDouble(tok.nextToken());
        }
        catch (NumberFormatException e) {
            this.shear_after = Double.NaN;
        }
        try {
            this.normal_before = Double.parseDouble(tok.nextToken());
        }
        catch (NumberFormatException e) {
            this.normal_before = Double.NaN;
        }
        try {
            this.normal_after = Double.parseDouble(tok.nextToken());
        }
        catch (NumberFormatException e) {
            this.normal_after = Double.NaN;
        }
        while (tok.hasMoreTokens()) {
            this.comment_text = this.comment_text + tok.nextToken() + " ";
        }
    }

    public void addSlipAndElementData(String fileLine) {
        if (this.hasElementSlipsAndIDs) {
            StringTokenizer tok = new StringTokenizer(fileLine);
            int kindOfLine = Integer.parseInt(tok.nextToken());
            if (kindOfLine != 201) {
                throw new RuntimeException("not a slip-map-record line type");
            }
            tok.nextToken();
            tok.nextToken();
            tok.nextToken();
            tok.nextToken();
            tok.nextToken();
            double slip = Double.parseDouble(tok.nextToken());
            tok.nextToken();
            tok.nextToken();
            tok.nextToken();
            tok.nextToken();
            tok.nextToken();
            int element_id = 0;
            if (tok.hasMoreTokens()) {
                try {
                    element_id = Integer.parseInt(tok.nextToken());
                    if (element_id <= 0) {
                        this.tempSlip = slip;
                    }
                }
                catch (NumberFormatException e) {
                    element_id = 0;
                }
            } else {
                element_id = 0;
            }
            if (element_id > 0) {
                this.addSlip(element_id, slip);
            }
            if (element_id == 0) {
                this.hasElementSlipsAndIDs = false;
            }
        }
    }

    public void addType202_Line(String fileLine) {
        StringTokenizer tok = new StringTokenizer(fileLine);
        int kindOfLine = Integer.parseInt(tok.nextToken());
        if (kindOfLine != 202) {
            throw new RuntimeException("not a type 202 line; yours is type=" + kindOfLine);
        }
        int element_id = Integer.parseInt(tok.nextToken());
        this.addSlip(element_id, this.tempSlip);
    }

    public int getHypocenterElementID() {
        double minDist = Double.MAX_VALUE;
        int id = -1;
        for (int elemID : this.getElementIDs()) {
            SimulatorElement rectElem = (SimulatorElement)this.rectElementsList.get(elemID - 1);
            double dist = (rectElem.getAveDAS() - this.hypo_das) * (rectElem.getAveDAS() - this.hypo_das) + (rectElem.getAveDepth() - this.hypo_depth) * (rectElem.getAveDepth() - this.hypo_depth);
            if (!(dist < minDist)) continue;
            minDist = dist;
            id = rectElem.getID();
        }
        return id;
    }

    public Vertex getVertxForMinDAS() {
        Vertex minVertex = null;
        double minDAS = Double.MAX_VALUE;
        for (int elemID : this.getElementIDs()) {
            SimulatorElement elem = (SimulatorElement)this.rectElementsList.get(elemID - 1);
            double elemMinDAS = elem.getMinDAS();
            if (!(elemMinDAS < minDAS)) continue;
            minDAS = elemMinDAS;
            minVertex = elem.getVertexForMinDAS();
        }
        return minVertex;
    }

    public Vertex getVertxForMaxDAS() {
        Vertex maxVertex = null;
        double maxDAS = Double.NEGATIVE_INFINITY;
        for (int elemID : this.elementIDs) {
            SimulatorElement elem = (SimulatorElement)this.rectElementsList.get(elemID - 1);
            double elemMaxDAS = elem.getMaxDAS();
            if (elemMaxDAS > maxDAS) {
                maxDAS = elemMaxDAS;
            }
            maxVertex = elem.getVertexForMaxDAS();
        }
        return maxVertex;
    }

    public double getMinDAS() {
        return this.das_lo;
    }

    public double getMaxDAS() {
        return this.das_hi;
    }

    @Override
    public double getLength() {
        return this.das_hi - this.das_lo;
    }

    public double getDepthLo() {
        return this.depth_lo;
    }

    public double getDepthHi() {
        return this.depth_hi;
    }

    public double getMeanSlip() {
        return this.mean_slip;
    }

    @Override
    public String toString() {
        Object info = super.toString();
        info = (String)info + "\nduration=" + this.duration + "\n";
        info = (String)info + "depth_lo=" + this.depth_lo + "\n";
        info = (String)info + "depth_hi=" + this.depth_hi + "\n";
        info = (String)info + "das_lo=" + this.das_lo + "\n";
        info = (String)info + "das_hi=" + this.das_hi + "\n";
        info = (String)info + "mean_slip=" + this.mean_slip + "\n";
        return info;
    }

    @Override
    public double getMagnitude() {
        return this.magnitude;
    }

    @Override
    public double getDuration() {
        return this.duration;
    }

    @Override
    public double getArea() {
        return this.area;
    }

    @Override
    public double getMoment() {
        return this.moment;
    }
}

