/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.opensha.sha.simulators.SimulatorElement;

public abstract class EventRecord {
    int event_id;
    double time;
    int sectionID;
    int numElements = 0;
    private static final int element_array_padding = 10;
    double[] elementSlips = new double[0];
    int[] elementIDs = new int[0];
    private double[] elementTimeFirstSlips = null;
    List<SimulatorElement> rectElementsList;

    public EventRecord(List<SimulatorElement> rectElementsList) {
        this.rectElementsList = rectElementsList;
    }

    public void addElement(int id) {
        this.addSlip(id, Double.NaN, Double.NaN);
    }

    public void addSlip(int id, double slip) {
        this.addSlip(id, slip, Double.NaN);
    }

    public void addSlip(int id, double slip, double time) {
        int ind = this.numElements++;
        this.elementIDs = Ints.ensureCapacity((int[])this.elementIDs, (int)this.numElements, (int)10);
        this.elementIDs[ind] = id;
        if (!Double.isNaN(slip)) {
            this.elementSlips = Doubles.ensureCapacity((double[])this.elementSlips, (int)this.numElements, (int)10);
            this.elementSlips[ind] = slip;
        }
        if (Double.isNaN(time)) {
            Preconditions.checkState((this.elementTimeFirstSlips == null ? 1 : 0) != 0, (Object)"Some elementes have NaN time of first slip while others have real ones");
        } else {
            if (this.elementTimeFirstSlips == null) {
                Preconditions.checkState((ind == 0 ? 1 : 0) != 0);
                this.elementTimeFirstSlips = new double[10];
            }
            this.elementTimeFirstSlips = Doubles.ensureCapacity((double[])this.elementTimeFirstSlips, (int)this.numElements, (int)10);
            this.elementTimeFirstSlips[ind] = time;
        }
    }

    public void scaleElementTimeFirstSlips(double timeScale, double eventTime) {
        Preconditions.checkState((this.elementTimeFirstSlips != null ? 1 : 0) != 0);
        int i = 0;
        while (i < this.elementTimeFirstSlips.length) {
            double patchRelStart = this.elementTimeFirstSlips[i] - eventTime;
            double newPatchRelStart = patchRelStart / timeScale;
            double offsetForNoScale = patchRelStart - newPatchRelStart;
            int n = i++;
            this.elementTimeFirstSlips[n] = this.elementTimeFirstSlips[n] - offsetForNoScale;
        }
    }

    public int getID() {
        return this.event_id;
    }

    public void setID(int id) {
        this.event_id = id;
    }

    public int getSectionID() {
        return this.sectionID;
    }

    public void setSectionID(int sectionID) {
        this.sectionID = sectionID;
    }

    public abstract double getMagnitude();

    public double getTime() {
        return this.time;
    }

    public void setTime(double time) {
        this.time = time;
    }

    public abstract double getDuration();

    public synchronized int[] getElementIDs() {
        if (this.elementIDs.length > this.numElements) {
            this.elementIDs = Arrays.copyOf(this.elementIDs, this.numElements);
        }
        return this.elementIDs;
    }

    public void setElementIDsAndSlips(int[] elementIDs, double[] elementSlips) {
        if (elementIDs != null && elementSlips != null) {
            Preconditions.checkState((elementIDs.length == elementSlips.length ? 1 : 0) != 0);
        }
        if (elementIDs != null) {
            this.elementIDs = elementIDs;
            this.numElements = elementIDs.length;
        }
        if (elementSlips != null) {
            this.elementIDs = elementIDs;
            this.numElements = elementIDs.length;
        }
    }

    public abstract double getLength();

    public abstract double getArea();

    public double[] getElementSlips() {
        if (this.elementSlips.length > this.numElements) {
            this.elementSlips = Arrays.copyOf(this.elementSlips, this.numElements);
        }
        return this.elementSlips;
    }

    public double[] getElementTimeFirstSlips() {
        if (this.elementTimeFirstSlips == null) {
            return null;
        }
        if (this.elementTimeFirstSlips.length > this.numElements) {
            this.elementTimeFirstSlips = Arrays.copyOf(this.elementTimeFirstSlips, this.numElements);
        }
        return this.elementTimeFirstSlips;
    }

    public void setElementTimeFirstSlips(double[] elementTimeFirstSlips) {
        this.elementTimeFirstSlips = elementTimeFirstSlips;
    }

    public boolean hasElementSlipsAndIDs() {
        return this.numElements > 0;
    }

    public abstract double getMoment();

    public List<SimulatorElement> getElements() {
        ArrayList re_list = Lists.newArrayList();
        for (int elemID : this.getElementIDs()) {
            SimulatorElement elem = this.rectElementsList.get(elemID - 1);
            Preconditions.checkState((elem.getID() == elemID ? 1 : 0) != 0);
            re_list.add(elem);
        }
        return re_list;
    }

    public String toString() {
        Object info = "";
        info = (String)info + "event_id=" + this.event_id + "\n";
        info = (String)info + "magnitude=" + this.getMagnitude() + "\n";
        info = (String)info + "time=" + this.time + "\n";
        info = (String)info + "duration=" + this.getDuration() + "\n";
        info = (String)info + "sectionID=" + this.sectionID + "\n";
        info = (String)info + "area=" + this.getArea() + "\n";
        info = (String)info + "moment=" + this.getMoment();
        return info;
    }
}

